//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"

void TURLView::AnchorSelectPrevious()	{
//	Purpose:	Select the previous anchor in the document.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Circular selection, go before the start, start again at the
//		end.
//	Revision History:
//		01-30-94	created

	//	Only if there are anchors.
	if(TNSCp_anchors->getCount() == 0)	{
		return;
	}

	//	Find out what anchor we are on.
	unsigned short int usi_find = TNSCp_anchors->indexOf((void *)
		TAp_selected);

	//	Set to the previous anchor, modulus.
	if(usi_find == 0U)	{
		usi_find = TNSCp_anchors->getCount();
	}
	usi_find--;
	TAp_selected = (TextAttribute *)(TNSCp_anchors->at(usi_find));

	//	Put the anchor in the view.
	AnchorInView();
}
