
/*
** mapper 1.1
** 7/1/93 Kevin Hughes, kevinh@pulua.hcc.hawaii.edu
** "macmartinized" polygon code copyright 1992 by Eric Haines, erich@eye.com
** All suggestions, help, etc. gratefully accepted!
**
** 1.1 : Better formatting, added better polygon code.
*/

#include <stdio.h>

#define CONF_FILE "foo"
#define MAXLINE 500
#define MAXVERTS 100
#define X 0
#define Y 1

int isname(char);

int main(int argc, char **argv)
{
        char mapname[40], testmapname[40], result[80], input[MAXLINE],
        type[10], num[5];
        double testpoint[2], pointarray[MAXVERTS][2];
        int i, j, k;
        FILE *fp;

        if (argc != 4)
                servererr("Wrong number of arguments.");
        strcpy(mapname, argv[1]);
        testpoint[X] = (double) atoi(argv[2]);
        testpoint[Y] = (double) atoi(argv[3]);

        if ((fp = fopen(CONF_FILE, "r")) == NULL)
                servererr("Couldn't open configuration file.");
        while (fgets(input, MAXLINE, fp) != NULL) {
                if (input[0] == '#' || input[0] == '\n')
                        continue;
                for (i = 0; isname(input[i]) || isdigit(input[i]); i++)
                        testmapname[i] = input[i];
                testmapname[i] = '\0';
                if (!strstr(mapname, testmapname))
                        continue;
                k = 0;
                while (!isname(input[i])) {
                        while (isspace(input[i]) || input[i] == ',')
                                i++;
                        j = 0;
                        while (isdigit(input[i]))
                                num[j++] = input[i++];
                        num[j] = '\0';
                        if (num[0] != '\0')
                                pointarray[k][X] = (double) atoi(num);
                        else
                                break;
                        while (isspace(input[i]) || input[i] == ',')
                                i++;
                        j = 0;
                        while (isdigit(input[i]))
                                num[j++] = input[i++];
                        num[j] = '\0';
                        if (num[0] != '\0')
                                pointarray[k++][Y] = (double) atoi(num);
                        else {
                                fclose(fp);
                                servererr("Missing y value.");
                        }
                }
                j = 0;
                while (isname(input[i]))
                        type[j++] = input[i++];
                type[j] = '\0';
                while (isspace(input[i]))
                        i++;
                j = 0;
                while (isname(input[i]) || isdigit(input[i]))
                        result[j++] = input[i++];
                result[j] = '\0';
                pointarray[k][X] = -1;
                if (k <= 1 || !strcmp(type, "default")) {
                        fclose(fp);
                        sendmesg(result);
                }
                if (!strcmp(mapname, testmapname)) {
                        if (!strcmp(type, "poly")) {
                                if (pointinpoly(testpoint, pointarray)) {
                                        fclose(fp);
                                        sendmesg(result);
                                }
                        }
                        else if (!strcmp(type, "rect")) {
                                if (pointinrect(testpoint, pointarray)) {
                                        fclose(fp);
                                        sendmesg(result);
                                }
                        }
                        else if (!strcmp(type, "circle")) {
                                if (pointincircle(testpoint, pointarray)) {
                                        fclose(fp);
                                        sendmesg(result);
                                }
                        }
                }       
        }
        fclose(fp);
        servererr("No default specified.");
}

sendmesg(char *filename)
{
        char sendline[MAXLINE];
        FILE *fp;

        if ((fp = fopen(filename, "r")) == NULL) {
                sprintf(sendline, "Couldn't open target file %s", filename);
                servererr(sendline);
        }
        while (fgets(sendline, MAXLINE, fp) != NULL)
                printf("%s", sendline);
        fclose(fp);
        exit(0);
}

int pointinrect(double point[2], double coords[MAXVERTS][2])
{
        return ((point[X] >= coords[0][X] && point[X] <= coords[1][X]) &&
        (point[Y] >= coords[0][Y] && point[Y] <= coords[1][Y]));
}

int pointincircle(double point[2], double coords[MAXVERTS][2])
{
        int radius1, radius2;

        radius1 = ((coords[0][Y] - coords[1][Y]) * (coords[0][Y] -
        coords[1][Y])) + ((coords[0][X] - coords[1][X]) * (coords[0][X] -
        coords[1][X]));
        radius2 = ((coords[0][Y] - point[Y]) * (coords[0][Y] - point[Y])) +
        ((coords[0][X] - point[X]) * (coords[0][X] - point[X]));
        return (radius2 <= radius1);
}

int pointinpoly(double point[2], double pgon[MAXVERTS][2])
{
        int i, numverts, inside_flag, xflag0;
        int crossings;
        double *p, *stop;
        double tx, ty, y;

        for (i = 0; pgon[i][X] != -1 && i < MAXVERTS; i++)
                ;
        numverts = i;
        crossings = 0;

        tx = point[X];
        ty = point[Y];
        y = pgon[numverts - 1][Y];

        p = (double *) pgon + 1;
        if ((y >= ty) != (*p >= ty)) {
                if ((xflag0 = (pgon[numverts - 1][X] >= tx)) ==
                (*(double *) pgon >= tx)) {
                        if (xflag0)
                                crossings++;
                }
                else {
                        crossings += (pgon[numverts - 1][X] - (y - ty) *
                        (*(double *) pgon - pgon[numverts - 1][X]) /
                        (*p - y)) >= tx;
                }
        }

        stop = pgon[numverts];

        for (y = *p, p += 2; p < stop; y = *p, p += 2) {
                if (y >= ty) {
                        while ((p < stop) && (*p >= ty))
                                p += 2;
                        if (p >= stop)
                                break;
                        if ((xflag0 = (*(p - 3) >= tx)) == (*(p - 1) >= tx)) {
                                if (xflag0)
                                        crossings++;
                        }
                        else {
                                crossings += (*(p - 3) - (*(p - 2) - ty) *
                                (*(p - 1) - *(p - 3)) / (*p - *(p - 2))) >= tx;
                        }
                }
                else {
                        while ((p < stop) && (*p < ty))
                                p += 2;
                        if (p >= stop)
                                break;
                        if ((xflag0 = (*(p - 3) >= tx)) == (*(p - 1) >= tx)) {
                                if (xflag0)
                                        crossings++;
                        }
                        else {
                                crossings += (*(p - 3) - (*(p - 2) - ty) *
                                (*(p - 1) - *(p - 3)) / (*p - *(p - 2))) >= tx;
                        }
                }
        }
        inside_flag = crossings & 0x01;
        return (inside_flag);
}

servererr(char *msg)
{
        printf("<title>Mapping Server Error</title>");
        printf("<h1>Mapping Server Error</h1>");
        printf("This server encountered an error:<p>");
        printf("<code>%s</code>", msg);
        exit(-1);
}

int isname(char c)
{
        return (isalpha(c) || c == '.' || c == '/');
}
