Date:         Wed, 01 Dec 1993 07:19:06 CST
From:         guthery@austin.slcs.slb.com
To:           sanders@BSDI.COM
Subject:      WAIS Gateway

Tony:

Thanks much for the WAIS gateway code.  Here's one way to implement hitting
the button and getting the documents itself.  I'm a Perl newby so any
suggestions for improvement are appreciated.

Cheers, Scott

------------------------------------------------------------------------------

# wais.pl -- WAIS search interface
#
# yet-another-wais.pl,v 1.1 1994/06/23 05:44:03 sanders Exp
#
# Tony Sanders <sanders@bsdi.com>, Nov 1993
#
# Example configuration (in local.conf):
#     map topdir wais.pl &do_wais($top, $path, $query, "database", "title")
#
package patentbase;

$waisq = "/home/patents/wais/bin/waisq";
$waisd = "/home/patents/1992-patents";
$src   = "1992-patents";
$title = "1992 Patent Abstracts";
$hits  = 0;

sub main'do_wais {
  local($path, $query) = @_;
  if($query) {
    $squery = query;
    open(WAISQ, "-|") || exec ($waisq, "-c", $waisd,
				"-f", "-", "-S", "$src.src", "-g", $query);
    &'MIME_header('ok', 'text/html');
    print "<HEAD>\n<TITLE>Search of ", $title, "</TITLE>\n</HEAD>\n";
    print "<BODY>\n<H1>", $title, "</H1>\n";

    print "Index \`$src\' contains the following\n";
    print "items relevant to \`$query\':<P>\n";
    print "<DL>\n";

    local($score, $headline, $lines, $bytes, $type, $date);
    while (<WAISQ>) {
	/:score\s+(\d+)/ && ($score = $1);
	/:number-of-lines\s+(\d+)/ && ($lines = $1);
	/:number-of-bytes\s+(\d+)/ && ($bytes = $1);
	/:type "(.*)"/ && ($type = $1);
	/:headline "(.*)"/ && ($headline = $1);         # XXX
	/:date "(\d+)"/ && ($date = $1, $hits++, &docdone);
    }
    close(WAISQ);
    print "</DL>\n";

    if ($hits == 0) {
        print "Nothing found.\n";
    }
    print "</BODY>\n";
  } else {
      &main'retrieve($path, $query);
  }
}

sub docdone {
    if ($headline =~ /Search produced no result/) {
        print $headline, "<P>\n<PRE>";
        &'safeopen(WAISCAT, "$waisd/$src.cat") || die "$src.cat: $!";
        while (<WAISCAT>) {
            s#(Catalog for database:)\s+.*#$1 <A HREF="/$top/$src.src">$src.src</A>#;
            s#Headline:\s+(.*)#Headline: <A HREF="$1">$1</A>#;
            print;
	}
	close(WAISCAT);
        print "\n</PRE>\n";
    } else {
	print "<DT><A HREF=\"getpat?$query@$hits\">$headline</A>\n";
	print "<DD>Score: $score, Lines: $lines, Bytes: $bytes\n";
    }
    $score = $headline = $lines = $bytes = $type = $date = '';
}

sub main'do_getpat {
    local($root, $keynum) = @_;
    if($keynum) {
      ($query, $number) = split('@', $keynum);
      &main'MIME_header('ok', 'text/html');
      print "<HEAD>\n<TITLE>Patent Abstract Retrieval</TITLE>\n</HEAD>\n";
      print "<LISTING>\n";
      open(WAISQ, "-|") || exec ($waisq, "-c", $waisd, "-v", $number,
			   "-f", "/dev/null", "-S", "$src.src", "-g", $query);
      while($line = <WAISQ>) {
        print $line;
      }
      print "</LISTING>\n";
      close(WAISQ);
  } else {
      &main'retrieve($root, $title);
  }
   
}

1;








