#       This is a shell archive of patches for Jim Kyle's DEVLOD.
#       These patches enable DEVLOD to load drivers with multiple
#         devices, as well as work under DOS 6.
#
#       DEVLOD can be gotten via anonymous ftp from these sites:
#         ftp://garbo.uwasa.fi/pc/sysfile/devlod.zip
#         ftp://oak.oakland.edu/SimTel/msdos/sysfile/devlod.zip
#
#       To use this archive, you need utilities to extract shell
#         archives and apply patches made with diff.
#
#	Remove everything above and including the cut line.
#       Then run the rest of the file through sh.
#----cut here-----cut here-----cut here-----cut here----#
#!/bin/sh
# shar:    Shell Archiver
#	Run the following text with /bin/sh to create:
#	devlod.dif
#	movup.dif
# This archive created: Mon Jan 15 15:50:41 1996
cat << \SHAR_EOF > devlod.dif
*** devlod.c	Tue Sep 25 22:14:42 1990
--- devlod1.c	Sun Jan 14 21:23:26 1996
***************
*** 2,11 ****
   *     DEVLOD.C - Jim Kyle - 08/20/90                               *
   *            Copyright 1990 by Jim Kyle - All Rights Reserved      *
   *     (minor revisions by Andrew Schulman - 9/12/90                *
   *     Dynamic loader for device drivers                            *
   *            Requires Turbo C; see DEVLOD.MAK also for ASM helpers.*
   ********************************************************************/
!      
  #include <stdio.h>
  #include <stdlib.h>
  #include <dos.h>
--- 2,17 ----
   *     DEVLOD.C - Jim Kyle - 08/20/90                               *
   *            Copyright 1990 by Jim Kyle - All Rights Reserved      *
   *     (minor revisions by Andrew Schulman - 9/12/90                *
+  *     Further revisions added by Rob Rothenburg Walking-Owl - 1/96 *
+  *            Should work with DOS 6                                *
+  *            Some support for multiple drivers (in same file)      *
+  *     Needs: Check if Windows is running                           *
+  *            Reject OS/2 device drivers (OS/2 flag in attrib word) *
   *     Dynamic loader for device drivers                            *
   *            Requires Turbo C; see DEVLOD.MAK also for ASM helpers.*
   ********************************************************************/
! 
! 
  #include <stdio.h>
  #include <stdlib.h>
  #include <dos.h>
***************
*** 74,79 ****
--- 80,87 ----
  
  void movup( char far *, char far *, int ); /* in MOVUP.ASM file     */
  void copyptr( void far *src, void far *dst ); /* in MOVUP.ASM file  */
+ void chainptr( void far *src, void far *dst ); /* in MOVUP.ASM file  */
+   /* returns number of drivers chained */
  
  void exit(int c)            /* called by startup code's sequence    */
  { _exit(c);}
***************
*** 179,184 ****
--- 187,193 ----
        break;
      case  4:
      case  5:
+     case  6:
        nblkdrs = (BYTE far *) MK_FP(nulseg, LoLofs + 0x20);
        lastdrive = *((BYTE far *) MK_FP(nulseg, LoLofs + 0x21));
        nulofs  = LoLofs + 0x22;
***************
*** 207,213 ****
  
    copyptr ( nuldrvr, &nxtdrvr );        /* hold old head now    */
    copyptr ( &drvptr, nuldrvr );         /* put new after NUL    */
!   copyptr ( &nxtdrvr, drvptr );         /* and old after new    */
  }
  
  // returns number of next free drive, -1 if none available
--- 216,222 ----
  
    copyptr ( nuldrvr, &nxtdrvr );        /* hold old head now    */
    copyptr ( &drvptr, nuldrvr );         /* put new after NUL    */
!   chainptr ( &nxtdrvr, drvptr );         /* and old after new    */
  }
  
  // returns number of next free drive, -1 if none available
***************
*** 231,256 ****
  int Init_Drvr ( void )
  { unsigned tmp;
  #define INIT 0
-   CmdPkt.command = INIT;        /* build command packet         */
-   CmdPkt.hdrlen = sizeof (struct packet);
-   CmdPkt.unit = 0;
-   CmdPkt.inpofs  = (unsigned)dvrarg;    /* points into cmd line */
-   CmdPkt.inpseg  = _psp;
-   /* can't really check for next drive here, because don't yet know
-      if this is a block driver or not */
-   CmdPkt.NextDrv = Next_Drive();
    drvptr  = MK_FP( _psp+0x10, 0 );      /* new driver's address */
  
!   tmp = *((unsigned far *)drvptr+3);    /* STRATEGY pointer     */
!   driver = MK_FP( FP_SEG( drvptr ), tmp );
!   _ES = FP_SEG( (void far *)&CmdPkt );
!   _BX = FP_OFF( (void far *)&CmdPkt );
!   (*driver)();                  /* set up the packet address    */
! 
!   tmp = *((unsigned far *)drvptr+4);    /* COMMAND pointer      */
!   driver = MK_FP( FP_SEG( drvptr ), tmp );
!   (*driver)();                  /* do the initialization        */
!   
    /* check status code in command packet                        */
    return (! ( CmdPkt.status & 0x8000 ));
  }
--- 240,271 ----
  int Init_Drvr ( void )
  { unsigned tmp;
  #define INIT 0
    drvptr  = MK_FP( _psp+0x10, 0 );      /* new driver's address */
+   do {
+     CmdPkt.command = INIT;        /* build command packet         */
+     CmdPkt.hdrlen = sizeof (struct packet);
+     CmdPkt.unit = 0;
+     CmdPkt.inpofs  = (unsigned)dvrarg;    /* points into cmd line */
+     CmdPkt.inpseg  = _psp;
+     /* can't really check for next drive here, because don't yet know
+        if this is a block driver or not */
+     CmdPkt.NextDrv = Next_Drive();
+ 
+     tmp = *((unsigned far *)drvptr+3);    /* STRATEGY pointer     */
+     driver = MK_FP( FP_SEG( drvptr ), tmp );
+     _ES = FP_SEG( (void far *)&CmdPkt );
+     _BX = FP_OFF( (void far *)&CmdPkt );
+     (*driver)();                  /* set up the packet address    */
+ 
+     tmp = *((unsigned far *)drvptr+4);    /* COMMAND pointer      */
+     driver = MK_FP( FP_SEG( drvptr ), tmp );
+     (*driver)();                  /* do the initialization        */
+ 
+     tmp = *((unsigned far *)drvptr);    
+     drvptr = MK_FP( FP_SEG(drvptr), tmp + FP_OFF(drvptr) );
+   } while ((tmp!=0xffff) && (! ( CmdPkt.status & 0x8000 )));
  
!   drvptr  = MK_FP( _psp+0x10, 0 );      /* new driver's address */
    /* check status code in command packet                        */
    return (! ( CmdPkt.status & 0x8000 ));
  }
SHAR_EOF
cat << \SHAR_EOF > movup.dif
*** movup.asm	Tue Sep 25 22:07:02 1990
--- movup1.asm	Sun Jan 14 20:47:10 1996
***************
*** 4,9 ****
--- 4,11 ----
  ;|      Copyright 1990 by Jim Kyle - All Rights Reserved        |
  ;[]------------------------------------------------------------[]
  
+ ; Minor optimizations made by Rob Rothenburg Walking-Owl
+ 
  _TEXT   SEGMENT BYTE PUBLIC 'CODE'
  _TEXT   ENDS
  
***************
*** 69,78 ****
          pop     ds
          pop     di
          pop     si
!         mov     sp, bp
!         pop     bp
          ret
  _copyptr        ENDP
  
  _TEXT   ENDS
  
--- 71,111 ----
          pop     ds
          pop     di
          pop     si
!         pop     bp      ; unnecessary mov sp, bp removed
          ret
  _copyptr        ENDP
+ 
+ ; ----- Chain seraching code added by Rob Rothenburg Walking-Owl, 1/14/96
+         PUBLIC  _chainptr
+ 
+ _chainptr       PROC      NEAR
+         push    bp
+         mov     bp, sp
+         push    si
+         push    di
+         push    ds
+         lds     si,[bp+4]               ; source
+         les     di,[bp+8]               ; destination
+         mov     bx, di
+ @2@0:
+         cmp     WORD PTR es:[di], -1    ; is it end of chain?
+         je      SHORT @2@1
+         add     WORD PTR es:[di], bx
+         mov     WORD PTR es:[di+2], es  ; set segment
+ ; Add resolution of segment:offset so that offset is 0!
+ 
+         mov     di, WORD PTR es:[di]    ; set offset to next in chain
+         jmp     SHORT @2@0
+ @2@1:
+         cld
+         movsw
+         movsw
+         pop     ds
+         pop     di
+         pop     si
+         pop     bp
+         ret
+ _chainptr       ENDP
  
  _TEXT   ENDS
  
SHAR_EOF
#	End of shell archive
exit 0
