/*
 * Copyright 1987 by MIT Student Information Processing Board
 *
 * For copyright information, see mit-sipb-copyright.h.
 */

#ifndef _SS_INTERNAL
#define _SS_INTERNAL
#include <stdio.h>
#include <strings.h>
#include "ss.h"

typedef struct _ss_data {	/* init values */
     /* this subsystem */
     char *subsystem_name;
     char *subsystem_version;
     /* current request info */
     int argc;
     char **argv;		/* arg list */
     char *current_request;	/* primary name */
     /* info directory for 'help' */
     char **info_dirs;
     /* to be extracted by subroutines */
     char *info_ptr;		/* (char *) NULL */
     /* for ss_listen processing */
     char *prompt;
     ss_request_table **rqt_tables;
     char escape_disabled;
     /* to get out */
     int abort;		/* exit subsystem */
     int exit_status;
} ss_data;

#define CURRENT_SS_VERSION 1

#define	ss_info(sci_idx)	(_ss_table[sci_idx])
#define	ss_current_request(sci_idx,code_ptr)	\
     (*code_ptr=0,ss_info(sci_idx)->current_request)

char	*error_message();
FUNCTION_TYPE ss_unknown_function();
void	ss_delete_info_dir(), ss_execute_line();

extern ss_data **_ss_table;
extern char *ss_et_msgs[];

extern char *sys_errlist[];
extern char *malloc(), *realloc(), *calloc();
extern int exit();

#endif _SS_INTERNAL
