/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.AlgorithmId;
import com.sun.crypto.provider.DerOutputStream;
import com.sun.crypto.provider.DerValue;
import java.io.IOException;

class EncryptedPrivateKeyInfo {
    private AlgorithmId algid;
    private byte[] encryptedData;
    private byte[] encoded;

    public EncryptedPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.algid = algorithmId;
        this.encryptedData = (byte[])byArray.clone();
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new IOException("overrun, bytes = " + derValue.data.available());
        }
        this.algid = new AlgorithmId(derValueArray[0]);
        if (derValueArray[0].data.available() != 0) {
            throw new IOException("encryptionAlgorithm field overrun");
        }
        this.encryptedData = derValueArray[1].getOctetString();
        if (derValueArray[1].data.available() != 0) {
            throw new IOException("encryptedData field overrun");
        }
        this.encoded = (byte[])byArray.clone();
    }

    public AlgorithmId getAlgorithm() {
        return this.algid;
    }

    public byte[] getEncoded() throws IOException {
        if (this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.algid.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.encryptedData);
        derOutputStream.write((byte)48, derOutputStream2);
        this.encoded = derOutputStream.toByteArray();
        return (byte[])this.encoded.clone();
    }

    public byte[] getEncryptedData() {
        return (byte[])this.encryptedData.clone();
    }
}

