
/* SSLeay module */
/* -*-C-*- */

/*

   This module provides an interface to Eric Young's implementation of
the Secure Sockets Layer, SSLeay.  Abandon all hope, ye who enter here.

*/


#define SSLeay_TAIL
#define SSLeay_constants(d) defineConstants(d);

#include "pem.h"
#include "x509.h"
#include "ssl.h"
#include "err.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>

#include <string.h>
#include <errno.h>
#include "compile.h"                  /* Required for PyCode_Type */

/* Uncomment the following line for copious debugging output */
/* #define DEBUG */

/* Callback variables */
static PyObject *verify_callback_obj;
int PySSLeay_verify_callback(int ok, X509 *xs, X509 *xi, int depth, int error);


/*************************************************************************/
/*                                                                       */
/*                           Utility functions                           */
/*                                                                       */
/*************************************************************************/

static int should_retry(i)
int i;
	{
	if ((i == 0) || (i == -1))
		{
		if (errno == EWOULDBLOCK) return(1);
#ifndef _Windows
		if (errno == EPROTO) return(1);
#endif
		}
	return(0);
	}


static PyObject *
err_closed()
{
	PyErr_SetString(PyExc_ValueError, "I/O operation on closed file");
	return NULL;
}

/* Convenience routine to export an integer value.
   For simplicity, errors (which are unlikely anyway) are ignored. */

static void
insint(PyObject *d, char *name, int value)
{
  PyObject *v = PyInt_FromLong((long) value);
  if (v == NULL) {
    /* Don't bother reporting this error */
    PyErr_Clear();
  }
  else {
    PyDict_SetItemString(d, name, v);
    Py_DECREF(v);
  }
}

/* Convenience function to raise an exception on encountering an SSL error */

PyObject *
PySSLeay_Err()
{
  unsigned long l;
  PyObject *errlist=NULL;

  errlist=PyList_New(0);
  if (errlist==NULL) return NULL;
  do
    {
      l=ERR_get_error();
      if (l!=0) 
	{
	  char buf[128];
	  PyObject *errstr;
	  
	  ERR_error_string(l, buf);
	  errstr=PyString_FromString(buf);
	  if (errstr!=NULL)
	    {
	      PyList_Append(errlist, errstr);
	      Py_DECREF(errstr);
	    }
	  else {Py_DECREF(errlist); return NULL;}
	}
    } while (l!=0);
  
  PyErr_SetObject(ErrorObject, errlist);
  return (NULL);
}



#if 0

static PyObject *
BUILD_FUNC_DEF_2(PyX509_add_cert_dir,PySSLObject *,s, PyObject *,args)
{
  char *paths;  
  int dir_type, err;
  
  if (!PyArg_ParseTuple(args, "si", &paths, &dir_type))
    {
      return NULL;
    }
  err=X509_add_cert_dir(CertCtx, paths, dir_type);
#ifdef DEBUG
  printf("X509_add_cert_dir returned %i\n", err);
#endif
  if (err<0) return PyX509_Err();
  Py_INCREF(Py_None);
  return(Py_None);
}

static PyObject *
BUILD_FUNC_DEF_2(PyX509_set_verify_cb,PySSLObject *,s, PyObject *,args)
{
  PyObject *callback;
  if (!PyArg_ParseTuple(args, "O!", &PyFunction_Type, &callback))
    {
      return NULL;
    }
  Py_XINCREF(callback);
  Py_XDECREF(verify_callback_obj);
  verify_callback_obj=callback;
  Py_INCREF(Py_None);
  return(Py_None);
}
#endif

/* Initialize this module. */

static void
defineConstants(PyObject *d)
{
  SSL_load_error_strings();
  SSL_debug("server.log");

  insint(d, "VERIFY_NONE", SSL_VERIFY_NONE);
  insint(d, "VERIFY_PEER", SSL_VERIFY_PEER);
  insint(d, "VERIFY_FAIL_IF_NO_PEER_CERT", SSL_VERIFY_FAIL_IF_NO_PEER_CERT);

  insint(d, "X509_FILETYPE_PEM", X509_FILETYPE_PEM);
  insint(d, "X509_FILETYPE_ASN1", X509_FILETYPE_ASN1);
  insint(d, "VERIFY_ERR_UNABLE_TO_GET_ISSUER", VERIFY_ERR_UNABLE_TO_GET_ISSUER);
 
  Py_INCREF(Py_None); verify_callback_obj=Py_None;
}
