
static PyObject *
X509_getattr_(X509Object *s, char *name)
{
  X509_NAME *x5n=NULL;
  char *str=NULL;

  if (strcmp(name, "oneline_issuer_name")==0)
    {
      if (s->x509!=NULL) x5n=X509_get_issuer_name(s->x509);
      if (x5n!=NULL) str=X509_NAME_oneline(x5n);
      if (str==NULL) str="";
      return Py_BuildValue("s", str);
  }
  
  if (strcmp(name, "oneline_subject")==0)
    {
      if (s->x509!=NULL) x5n=X509_get_subject_name(s->x509);
      if (x5n!=NULL) str=X509_NAME_oneline(x5n);
      if (str==NULL) str="";
      return Py_BuildValue("s", str);
    }
  
  return Py_FindMethod(X509_methods, (PyObject *) s, name);
}

static int
X509_setattr_(X509Object *s, char *name, PyObject *v)
{
  if (v == NULL) {
    PyErr_SetString(PyExc_TypeError, "can't delete X509 object attributes");
    return -1;
  }
  else {
    PyErr_SetString(PyExc_TypeError, "can't set X509 object attributes");
    return -1;
  }
}
