
/* -*-C-*- */
   
static int
SSLCTX_setattr_(SSLCTXObject *s, char *name,PyObject *v)
{
  int err;

  if (v == NULL) {
    PyErr_SetString(PyExc_TypeError, "can't delete SSLCTX object attributes");
    return -1;
  }
  if (strcmp(name, "pref_ciphers")==0)
    {
      if (!PyString_Check(v))
	{
	  PyErr_SetString(PyExc_TypeError,
			  "pref_ciphers attribute must be a string");
	  return -1;
	}
      err=SSL_CTX_set_cipher_list(s->SSLctx, PyString_AsString(v));
      if (err<=0) 
	{
	  PySSLeay_Err();
	  return -1;
	}
      return 0;
    }
  PyErr_SetString(PyExc_AttributeError, "no such SSLCTX object attribute");
  return -1;
}

static PyObject *
SSLCTX_getattr_(SSLCTXObject *s, char *name)
{    
  if (strcmp(name, "sess_accept")==0)
    return PyInt_FromLong( SSL_CTX_sess_accept(s->SSLctx));
  if (strcmp(name, "sess_accept_good")==0)
    return PyInt_FromLong( SSL_CTX_sess_accept_good(s->SSLctx));
  if (strcmp(name, "sess_connect")==0)
    return PyInt_FromLong( SSL_CTX_sess_connect(s->SSLctx));
  if (strcmp(name, "sess_connect_good")==0)
    return PyInt_FromLong( SSL_CTX_sess_connect_good(s->SSLctx));
  if (strcmp(name, "sess_hits")==0)
    return PyInt_FromLong( SSL_CTX_sess_hits(s->SSLctx));
  if (strcmp(name, "sess_misses")==0)
    return PyInt_FromLong( SSL_CTX_sess_misses(s->SSLctx));
  if (strcmp(name, "sess_timeouts")==0)
    return PyInt_FromLong( SSL_CTX_sess_timeouts(s->SSLctx));
  if (strcmp(name, "cert")==0)
    {
      Py_INCREF(Py_None);
      return Py_None;
    }
  if (strcmp(name, "pref_ciphers")==0)
    {
      int i, len=0;
      char *buf;
      PyObject *v;

      for (i=0; i<s->SSLctx->num_cipher_list; i++) 
	len+=strlen(s->SSLctx->cipher_list[i])+1;
      len += 1+50; /* 1 for the terminator, 50 for paranoia's sake */
      buf=malloc(len);
      if (buf==NULL)
	{
	  PyErr_SetString(PyExc_MemoryError, 
			  "Out of memory on buffer allocation");
	  return NULL;
	}
      buf[0]='\0';
      for(i=0; i<s->SSLctx->num_cipher_list; i++)
	{
	  strcat(buf, s->SSLctx->cipher_list[i]);
	  strcat(buf, ":");
	}
      len=strlen(buf);
      if (len>0) buf[len-1]='\0';		/* Overwrite final colon */
      v=PyString_FromString(buf);
      free(buf);
      return v;
    }
  return NULL;
}

static PyObject *
SSLCTX_use_certificate_(SSLCTXObject *s, PyObject *args)
{
  X509Object *x509;
  int err;

  if (s->SSLctx==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "O!", &X509Type, &x509))
    return NULL;
  err=SSL_CTX_use_certificate(s->SSLctx, x509->x509);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLCTX_use_certificate_ASN1_(SSLCTXObject *s, PyObject *args)
{
  int err, len;
  unsigned char *d;
  
  if (s->SSLctx==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "s#", &d, &len))
    return NULL;
  err=SSL_CTX_use_certificate_ASN1(s->SSLctx, len, d);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLCTX_use_certificate_file_(SSLCTXObject *s, PyObject *args)
{
  int err, type;
  char *filename;
  
  if (s->SSLctx==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "si", &filename, &type))
    return NULL;
  err=SSL_CTX_use_certificate_file(s->SSLctx, filename, type);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLCTX_use_RSAPrivateKey_ASN1_(SSLCTXObject *s, PyObject *args)
{
  int err, len;
  unsigned char *d;
  
  if (s->SSLctx==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "s#", &d, &len))
    return NULL;
  err=SSL_CTX_use_RSAPrivateKey_ASN1(s->SSLctx, d, len);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLCTX_use_RSAPrivateKey_file_(SSLCTXObject *s, PyObject *args)
{
  int err, type;
  char *filename;
  
  if (s->SSLctx==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "si", &filename, &type))
    return NULL;
  err=SSL_CTX_use_RSAPrivateKey_file(s->SSLctx, filename, type);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}
