/* s.accept() method */

static PyObject *
SSLconn_accept_(SSLconnObject *s, PyObject *args)
{
  int i;
  X509 *peer;
  PyObject *value;

/* XXX with non-blocking I/O, this utterly fails to work.  I'm not sure why. */
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
  if (!SSL_is_init_finished(s->SSL))
    {
      do 
	{
#ifdef DEBUG
	  printf("calling SSL_accept\n");
#endif      
	  i = SSL_accept(s->SSL);
#ifdef DEBUG
      printf("exiting SSL_accept with code %i, errno %i\n", i, errno);
#endif      
	} while(i<=0 && should_retry(i));
      if (i <= 0) return PySSLeay_Err();
    }
  
  if (PyErr_Occurred()) return(NULL);
  peer=SSL_get_peer_certificate(s->SSL);
  if (peer==NULL) {Py_XINCREF(Py_None); peer=(X509*)Py_None;}
  else {X509Object *obj; 
        obj=X509_New(peer); 
        X509_free(peer); 
        peer=(X509*)obj;}
  value=Py_BuildValue("sO", SSL_get_cipher(s->SSL), peer);
  Py_XDECREF(Py_None);  
  return(value);
}


/* s.close() method.
   Set the file descriptor to -1 so operations tried subsequently
   will surely fail. */

static PyObject *
SSLconn_close_(SSLconnObject *s, PyObject *args)
{
  int fd;
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
  fd=SSL_get_fd(s->SSL);
  (void) close(fd);
  SSL_set_fd(s->SSL,-1);
  SSL_free(s->SSL);
  s->SSL=NULL;
  Py_INCREF(Py_None);
  return Py_None;
}


/* s.connect() method */

static PyObject *
SSLconn_connect_(SSLconnObject *s, PyObject *args)
{
  int res;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
/* XXX with non-blocking I/O, this utterly fails to work.  I'm not sure why. */
  do 
    {
#ifdef DEBUG
      printf("calling SSL_connect\n");
#endif      
      res = SSL_connect(s->SSL);
#ifdef DEBUG
      printf("exiting SSL_connect with code %i, errno %i\n", res, errno);
#endif      
    } while (should_retry(res));
  
  if (PyErr_Occurred()) return(NULL);
  if (res<=0)
    {
      return PySSLeay_Err();
    }
  Py_INCREF(Py_None);
#ifdef DEBUG
      printf("returning from PySSLeay_connect\n");
#endif      
  return Py_None;
}


/* s.fileno() method */

static PyObject *
SSLconn_fileno_(SSLconnObject *s, PyObject *args)
{
  long fd;
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args,""))
    return NULL;
  fd=SSL_get_fd(s->SSL);
  return PyInt_FromLong(fd);
}


/* s.flush() method */

static PyObject *
SSLconn_flush_(SSLconnObject *s, PyObject *args)
{
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args,""))
    return NULL;
  /* XXX Flush does nothing at all! */
  Py_INCREF(Py_None);
  return Py_None;
}


/* s.isatty() method */

static PyObject *
SSLconn_isatty_(SSLconnObject *s, PyObject *args)
{
  if (!PyArg_ParseTuple(args,""))
    return NULL;
  return PyInt_FromLong((long)0);
}


/* s.makefile() method */

static PyObject *
SSLconn_makefile_(SSLconnObject *s, PyObject *args)
{
 if (s->SSL==NULL) return err_closed();  
/*  if (!PyArg_ParseTuple(args,""))
    return NULL;*/
  Py_INCREF(s);
  return (PyObject*)s;
}


/* s.readline(n) method */

static PyObject *
SSLconn_readline_(SSLconnObject *s, PyObject *args)
{
 int n=1, n1, n2=100, len;
 char c;
 register char *buf, *end;
 PyObject *v;

 if (s->SSL==NULL) return err_closed();  
 if (args!=NULL && !PyArg_ParseTuple(args,""))
   return(NULL);
 
 n=0;
 v = PyString_FromStringAndSize((char *)NULL, n2);
 if (v == NULL)
   return NULL;
 buf = PyString_AS_STRING((PyStringObject *)v);
 end = buf + n2;

 for (;;) {
  len = SSL_read(s->SSL, &c, 1);
  if (len==0) 
    {
      return PyString_FromStringAndSize("", 0);
    }
  if ((*buf++ = c) == '\n') 
    {
     break;
    }
  if (buf == end) 
    {
     n1 = n2;
     n2 += 1000;
     if (_PyString_Resize(&v, n2) < 0)
       return NULL;
     buf = PyString_AS_STRING((PyStringObject *)v) + n1;
     end = PyString_AS_STRING((PyStringObject *)v) + n2;
    }
 }
 
 n1 = buf - PyString_AS_STRING((PyStringObject *)v);
 if (n1==0) 
   {
     Py_XDECREF(v);
     return PyString_FromStringAndSize("", 0);
   }
 if (n1 != n2)
   _PyString_Resize(&v, n1);
 return v;
}


/* s.readlines() method */
static PyObject *
SSLconn_readlines_(SSLconnObject *s, PyObject *args)
{
  PyObject *list, *line;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args,"")) return NULL;
  list=PyList_New(0);
  if (list==NULL) return NULL;
  for (;;) 
    {
     line=SSLconn_readline(s, NULL);
     if (line==NULL) 
       {
	Py_DECREF(list);
	return NULL;
       }
     if (PyString_Size(line) == 0) {Py_DECREF(line); break;}
     PyList_Append(list, line);
     Py_DECREF(line);
    }  
  
  return(list);
}

/* s.recv(nbytes) method */

static PyObject *
SSLconn_recv_(SSLconnObject *s, PyObject *args)
{
  int len=-1, buflen, n, pos=0;
  PyObject *buf;

  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "|i", &len)) {
    return NULL;
  }
  if (len==0) return PyString_FromStringAndSize((char *)NULL, 0);

  if (len>0) {buflen=len;}
  else {buflen=1024;}
		     
  buf = PyString_FromStringAndSize((char *)NULL, buflen);
  if (buf == NULL)
    return NULL;
  while(1)
    {
     n = SSL_read(s->SSL, PyString_AsString(buf)+pos, buflen-pos);
     if (should_retry(n)) continue;
     if (n<=0) break;
     pos+=n;
     if (pos==buflen)
       {
	 if (len>0) break;
	 buflen+=1024;
	 if (_PyString_Resize(&buf, buflen) < 0)
	   return NULL;
       }
   } 
  if (n < 0)
    {return PySSLeay_Err();}
  if (_PyString_Resize(&buf, pos) < 0)
    {
      return NULL;
    }
  return buf;
}


 /* s.seek() method */

static PyObject *
SSLconn_seek_(SSLconnObject *s, PyObject *args)
{
  errno=-ESPIPE;
  PyErr_SetFromErrno(PyExc_IOError);
  return NULL;
}

 /* s.tell() method */

static PyObject *
SSLconn_tell_(SSLconnObject *s, PyObject *args)
{
  errno=-ESPIPE;
  PyErr_SetFromErrno(PyExc_IOError);
  return NULL;
}


/* s.send(data) method */

static PyObject *
SSLconn_send_(SSLconnObject *s, PyObject *args)
{
  char *buf;
  int len, n, totalsent;
  totalsent = 0;

  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "s#", &buf, &len)) {
    return NULL;
  }
  if (len==0) return PyInt_FromLong(0L);

  while (len!=0)
    {
      n = SSL_write(s->SSL, buf, len);
      if (should_retry(n))
	{
	  continue;
	}
      if (n <= 0)
	return PySSLeay_Err();
      buf+=n; len-=n; totalsent+=n;
    } 
  return PyInt_FromLong((long)totalsent);
}

static PyObject *
SSLconn_use_certificate_(SSLconnObject *s, PyObject *args)
{
  X509Object *x509;
  int err;

  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "O!", &X509Type, &x509))
    return NULL;
  err=SSL_use_certificate(s->SSL, x509->x509);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLconn_use_certificate_ASN1_(SSLconnObject *s, PyObject *args)
{
  int err, len;
  unsigned char *d;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "s#", &d, &len))
    return NULL;
  err=SSL_use_certificate_ASN1(s->SSL, len, d);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLconn_use_certificate_file_(SSLconnObject *s, PyObject *args)
{
  int err, type;
  char *filename;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "si", &filename, &type))
    return NULL;
  err=SSL_use_certificate_file(s->SSL, filename, type);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

#if 0
static PyObject *
SSLconn_useRSA_(SSLconnObject *s, PyObject *args)
{
  PyRSAObject *rsa;
  int err;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "O!", &PyRSA_Type, &rsa))
    return NULL;
  err=SSL_use_RSAPrivateKey(s->SSL, rsa->rsa);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}
#endif

static PyObject *
SSLconn_use_RSAPrivateKey_ASN1_(SSLconnObject *s, PyObject *args)
{
  int err, len;
  unsigned char *d;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "s#", &d, &len))
    return NULL;
  err=SSL_use_RSAPrivateKey_ASN1(s->SSL, d, len);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

static PyObject *
SSLconn_use_RSAPrivateKey_file_(SSLconnObject *s, PyObject *args)
{
  int err, type;
  char *filename;
  
  if (s->SSL==NULL) return err_closed();  
  if (!PyArg_ParseTuple(args, "si", &filename, &type))
    return NULL;
  err=SSL_use_RSAPrivateKey_file(s->SSL, filename, type);
  if (err<=0) return PySSLeay_Err();
  Py_INCREF(Py_None);
  return Py_None;
}

/* s.writelines(linelist) method */

static PyObject *
SSLconn_writelines_(SSLconnObject *s, PyObject *args)
{
 int N, n, i, len;
 PyObject *line;
 
 if (s->SSL==NULL) return err_closed();  
 if (args == NULL || !PyList_Check(args)) 
   {
    PyErr_SetString(PyExc_TypeError,
		    "writelines() requires list of strings");
    return NULL;
   }
 
 N=PyList_Size(args);
 for(i=0; i<N; i++) 
   {
    line=PyList_GetItem(args, i);
    if (!PyString_Check(line))
      {
       PyErr_SetString(PyExc_TypeError,
		       "writelines() requires list of strings");
       return NULL;
      }
    len=PyString_Size(line);
    n = SSL_write(s->SSL, PyString_AsString(line), len);
    if (n!=len)
       return PySSLeay_Err();
   }
 
 Py_INCREF(Py_None);
 return (Py_None);
}

static PyObject *
SSLconn_getattr_(SSLconnObject *s, char *name)
{
  if (!strcmp(name, "pending"))
    {	
      return PyInt_FromLong(SSL_pending(s->SSL));
    }
  if (!strcmp(name, "version"))
    {	
      return PyInt_FromLong(s->SSL->version);
    }
  if (!strcmp(name, "verify_mode"))
    {	
      return PyInt_FromLong(s->SSL->verify_mode);
    }
  if (!strcmp(name, "cipher"))
    {	
      return PyString_FromString(SSL_get_cipher(s->SSL));
    }
  if (!strcmp(name, "peer_cert"))
    {
      X509 *peer; X509Object *obj;
      peer=SSL_get_peer_certificate(s->SSL);
      if (peer==NULL) {Py_INCREF(Py_None); return (Py_None);}
      obj=X509_New();
      obj->x509=peer;
      return (PyObject*)obj;
    }
  if (strcmp(name, "pref_ciphers")==0)
    {
      int i, len=0;
      char *buf;
      PyObject *v;

      for (i=0; i<s->SSL->num_cipher_list; i++) 
	len+=strlen(s->SSL->cipher_list[i])+1;
      len += 1+50; /* 1 for the terminator, 50 for paranoia's sake */
      buf=malloc(len);
      if (buf==NULL)
	{
	  PyErr_SetString(PyExc_MemoryError, 
			  "Out of memory on buffer allocation");
	  return NULL;
	}
      buf[0]='\0';
      for(i=0; i<s->SSL->num_cipher_list; i++)
	{
	  strcat(buf, s->SSL->cipher_list[i]);
	  strcat(buf, ":");
	}
      len=strlen(buf);
      if (len>0) buf[len-1]='\0';		/* Overwrite final colon */
      v=PyString_FromString(buf);
      free(buf);
      return v;
    }
  if (!strcmp(name, "sslctx"))
    {	
      SSLCTXObject *sslctx=SSLCTX_New();
      if (sslctx) sslctx->SSLctx=SSL_CTX_new();
      if (sslctx && sslctx->SSLctx) *(sslctx->SSLctx)=*(SSL_get_SSL_CTX(s->SSL));
      return (PyObject*)sslctx;
    }
  return Py_FindMethod(SSLconn_methods, (PyObject *) s, name);
}

static int
SSLconn_setattr_(SSLconnObject *s, char *name, PyObject *v)
{
  int err;
  
  if (v == NULL) {
    PyErr_SetString(PyExc_TypeError, "can't delete SSLconn object attributes");
    return -1;
  }
  if (strcmp(name, "pref_ciphers")==0)
    {
      if (!PyString_Check(v))
	{
	  PyErr_SetString(PyExc_TypeError,
			  "pref_ciphers attribute must be a string");
	  return -1;
	}
      err=SSL_set_cipher_list(s->SSL, PyString_AsString(v));
      if (err<=0) 
	{
	  PySSLeay_Err();
	  return -1;
	}
      return 0;
    }
  if (strcmp(name, "timeout")==0)
    {
      if (!PyInt_Check(v))
	{
	  PyErr_SetString(PyExc_TypeError,
			  "timeout attribute must be an integer");
	  return -1;
	}
      err=SSL_set_timeout(s->SSL->session, PyInt_AsLong(v));
      if (err<=0) 
	{
	  PySSLeay_Err();
	  return -1;
	}
      return 0;
    }

  PyErr_SetString(PyExc_AttributeError, "no such SSLconn object attribute");
  return -1;
}

static PyObject *
SSLconn_set_verify_(SSLconnObject *s, PyObject *args)
{
  int mode;
  if (!PyArg_ParseTuple(args, "i", &mode))
    {
      return NULL;
    }
  SSL_set_verify(s->SSL, mode, PySSLeay_verify_callback);
  Py_INCREF(Py_None);
  return(Py_None);
}

