/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pad;

import gnu.crypto.pad.BasePad;
import gnu.crypto.pad.WrongPaddingException;

public class TLS1
extends BasePad {
    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] in, int off, int len) {
        int padlen = this.blockSize - len % this.blockSize;
        byte[] pad = new byte[padlen];
        int i = 0;
        while (i < padlen) {
            pad[i] = (byte)(padlen - 1);
            ++i;
        }
        return pad;
    }

    public int unpad(byte[] in, int off, int len) throws WrongPaddingException {
        int padlen = in[off + len - 1] & 0xFF;
        int i = off + (len - padlen - 1);
        while (i < off + len - 1) {
            if ((in[i] & 0xFF) != padlen) {
                throw new WrongPaddingException();
            }
            ++i;
        }
        return padlen + 1;
    }

    public TLS1() {
        super("tls1");
    }
}

