# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.computefleet import ComputeFleetMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-computefleet
# USAGE
    python fleets_create_or_update_minimum_set.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeFleetMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.fleets.begin_create_or_update(
        resource_group_name="rgazurefleet",
        fleet_name="testFleet",
        resource={
            "location": "eastus2euap",
            "properties": {
                "computeProfile": {
                    "baseVirtualMachineProfile": {
                        "networkProfile": {
                            "networkApiVersion": "2022-07-01",
                            "networkInterfaceConfigurations": [
                                {
                                    "name": "vmNameTest",
                                    "properties": {
                                        "enableAcceleratedNetworking": False,
                                        "enableIPForwarding": True,
                                        "ipConfigurations": [
                                            {
                                                "name": "vmNameTest",
                                                "properties": {
                                                    "loadBalancerBackendAddressPools": [
                                                        {
                                                            "id": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}"
                                                        }
                                                    ],
                                                    "primary": True,
                                                    "subnet": {
                                                        "id": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}"
                                                    },
                                                },
                                            }
                                        ],
                                        "primary": True,
                                    },
                                }
                            ],
                        },
                        "osProfile": {
                            "adminPassword": "TestPassword$0",
                            "adminUsername": "azureuser",
                            "computerNamePrefix": "prefix",
                            "linuxConfiguration": {"disablePasswordAuthentication": False},
                        },
                        "storageProfile": {
                            "imageReference": {
                                "offer": "0001-com-ubuntu-server-focal",
                                "publisher": "canonical",
                                "sku": "20_04-lts-gen2",
                                "version": "latest",
                            },
                            "osDisk": {
                                "caching": "ReadWrite",
                                "createOption": "FromImage",
                                "managedDisk": {"storageAccountType": "Standard_LRS"},
                                "osType": "Linux",
                            },
                        },
                    },
                    "computeApiVersion": "2023-09-01",
                    "platformFaultDomainCount": 1,
                },
                "regularPriorityProfile": {"allocationStrategy": "LowestPrice", "capacity": 2, "minCapacity": 1},
                "spotPriorityProfile": {
                    "allocationStrategy": "PriceCapacityOptimized",
                    "capacity": 2,
                    "evictionPolicy": "Delete",
                    "maintain": True,
                    "minCapacity": 1,
                },
                "vmSizesProfile": [
                    {"name": "Standard_D2s_v3"},
                    {"name": "Standard_D4s_v3"},
                    {"name": "Standard_E2s_v3"},
                ],
            },
            "tags": {"key": "fleets-test"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-11-01/Fleets_CreateOrUpdate_MinimumSet.json
if __name__ == "__main__":
    main()
