# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementSnapshotPoliciesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_get(self, resource_group):
        response = self.client.snapshot_policies.get(
            resource_group_name=resource_group.name,
            account_name="str",
            snapshot_policy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_create(self, resource_group):
        response = self.client.snapshot_policies.create(
            resource_group_name=resource_group.name,
            account_name="str",
            snapshot_policy_name="str",
            body={
                "location": "str",
                "properties": {
                    "dailySchedule": {"hour": 0, "minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                    "enabled": bool,
                    "hourlySchedule": {"minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                    "monthlySchedule": {
                        "daysOfMonth": "str",
                        "hour": 0,
                        "minute": 0,
                        "snapshotsToKeep": 0,
                        "usedBytes": 0,
                    },
                    "provisioningState": "str",
                    "weeklySchedule": {"day": "str", "hour": 0, "minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_begin_update(self, resource_group):
        response = self.client.snapshot_policies.begin_update(
            resource_group_name=resource_group.name,
            account_name="str",
            snapshot_policy_name="str",
            body={
                "id": "str",
                "location": "str",
                "name": "str",
                "properties": {
                    "dailySchedule": {"hour": 0, "minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                    "enabled": bool,
                    "hourlySchedule": {"minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                    "monthlySchedule": {
                        "daysOfMonth": "str",
                        "hour": 0,
                        "minute": 0,
                        "snapshotsToKeep": 0,
                        "usedBytes": 0,
                    },
                    "provisioningState": "str",
                    "weeklySchedule": {"day": "str", "hour": 0, "minute": 0, "snapshotsToKeep": 0, "usedBytes": 0},
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_begin_delete(self, resource_group):
        response = self.client.snapshot_policies.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            snapshot_policy_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_list(self, resource_group):
        response = self.client.snapshot_policies.list(
            resource_group_name=resource_group.name,
            account_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_snapshot_policies_list_volumes(self, resource_group):
        response = self.client.snapshot_policies.list_volumes(
            resource_group_name=resource_group.name,
            account_name="str",
            snapshot_policy_name="str",
        )

        # please add some check logic here by yourself
        # ...
