# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    """Name is invalid."""
    ALREADY_EXISTS = "AlreadyExists"
    """Name already exists."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the Fabric capacity resource."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    DELETING = "Deleting"
    """Resource is deleting"""
    PROVISIONING = "Provisioning"
    """Resource is provisioning"""
    UPDATING = "Updating"
    """Resource is updating"""


class ResourceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The state of the Fabric capacity resource."""

    ACTIVE = "Active"
    """Resource is active"""
    PROVISIONING = "Provisioning"
    """Resource is provisioning"""
    FAILED = "Failed"
    """Resource is failed"""
    UPDATING = "Updating"
    """Resource is updating"""
    DELETING = "Deleting"
    """Resource is deleting"""
    SUSPENDING = "Suspending"
    """Resource is suspending"""
    SUSPENDED = "Suspended"
    """Resource is suspended"""
    PAUSING = "Pausing"
    """Resource is pausing"""
    PAUSED = "Paused"
    """Resource is paused"""
    RESUMING = "Resuming"
    """Resource is resuming"""
    SCALING = "Scaling"
    """Resource is scaling"""
    PREPARING = "Preparing"
    """Resource is preparing"""


class RpSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the Azure pricing tier to which the SKU applies."""

    FABRIC = "Fabric"
    """Fabric tier"""
