/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm;

import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrologCollectionIterator
extends BacktrackInfo {
    protected Iterator<?> iterator;
    protected Term destTerm;
    protected int startUndoPosition;

    public PrologCollectionIterator(Iterable<?> iterable, Term destination, int undoPosition) {
        this(iterable.iterator(), destination, undoPosition);
    }

    public PrologCollectionIterator(Iterator<?> iterable, Term destination, int undoPosition) {
        super(-1, -1);
        this.iterator = iterable;
        this.destTerm = destination;
        this.startUndoPosition = undoPosition;
    }

    public int getUndoPosition() {
        return this.startUndoPosition;
    }

    public int nextSolution(Interpreter interpreter) throws PrologException {
        while (this.iterator.hasNext()) {
            JavaObjectTerm term = new JavaObjectTerm(this.iterator.next());
            int rc = interpreter.unify(this.destTerm, term);
            if (rc == -1) {
                interpreter.undo(this.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo(this);
            return 0;
        }
        return -1;
    }
}

