/*	$NetBSD: gmc_7_0_sh_mask.h,v 1.2 2018/08/27 04:58:22 riastradh Exp $	*/

/*
 * GMC_7_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef GMC_7_0_SH_MASK_H
#define GMC_7_0_SH_MASK_H

#define MC_CONFIG__MCDW_WR_ENABLE_MASK 0x1
#define MC_CONFIG__MCDW_WR_ENABLE__SHIFT 0x0
#define MC_CONFIG__MCDX_WR_ENABLE_MASK 0x2
#define MC_CONFIG__MCDX_WR_ENABLE__SHIFT 0x1
#define MC_CONFIG__MCDY_WR_ENABLE_MASK 0x4
#define MC_CONFIG__MCDY_WR_ENABLE__SHIFT 0x2
#define MC_CONFIG__MCDZ_WR_ENABLE_MASK 0x8
#define MC_CONFIG__MCDZ_WR_ENABLE__SHIFT 0x3
#define MC_CONFIG__MC_RD_ENABLE_MASK 0x30
#define MC_CONFIG__MC_RD_ENABLE__SHIFT 0x4
#define MC_CONFIG__MCC_INDEX_MODE_ENABLE_MASK 0x80000000
#define MC_CONFIG__MCC_INDEX_MODE_ENABLE__SHIFT 0x1f
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP0_MASK 0x1
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP1_MASK 0x2
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP1__SHIFT 0x1
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP2_MASK 0x4
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP2__SHIFT 0x2
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP3_MASK 0x8
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP3__SHIFT 0x3
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP4_MASK 0x10
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP4__SHIFT 0x4
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP5_MASK 0x20
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP5__SHIFT 0x5
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP6_MASK 0x40
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP6__SHIFT 0x6
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP7_MASK 0x80
#define MC_ARB_AGE_CNTL__RESET_RD_GROUP7__SHIFT 0x7
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP0_MASK 0x100
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP0__SHIFT 0x8
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP1_MASK 0x200
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP1__SHIFT 0x9
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP2_MASK 0x400
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP2__SHIFT 0xa
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP3_MASK 0x800
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP3__SHIFT 0xb
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP4_MASK 0x1000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP4__SHIFT 0xc
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP5_MASK 0x2000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP5__SHIFT 0xd
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP6_MASK 0x4000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP6__SHIFT 0xe
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP7_MASK 0x8000
#define MC_ARB_AGE_CNTL__RESET_WR_GROUP7__SHIFT 0xf
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_RD_MASK 0x70000
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_RD__SHIFT 0x10
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_WR_MASK 0x380000
#define MC_ARB_AGE_CNTL__AGE_LOW_RATE_WR__SHIFT 0x13
#define MC_ARB_RET_CREDITS2__ACP_WR_MASK 0xff
#define MC_ARB_RET_CREDITS2__ACP_WR__SHIFT 0x0
#define MC_ARB_FED_CNTL__MODE_MASK 0x3
#define MC_ARB_FED_CNTL__MODE__SHIFT 0x0
#define MC_ARB_FED_CNTL__WR_ERR_MASK 0xc
#define MC_ARB_FED_CNTL__WR_ERR__SHIFT 0x2
#define MC_ARB_FED_CNTL__KEEP_POISON_IN_PAGE_MASK 0x10
#define MC_ARB_FED_CNTL__KEEP_POISON_IN_PAGE__SHIFT 0x4
#define MC_ARB_FED_CNTL__RDRET_PARITY_NACK_MASK 0x20
#define MC_ARB_FED_CNTL__RDRET_PARITY_NACK__SHIFT 0x5
#define MC_ARB_FED_CNTL__USE_LEGACY_NACK_MASK 0x40
#define MC_ARB_FED_CNTL__USE_LEGACY_NACK__SHIFT 0x6
#define MC_ARB_FED_CNTL__DEBUG_RSV_MASK 0xffffff80
#define MC_ARB_FED_CNTL__DEBUG_RSV__SHIFT 0x7
#define MC_ARB_GECC2_STATUS__CORR_STS0_MASK 0x1
#define MC_ARB_GECC2_STATUS__CORR_STS0__SHIFT 0x0
#define MC_ARB_GECC2_STATUS__UNCORR_STS0_MASK 0x2
#define MC_ARB_GECC2_STATUS__UNCORR_STS0__SHIFT 0x1
#define MC_ARB_GECC2_STATUS__FED_STS0_MASK 0x4
#define MC_ARB_GECC2_STATUS__FED_STS0__SHIFT 0x2
#define MC_ARB_GECC2_STATUS__RSVD0_MASK 0x8
#define MC_ARB_GECC2_STATUS__RSVD0__SHIFT 0x3
#define MC_ARB_GECC2_STATUS__CORR_STS1_MASK 0x10
#define MC_ARB_GECC2_STATUS__CORR_STS1__SHIFT 0x4
#define MC_ARB_GECC2_STATUS__UNCORR_STS1_MASK 0x20
#define MC_ARB_GECC2_STATUS__UNCORR_STS1__SHIFT 0x5
#define MC_ARB_GECC2_STATUS__FED_STS1_MASK 0x40
#define MC_ARB_GECC2_STATUS__FED_STS1__SHIFT 0x6
#define MC_ARB_GECC2_STATUS__RSVD1_MASK 0x80
#define MC_ARB_GECC2_STATUS__RSVD1__SHIFT 0x7
#define MC_ARB_GECC2_STATUS__CORR_CLEAR0_MASK 0x100
#define MC_ARB_GECC2_STATUS__CORR_CLEAR0__SHIFT 0x8
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR0_MASK 0x200
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR0__SHIFT 0x9
#define MC_ARB_GECC2_STATUS__FED_CLEAR0_MASK 0x400
#define MC_ARB_GECC2_STATUS__FED_CLEAR0__SHIFT 0xa
#define MC_ARB_GECC2_STATUS__RSVD2_MASK 0x800
#define MC_ARB_GECC2_STATUS__RSVD2__SHIFT 0xb
#define MC_ARB_GECC2_STATUS__CORR_CLEAR1_MASK 0x1000
#define MC_ARB_GECC2_STATUS__CORR_CLEAR1__SHIFT 0xc
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR1_MASK 0x2000
#define MC_ARB_GECC2_STATUS__UNCORR_CLEAR1__SHIFT 0xd
#define MC_ARB_GECC2_STATUS__FED_CLEAR1_MASK 0x4000
#define MC_ARB_GECC2_STATUS__FED_CLEAR1__SHIFT 0xe
#define MC_ARB_GECC2_STATUS__RSVD3_MASK 0x8000
#define MC_ARB_GECC2_STATUS__RSVD3__SHIFT 0xf
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS0_MASK 0x10000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS0__SHIFT 0x10
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS0_MASK 0x20000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS0__SHIFT 0x11
#define MC_ARB_GECC2_STATUS__RSVD4_MASK 0xc0000
#define MC_ARB_GECC2_STATUS__RSVD4__SHIFT 0x12
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS1_MASK 0x100000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_STS1__SHIFT 0x14
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS1_MASK 0x200000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_STS1__SHIFT 0x15
#define MC_ARB_GECC2_STATUS__RSVD5_MASK 0xc00000
#define MC_ARB_GECC2_STATUS__RSVD5__SHIFT 0x16
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR0_MASK 0x1000000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR0__SHIFT 0x18
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR0_MASK 0x2000000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR0__SHIFT 0x19
#define MC_ARB_GECC2_STATUS__RSVD6_MASK 0xc000000
#define MC_ARB_GECC2_STATUS__RSVD6__SHIFT 0x1a
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR1_MASK 0x10000000
#define MC_ARB_GECC2_STATUS__RMWRD_CORR_CLEAR1__SHIFT 0x1c
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR1_MASK 0x20000000
#define MC_ARB_GECC2_STATUS__RMWRD_UNCORR_CLEAR1__SHIFT 0x1d
#define MC_ARB_GECC2_MISC__STREAK_BREAK_MASK 0xf
#define MC_ARB_GECC2_MISC__STREAK_BREAK__SHIFT 0x0
#define MC_ARB_GECC2_MISC__COL10_HACK_MASK 0x10
#define MC_ARB_GECC2_MISC__COL10_HACK__SHIFT 0x4
#define MC_ARB_GECC2_MISC__CWRD_IN_REPLAY_MASK 0x20
#define MC_ARB_GECC2_MISC__CWRD_IN_REPLAY__SHIFT 0x5
#define MC_ARB_GECC2_MISC__NO_EOB_ALL_WR_IN_REPLAY_MASK 0x40
#define MC_ARB_GECC2_MISC__NO_EOB_ALL_WR_IN_REPLAY__SHIFT 0x6
#define MC_ARB_GECC2_MISC__DEBUG_RSV_MASK 0xffffff80
#define MC_ARB_GECC2_MISC__DEBUG_RSV__SHIFT 0x7
#define MC_ARB_GECC2_DEBUG__NUM_ERR_BITS_MASK 0x3
#define MC_ARB_GECC2_DEBUG__NUM_ERR_BITS__SHIFT 0x0
#define MC_ARB_GECC2_DEBUG__DIRECTION_MASK 0x4
#define MC_ARB_GECC2_DEBUG__DIRECTION__SHIFT 0x2
#define MC_ARB_GECC2_DEBUG__DATA_FIELD_MASK 0x18
#define MC_ARB_GECC2_DEBUG__DATA_FIELD__SHIFT 0x3
#define MC_ARB_GECC2_DEBUG__SW_INJECTION_MASK 0x20
#define MC_ARB_GECC2_DEBUG__SW_INJECTION__SHIFT 0x5
#define MC_ARB_GECC2_DEBUG2__PERIOD_MASK 0xff
#define MC_ARB_GECC2_DEBUG2__PERIOD__SHIFT 0x0
#define MC_ARB_GECC2_DEBUG2__ERR0_START_MASK 0xff00
#define MC_ARB_GECC2_DEBUG2__ERR0_START__SHIFT 0x8
#define MC_ARB_GECC2_DEBUG2__ERR1_START_MASK 0xff0000
#define MC_ARB_GECC2_DEBUG2__ERR1_START__SHIFT 0x10
#define MC_ARB_GECC2_DEBUG2__ERR2_START_MASK 0xff000000
#define MC_ARB_GECC2_DEBUG2__ERR2_START__SHIFT 0x18
#define MC_ARB_GECC2__ENABLE_MASK 0x1
#define MC_ARB_GECC2__ENABLE__SHIFT 0x0
#define MC_ARB_GECC2__ECC_MODE_MASK 0x6
#define MC_ARB_GECC2__ECC_MODE__SHIFT 0x1
#define MC_ARB_GECC2__PAGE_BIT0_MASK 0x18
#define MC_ARB_GECC2__PAGE_BIT0__SHIFT 0x3
#define MC_ARB_GECC2__EXOR_BANK_SEL_MASK 0x60
#define MC_ARB_GECC2__EXOR_BANK_SEL__SHIFT 0x5
#define MC_ARB_GECC2__NO_GECC_CLI_MASK 0x780
#define MC_ARB_GECC2__NO_GECC_CLI__SHIFT 0x7
#define MC_ARB_GECC2__READ_ERR_MASK 0x3800
#define MC_ARB_GECC2__READ_ERR__SHIFT 0xb
#define MC_ARB_GECC2__CLOSE_BANK_RMW_MASK 0x4000
#define MC_ARB_GECC2__CLOSE_BANK_RMW__SHIFT 0xe
#define MC_ARB_GECC2__COLFIFO_WATER_MASK 0x1f8000
#define MC_ARB_GECC2__COLFIFO_WATER__SHIFT 0xf
#define MC_ARB_GECC2__WRADDR_CONV_MASK 0x200000
#define MC_ARB_GECC2__WRADDR_CONV__SHIFT 0x15
#define MC_ARB_GECC2__RMWRD_UNCOR_POISON_MASK 0x400000
#define MC_ARB_GECC2__RMWRD_UNCOR_POISON__SHIFT 0x16
#define MC_ARB_GECC2_CLI__NO_GECC_CLI0_MASK 0xff
#define MC_ARB_GECC2_CLI__NO_GECC_CLI0__SHIFT 0x0
#define MC_ARB_GECC2_CLI__NO_GECC_CLI1_MASK 0xff00
#define MC_ARB_GECC2_CLI__NO_GECC_CLI1__SHIFT 0x8
#define MC_ARB_GECC2_CLI__NO_GECC_CLI2_MASK 0xff0000
#define MC_ARB_GECC2_CLI__NO_GECC_CLI2__SHIFT 0x10
#define MC_ARB_GECC2_CLI__NO_GECC_CLI3_MASK 0xff000000
#define MC_ARB_GECC2_CLI__NO_GECC_CLI3__SHIFT 0x18
#define MC_ARB_ADDR_SWIZ0__A8_MASK 0xf
#define MC_ARB_ADDR_SWIZ0__A8__SHIFT 0x0
#define MC_ARB_ADDR_SWIZ0__A9_MASK 0xf0
#define MC_ARB_ADDR_SWIZ0__A9__SHIFT 0x4
#define MC_ARB_ADDR_SWIZ0__A10_MASK 0xf00
#define MC_ARB_ADDR_SWIZ0__A10__SHIFT 0x8
#define MC_ARB_ADDR_SWIZ0__A11_MASK 0xf000
#define MC_ARB_ADDR_SWIZ0__A11__SHIFT 0xc
#define MC_ARB_ADDR_SWIZ0__A12_MASK 0xf0000
#define MC_ARB_ADDR_SWIZ0__A12__SHIFT 0x10
#define MC_ARB_ADDR_SWIZ0__A13_MASK 0xf00000
#define MC_ARB_ADDR_SWIZ0__A13__SHIFT 0x14
#define MC_ARB_ADDR_SWIZ0__A14_MASK 0xf000000
#define MC_ARB_ADDR_SWIZ0__A14__SHIFT 0x18
#define MC_ARB_ADDR_SWIZ0__A15_MASK 0xf0000000
#define MC_ARB_ADDR_SWIZ0__A15__SHIFT 0x1c
#define MC_ARB_ADDR_SWIZ1__A16_MASK 0xf
#define MC_ARB_ADDR_SWIZ1__A16__SHIFT 0x0
#define MC_ARB_ADDR_SWIZ1__A17_MASK 0xf0
#define MC_ARB_ADDR_SWIZ1__A17__SHIFT 0x4
#define MC_ARB_ADDR_SWIZ1__A18_MASK 0xf00
#define MC_ARB_ADDR_SWIZ1__A18__SHIFT 0x8
#define MC_ARB_ADDR_SWIZ1__A19_MASK 0xf000
#define MC_ARB_ADDR_SWIZ1__A19__SHIFT 0xc
#define MC_ARB_MISC3__NO_GECC_EXT_EOB_MASK 0x1
#define MC_ARB_MISC3__NO_GECC_EXT_EOB__SHIFT 0x0
#define MC_ARB_MISC3__TBD_FIELD_MASK 0xfffffffe
#define MC_ARB_MISC3__TBD_FIELD__SHIFT 0x1
#define MC_ARB_WCDR_2__WPRE_INC_STEP_MASK 0xf
#define MC_ARB_WCDR_2__WPRE_INC_STEP__SHIFT 0x0
#define MC_ARB_WCDR_2__WPRE_MIN_THRESHOLD_MASK 0x1f0
#define MC_ARB_WCDR_2__WPRE_MIN_THRESHOLD__SHIFT 0x4
#define MC_ARB_WCDR_2__DEBUG_0_MASK 0x200
#define MC_ARB_WCDR_2__DEBUG_0__SHIFT 0x9
#define MC_ARB_WCDR_2__DEBUG_1_MASK 0x400
#define MC_ARB_WCDR_2__DEBUG_1__SHIFT 0xa
#define MC_ARB_WCDR_2__DEBUG_2_MASK 0x800
#define MC_ARB_WCDR_2__DEBUG_2__SHIFT 0xb
#define MC_ARB_WCDR_2__DEBUG_3_MASK 0x1000
#define MC_ARB_WCDR_2__DEBUG_3__SHIFT 0xc
#define MC_ARB_WCDR_2__DEBUG_4_MASK 0x2000
#define MC_ARB_WCDR_2__DEBUG_4__SHIFT 0xd
#define MC_ARB_WCDR_2__DEBUG_5_MASK 0x4000
#define MC_ARB_WCDR_2__DEBUG_5__SHIFT 0xe
#define MC_ARB_RTT_DATA__PATTERN_MASK 0xff
#define MC_ARB_RTT_DATA__PATTERN__SHIFT 0x0
#define MC_ARB_RTT_CNTL0__ENABLE_MASK 0x1
#define MC_ARB_RTT_CNTL0__ENABLE__SHIFT 0x0
#define MC_ARB_RTT_CNTL0__START_IDLE_MASK 0x2
#define MC_ARB_RTT_CNTL0__START_IDLE__SHIFT 0x1
#define MC_ARB_RTT_CNTL0__START_R2W_MASK 0xc
#define MC_ARB_RTT_CNTL0__START_R2W__SHIFT 0x2
#define MC_ARB_RTT_CNTL0__FLUSH_ON_ENTER_MASK 0x10
#define MC_ARB_RTT_CNTL0__FLUSH_ON_ENTER__SHIFT 0x4
#define MC_ARB_RTT_CNTL0__HARSH_START_MASK 0x20
#define MC_ARB_RTT_CNTL0__HARSH_START__SHIFT 0x5
#define MC_ARB_RTT_CNTL0__TPS_HARSH_PRIORITY_MASK 0x40
#define MC_ARB_RTT_CNTL0__TPS_HARSH_PRIORITY__SHIFT 0x6
#define MC_ARB_RTT_CNTL0__TWRT_HARSH_PRIORITY_MASK 0x80
#define MC_ARB_RTT_CNTL0__TWRT_HARSH_PRIORITY__SHIFT 0x7
#define MC_ARB_RTT_CNTL0__BREAK_ON_HARSH_MASK 0x100
#define MC_ARB_RTT_CNTL0__BREAK_ON_HARSH__SHIFT 0x8
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTRD_MASK 0x200
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTRD__SHIFT 0x9
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTWR_MASK 0x400
#define MC_ARB_RTT_CNTL0__BREAK_ON_URGENTWR__SHIFT 0xa
#define MC_ARB_RTT_CNTL0__TRAIN_PERIOD_MASK 0x3800
#define MC_ARB_RTT_CNTL0__TRAIN_PERIOD__SHIFT 0xb
#define MC_ARB_RTT_CNTL0__START_R2W_RFSH_MASK 0x4000
#define MC_ARB_RTT_CNTL0__START_R2W_RFSH__SHIFT 0xe
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_0_MASK 0x8000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_0__SHIFT 0xf
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_1_MASK 0x10000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_1__SHIFT 0x10
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_2_MASK 0x20000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_2__SHIFT 0x11
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_3_MASK 0x40000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_3__SHIFT 0x12
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_4_MASK 0x80000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_4__SHIFT 0x13
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_5_MASK 0x100000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_5__SHIFT 0x14
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_6_MASK 0x200000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_6__SHIFT 0x15
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_7_MASK 0x400000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_7__SHIFT 0x16
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_8_MASK 0x800000
#define MC_ARB_RTT_CNTL0__DEBUG_RSV_8__SHIFT 0x17
#define MC_ARB_RTT_CNTL0__DATA_CNTL_MASK 0x1000000
#define MC_ARB_RTT_CNTL0__DATA_CNTL__SHIFT 0x18
#define MC_ARB_RTT_CNTL0__NEIGHBOR_BIT_MASK 0x2000000
#define MC_ARB_RTT_CNTL0__NEIGHBOR_BIT__SHIFT 0x19
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MASK 0x1f
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE__SHIFT 0x0
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_MASK 0x20
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE__SHIFT 0x5
#define MC_ARB_RTT_CNTL1__WINDOW_INC_THRESHOLD_MASK 0x1fc0
#define MC_ARB_RTT_CNTL1__WINDOW_INC_THRESHOLD__SHIFT 0x6
#define MC_ARB_RTT_CNTL1__WINDOW_DEC_THRESHOLD_MASK 0xfe000
#define MC_ARB_RTT_CNTL1__WINDOW_DEC_THRESHOLD__SHIFT 0xd
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MAX_MASK 0x1f00000
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MAX__SHIFT 0x14
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MIN_MASK 0x3e000000
#define MC_ARB_RTT_CNTL1__WINDOW_SIZE_MIN__SHIFT 0x19
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_COUNT_MASK 0xc0000000
#define MC_ARB_RTT_CNTL1__WINDOW_UPDATE_COUNT__SHIFT 0x1e
#define MC_ARB_RTT_CNTL2__SAMPLE_CNT_MASK 0x3f
#define MC_ARB_RTT_CNTL2__SAMPLE_CNT__SHIFT 0x0
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_THRESHOLD_MASK 0xfc0
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_THRESHOLD__SHIFT 0x6
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_SIZE_MASK 0x1000
#define MC_ARB_RTT_CNTL2__PHASE_ADJUST_SIZE__SHIFT 0xc
#define MC_ARB_RTT_CNTL2__FILTER_CNTL_MASK 0x2000
#define MC_ARB_RTT_CNTL2__FILTER_CNTL__SHIFT 0xd
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH0_MASK 0x3
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH0__SHIFT 0x0
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH1_MASK 0xc
#define MC_ARB_RTT_DEBUG__DEBUG_BYTE_CH1__SHIFT 0x2
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH0_MASK 0xff0
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH0__SHIFT 0x4
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH0_MASK 0x1f000
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH0__SHIFT 0xc
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH1_MASK 0x1fe0000
#define MC_ARB_RTT_DEBUG__SHIFTED_PHASE_CH1__SHIFT 0x11
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH1_MASK 0x3e000000
#define MC_ARB_RTT_DEBUG__WINDOW_SIZE_CH1__SHIFT 0x19
#define MC_ARB_CAC_CNTL__ENABLE_MASK 0x1
#define MC_ARB_CAC_CNTL__ENABLE__SHIFT 0x0
#define MC_ARB_CAC_CNTL__READ_WEIGHT_MASK 0x7e
#define MC_ARB_CAC_CNTL__READ_WEIGHT__SHIFT 0x1
#define MC_ARB_CAC_CNTL__WRITE_WEIGHT_MASK 0x1f80
#define MC_ARB_CAC_CNTL__WRITE_WEIGHT__SHIFT 0x7
#define MC_ARB_CAC_CNTL__ALLOW_OVERFLOW_MASK 0x2000
#define MC_ARB_CAC_CNTL__ALLOW_OVERFLOW__SHIFT 0xd
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_ENABLE_MASK 0x20
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_ENABLE__SHIFT 0x5
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT4_MASK 0x40
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT4__SHIFT 0x6
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT5_MASK 0x80
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT5__SHIFT 0x7
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT6_MASK 0x100
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT6__SHIFT 0x8
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT7_MASK 0x200
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT7__SHIFT 0x9
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT8_MASK 0x400
#define MC_ARB_MISC2__TCCDL4_BANKBIT3_XOR_COLBIT8__SHIFT 0xa
#define MC_ARB_MISC2__POP_IDLE_REPLAY_MASK 0x800
#define MC_ARB_MISC2__POP_IDLE_REPLAY__SHIFT 0xb
#define MC_ARB_MISC2__RDRET_NO_REORDERING_MASK 0x1000
#define MC_ARB_MISC2__RDRET_NO_REORDERING__SHIFT 0xc
#define MC_ARB_MISC2__RDRET_NO_BP_MASK 0x2000
#define MC_ARB_MISC2__RDRET_NO_BP__SHIFT 0xd
#define MC_ARB_MISC2__RDRET_SEQ_SKID_MASK 0x3c000
#define MC_ARB_MISC2__RDRET_SEQ_SKID__SHIFT 0xe
#define MC_ARB_MISC2__GECC_MASK 0x40000
#define MC_ARB_MISC2__GECC__SHIFT 0x12
#define MC_ARB_MISC2__GECC_RST_MASK 0x80000
#define MC_ARB_MISC2__GECC_RST__SHIFT 0x13
#define MC_ARB_MISC2__GECC_STATUS_MASK 0x100000
#define MC_ARB_MISC2__GECC_STATUS__SHIFT 0x14
#define MC_ARB_MISC2__TAGFIFO_THRESHOLD_MASK 0x1e00000
#define MC_ARB_MISC2__TAGFIFO_THRESHOLD__SHIFT 0x15
#define MC_ARB_MISC2__WCDR_REPLAY_MASKCNT_MASK 0xe000000
#define MC_ARB_MISC2__WCDR_REPLAY_MASKCNT__SHIFT 0x19
#define MC_ARB_MISC2__REPLAY_DEBUG_MASK 0x10000000
#define MC_ARB_MISC2__REPLAY_DEBUG__SHIFT 0x1c
#define MC_ARB_MISC2__ARB_DEBUG29_MASK 0x20000000
#define MC_ARB_MISC2__ARB_DEBUG29__SHIFT 0x1d
#define MC_ARB_MISC2__SEQ_RDY_POP_IDLE_MASK 0x40000000
#define MC_ARB_MISC2__SEQ_RDY_POP_IDLE__SHIFT 0x1e
#define MC_ARB_MISC2__TCCDL4_REPLAY_EOB_MASK 0x80000000
#define MC_ARB_MISC2__TCCDL4_REPLAY_EOB__SHIFT 0x1f
#define MC_ARB_MISC__STICKY_RFSH_MASK 0x1
#define MC_ARB_MISC__STICKY_RFSH__SHIFT 0x0
#define MC_ARB_MISC__IDLE_RFSH_MASK 0x2
#define MC_ARB_MISC__IDLE_RFSH__SHIFT 0x1
#define MC_ARB_MISC__STUTTER_RFSH_MASK 0x4
#define MC_ARB_MISC__STUTTER_RFSH__SHIFT 0x2
#define MC_ARB_MISC__CHAN_COUPLE_MASK 0x7f8
#define MC_ARB_MISC__CHAN_COUPLE__SHIFT 0x3
#define MC_ARB_MISC__HARSHNESS_MASK 0x7f800
#define MC_ARB_MISC__HARSHNESS__SHIFT 0xb
#define MC_ARB_MISC__SMART_RDWR_SW_MASK 0x80000
#define MC_ARB_MISC__SMART_RDWR_SW__SHIFT 0x13
#define MC_ARB_MISC__CALI_ENABLE_MASK 0x100000
#define MC_ARB_MISC__CALI_ENABLE__SHIFT 0x14
#define MC_ARB_MISC__CALI_RATES_MASK 0x600000
#define MC_ARB_MISC__CALI_RATES__SHIFT 0x15
#define MC_ARB_MISC__DISPURGVLD_NOWRT_MASK 0x800000
#define MC_ARB_MISC__DISPURGVLD_NOWRT__SHIFT 0x17
#define MC_ARB_MISC__DISPURG_NOSW2WR_MASK 0x1000000
#define MC_ARB_MISC__DISPURG_NOSW2WR__SHIFT 0x18
#define MC_ARB_MISC__DISPURG_STALL_MASK 0x2000000
#define MC_ARB_MISC__DISPURG_STALL__SHIFT 0x19
#define MC_ARB_MISC__DISPURG_THROTTLE_MASK 0x3c000000
#define MC_ARB_MISC__DISPURG_THROTTLE__SHIFT 0x1a
#define MC_ARB_MISC__EXTEND_WEIGHT_MASK 0x40000000
#define MC_ARB_MISC__EXTEND_WEIGHT__SHIFT 0x1e
#define MC_ARB_MISC__ACPURG_STALL_MASK 0x80000000
#define MC_ARB_MISC__ACPURG_STALL__SHIFT 0x1f
#define MC_ARB_BANKMAP__BANK0_MASK 0xf
#define MC_ARB_BANKMAP__BANK0__SHIFT 0x0
#define MC_ARB_BANKMAP__BANK1_MASK 0xf0
#define MC_ARB_BANKMAP__BANK1__SHIFT 0x4
#define MC_ARB_BANKMAP__BANK2_MASK 0xf00
#define MC_ARB_BANKMAP__BANK2__SHIFT 0x8
#define MC_ARB_BANKMAP__BANK3_MASK 0xf000
#define MC_ARB_BANKMAP__BANK3__SHIFT 0xc
#define MC_ARB_BANKMAP__RANK_MASK 0xf0000
#define MC_ARB_BANKMAP__RANK__SHIFT 0x10
#define MC_ARB_RAMCFG__NOOFBANK_MASK 0x3
#define MC_ARB_RAMCFG__NOOFBANK__SHIFT 0x0
#define MC_ARB_RAMCFG__NOOFRANKS_MASK 0x4
#define MC_ARB_RAMCFG__NOOFRANKS__SHIFT 0x2
#define MC_ARB_RAMCFG__NOOFROWS_MASK 0x38
#define MC_ARB_RAMCFG__NOOFROWS__SHIFT 0x3
#define MC_ARB_RAMCFG__NOOFCOLS_MASK 0xc0
#define MC_ARB_RAMCFG__NOOFCOLS__SHIFT 0x6
#define MC_ARB_RAMCFG__CHANSIZE_MASK 0x100
#define MC_ARB_RAMCFG__CHANSIZE__SHIFT 0x8
#define MC_ARB_RAMCFG__RSV_1_MASK 0x200
#define MC_ARB_RAMCFG__RSV_1__SHIFT 0x9
#define MC_ARB_RAMCFG__RSV_2_MASK 0x400
#define MC_ARB_RAMCFG__RSV_2__SHIFT 0xa
#define MC_ARB_RAMCFG__RSV_3_MASK 0x800
#define MC_ARB_RAMCFG__RSV_3__SHIFT 0xb
#define MC_ARB_RAMCFG__NOOFGROUPS_MASK 0x1000
#define MC_ARB_RAMCFG__NOOFGROUPS__SHIFT 0xc
#define MC_ARB_RAMCFG__RSV_4_MASK 0x3e000
#define MC_ARB_RAMCFG__RSV_4__SHIFT 0xd
#define MC_ARB_POP__ENABLE_ARB_MASK 0x1
#define MC_ARB_POP__ENABLE_ARB__SHIFT 0x0
#define MC_ARB_POP__SPEC_OPEN_MASK 0x2
#define MC_ARB_POP__SPEC_OPEN__SHIFT 0x1
#define MC_ARB_POP__POP_DEPTH_MASK 0x3c
#define MC_ARB_POP__POP_DEPTH__SHIFT 0x2
#define MC_ARB_POP__WRDATAINDEX_DEPTH_MASK 0xfc0
#define MC_ARB_POP__WRDATAINDEX_DEPTH__SHIFT 0x6
#define MC_ARB_POP__SKID_DEPTH_MASK 0x7000
#define MC_ARB_POP__SKID_DEPTH__SHIFT 0xc
#define MC_ARB_POP__WAIT_AFTER_RFSH_MASK 0x18000
#define MC_ARB_POP__WAIT_AFTER_RFSH__SHIFT 0xf
#define MC_ARB_POP__QUICK_STOP_MASK 0x20000
#define MC_ARB_POP__QUICK_STOP__SHIFT 0x11
#define MC_ARB_POP__ENABLE_TWO_PAGE_MASK 0x40000
#define MC_ARB_POP__ENABLE_TWO_PAGE__SHIFT 0x12
#define MC_ARB_POP__ALLOW_EOB_BY_WRRET_STALL_MASK 0x80000
#define MC_ARB_POP__ALLOW_EOB_BY_WRRET_STALL__SHIFT 0x13
#define MC_ARB_MINCLKS__READ_CLKS_MASK 0xff
#define MC_ARB_MINCLKS__READ_CLKS__SHIFT 0x0
#define MC_ARB_MINCLKS__WRITE_CLKS_MASK 0xff00
#define MC_ARB_MINCLKS__WRITE_CLKS__SHIFT 0x8
#define MC_ARB_MINCLKS__ARB_RW_SWITCH_MASK 0x10000
#define MC_ARB_MINCLKS__ARB_RW_SWITCH__SHIFT 0x10
#define MC_ARB_MINCLKS__RW_SWITCH_HARSH_MASK 0x60000
#define MC_ARB_MINCLKS__RW_SWITCH_HARSH__SHIFT 0x11
#define MC_ARB_SQM_CNTL__MIN_PENAL_MASK 0xff
#define MC_ARB_SQM_CNTL__MIN_PENAL__SHIFT 0x0
#define MC_ARB_SQM_CNTL__DYN_SQM_ENABLE_MASK 0x100
#define MC_ARB_SQM_CNTL__DYN_SQM_ENABLE__SHIFT 0x8
#define MC_ARB_SQM_CNTL__SQM_RDY16_MASK 0x200
#define MC_ARB_SQM_CNTL__SQM_RDY16__SHIFT 0x9
#define MC_ARB_SQM_CNTL__SQM_RESERVE_MASK 0xfc00
#define MC_ARB_SQM_CNTL__SQM_RESERVE__SHIFT 0xa
#define MC_ARB_SQM_CNTL__RATIO_MASK 0xff0000
#define MC_ARB_SQM_CNTL__RATIO__SHIFT 0x10
#define MC_ARB_SQM_CNTL__RATIO_DEBUG_MASK 0xff000000
#define MC_ARB_SQM_CNTL__RATIO_DEBUG__SHIFT 0x18
#define MC_ARB_ADDR_HASH__BANK_XOR_ENABLE_MASK 0xf
#define MC_ARB_ADDR_HASH__BANK_XOR_ENABLE__SHIFT 0x0
#define MC_ARB_ADDR_HASH__COL_XOR_MASK 0xff0
#define MC_ARB_ADDR_HASH__COL_XOR__SHIFT 0x4
#define MC_ARB_ADDR_HASH__ROW_XOR_MASK 0xffff000
#define MC_ARB_ADDR_HASH__ROW_XOR__SHIFT 0xc
#define MC_ARB_DRAM_TIMING__ACTRD_MASK 0xff
#define MC_ARB_DRAM_TIMING__ACTRD__SHIFT 0x0
#define MC_ARB_DRAM_TIMING__ACTWR_MASK 0xff00
#define MC_ARB_DRAM_TIMING__ACTWR__SHIFT 0x8
#define MC_ARB_DRAM_TIMING__RASMACTRD_MASK 0xff0000
#define MC_ARB_DRAM_TIMING__RASMACTRD__SHIFT 0x10
#define MC_ARB_DRAM_TIMING__RASMACTWR_MASK 0xff000000
#define MC_ARB_DRAM_TIMING__RASMACTWR__SHIFT 0x18
#define MC_ARB_DRAM_TIMING2__RAS2RAS_MASK 0xff
#define MC_ARB_DRAM_TIMING2__RAS2RAS__SHIFT 0x0
#define MC_ARB_DRAM_TIMING2__RP_MASK 0xff00
#define MC_ARB_DRAM_TIMING2__RP__SHIFT 0x8
#define MC_ARB_DRAM_TIMING2__WRPLUSRP_MASK 0xff0000
#define MC_ARB_DRAM_TIMING2__WRPLUSRP__SHIFT 0x10
#define MC_ARB_DRAM_TIMING2__BUS_TURN_MASK 0x1f000000
#define MC_ARB_DRAM_TIMING2__BUS_TURN__SHIFT 0x18
#define MC_ARB_WTM_CNTL_RD__WTMODE_MASK 0x3
#define MC_ARB_WTM_CNTL_RD__WTMODE__SHIFT 0x0
#define MC_ARB_WTM_CNTL_RD__HARSH_PRI_MASK 0x4
#define MC_ARB_WTM_CNTL_RD__HARSH_PRI__SHIFT 0x2
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP0_MASK 0x8
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP0__SHIFT 0x3
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP1_MASK 0x10
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP1__SHIFT 0x4
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP2_MASK 0x20
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP2__SHIFT 0x5
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP3_MASK 0x40
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP3__SHIFT 0x6
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP4_MASK 0x80
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP4__SHIFT 0x7
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP5_MASK 0x100
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP5__SHIFT 0x8
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP6_MASK 0x200
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP6__SHIFT 0x9
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP7_MASK 0x400
#define MC_ARB_WTM_CNTL_RD__ALLOW_STUTTER_GRP7__SHIFT 0xa
#define MC_ARB_WTM_CNTL_RD__ACP_HARSH_PRI_MASK 0x800
#define MC_ARB_WTM_CNTL_RD__ACP_HARSH_PRI__SHIFT 0xb
#define MC_ARB_WTM_CNTL_RD__ACP_OVER_DISP_MASK 0x1000
#define MC_ARB_WTM_CNTL_RD__ACP_OVER_DISP__SHIFT 0xc
#define MC_ARB_WTM_CNTL_RD__FORCE_ACP_URG_MASK 0x2000
#define MC_ARB_WTM_CNTL_RD__FORCE_ACP_URG__SHIFT 0xd
#define MC_ARB_WTM_CNTL_WR__WTMODE_MASK 0x3
#define MC_ARB_WTM_CNTL_WR__WTMODE__SHIFT 0x0
#define MC_ARB_WTM_CNTL_WR__HARSH_PRI_MASK 0x4
#define MC_ARB_WTM_CNTL_WR__HARSH_PRI__SHIFT 0x2
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP0_MASK 0x8
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP0__SHIFT 0x3
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP1_MASK 0x10
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP1__SHIFT 0x4
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP2_MASK 0x20
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP2__SHIFT 0x5
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP3_MASK 0x40
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP3__SHIFT 0x6
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP4_MASK 0x80
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP4__SHIFT 0x7
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP5_MASK 0x100
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP5__SHIFT 0x8
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP6_MASK 0x200
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP6__SHIFT 0x9
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP7_MASK 0x400
#define MC_ARB_WTM_CNTL_WR__ALLOW_STUTTER_GRP7__SHIFT 0xa
#define MC_ARB_WTM_CNTL_WR__ACP_HARSH_PRI_MASK 0x800
#define MC_ARB_WTM_CNTL_WR__ACP_HARSH_PRI__SHIFT 0xb
#define MC_ARB_WTM_CNTL_WR__ACP_OVER_DISP_MASK 0x1000
#define MC_ARB_WTM_CNTL_WR__ACP_OVER_DISP__SHIFT 0xc
#define MC_ARB_WTM_CNTL_WR__FORCE_ACP_URG_MASK 0x2000
#define MC_ARB_WTM_CNTL_WR__FORCE_ACP_URG__SHIFT 0xd
#define MC_ARB_WTM_GRPWT_RD__GRP0_MASK 0x3
#define MC_ARB_WTM_GRPWT_RD__GRP0__SHIFT 0x0
#define MC_ARB_WTM_GRPWT_RD__GRP1_MASK 0xc
#define MC_ARB_WTM_GRPWT_RD__GRP1__SHIFT 0x2
#define MC_ARB_WTM_GRPWT_RD__GRP2_MASK 0x30
#define MC_ARB_WTM_GRPWT_RD__GRP2__SHIFT 0x4
#define MC_ARB_WTM_GRPWT_RD__GRP3_MASK 0xc0
#define MC_ARB_WTM_GRPWT_RD__GRP3__SHIFT 0x6
#define MC_ARB_WTM_GRPWT_RD__GRP4_MASK 0x300
#define MC_ARB_WTM_GRPWT_RD__GRP4__SHIFT 0x8
#define MC_ARB_WTM_GRPWT_RD__GRP5_MASK 0xc00
#define MC_ARB_WTM_GRPWT_RD__GRP5__SHIFT 0xa
#define MC_ARB_WTM_GRPWT_RD__GRP6_MASK 0x3000
#define MC_ARB_WTM_GRPWT_RD__GRP6__SHIFT 0xc
#define MC_ARB_WTM_GRPWT_RD__GRP7_MASK 0xc000
#define MC_ARB_WTM_GRPWT_RD__GRP7__SHIFT 0xe
#define MC_ARB_WTM_GRPWT_RD__GRP_EXT_MASK 0xff0000
#define MC_ARB_WTM_GRPWT_RD__GRP_EXT__SHIFT 0x10
#define MC_ARB_WTM_GRPWT_WR__GRP0_MASK 0x3
#define MC_ARB_WTM_GRPWT_WR__GRP0__SHIFT 0x0
#define MC_ARB_WTM_GRPWT_WR__GRP1_MASK 0xc
#define MC_ARB_WTM_GRPWT_WR__GRP1__SHIFT 0x2
#define MC_ARB_WTM_GRPWT_WR__GRP2_MASK 0x30
#define MC_ARB_WTM_GRPWT_WR__GRP2__SHIFT 0x4
#define MC_ARB_WTM_GRPWT_WR__GRP3_MASK 0xc0
#define MC_ARB_WTM_GRPWT_WR__GRP3__SHIFT 0x6
#define MC_ARB_WTM_GRPWT_WR__GRP4_MASK 0x300
#define MC_ARB_WTM_GRPWT_WR__GRP4__SHIFT 0x8
#define MC_ARB_WTM_GRPWT_WR__GRP5_MASK 0xc00
#define MC_ARB_WTM_GRPWT_WR__GRP5__SHIFT 0xa
#define MC_ARB_WTM_GRPWT_WR__GRP6_MASK 0x3000
#define MC_ARB_WTM_GRPWT_WR__GRP6__SHIFT 0xc
#define MC_ARB_WTM_GRPWT_WR__GRP7_MASK 0xc000
#define MC_ARB_WTM_GRPWT_WR__GRP7__SHIFT 0xe
#define MC_ARB_WTM_GRPWT_WR__GRP_EXT_MASK 0xff0000
#define MC_ARB_WTM_GRPWT_WR__GRP_EXT__SHIFT 0x10
#define MC_ARB_TM_CNTL_RD__GROUPBY_RANK_MASK 0x1
#define MC_ARB_TM_CNTL_RD__GROUPBY_RANK__SHIFT 0x0
#define MC_ARB_TM_CNTL_RD__BANK_SELECT_MASK 0x6
#define MC_ARB_TM_CNTL_RD__BANK_SELECT__SHIFT 0x1
#define MC_ARB_TM_CNTL_RD__MATCH_RANK_MASK 0x8
#define MC_ARB_TM_CNTL_RD__MATCH_RANK__SHIFT 0x3
#define MC_ARB_TM_CNTL_RD__MATCH_BANK_MASK 0x10
#define MC_ARB_TM_CNTL_RD__MATCH_BANK__SHIFT 0x4
#define MC_ARB_TM_CNTL_WR__GROUPBY_RANK_MASK 0x1
#define MC_ARB_TM_CNTL_WR__GROUPBY_RANK__SHIFT 0x0
#define MC_ARB_TM_CNTL_WR__BANK_SELECT_MASK 0x6
#define MC_ARB_TM_CNTL_WR__BANK_SELECT__SHIFT 0x1
#define MC_ARB_TM_CNTL_WR__MATCH_RANK_MASK 0x8
#define MC_ARB_TM_CNTL_WR__MATCH_RANK__SHIFT 0x3
#define MC_ARB_TM_CNTL_WR__MATCH_BANK_MASK 0x10
#define MC_ARB_TM_CNTL_WR__MATCH_BANK__SHIFT 0x4
#define MC_ARB_LAZY0_RD__GROUP0_MASK 0xff
#define MC_ARB_LAZY0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_LAZY0_RD__GROUP1_MASK 0xff00
#define MC_ARB_LAZY0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_LAZY0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_LAZY0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_LAZY0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_LAZY0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_LAZY0_WR__GROUP0_MASK 0xff
#define MC_ARB_LAZY0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_LAZY0_WR__GROUP1_MASK 0xff00
#define MC_ARB_LAZY0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_LAZY0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_LAZY0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_LAZY0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_LAZY0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_LAZY1_RD__GROUP4_MASK 0xff
#define MC_ARB_LAZY1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_LAZY1_RD__GROUP5_MASK 0xff00
#define MC_ARB_LAZY1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_LAZY1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_LAZY1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_LAZY1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_LAZY1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_LAZY1_WR__GROUP4_MASK 0xff
#define MC_ARB_LAZY1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_LAZY1_WR__GROUP5_MASK 0xff00
#define MC_ARB_LAZY1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_LAZY1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_LAZY1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_LAZY1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_LAZY1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_AGE_RD__RATE_GROUP0_MASK 0x3
#define MC_ARB_AGE_RD__RATE_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_RD__RATE_GROUP1_MASK 0xc
#define MC_ARB_AGE_RD__RATE_GROUP1__SHIFT 0x2
#define MC_ARB_AGE_RD__RATE_GROUP2_MASK 0x30
#define MC_ARB_AGE_RD__RATE_GROUP2__SHIFT 0x4
#define MC_ARB_AGE_RD__RATE_GROUP3_MASK 0xc0
#define MC_ARB_AGE_RD__RATE_GROUP3__SHIFT 0x6
#define MC_ARB_AGE_RD__RATE_GROUP4_MASK 0x300
#define MC_ARB_AGE_RD__RATE_GROUP4__SHIFT 0x8
#define MC_ARB_AGE_RD__RATE_GROUP5_MASK 0xc00
#define MC_ARB_AGE_RD__RATE_GROUP5__SHIFT 0xa
#define MC_ARB_AGE_RD__RATE_GROUP6_MASK 0x3000
#define MC_ARB_AGE_RD__RATE_GROUP6__SHIFT 0xc
#define MC_ARB_AGE_RD__RATE_GROUP7_MASK 0xc000
#define MC_ARB_AGE_RD__RATE_GROUP7__SHIFT 0xe
#define MC_ARB_AGE_RD__ENABLE_GROUP0_MASK 0x10000
#define MC_ARB_AGE_RD__ENABLE_GROUP0__SHIFT 0x10
#define MC_ARB_AGE_RD__ENABLE_GROUP1_MASK 0x20000
#define MC_ARB_AGE_RD__ENABLE_GROUP1__SHIFT 0x11
#define MC_ARB_AGE_RD__ENABLE_GROUP2_MASK 0x40000
#define MC_ARB_AGE_RD__ENABLE_GROUP2__SHIFT 0x12
#define MC_ARB_AGE_RD__ENABLE_GROUP3_MASK 0x80000
#define MC_ARB_AGE_RD__ENABLE_GROUP3__SHIFT 0x13
#define MC_ARB_AGE_RD__ENABLE_GROUP4_MASK 0x100000
#define MC_ARB_AGE_RD__ENABLE_GROUP4__SHIFT 0x14
#define MC_ARB_AGE_RD__ENABLE_GROUP5_MASK 0x200000
#define MC_ARB_AGE_RD__ENABLE_GROUP5__SHIFT 0x15
#define MC_ARB_AGE_RD__ENABLE_GROUP6_MASK 0x400000
#define MC_ARB_AGE_RD__ENABLE_GROUP6__SHIFT 0x16
#define MC_ARB_AGE_RD__ENABLE_GROUP7_MASK 0x800000
#define MC_ARB_AGE_RD__ENABLE_GROUP7__SHIFT 0x17
#define MC_ARB_AGE_RD__DIVIDE_GROUP0_MASK 0x1000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP0__SHIFT 0x18
#define MC_ARB_AGE_RD__DIVIDE_GROUP1_MASK 0x2000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP1__SHIFT 0x19
#define MC_ARB_AGE_RD__DIVIDE_GROUP2_MASK 0x4000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP2__SHIFT 0x1a
#define MC_ARB_AGE_RD__DIVIDE_GROUP3_MASK 0x8000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP3__SHIFT 0x1b
#define MC_ARB_AGE_RD__DIVIDE_GROUP4_MASK 0x10000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP4__SHIFT 0x1c
#define MC_ARB_AGE_RD__DIVIDE_GROUP5_MASK 0x20000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP5__SHIFT 0x1d
#define MC_ARB_AGE_RD__DIVIDE_GROUP6_MASK 0x40000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP6__SHIFT 0x1e
#define MC_ARB_AGE_RD__DIVIDE_GROUP7_MASK 0x80000000
#define MC_ARB_AGE_RD__DIVIDE_GROUP7__SHIFT 0x1f
#define MC_ARB_AGE_WR__RATE_GROUP0_MASK 0x3
#define MC_ARB_AGE_WR__RATE_GROUP0__SHIFT 0x0
#define MC_ARB_AGE_WR__RATE_GROUP1_MASK 0xc
#define MC_ARB_AGE_WR__RATE_GROUP1__SHIFT 0x2
#define MC_ARB_AGE_WR__RATE_GROUP2_MASK 0x30
#define MC_ARB_AGE_WR__RATE_GROUP2__SHIFT 0x4
#define MC_ARB_AGE_WR__RATE_GROUP3_MASK 0xc0
#define MC_ARB_AGE_WR__RATE_GROUP3__SHIFT 0x6
#define MC_ARB_AGE_WR__RATE_GROUP4_MASK 0x300
#define MC_ARB_AGE_WR__RATE_GROUP4__SHIFT 0x8
#define MC_ARB_AGE_WR__RATE_GROUP5_MASK 0xc00
#define MC_ARB_AGE_WR__RATE_GROUP5__SHIFT 0xa
#define MC_ARB_AGE_WR__RATE_GROUP6_MASK 0x3000
#define MC_ARB_AGE_WR__RATE_GROUP6__SHIFT 0xc
#define MC_ARB_AGE_WR__RATE_GROUP7_MASK 0xc000
#define MC_ARB_AGE_WR__RATE_GROUP7__SHIFT 0xe
#define MC_ARB_AGE_WR__ENABLE_GROUP0_MASK 0x10000
#define MC_ARB_AGE_WR__ENABLE_GROUP0__SHIFT 0x10
#define MC_ARB_AGE_WR__ENABLE_GROUP1_MASK 0x20000
#define MC_ARB_AGE_WR__ENABLE_GROUP1__SHIFT 0x11
#define MC_ARB_AGE_WR__ENABLE_GROUP2_MASK 0x40000
#define MC_ARB_AGE_WR__ENABLE_GROUP2__SHIFT 0x12
#define MC_ARB_AGE_WR__ENABLE_GROUP3_MASK 0x80000
#define MC_ARB_AGE_WR__ENABLE_GROUP3__SHIFT 0x13
#define MC_ARB_AGE_WR__ENABLE_GROUP4_MASK 0x100000
#define MC_ARB_AGE_WR__ENABLE_GROUP4__SHIFT 0x14
#define MC_ARB_AGE_WR__ENABLE_GROUP5_MASK 0x200000
#define MC_ARB_AGE_WR__ENABLE_GROUP5__SHIFT 0x15
#define MC_ARB_AGE_WR__ENABLE_GROUP6_MASK 0x400000
#define MC_ARB_AGE_WR__ENABLE_GROUP6__SHIFT 0x16
#define MC_ARB_AGE_WR__ENABLE_GROUP7_MASK 0x800000
#define MC_ARB_AGE_WR__ENABLE_GROUP7__SHIFT 0x17
#define MC_ARB_AGE_WR__DIVIDE_GROUP0_MASK 0x1000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP0__SHIFT 0x18
#define MC_ARB_AGE_WR__DIVIDE_GROUP1_MASK 0x2000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP1__SHIFT 0x19
#define MC_ARB_AGE_WR__DIVIDE_GROUP2_MASK 0x4000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP2__SHIFT 0x1a
#define MC_ARB_AGE_WR__DIVIDE_GROUP3_MASK 0x8000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP3__SHIFT 0x1b
#define MC_ARB_AGE_WR__DIVIDE_GROUP4_MASK 0x10000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP4__SHIFT 0x1c
#define MC_ARB_AGE_WR__DIVIDE_GROUP5_MASK 0x20000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP5__SHIFT 0x1d
#define MC_ARB_AGE_WR__DIVIDE_GROUP6_MASK 0x40000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP6__SHIFT 0x1e
#define MC_ARB_AGE_WR__DIVIDE_GROUP7_MASK 0x80000000
#define MC_ARB_AGE_WR__DIVIDE_GROUP7__SHIFT 0x1f
#define MC_ARB_RFSH_CNTL__ENABLE_MASK 0x1
#define MC_ARB_RFSH_CNTL__ENABLE__SHIFT 0x0
#define MC_ARB_RFSH_CNTL__URG0_MASK 0x3e
#define MC_ARB_RFSH_CNTL__URG0__SHIFT 0x1
#define MC_ARB_RFSH_CNTL__URG1_MASK 0x7c0
#define MC_ARB_RFSH_CNTL__URG1__SHIFT 0x6
#define MC_ARB_RFSH_CNTL__ACCUM_MASK 0x800
#define MC_ARB_RFSH_CNTL__ACCUM__SHIFT 0xb
#define MC_ARB_RFSH_RATE__POWERMODE0_MASK 0xff
#define MC_ARB_RFSH_RATE__POWERMODE0__SHIFT 0x0
#define MC_ARB_PM_CNTL__OVERRIDE_CGSTATE_MASK 0x3
#define MC_ARB_PM_CNTL__OVERRIDE_CGSTATE__SHIFT 0x0
#define MC_ARB_PM_CNTL__OVRR_CGRFSH_MASK 0x4
#define MC_ARB_PM_CNTL__OVRR_CGRFSH__SHIFT 0x2
#define MC_ARB_PM_CNTL__OVRR_CGSQM_MASK 0x8
#define MC_ARB_PM_CNTL__OVRR_CGSQM__SHIFT 0x3
#define MC_ARB_PM_CNTL__SRFSH_ON_D1_MASK 0x10
#define MC_ARB_PM_CNTL__SRFSH_ON_D1__SHIFT 0x4
#define MC_ARB_PM_CNTL__BLKOUT_ON_D1_MASK 0x20
#define MC_ARB_PM_CNTL__BLKOUT_ON_D1__SHIFT 0x5
#define MC_ARB_PM_CNTL__IDLE_ON_D1_MASK 0x40
#define MC_ARB_PM_CNTL__IDLE_ON_D1__SHIFT 0x6
#define MC_ARB_PM_CNTL__OVRR_PM_MASK 0x80
#define MC_ARB_PM_CNTL__OVRR_PM__SHIFT 0x7
#define MC_ARB_PM_CNTL__OVRR_PM_STATE_MASK 0x300
#define MC_ARB_PM_CNTL__OVRR_PM_STATE__SHIFT 0x8
#define MC_ARB_PM_CNTL__OVRR_RD_MASK 0x400
#define MC_ARB_PM_CNTL__OVRR_RD__SHIFT 0xa
#define MC_ARB_PM_CNTL__OVRR_RD_STATE_MASK 0x800
#define MC_ARB_PM_CNTL__OVRR_RD_STATE__SHIFT 0xb
#define MC_ARB_PM_CNTL__OVRR_WR_MASK 0x1000
#define MC_ARB_PM_CNTL__OVRR_WR__SHIFT 0xc
#define MC_ARB_PM_CNTL__OVRR_WR_STATE_MASK 0x2000
#define MC_ARB_PM_CNTL__OVRR_WR_STATE__SHIFT 0xd
#define MC_ARB_PM_CNTL__OVRR_RFSH_MASK 0x4000
#define MC_ARB_PM_CNTL__OVRR_RFSH__SHIFT 0xe
#define MC_ARB_PM_CNTL__OVRR_RFSH_STATE_MASK 0x8000
#define MC_ARB_PM_CNTL__OVRR_RFSH_STATE__SHIFT 0xf
#define MC_ARB_PM_CNTL__RSV_0_MASK 0x30000
#define MC_ARB_PM_CNTL__RSV_0__SHIFT 0x10
#define MC_ARB_PM_CNTL__IDLE_ON_D2_MASK 0x40000
#define MC_ARB_PM_CNTL__IDLE_ON_D2__SHIFT 0x12
#define MC_ARB_PM_CNTL__IDLE_ON_D3_MASK 0x80000
#define MC_ARB_PM_CNTL__IDLE_ON_D3__SHIFT 0x13
#define MC_ARB_PM_CNTL__IDLE_CNT_MASK 0xf00000
#define MC_ARB_PM_CNTL__IDLE_CNT__SHIFT 0x14
#define MC_ARB_PM_CNTL__RSV_1_MASK 0x1000000
#define MC_ARB_PM_CNTL__RSV_1__SHIFT 0x18
#define MC_ARB_PM_CNTL__RSV_2_MASK 0x2000000
#define MC_ARB_PM_CNTL__RSV_2__SHIFT 0x19
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT0_MASK 0xf
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT0__SHIFT 0x0
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT1_MASK 0xf0
#define MC_ARB_GDEC_RD_CNTL__PAGEBIT1__SHIFT 0x4
#define MC_ARB_GDEC_RD_CNTL__USE_RANK_MASK 0x100
#define MC_ARB_GDEC_RD_CNTL__USE_RANK__SHIFT 0x8
#define MC_ARB_GDEC_RD_CNTL__USE_RSNO_MASK 0x200
#define MC_ARB_GDEC_RD_CNTL__USE_RSNO__SHIFT 0x9
#define MC_ARB_GDEC_RD_CNTL__REM_DEFAULT_GRP_MASK 0x3c00
#define MC_ARB_GDEC_RD_CNTL__REM_DEFAULT_GRP__SHIFT 0xa
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT0_MASK 0xf
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT0__SHIFT 0x0
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT1_MASK 0xf0
#define MC_ARB_GDEC_WR_CNTL__PAGEBIT1__SHIFT 0x4
#define MC_ARB_GDEC_WR_CNTL__USE_RANK_MASK 0x100
#define MC_ARB_GDEC_WR_CNTL__USE_RANK__SHIFT 0x8
#define MC_ARB_GDEC_WR_CNTL__USE_RSNO_MASK 0x200
#define MC_ARB_GDEC_WR_CNTL__USE_RSNO__SHIFT 0x9
#define MC_ARB_GDEC_WR_CNTL__REM_DEFAULT_GRP_MASK 0x3c00
#define MC_ARB_GDEC_WR_CNTL__REM_DEFAULT_GRP__SHIFT 0xa
#define MC_ARB_LM_RD__STREAK_LIMIT_MASK 0xff
#define MC_ARB_LM_RD__STREAK_LIMIT__SHIFT 0x0
#define MC_ARB_LM_RD__STREAK_LIMIT_UBER_MASK 0xff00
#define MC_ARB_LM_RD__STREAK_LIMIT_UBER__SHIFT 0x8
#define MC_ARB_LM_RD__STREAK_BREAK_MASK 0x10000
#define MC_ARB_LM_RD__STREAK_BREAK__SHIFT 0x10
#define MC_ARB_LM_RD__STREAK_UBER_MASK 0x20000
#define MC_ARB_LM_RD__STREAK_UBER__SHIFT 0x11
#define MC_ARB_LM_RD__ENABLE_TWO_LIST_MASK 0x40000
#define MC_ARB_LM_RD__ENABLE_TWO_LIST__SHIFT 0x12
#define MC_ARB_LM_RD__POPIDLE_RST_TWOLIST_MASK 0x80000
#define MC_ARB_LM_RD__POPIDLE_RST_TWOLIST__SHIFT 0x13
#define MC_ARB_LM_RD__SKID1_RST_TWOLIST_MASK 0x100000
#define MC_ARB_LM_RD__SKID1_RST_TWOLIST__SHIFT 0x14
#define MC_ARB_LM_RD__BANKGROUP_CONFIG_MASK 0xe00000
#define MC_ARB_LM_RD__BANKGROUP_CONFIG__SHIFT 0x15
#define MC_ARB_LM_WR__STREAK_LIMIT_MASK 0xff
#define MC_ARB_LM_WR__STREAK_LIMIT__SHIFT 0x0
#define MC_ARB_LM_WR__STREAK_LIMIT_UBER_MASK 0xff00
#define MC_ARB_LM_WR__STREAK_LIMIT_UBER__SHIFT 0x8
#define MC_ARB_LM_WR__STREAK_BREAK_MASK 0x10000
#define MC_ARB_LM_WR__STREAK_BREAK__SHIFT 0x10
#define MC_ARB_LM_WR__STREAK_UBER_MASK 0x20000
#define MC_ARB_LM_WR__STREAK_UBER__SHIFT 0x11
#define MC_ARB_LM_WR__ENABLE_TWO_LIST_MASK 0x40000
#define MC_ARB_LM_WR__ENABLE_TWO_LIST__SHIFT 0x12
#define MC_ARB_LM_WR__POPIDLE_RST_TWOLIST_MASK 0x80000
#define MC_ARB_LM_WR__POPIDLE_RST_TWOLIST__SHIFT 0x13
#define MC_ARB_LM_WR__SKID1_RST_TWOLIST_MASK 0x100000
#define MC_ARB_LM_WR__SKID1_RST_TWOLIST__SHIFT 0x14
#define MC_ARB_LM_WR__BANKGROUP_CONFIG_MASK 0xe00000
#define MC_ARB_LM_WR__BANKGROUP_CONFIG__SHIFT 0x15
#define MC_ARB_REMREQ__RD_WATER_MASK 0xff
#define MC_ARB_REMREQ__RD_WATER__SHIFT 0x0
#define MC_ARB_REMREQ__WR_WATER_MASK 0xff00
#define MC_ARB_REMREQ__WR_WATER__SHIFT 0x8
#define MC_ARB_REMREQ__WR_MAXBURST_SIZE_MASK 0xf0000
#define MC_ARB_REMREQ__WR_MAXBURST_SIZE__SHIFT 0x10
#define MC_ARB_REMREQ__WR_LAZY_TIMER_MASK 0xf00000
#define MC_ARB_REMREQ__WR_LAZY_TIMER__SHIFT 0x14
#define MC_ARB_REMREQ__ENABLE_REMOTE_NACK_REQ_MASK 0x1000000
#define MC_ARB_REMREQ__ENABLE_REMOTE_NACK_REQ__SHIFT 0x18
#define MC_ARB_REPLAY__ENABLE_RD_MASK 0x1
#define MC_ARB_REPLAY__ENABLE_RD__SHIFT 0x0
#define MC_ARB_REPLAY__ENABLE_WR_MASK 0x2
#define MC_ARB_REPLAY__ENABLE_WR__SHIFT 0x1
#define MC_ARB_REPLAY__WRACK_MODE_MASK 0x4
#define MC_ARB_REPLAY__WRACK_MODE__SHIFT 0x2
#define MC_ARB_REPLAY__WAW_ENABLE_MASK 0x8
#define MC_ARB_REPLAY__WAW_ENABLE__SHIFT 0x3
#define MC_ARB_REPLAY__RAW_ENABLE_MASK 0x10
#define MC_ARB_REPLAY__RAW_ENABLE__SHIFT 0x4
#define MC_ARB_REPLAY__IGNORE_WR_CDC_MASK 0x20
#define MC_ARB_REPLAY__IGNORE_WR_CDC__SHIFT 0x5
#define MC_ARB_REPLAY__BREAK_ON_STALL_MASK 0x40
#define MC_ARB_REPLAY__BREAK_ON_STALL__SHIFT 0x6
#define MC_ARB_REPLAY__BOS_ENABLE_WAIT_CYC_MASK 0x80
#define MC_ARB_REPLAY__BOS_ENABLE_WAIT_CYC__SHIFT 0x7
#define MC_ARB_REPLAY__BOS_WAIT_CYC_MASK 0x7f00
#define MC_ARB_REPLAY__BOS_WAIT_CYC__SHIFT 0x8
#define MC_ARB_REPLAY__NO_PCH_AT_REPLAY_START_MASK 0x8000
#define MC_ARB_REPLAY__NO_PCH_AT_REPLAY_START__SHIFT 0xf
#define MC_ARB_RET_CREDITS_RD__LCL_MASK 0xff
#define MC_ARB_RET_CREDITS_RD__LCL__SHIFT 0x0
#define MC_ARB_RET_CREDITS_RD__HUB_MASK 0xff00
#define MC_ARB_RET_CREDITS_RD__HUB__SHIFT 0x8
#define MC_ARB_RET_CREDITS_RD__DISP_MASK 0xff0000
#define MC_ARB_RET_CREDITS_RD__DISP__SHIFT 0x10
#define MC_ARB_RET_CREDITS_RD__RETURN_CREDIT_MASK 0xff000000
#define MC_ARB_RET_CREDITS_RD__RETURN_CREDIT__SHIFT 0x18
#define MC_ARB_RET_CREDITS_WR__LCL_MASK 0xff
#define MC_ARB_RET_CREDITS_WR__LCL__SHIFT 0x0
#define MC_ARB_RET_CREDITS_WR__HUB_MASK 0xff00
#define MC_ARB_RET_CREDITS_WR__HUB__SHIFT 0x8
#define MC_ARB_RET_CREDITS_WR__RETURN_CREDIT_MASK 0xff0000
#define MC_ARB_RET_CREDITS_WR__RETURN_CREDIT__SHIFT 0x10
#define MC_ARB_RET_CREDITS_WR__WRRET_SEQ_SKID_MASK 0xf000000
#define MC_ARB_RET_CREDITS_WR__WRRET_SEQ_SKID__SHIFT 0x18
#define MC_ARB_MAX_LAT_CID__CID_CH0_MASK 0xff
#define MC_ARB_MAX_LAT_CID__CID_CH0__SHIFT 0x0
#define MC_ARB_MAX_LAT_CID__CID_CH1_MASK 0xff00
#define MC_ARB_MAX_LAT_CID__CID_CH1__SHIFT 0x8
#define MC_ARB_MAX_LAT_CID__WRITE_CH0_MASK 0x10000
#define MC_ARB_MAX_LAT_CID__WRITE_CH0__SHIFT 0x10
#define MC_ARB_MAX_LAT_CID__WRITE_CH1_MASK 0x20000
#define MC_ARB_MAX_LAT_CID__WRITE_CH1__SHIFT 0x11
#define MC_ARB_MAX_LAT_CID__REALTIME_CH0_MASK 0x40000
#define MC_ARB_MAX_LAT_CID__REALTIME_CH0__SHIFT 0x12
#define MC_ARB_MAX_LAT_CID__REALTIME_CH1_MASK 0x80000
#define MC_ARB_MAX_LAT_CID__REALTIME_CH1__SHIFT 0x13
#define MC_ARB_MAX_LAT_RSLT0__MAX_LATENCY_MASK 0xffffffff
#define MC_ARB_MAX_LAT_RSLT0__MAX_LATENCY__SHIFT 0x0
#define MC_ARB_MAX_LAT_RSLT1__MAX_LATENCY_MASK 0xffffffff
#define MC_ARB_MAX_LAT_RSLT1__MAX_LATENCY__SHIFT 0x0
#define MC_ARB_SSM__FORMAT_MASK 0x1f
#define MC_ARB_SSM__FORMAT__SHIFT 0x0
#define MC_ARB_CG__CG_ARB_REQ_MASK 0xff
#define MC_ARB_CG__CG_ARB_REQ__SHIFT 0x0
#define MC_ARB_CG__CG_ARB_RESP_MASK 0xff00
#define MC_ARB_CG__CG_ARB_RESP__SHIFT 0x8
#define MC_ARB_CG__RSV_0_MASK 0xff0000
#define MC_ARB_CG__RSV_0__SHIFT 0x10
#define MC_ARB_CG__RSV_1_MASK 0xff000000
#define MC_ARB_CG__RSV_1__SHIFT 0x18
#define MC_ARB_WCDR__IDLE_ENABLE_MASK 0x1
#define MC_ARB_WCDR__IDLE_ENABLE__SHIFT 0x0
#define MC_ARB_WCDR__SEQ_IDLE_MASK 0x2
#define MC_ARB_WCDR__SEQ_IDLE__SHIFT 0x1
#define MC_ARB_WCDR__IDLE_PERIOD_MASK 0x7c
#define MC_ARB_WCDR__IDLE_PERIOD__SHIFT 0x2
#define MC_ARB_WCDR__IDLE_BURST_MASK 0x1f80
#define MC_ARB_WCDR__IDLE_BURST__SHIFT 0x7
#define MC_ARB_WCDR__IDLE_BURST_MODE_MASK 0x2000
#define MC_ARB_WCDR__IDLE_BURST_MODE__SHIFT 0xd
#define MC_ARB_WCDR__IDLE_WAKEUP_MASK 0xc000
#define MC_ARB_WCDR__IDLE_WAKEUP__SHIFT 0xe
#define MC_ARB_WCDR__IDLE_DEGLITCH_ENABLE_MASK 0x10000
#define MC_ARB_WCDR__IDLE_DEGLITCH_ENABLE__SHIFT 0x10
#define MC_ARB_WCDR__WPRE_ENABLE_MASK 0x20000
#define MC_ARB_WCDR__WPRE_ENABLE__SHIFT 0x11
#define MC_ARB_WCDR__WPRE_THRESHOLD_MASK 0x3c0000
#define MC_ARB_WCDR__WPRE_THRESHOLD__SHIFT 0x12
#define MC_ARB_WCDR__WPRE_MAX_BURST_MASK 0x1c00000
#define MC_ARB_WCDR__WPRE_MAX_BURST__SHIFT 0x16
#define MC_ARB_WCDR__WPRE_INC_READ_MASK 0x2000000
#define MC_ARB_WCDR__WPRE_INC_READ__SHIFT 0x19
#define MC_ARB_WCDR__WPRE_INC_SKIDIDLE_MASK 0x4000000
#define MC_ARB_WCDR__WPRE_INC_SKIDIDLE__SHIFT 0x1a
#define MC_ARB_WCDR__WPRE_INC_SEQIDLE_MASK 0x8000000
#define MC_ARB_WCDR__WPRE_INC_SEQIDLE__SHIFT 0x1b
#define MC_ARB_WCDR__WPRE_TWOPAGE_MASK 0x10000000
#define MC_ARB_WCDR__WPRE_TWOPAGE__SHIFT 0x1c
#define MC_ARB_DRAM_TIMING_1__ACTRD_MASK 0xff
#define MC_ARB_DRAM_TIMING_1__ACTRD__SHIFT 0x0
#define MC_ARB_DRAM_TIMING_1__ACTWR_MASK 0xff00
#define MC_ARB_DRAM_TIMING_1__ACTWR__SHIFT 0x8
#define MC_ARB_DRAM_TIMING_1__RASMACTRD_MASK 0xff0000
#define MC_ARB_DRAM_TIMING_1__RASMACTRD__SHIFT 0x10
#define MC_ARB_DRAM_TIMING_1__RASMACTWR_MASK 0xff000000
#define MC_ARB_DRAM_TIMING_1__RASMACTWR__SHIFT 0x18
#define MC_ARB_BUSY_STATUS__LM_RD0_MASK 0x1
#define MC_ARB_BUSY_STATUS__LM_RD0__SHIFT 0x0
#define MC_ARB_BUSY_STATUS__LM_RD1_MASK 0x2
#define MC_ARB_BUSY_STATUS__LM_RD1__SHIFT 0x1
#define MC_ARB_BUSY_STATUS__LM_WR0_MASK 0x4
#define MC_ARB_BUSY_STATUS__LM_WR0__SHIFT 0x2
#define MC_ARB_BUSY_STATUS__LM_WR1_MASK 0x8
#define MC_ARB_BUSY_STATUS__LM_WR1__SHIFT 0x3
#define MC_ARB_BUSY_STATUS__HM_RD0_MASK 0x10
#define MC_ARB_BUSY_STATUS__HM_RD0__SHIFT 0x4
#define MC_ARB_BUSY_STATUS__HM_RD1_MASK 0x20
#define MC_ARB_BUSY_STATUS__HM_RD1__SHIFT 0x5
#define MC_ARB_BUSY_STATUS__HM_WR0_MASK 0x40
#define MC_ARB_BUSY_STATUS__HM_WR0__SHIFT 0x6
#define MC_ARB_BUSY_STATUS__HM_WR1_MASK 0x80
#define MC_ARB_BUSY_STATUS__HM_WR1__SHIFT 0x7
#define MC_ARB_BUSY_STATUS__WDE_RD0_MASK 0x100
#define MC_ARB_BUSY_STATUS__WDE_RD0__SHIFT 0x8
#define MC_ARB_BUSY_STATUS__WDE_RD1_MASK 0x200
#define MC_ARB_BUSY_STATUS__WDE_RD1__SHIFT 0x9
#define MC_ARB_BUSY_STATUS__WDE_WR0_MASK 0x400
#define MC_ARB_BUSY_STATUS__WDE_WR0__SHIFT 0xa
#define MC_ARB_BUSY_STATUS__WDE_WR1_MASK 0x800
#define MC_ARB_BUSY_STATUS__WDE_WR1__SHIFT 0xb
#define MC_ARB_BUSY_STATUS__POP0_MASK 0x1000
#define MC_ARB_BUSY_STATUS__POP0__SHIFT 0xc
#define MC_ARB_BUSY_STATUS__POP1_MASK 0x2000
#define MC_ARB_BUSY_STATUS__POP1__SHIFT 0xd
#define MC_ARB_BUSY_STATUS__TAGFIFO0_MASK 0x4000
#define MC_ARB_BUSY_STATUS__TAGFIFO0__SHIFT 0xe
#define MC_ARB_BUSY_STATUS__TAGFIFO1_MASK 0x8000
#define MC_ARB_BUSY_STATUS__TAGFIFO1__SHIFT 0xf
#define MC_ARB_BUSY_STATUS__REPLAY0_MASK 0x10000
#define MC_ARB_BUSY_STATUS__REPLAY0__SHIFT 0x10
#define MC_ARB_BUSY_STATUS__REPLAY1_MASK 0x20000
#define MC_ARB_BUSY_STATUS__REPLAY1__SHIFT 0x11
#define MC_ARB_BUSY_STATUS__RDRET0_MASK 0x40000
#define MC_ARB_BUSY_STATUS__RDRET0__SHIFT 0x12
#define MC_ARB_BUSY_STATUS__RDRET1_MASK 0x80000
#define MC_ARB_BUSY_STATUS__RDRET1__SHIFT 0x13
#define MC_ARB_BUSY_STATUS__GECC2_RD0_MASK 0x100000
#define MC_ARB_BUSY_STATUS__GECC2_RD0__SHIFT 0x14
#define MC_ARB_BUSY_STATUS__GECC2_RD1_MASK 0x200000
#define MC_ARB_BUSY_STATUS__GECC2_RD1__SHIFT 0x15
#define MC_ARB_BUSY_STATUS__GECC2_WR0_MASK 0x400000
#define MC_ARB_BUSY_STATUS__GECC2_WR0__SHIFT 0x16
#define MC_ARB_BUSY_STATUS__GECC2_WR1_MASK 0x800000
#define MC_ARB_BUSY_STATUS__GECC2_WR1__SHIFT 0x17
#define MC_ARB_BUSY_STATUS__WCDR0_MASK 0x1000000
#define MC_ARB_BUSY_STATUS__WCDR0__SHIFT 0x18
#define MC_ARB_BUSY_STATUS__WCDR1_MASK 0x2000000
#define MC_ARB_BUSY_STATUS__WCDR1__SHIFT 0x19
#define MC_ARB_BUSY_STATUS__RTT0_MASK 0x4000000
#define MC_ARB_BUSY_STATUS__RTT0__SHIFT 0x1a
#define MC_ARB_BUSY_STATUS__RTT1_MASK 0x8000000
#define MC_ARB_BUSY_STATUS__RTT1__SHIFT 0x1b
#define MC_ARB_BUSY_STATUS__REM_RD0_MASK 0x10000000
#define MC_ARB_BUSY_STATUS__REM_RD0__SHIFT 0x1c
#define MC_ARB_BUSY_STATUS__REM_RD1_MASK 0x20000000
#define MC_ARB_BUSY_STATUS__REM_RD1__SHIFT 0x1d
#define MC_ARB_BUSY_STATUS__REM_WR0_MASK 0x40000000
#define MC_ARB_BUSY_STATUS__REM_WR0__SHIFT 0x1e
#define MC_ARB_BUSY_STATUS__REM_WR1_MASK 0x80000000
#define MC_ARB_BUSY_STATUS__REM_WR1__SHIFT 0x1f
#define MC_ARB_DRAM_TIMING2_1__RAS2RAS_MASK 0xff
#define MC_ARB_DRAM_TIMING2_1__RAS2RAS__SHIFT 0x0
#define MC_ARB_DRAM_TIMING2_1__RP_MASK 0xff00
#define MC_ARB_DRAM_TIMING2_1__RP__SHIFT 0x8
#define MC_ARB_DRAM_TIMING2_1__WRPLUSRP_MASK 0xff0000
#define MC_ARB_DRAM_TIMING2_1__WRPLUSRP__SHIFT 0x10
#define MC_ARB_DRAM_TIMING2_1__BUS_TURN_MASK 0x1f000000
#define MC_ARB_DRAM_TIMING2_1__BUS_TURN__SHIFT 0x18
#define MC_ARB_BURST_TIME__STATE0_MASK 0x1f
#define MC_ARB_BURST_TIME__STATE0__SHIFT 0x0
#define MC_ARB_BURST_TIME__STATE1_MASK 0x3e0
#define MC_ARB_BURST_TIME__STATE1__SHIFT 0x5
#define MC_ARB_BURST_TIME__STATE2_MASK 0x7c00
#define MC_ARB_BURST_TIME__STATE2__SHIFT 0xa
#define MC_ARB_BURST_TIME__STATE3_MASK 0xf8000
#define MC_ARB_BURST_TIME__STATE3__SHIFT 0xf
#define MC_CITF_XTRA_ENABLE__CB1_RD_MASK 0x1
#define MC_CITF_XTRA_ENABLE__CB1_RD__SHIFT 0x0
#define MC_CITF_XTRA_ENABLE__CB1_WR_MASK 0x2
#define MC_CITF_XTRA_ENABLE__CB1_WR__SHIFT 0x1
#define MC_CITF_XTRA_ENABLE__DB1_RD_MASK 0x4
#define MC_CITF_XTRA_ENABLE__DB1_RD__SHIFT 0x2
#define MC_CITF_XTRA_ENABLE__DB1_WR_MASK 0x8
#define MC_CITF_XTRA_ENABLE__DB1_WR__SHIFT 0x3
#define MC_CITF_XTRA_ENABLE__TC2_RD_MASK 0x10
#define MC_CITF_XTRA_ENABLE__TC2_RD__SHIFT 0x4
#define MC_CITF_XTRA_ENABLE__ARB_DBG_MASK 0xf00
#define MC_CITF_XTRA_ENABLE__ARB_DBG__SHIFT 0x8
#define MC_CITF_XTRA_ENABLE__TC2_WR_MASK 0x1000
#define MC_CITF_XTRA_ENABLE__TC2_WR__SHIFT 0xc
#define MC_CITF_XTRA_ENABLE__CB0_CONNECT_CNTL_MASK 0x6000
#define MC_CITF_XTRA_ENABLE__CB0_CONNECT_CNTL__SHIFT 0xd
#define MC_CITF_XTRA_ENABLE__DB0_CONNECT_CNTL_MASK 0x18000
#define MC_CITF_XTRA_ENABLE__DB0_CONNECT_CNTL__SHIFT 0xf
#define MC_CITF_XTRA_ENABLE__CB1_CONNECT_CNTL_MASK 0x60000
#define MC_CITF_XTRA_ENABLE__CB1_CONNECT_CNTL__SHIFT 0x11
#define MC_CITF_XTRA_ENABLE__DB1_CONNECT_CNTL_MASK 0x180000
#define MC_CITF_XTRA_ENABLE__DB1_CONNECT_CNTL__SHIFT 0x13
#define MC_CITF_XTRA_ENABLE__TC0_CONNECT_CNTL_MASK 0x600000
#define MC_CITF_XTRA_ENABLE__TC0_CONNECT_CNTL__SHIFT 0x15
#define MC_CITF_XTRA_ENABLE__TC1_CONNECT_CNTL_MASK 0x1800000
#define MC_CITF_XTRA_ENABLE__TC1_CONNECT_CNTL__SHIFT 0x17
#define MC_CITF_XTRA_ENABLE__CB0_CID_CNTL_ENABLE_MASK 0x2000000
#define MC_CITF_XTRA_ENABLE__CB0_CID_CNTL_ENABLE__SHIFT 0x19
#define MC_CITF_XTRA_ENABLE__DB0_CID_CNTL_ENABLE_MASK 0x4000000
#define MC_CITF_XTRA_ENABLE__DB0_CID_CNTL_ENABLE__SHIFT 0x1a
#define MC_CITF_XTRA_ENABLE__CB1_CID_CNTL_ENABLE_MASK 0x8000000
#define MC_CITF_XTRA_ENABLE__CB1_CID_CNTL_ENABLE__SHIFT 0x1b
#define MC_CITF_XTRA_ENABLE__DB1_CID_CNTL_ENABLE_MASK 0x10000000
#define MC_CITF_XTRA_ENABLE__DB1_CID_CNTL_ENABLE__SHIFT 0x1c
#define MC_CITF_XTRA_ENABLE__TC2_REPAIR_ENABLE_MASK 0x60000000
#define MC_CITF_XTRA_ENABLE__TC2_REPAIR_ENABLE__SHIFT 0x1d
#define CC_MC_MAX_CHANNEL__NOOFCHAN_MASK 0x1e
#define CC_MC_MAX_CHANNEL__NOOFCHAN__SHIFT 0x1
#define MC_CG_CONFIG__MCDW_WR_ENABLE_MASK 0x1
#define MC_CG_CONFIG__MCDW_WR_ENABLE__SHIFT 0x0
#define MC_CG_CONFIG__MCDX_WR_ENABLE_MASK 0x2
#define MC_CG_CONFIG__MCDX_WR_ENABLE__SHIFT 0x1
#define MC_CG_CONFIG__MCDY_WR_ENABLE_MASK 0x4
#define MC_CG_CONFIG__MCDY_WR_ENABLE__SHIFT 0x2
#define MC_CG_CONFIG__MCDZ_WR_ENABLE_MASK 0x8
#define MC_CG_CONFIG__MCDZ_WR_ENABLE__SHIFT 0x3
#define MC_CG_CONFIG__MC_RD_ENABLE_MASK 0x30
#define MC_CG_CONFIG__MC_RD_ENABLE__SHIFT 0x4
#define MC_CG_CONFIG__INDEX_MASK 0x3fffc0
#define MC_CG_CONFIG__INDEX__SHIFT 0x6
#define MC_CITF_CNTL__IGNOREPM_MASK 0x4
#define MC_CITF_CNTL__IGNOREPM__SHIFT 0x2
#define MC_CITF_CNTL__EXEMPTPM_MASK 0x8
#define MC_CITF_CNTL__EXEMPTPM__SHIFT 0x3
#define MC_CITF_CNTL__GFX_IDLE_OVERRIDE_MASK 0x30
#define MC_CITF_CNTL__GFX_IDLE_OVERRIDE__SHIFT 0x4
#define MC_CITF_CNTL__MCD_SRBM_MASK_ENABLE_MASK 0x40
#define MC_CITF_CNTL__MCD_SRBM_MASK_ENABLE__SHIFT 0x6
#define MC_CITF_CNTL__CNTR_CHMAP_MODE_MASK 0x80
#define MC_CITF_CNTL__CNTR_CHMAP_MODE__SHIFT 0x7
#define MC_CITF_CNTL__REMOTE_RB_CONNECT_ENABLE_MASK 0x100
#define MC_CITF_CNTL__REMOTE_RB_CONNECT_ENABLE__SHIFT 0x8
#define MC_CITF_CREDITS_VM__READ_ALL_MASK 0x3f
#define MC_CITF_CREDITS_VM__READ_ALL__SHIFT 0x0
#define MC_CITF_CREDITS_VM__WRITE_ALL_MASK 0xfc0
#define MC_CITF_CREDITS_VM__WRITE_ALL__SHIFT 0x6
#define MC_CITF_CREDITS_ARB_RD__READ_LCL_MASK 0xff
#define MC_CITF_CREDITS_ARB_RD__READ_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_ARB_RD__READ_HUB_MASK 0xff00
#define MC_CITF_CREDITS_ARB_RD__READ_HUB__SHIFT 0x8
#define MC_CITF_CREDITS_ARB_RD__READ_PRI_MASK 0xff0000
#define MC_CITF_CREDITS_ARB_RD__READ_PRI__SHIFT 0x10
#define MC_CITF_CREDITS_ARB_RD__LCL_PRI_MASK 0x1000000
#define MC_CITF_CREDITS_ARB_RD__LCL_PRI__SHIFT 0x18
#define MC_CITF_CREDITS_ARB_RD__HUB_PRI_MASK 0x2000000
#define MC_CITF_CREDITS_ARB_RD__HUB_PRI__SHIFT 0x19
#define MC_CITF_CREDITS_ARB_WR__WRITE_LCL_MASK 0xff
#define MC_CITF_CREDITS_ARB_WR__WRITE_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_ARB_WR__WRITE_HUB_MASK 0xff00
#define MC_CITF_CREDITS_ARB_WR__WRITE_HUB__SHIFT 0x8
#define MC_CITF_CREDITS_ARB_WR__HUB_PRI_MASK 0x10000
#define MC_CITF_CREDITS_ARB_WR__HUB_PRI__SHIFT 0x10
#define MC_CITF_CREDITS_ARB_WR__LCL_PRI_MASK 0x20000
#define MC_CITF_CREDITS_ARB_WR__LCL_PRI__SHIFT 0x11
#define MC_CITF_DAGB_CNTL__JUMP_AHEAD_MASK 0x1
#define MC_CITF_DAGB_CNTL__JUMP_AHEAD__SHIFT 0x0
#define MC_CITF_DAGB_CNTL__CENTER_RD_MAX_BURST_MASK 0x1e
#define MC_CITF_DAGB_CNTL__CENTER_RD_MAX_BURST__SHIFT 0x1
#define MC_CITF_DAGB_CNTL__DISABLE_SELF_INIT_MASK 0x20
#define MC_CITF_DAGB_CNTL__DISABLE_SELF_INIT__SHIFT 0x5
#define MC_CITF_DAGB_CNTL__CENTER_WR_MAX_BURST_MASK 0x3c0
#define MC_CITF_DAGB_CNTL__CENTER_WR_MAX_BURST__SHIFT 0x6
#define MC_CITF_INT_CREDITS__REMRDRET_MASK 0x3f
#define MC_CITF_INT_CREDITS__REMRDRET__SHIFT 0x0
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_LP_MASK 0x3f000
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_LP__SHIFT 0xc
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_HP_MASK 0xfc0000
#define MC_CITF_INT_CREDITS__CNTR_RD_HUB_HP__SHIFT 0x12
#define MC_CITF_INT_CREDITS__CNTR_RD_LCL_MASK 0x3f000000
#define MC_CITF_INT_CREDITS__CNTR_RD_LCL__SHIFT 0x18
#define MC_CITF_RET_MODE__INORDER_RD_MASK 0x1
#define MC_CITF_RET_MODE__INORDER_RD__SHIFT 0x0
#define MC_CITF_RET_MODE__INORDER_WR_MASK 0x2
#define MC_CITF_RET_MODE__INORDER_WR__SHIFT 0x1
#define MC_CITF_RET_MODE__REMPRI_RD_MASK 0x4
#define MC_CITF_RET_MODE__REMPRI_RD__SHIFT 0x2
#define MC_CITF_RET_MODE__REMPRI_WR_MASK 0x8
#define MC_CITF_RET_MODE__REMPRI_WR__SHIFT 0x3
#define MC_CITF_RET_MODE__LCLPRI_RD_MASK 0x10
#define MC_CITF_RET_MODE__LCLPRI_RD__SHIFT 0x4
#define MC_CITF_RET_MODE__LCLPRI_WR_MASK 0x20
#define MC_CITF_RET_MODE__LCLPRI_WR__SHIFT 0x5
#define MC_CITF_DAGB_DLY__DLY_MASK 0x1f
#define MC_CITF_DAGB_DLY__DLY__SHIFT 0x0
#define MC_CITF_DAGB_DLY__CLI_MASK 0x1f0000
#define MC_CITF_DAGB_DLY__CLI__SHIFT 0x10
#define MC_CITF_DAGB_DLY__POS_MASK 0x1f000000
#define MC_CITF_DAGB_DLY__POS__SHIFT 0x18
#define MC_RD_GRP_EXT__DBSTEN0_MASK 0xf
#define MC_RD_GRP_EXT__DBSTEN0__SHIFT 0x0
#define MC_RD_GRP_EXT__TC0_MASK 0xf0
#define MC_RD_GRP_EXT__TC0__SHIFT 0x4
#define MC_WR_GRP_EXT__DBSTEN0_MASK 0xf
#define MC_WR_GRP_EXT__DBSTEN0__SHIFT 0x0
#define MC_WR_GRP_EXT__TC0_MASK 0xf0
#define MC_WR_GRP_EXT__TC0__SHIFT 0x4
#define MC_CITF_REMREQ__READ_CREDITS_MASK 0x7f
#define MC_CITF_REMREQ__READ_CREDITS__SHIFT 0x0
#define MC_CITF_REMREQ__WRITE_CREDITS_MASK 0x3f80
#define MC_CITF_REMREQ__WRITE_CREDITS__SHIFT 0x7
#define MC_CITF_REMREQ__CREDITS_ENABLE_MASK 0x4000
#define MC_CITF_REMREQ__CREDITS_ENABLE__SHIFT 0xe
#define MC_WR_TC0__ENABLE_MASK 0x1
#define MC_WR_TC0__ENABLE__SHIFT 0x0
#define MC_WR_TC0__PRESCALE_MASK 0x6
#define MC_WR_TC0__PRESCALE__SHIFT 0x1
#define MC_WR_TC0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_TC0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_TC0__STALL_MODE_MASK 0x30
#define MC_WR_TC0__STALL_MODE__SHIFT 0x4
#define MC_WR_TC0__STALL_OVERRIDE_MASK 0x40
#define MC_WR_TC0__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_TC0__MAX_BURST_MASK 0x780
#define MC_WR_TC0__MAX_BURST__SHIFT 0x7
#define MC_WR_TC0__LAZY_TIMER_MASK 0x7800
#define MC_WR_TC0__LAZY_TIMER__SHIFT 0xb
#define MC_WR_TC0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_TC0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_TC1__ENABLE_MASK 0x1
#define MC_WR_TC1__ENABLE__SHIFT 0x0
#define MC_WR_TC1__PRESCALE_MASK 0x6
#define MC_WR_TC1__PRESCALE__SHIFT 0x1
#define MC_WR_TC1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_TC1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_TC1__STALL_MODE_MASK 0x30
#define MC_WR_TC1__STALL_MODE__SHIFT 0x4
#define MC_WR_TC1__STALL_OVERRIDE_MASK 0x40
#define MC_WR_TC1__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_TC1__MAX_BURST_MASK 0x780
#define MC_WR_TC1__MAX_BURST__SHIFT 0x7
#define MC_WR_TC1__LAZY_TIMER_MASK 0x7800
#define MC_WR_TC1__LAZY_TIMER__SHIFT 0xb
#define MC_WR_TC1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_TC1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_HUB_MASK 0x3f
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_HUB__SHIFT 0x0
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_LCL_MASK 0xfc0
#define MC_CITF_INT_CREDITS_WR__CNTR_WR_LCL__SHIFT 0x6
#define MC_CITF_WTM_RD_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_CITF_WTM_RD_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_CITF_WTM_RD_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_CITF_WTM_RD_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_CITF_WTM_RD_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_CITF_WTM_RD_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_CITF_WTM_RD_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_CITF_WTM_RD_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_CITF_WTM_RD_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_CITF_WTM_RD_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_CITF_WTM_RD_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_CITF_WTM_RD_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_CITF_WTM_RD_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_CITF_WTM_RD_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_CITF_WTM_RD_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_CITF_WTM_RD_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_CITF_WTM_RD_CNTL__DISABLE_REMOTE_MASK 0x1000000
#define MC_CITF_WTM_RD_CNTL__DISABLE_REMOTE__SHIFT 0x18
#define MC_CITF_WTM_RD_CNTL__DISABLE_LOCAL_MASK 0x2000000
#define MC_CITF_WTM_RD_CNTL__DISABLE_LOCAL__SHIFT 0x19
#define MC_CITF_WTM_WR_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_CITF_WTM_WR_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_CITF_WTM_WR_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_CITF_WTM_WR_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_CITF_WTM_WR_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_CITF_WTM_WR_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_CITF_WTM_WR_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_CITF_WTM_WR_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_CITF_WTM_WR_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_CITF_WTM_WR_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_CITF_WTM_WR_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_CITF_WTM_WR_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_CITF_WTM_WR_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_CITF_WTM_WR_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_CITF_WTM_WR_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_CITF_WTM_WR_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_CITF_WTM_WR_CNTL__DISABLE_REMOTE_MASK 0x1000000
#define MC_CITF_WTM_WR_CNTL__DISABLE_REMOTE__SHIFT 0x18
#define MC_CITF_WTM_WR_CNTL__DISABLE_LOCAL_MASK 0x2000000
#define MC_CITF_WTM_WR_CNTL__DISABLE_LOCAL__SHIFT 0x19
#define MC_RD_CB__ENABLE_MASK 0x1
#define MC_RD_CB__ENABLE__SHIFT 0x0
#define MC_RD_CB__PRESCALE_MASK 0x6
#define MC_RD_CB__PRESCALE__SHIFT 0x1
#define MC_RD_CB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_CB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_CB__STALL_MODE_MASK 0x30
#define MC_RD_CB__STALL_MODE__SHIFT 0x4
#define MC_RD_CB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_CB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_CB__MAX_BURST_MASK 0x780
#define MC_RD_CB__MAX_BURST__SHIFT 0x7
#define MC_RD_CB__LAZY_TIMER_MASK 0x7800
#define MC_RD_CB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_CB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_CB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_DB__ENABLE_MASK 0x1
#define MC_RD_DB__ENABLE__SHIFT 0x0
#define MC_RD_DB__PRESCALE_MASK 0x6
#define MC_RD_DB__PRESCALE__SHIFT 0x1
#define MC_RD_DB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_DB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_DB__STALL_MODE_MASK 0x30
#define MC_RD_DB__STALL_MODE__SHIFT 0x4
#define MC_RD_DB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_DB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_DB__MAX_BURST_MASK 0x780
#define MC_RD_DB__MAX_BURST__SHIFT 0x7
#define MC_RD_DB__LAZY_TIMER_MASK 0x7800
#define MC_RD_DB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_DB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_DB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_TC0__ENABLE_MASK 0x1
#define MC_RD_TC0__ENABLE__SHIFT 0x0
#define MC_RD_TC0__PRESCALE_MASK 0x6
#define MC_RD_TC0__PRESCALE__SHIFT 0x1
#define MC_RD_TC0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_TC0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_TC0__STALL_MODE_MASK 0x30
#define MC_RD_TC0__STALL_MODE__SHIFT 0x4
#define MC_RD_TC0__STALL_OVERRIDE_MASK 0x40
#define MC_RD_TC0__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_TC0__MAX_BURST_MASK 0x780
#define MC_RD_TC0__MAX_BURST__SHIFT 0x7
#define MC_RD_TC0__LAZY_TIMER_MASK 0x7800
#define MC_RD_TC0__LAZY_TIMER__SHIFT 0xb
#define MC_RD_TC0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_TC0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_TC1__ENABLE_MASK 0x1
#define MC_RD_TC1__ENABLE__SHIFT 0x0
#define MC_RD_TC1__PRESCALE_MASK 0x6
#define MC_RD_TC1__PRESCALE__SHIFT 0x1
#define MC_RD_TC1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_TC1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_TC1__STALL_MODE_MASK 0x30
#define MC_RD_TC1__STALL_MODE__SHIFT 0x4
#define MC_RD_TC1__STALL_OVERRIDE_MASK 0x40
#define MC_RD_TC1__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_TC1__MAX_BURST_MASK 0x780
#define MC_RD_TC1__MAX_BURST__SHIFT 0x7
#define MC_RD_TC1__LAZY_TIMER_MASK 0x7800
#define MC_RD_TC1__LAZY_TIMER__SHIFT 0xb
#define MC_RD_TC1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_TC1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RD_HUB__ENABLE_MASK 0x1
#define MC_RD_HUB__ENABLE__SHIFT 0x0
#define MC_RD_HUB__PRESCALE_MASK 0x6
#define MC_RD_HUB__PRESCALE__SHIFT 0x1
#define MC_RD_HUB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_RD_HUB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_RD_HUB__STALL_MODE_MASK 0x30
#define MC_RD_HUB__STALL_MODE__SHIFT 0x4
#define MC_RD_HUB__STALL_OVERRIDE_MASK 0x40
#define MC_RD_HUB__STALL_OVERRIDE__SHIFT 0x6
#define MC_RD_HUB__MAX_BURST_MASK 0x780
#define MC_RD_HUB__MAX_BURST__SHIFT 0x7
#define MC_RD_HUB__LAZY_TIMER_MASK 0x7800
#define MC_RD_HUB__LAZY_TIMER__SHIFT 0xb
#define MC_RD_HUB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_RD_HUB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_CB__ENABLE_MASK 0x1
#define MC_WR_CB__ENABLE__SHIFT 0x0
#define MC_WR_CB__PRESCALE_MASK 0x6
#define MC_WR_CB__PRESCALE__SHIFT 0x1
#define MC_WR_CB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_CB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_CB__STALL_MODE_MASK 0x30
#define MC_WR_CB__STALL_MODE__SHIFT 0x4
#define MC_WR_CB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_CB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_CB__MAX_BURST_MASK 0x780
#define MC_WR_CB__MAX_BURST__SHIFT 0x7
#define MC_WR_CB__LAZY_TIMER_MASK 0x7800
#define MC_WR_CB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_CB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_CB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_DB__ENABLE_MASK 0x1
#define MC_WR_DB__ENABLE__SHIFT 0x0
#define MC_WR_DB__PRESCALE_MASK 0x6
#define MC_WR_DB__PRESCALE__SHIFT 0x1
#define MC_WR_DB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_DB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_DB__STALL_MODE_MASK 0x30
#define MC_WR_DB__STALL_MODE__SHIFT 0x4
#define MC_WR_DB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_DB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_DB__MAX_BURST_MASK 0x780
#define MC_WR_DB__MAX_BURST__SHIFT 0x7
#define MC_WR_DB__LAZY_TIMER_MASK 0x7800
#define MC_WR_DB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_DB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_DB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_WR_HUB__ENABLE_MASK 0x1
#define MC_WR_HUB__ENABLE__SHIFT 0x0
#define MC_WR_HUB__PRESCALE_MASK 0x6
#define MC_WR_HUB__PRESCALE__SHIFT 0x1
#define MC_WR_HUB__BLACKOUT_EXEMPT_MASK 0x8
#define MC_WR_HUB__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_WR_HUB__STALL_MODE_MASK 0x30
#define MC_WR_HUB__STALL_MODE__SHIFT 0x4
#define MC_WR_HUB__STALL_OVERRIDE_MASK 0x40
#define MC_WR_HUB__STALL_OVERRIDE__SHIFT 0x6
#define MC_WR_HUB__MAX_BURST_MASK 0x780
#define MC_WR_HUB__MAX_BURST__SHIFT 0x7
#define MC_WR_HUB__LAZY_TIMER_MASK 0x7800
#define MC_WR_HUB__LAZY_TIMER__SHIFT 0xb
#define MC_WR_HUB__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_WR_HUB__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_CITF_CREDITS_XBAR__READ_LCL_MASK 0xff
#define MC_CITF_CREDITS_XBAR__READ_LCL__SHIFT 0x0
#define MC_CITF_CREDITS_XBAR__WRITE_LCL_MASK 0xff00
#define MC_CITF_CREDITS_XBAR__WRITE_LCL__SHIFT 0x8
#define MC_RD_GRP_LCL__CB0_MASK 0xf000
#define MC_RD_GRP_LCL__CB0__SHIFT 0xc
#define MC_RD_GRP_LCL__CBCMASK0_MASK 0xf0000
#define MC_RD_GRP_LCL__CBCMASK0__SHIFT 0x10
#define MC_RD_GRP_LCL__CBFMASK0_MASK 0xf00000
#define MC_RD_GRP_LCL__CBFMASK0__SHIFT 0x14
#define MC_RD_GRP_LCL__DB0_MASK 0xf000000
#define MC_RD_GRP_LCL__DB0__SHIFT 0x18
#define MC_RD_GRP_LCL__DBHTILE0_MASK 0xf0000000
#define MC_RD_GRP_LCL__DBHTILE0__SHIFT 0x1c
#define MC_WR_GRP_LCL__CB0_MASK 0xf
#define MC_WR_GRP_LCL__CB0__SHIFT 0x0
#define MC_WR_GRP_LCL__CBCMASK0_MASK 0xf0
#define MC_WR_GRP_LCL__CBCMASK0__SHIFT 0x4
#define MC_WR_GRP_LCL__CBFMASK0_MASK 0xf00
#define MC_WR_GRP_LCL__CBFMASK0__SHIFT 0x8
#define MC_WR_GRP_LCL__DB0_MASK 0xf000
#define MC_WR_GRP_LCL__DB0__SHIFT 0xc
#define MC_WR_GRP_LCL__DBHTILE0_MASK 0xf0000
#define MC_WR_GRP_LCL__DBHTILE0__SHIFT 0x10
#define MC_WR_GRP_LCL__SX0_MASK 0xf00000
#define MC_WR_GRP_LCL__SX0__SHIFT 0x14
#define MC_WR_GRP_LCL__CBIMMED0_MASK 0xf0000000
#define MC_WR_GRP_LCL__CBIMMED0__SHIFT 0x1c
#define MC_CITF_PERF_MON_CNTL2__CID_MASK 0xff
#define MC_CITF_PERF_MON_CNTL2__CID__SHIFT 0x0
#define MC_CITF_PERF_MON_RSLT2__CB_RD_BUSY_MASK 0x40
#define MC_CITF_PERF_MON_RSLT2__CB_RD_BUSY__SHIFT 0x6
#define MC_CITF_PERF_MON_RSLT2__DB_RD_BUSY_MASK 0x80
#define MC_CITF_PERF_MON_RSLT2__DB_RD_BUSY__SHIFT 0x7
#define MC_CITF_PERF_MON_RSLT2__TC0_RD_BUSY_MASK 0x100
#define MC_CITF_PERF_MON_RSLT2__TC0_RD_BUSY__SHIFT 0x8
#define MC_CITF_PERF_MON_RSLT2__VC0_RD_BUSY_MASK 0x200
#define MC_CITF_PERF_MON_RSLT2__VC0_RD_BUSY__SHIFT 0x9
#define MC_CITF_PERF_MON_RSLT2__TC1_RD_BUSY_MASK 0x400
#define MC_CITF_PERF_MON_RSLT2__TC1_RD_BUSY__SHIFT 0xa
#define MC_CITF_PERF_MON_RSLT2__VC1_RD_BUSY_MASK 0x800
#define MC_CITF_PERF_MON_RSLT2__VC1_RD_BUSY__SHIFT 0xb
#define MC_CITF_PERF_MON_RSLT2__CB_WR_BUSY_MASK 0x1000
#define MC_CITF_PERF_MON_RSLT2__CB_WR_BUSY__SHIFT 0xc
#define MC_CITF_PERF_MON_RSLT2__DB_WR_BUSY_MASK 0x2000
#define MC_CITF_PERF_MON_RSLT2__DB_WR_BUSY__SHIFT 0xd
#define MC_CITF_PERF_MON_RSLT2__SX_WR_BUSY_MASK 0x4000
#define MC_CITF_PERF_MON_RSLT2__SX_WR_BUSY__SHIFT 0xe
#define MC_CITF_PERF_MON_RSLT2__TC2_RD_BUSY_MASK 0x8000
#define MC_CITF_PERF_MON_RSLT2__TC2_RD_BUSY__SHIFT 0xf
#define MC_CITF_PERF_MON_RSLT2__TC0_WR_BUSY_MASK 0x10000
#define MC_CITF_PERF_MON_RSLT2__TC0_WR_BUSY__SHIFT 0x10
#define MC_CITF_PERF_MON_RSLT2__TC1_WR_BUSY_MASK 0x20000
#define MC_CITF_PERF_MON_RSLT2__TC1_WR_BUSY__SHIFT 0x11
#define MC_CITF_PERF_MON_RSLT2__TC2_WR_BUSY_MASK 0x40000
#define MC_CITF_PERF_MON_RSLT2__TC2_WR_BUSY__SHIFT 0x12
#define MC_CITF_MISC_RD_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_RD_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_RD_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_RD_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_RD_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_RD_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_RD_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_RD_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_RD_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_RD_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_CITF_MISC_WR_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_WR_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_WR_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_WR_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_WR_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_WR_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_WR_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_WR_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_WR_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_WR_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_CITF_MISC_VM_CG__ONDLY_MASK 0x3f
#define MC_CITF_MISC_VM_CG__ONDLY__SHIFT 0x0
#define MC_CITF_MISC_VM_CG__OFFDLY_MASK 0xfc0
#define MC_CITF_MISC_VM_CG__OFFDLY__SHIFT 0x6
#define MC_CITF_MISC_VM_CG__RDYDLY_MASK 0x3f000
#define MC_CITF_MISC_VM_CG__RDYDLY__SHIFT 0xc
#define MC_CITF_MISC_VM_CG__ENABLE_MASK 0x40000
#define MC_CITF_MISC_VM_CG__ENABLE__SHIFT 0x12
#define MC_CITF_MISC_VM_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_CITF_MISC_VM_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_POWER__SRBM_GATE_OVERRIDE_MASK 0x4
#define MC_HUB_MISC_POWER__SRBM_GATE_OVERRIDE__SHIFT 0x2
#define MC_HUB_MISC_POWER__PM_BLACKOUT_CNTL_MASK 0x18
#define MC_HUB_MISC_POWER__PM_BLACKOUT_CNTL__SHIFT 0x3
#define MC_HUB_MISC_HUB_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_HUB_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_HUB_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_HUB_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_HUB_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_HUB_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_HUB_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_HUB_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_HUB_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_HUB_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_VM_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_VM_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_VM_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_VM_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_VM_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_VM_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_VM_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_VM_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_VM_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_VM_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_SIP_CG__ONDLY_MASK 0x3f
#define MC_HUB_MISC_SIP_CG__ONDLY__SHIFT 0x0
#define MC_HUB_MISC_SIP_CG__OFFDLY_MASK 0xfc0
#define MC_HUB_MISC_SIP_CG__OFFDLY__SHIFT 0x6
#define MC_HUB_MISC_SIP_CG__RDYDLY_MASK 0x3f000
#define MC_HUB_MISC_SIP_CG__RDYDLY__SHIFT 0xc
#define MC_HUB_MISC_SIP_CG__ENABLE_MASK 0x40000
#define MC_HUB_MISC_SIP_CG__ENABLE__SHIFT 0x12
#define MC_HUB_MISC_SIP_CG__MEM_LS_ENABLE_MASK 0x80000
#define MC_HUB_MISC_SIP_CG__MEM_LS_ENABLE__SHIFT 0x13
#define MC_HUB_MISC_DBG__SELECT0_MASK 0xf
#define MC_HUB_MISC_DBG__SELECT0__SHIFT 0x0
#define MC_HUB_MISC_DBG__SELECT1_MASK 0xf0
#define MC_HUB_MISC_DBG__SELECT1__SHIFT 0x4
#define MC_HUB_MISC_DBG__CTRL0_MASK 0x1f00
#define MC_HUB_MISC_DBG__CTRL0__SHIFT 0x8
#define MC_HUB_MISC_DBG__CTRL1_MASK 0x3e000
#define MC_HUB_MISC_DBG__CTRL1__SHIFT 0xd
#define MC_HUB_MISC_STATUS__OUTSTANDING_READ_MASK 0x1
#define MC_HUB_MISC_STATUS__OUTSTANDING_READ__SHIFT 0x0
#define MC_HUB_MISC_STATUS__OUTSTANDING_WRITE_MASK 0x2
#define MC_HUB_MISC_STATUS__OUTSTANDING_WRITE__SHIFT 0x1
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDREQ_MASK 0x4
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDREQ__SHIFT 0x2
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDRET_MASK 0x8
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_RDRET__SHIFT 0x3
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRREQ_MASK 0x10
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRREQ__SHIFT 0x4
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRRET_MASK 0x20
#define MC_HUB_MISC_STATUS__OUTSTANDING_HUB_WRRET__SHIFT 0x5
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_READ_MASK 0x40
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_READ__SHIFT 0x6
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_WRITE_MASK 0x80
#define MC_HUB_MISC_STATUS__OUTSTANDING_RPB_WRITE__SHIFT 0x7
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_READ_MASK 0x100
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_READ__SHIFT 0x8
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_WRITE_MASK 0x200
#define MC_HUB_MISC_STATUS__OUTSTANDING_MCD_WRITE__SHIFT 0x9
#define MC_HUB_MISC_STATUS__RPB_BUSY_MASK 0x400
#define MC_HUB_MISC_STATUS__RPB_BUSY__SHIFT 0xa
#define MC_HUB_MISC_STATUS__WRITE_DEADLOCK_WARNING_MASK 0x800
#define MC_HUB_MISC_STATUS__WRITE_DEADLOCK_WARNING__SHIFT 0xb
#define MC_HUB_MISC_STATUS__READ_DEADLOCK_WARNING_MASK 0x1000
#define MC_HUB_MISC_STATUS__READ_DEADLOCK_WARNING__SHIFT 0xc
#define MC_HUB_MISC_STATUS__GFX_BUSY_MASK 0x2000
#define MC_HUB_MISC_STATUS__GFX_BUSY__SHIFT 0xd
#define MC_HUB_MISC_OVERRIDE__IDLE_MASK 0x3
#define MC_HUB_MISC_OVERRIDE__IDLE__SHIFT 0x0
#define MC_HUB_MISC_FRAMING__BITS_MASK 0xffffffff
#define MC_HUB_MISC_FRAMING__BITS__SHIFT 0x0
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL0_MASK 0x2
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL0__SHIFT 0x1
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL1_MASK 0x4
#define MC_HUB_WDP_CNTL__JUMPAHEAD_GBL1__SHIFT 0x2
#define MC_HUB_WDP_CNTL__JUMPAHEAD_INTERNAL_MASK 0x8
#define MC_HUB_WDP_CNTL__JUMPAHEAD_INTERNAL__SHIFT 0x3
#define MC_HUB_WDP_CNTL__OVERRIDE_STALL_ENABLE_MASK 0x10
#define MC_HUB_WDP_CNTL__OVERRIDE_STALL_ENABLE__SHIFT 0x4
#define MC_HUB_WDP_CNTL__DEBUG_REG_MASK 0x1fe0
#define MC_HUB_WDP_CNTL__DEBUG_REG__SHIFT 0x5
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL0_MASK 0x2000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL0__SHIFT 0xd
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL1_MASK 0x4000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_GBL1__SHIFT 0xe
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_INTERNAL_MASK 0x8000
#define MC_HUB_WDP_CNTL__DISABLE_SELF_INIT_INTERNAL__SHIFT 0xf
#define MC_HUB_WDP_CNTL__FAIR_CH_SW_MASK 0x10000
#define MC_HUB_WDP_CNTL__FAIR_CH_SW__SHIFT 0x10
#define MC_HUB_WDP_CNTL__LCLWRREQ_BYPASS_MASK 0x20000
#define MC_HUB_WDP_CNTL__LCLWRREQ_BYPASS__SHIFT 0x11
#define MC_HUB_WDP_CNTL__DISP_WAIT_EOP_MASK 0x40000
#define MC_HUB_WDP_CNTL__DISP_WAIT_EOP__SHIFT 0x12
#define MC_HUB_WDP_CNTL__MCD_WAIT_EOP_MASK 0x80000
#define MC_HUB_WDP_CNTL__MCD_WAIT_EOP__SHIFT 0x13
#define MC_HUB_WDP_CNTL__SIP_WAIT_EOP_MASK 0x100000
#define MC_HUB_WDP_CNTL__SIP_WAIT_EOP__SHIFT 0x14
#define MC_HUB_WDP_ERR__MGPU1_TARG_SYS_MASK 0x1
#define MC_HUB_WDP_ERR__MGPU1_TARG_SYS__SHIFT 0x0
#define MC_HUB_WDP_ERR__MGPU2_TARG_SYS_MASK 0x2
#define MC_HUB_WDP_ERR__MGPU2_TARG_SYS__SHIFT 0x1
#define MC_HUB_WDP_BP__ENABLE_MASK 0x1
#define MC_HUB_WDP_BP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_BP__RDRET_MASK 0x3fffe
#define MC_HUB_WDP_BP__RDRET__SHIFT 0x1
#define MC_HUB_WDP_BP__WRREQ_MASK 0x3ffc0000
#define MC_HUB_WDP_BP__WRREQ__SHIFT 0x12
#define MC_HUB_WDP_STATUS__SIP_AVAIL_MASK 0x1
#define MC_HUB_WDP_STATUS__SIP_AVAIL__SHIFT 0x0
#define MC_HUB_WDP_STATUS__MCDW_RD_AVAIL_MASK 0x2
#define MC_HUB_WDP_STATUS__MCDW_RD_AVAIL__SHIFT 0x1
#define MC_HUB_WDP_STATUS__MCDX_RD_AVAIL_MASK 0x4
#define MC_HUB_WDP_STATUS__MCDX_RD_AVAIL__SHIFT 0x2
#define MC_HUB_WDP_STATUS__MCDY_RD_AVAIL_MASK 0x8
#define MC_HUB_WDP_STATUS__MCDY_RD_AVAIL__SHIFT 0x3
#define MC_HUB_WDP_STATUS__MCDZ_RD_AVAIL_MASK 0x10
#define MC_HUB_WDP_STATUS__MCDZ_RD_AVAIL__SHIFT 0x4
#define MC_HUB_WDP_STATUS__GBL0_VM_FULL_MASK 0x20
#define MC_HUB_WDP_STATUS__GBL0_VM_FULL__SHIFT 0x5
#define MC_HUB_WDP_STATUS__GBL0_STOR_FULL_MASK 0x40
#define MC_HUB_WDP_STATUS__GBL0_STOR_FULL__SHIFT 0x6
#define MC_HUB_WDP_STATUS__GBL0_BYPASS_STOR_FULL_MASK 0x80
#define MC_HUB_WDP_STATUS__GBL0_BYPASS_STOR_FULL__SHIFT 0x7
#define MC_HUB_WDP_STATUS__GBL1_VM_FULL_MASK 0x100
#define MC_HUB_WDP_STATUS__GBL1_VM_FULL__SHIFT 0x8
#define MC_HUB_WDP_STATUS__GBL1_STOR_FULL_MASK 0x200
#define MC_HUB_WDP_STATUS__GBL1_STOR_FULL__SHIFT 0x9
#define MC_HUB_WDP_STATUS__GBL1_BYPASS_STOR_FULL_MASK 0x400
#define MC_HUB_WDP_STATUS__GBL1_BYPASS_STOR_FULL__SHIFT 0xa
#define MC_HUB_RDREQ_STATUS__SIP_AVAIL_MASK 0x1
#define MC_HUB_RDREQ_STATUS__SIP_AVAIL__SHIFT 0x0
#define MC_HUB_RDREQ_STATUS__MCDW_RD_AVAIL_MASK 0x2
#define MC_HUB_RDREQ_STATUS__MCDW_RD_AVAIL__SHIFT 0x1
#define MC_HUB_RDREQ_STATUS__MCDX_RD_AVAIL_MASK 0x4
#define MC_HUB_RDREQ_STATUS__MCDX_RD_AVAIL__SHIFT 0x2
#define MC_HUB_RDREQ_STATUS__MCDY_RD_AVAIL_MASK 0x8
#define MC_HUB_RDREQ_STATUS__MCDY_RD_AVAIL__SHIFT 0x3
#define MC_HUB_RDREQ_STATUS__MCDZ_RD_AVAIL_MASK 0x10
#define MC_HUB_RDREQ_STATUS__MCDZ_RD_AVAIL__SHIFT 0x4
#define MC_HUB_RDREQ_STATUS__GBL0_VM_FULL_MASK 0x20
#define MC_HUB_RDREQ_STATUS__GBL0_VM_FULL__SHIFT 0x5
#define MC_HUB_RDREQ_STATUS__GBL0_STOR_FULL_MASK 0x40
#define MC_HUB_RDREQ_STATUS__GBL0_STOR_FULL__SHIFT 0x6
#define MC_HUB_RDREQ_STATUS__GBL0_BYPASS_STOR_FULL_MASK 0x80
#define MC_HUB_RDREQ_STATUS__GBL0_BYPASS_STOR_FULL__SHIFT 0x7
#define MC_HUB_RDREQ_STATUS__GBL1_VM_FULL_MASK 0x100
#define MC_HUB_RDREQ_STATUS__GBL1_VM_FULL__SHIFT 0x8
#define MC_HUB_RDREQ_STATUS__GBL1_STOR_FULL_MASK 0x200
#define MC_HUB_RDREQ_STATUS__GBL1_STOR_FULL__SHIFT 0x9
#define MC_HUB_RDREQ_STATUS__GBL1_BYPASS_STOR_FULL_MASK 0x400
#define MC_HUB_RDREQ_STATUS__GBL1_BYPASS_STOR_FULL__SHIFT 0xa
#define MC_HUB_RDREQ_STATUS__PWRXPRESS_ERR_MASK 0x800
#define MC_HUB_RDREQ_STATUS__PWRXPRESS_ERR__SHIFT 0xb
#define MC_HUB_WRRET_STATUS__MCDW_AVAIL_MASK 0x1
#define MC_HUB_WRRET_STATUS__MCDW_AVAIL__SHIFT 0x0
#define MC_HUB_WRRET_STATUS__MCDX_AVAIL_MASK 0x2
#define MC_HUB_WRRET_STATUS__MCDX_AVAIL__SHIFT 0x1
#define MC_HUB_WRRET_STATUS__MCDY_AVAIL_MASK 0x4
#define MC_HUB_WRRET_STATUS__MCDY_AVAIL__SHIFT 0x2
#define MC_HUB_WRRET_STATUS__MCDZ_AVAIL_MASK 0x8
#define MC_HUB_WRRET_STATUS__MCDZ_AVAIL__SHIFT 0x3
#define MC_HUB_RDREQ_CNTL__REMOTE_BLACKOUT_MASK 0x1
#define MC_HUB_RDREQ_CNTL__REMOTE_BLACKOUT__SHIFT 0x0
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL0_MASK 0x4
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL0__SHIFT 0x2
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL1_MASK 0x8
#define MC_HUB_RDREQ_CNTL__JUMPAHEAD_GBL1__SHIFT 0x3
#define MC_HUB_RDREQ_CNTL__OVERRIDE_STALL_ENABLE_MASK 0x10
#define MC_HUB_RDREQ_CNTL__OVERRIDE_STALL_ENABLE__SHIFT 0x4
#define MC_HUB_RDREQ_CNTL__MCDW_STALL_MODE_MASK 0x20
#define MC_HUB_RDREQ_CNTL__MCDW_STALL_MODE__SHIFT 0x5
#define MC_HUB_RDREQ_CNTL__MCDX_STALL_MODE_MASK 0x40
#define MC_HUB_RDREQ_CNTL__MCDX_STALL_MODE__SHIFT 0x6
#define MC_HUB_RDREQ_CNTL__MCDY_STALL_MODE_MASK 0x80
#define MC_HUB_RDREQ_CNTL__MCDY_STALL_MODE__SHIFT 0x7
#define MC_HUB_RDREQ_CNTL__MCDZ_STALL_MODE_MASK 0x100
#define MC_HUB_RDREQ_CNTL__MCDZ_STALL_MODE__SHIFT 0x8
#define MC_HUB_RDREQ_CNTL__BREAK_HDP_DEADLOCK_MASK 0x200
#define MC_HUB_RDREQ_CNTL__BREAK_HDP_DEADLOCK__SHIFT 0x9
#define MC_HUB_RDREQ_CNTL__DEBUG_REG_MASK 0x1fc00
#define MC_HUB_RDREQ_CNTL__DEBUG_REG__SHIFT 0xa
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL0_MASK 0x20000
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL0__SHIFT 0x11
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL1_MASK 0x40000
#define MC_HUB_RDREQ_CNTL__DISABLE_SELF_INIT_GBL1__SHIFT 0x12
#define MC_HUB_RDREQ_CNTL__PWRXPRESS_MODE_MASK 0x80000
#define MC_HUB_RDREQ_CNTL__PWRXPRESS_MODE__SHIFT 0x13
#define MC_HUB_RDREQ_CNTL__ACPG_HP_TO_MCD_OVERRIDE_MASK 0x100000
#define MC_HUB_RDREQ_CNTL__ACPG_HP_TO_MCD_OVERRIDE__SHIFT 0x14
#define MC_HUB_WRRET_CNTL__JUMPAHEAD_MASK 0x1
#define MC_HUB_WRRET_CNTL__JUMPAHEAD__SHIFT 0x0
#define MC_HUB_WRRET_CNTL__BP_MASK 0x1ffffe
#define MC_HUB_WRRET_CNTL__BP__SHIFT 0x1
#define MC_HUB_WRRET_CNTL__BP_ENABLE_MASK 0x200000
#define MC_HUB_WRRET_CNTL__BP_ENABLE__SHIFT 0x15
#define MC_HUB_WRRET_CNTL__DEBUG_REG_MASK 0x3fc00000
#define MC_HUB_WRRET_CNTL__DEBUG_REG__SHIFT 0x16
#define MC_HUB_WRRET_CNTL__DISABLE_SELF_INIT_MASK 0x40000000
#define MC_HUB_WRRET_CNTL__DISABLE_SELF_INIT__SHIFT 0x1e
#define MC_HUB_WRRET_CNTL__FAIR_CH_SW_MASK 0x80000000
#define MC_HUB_WRRET_CNTL__FAIR_CH_SW__SHIFT 0x1f
#define MC_HUB_RDREQ_WTM_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_HUB_RDREQ_WTM_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_HUB_RDREQ_WTM_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_HUB_RDREQ_WTM_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_HUB_RDREQ_WTM_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_HUB_RDREQ_WTM_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_HUB_RDREQ_WTM_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_HUB_RDREQ_WTM_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_HUB_RDREQ_WTM_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_HUB_RDREQ_WTM_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_HUB_RDREQ_WTM_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_HUB_RDREQ_WTM_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_HUB_RDREQ_WTM_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_HUB_WDP_WTM_CNTL__GROUP0_DECREMENT_MASK 0x7
#define MC_HUB_WDP_WTM_CNTL__GROUP0_DECREMENT__SHIFT 0x0
#define MC_HUB_WDP_WTM_CNTL__GROUP1_DECREMENT_MASK 0x38
#define MC_HUB_WDP_WTM_CNTL__GROUP1_DECREMENT__SHIFT 0x3
#define MC_HUB_WDP_WTM_CNTL__GROUP2_DECREMENT_MASK 0x1c0
#define MC_HUB_WDP_WTM_CNTL__GROUP2_DECREMENT__SHIFT 0x6
#define MC_HUB_WDP_WTM_CNTL__GROUP3_DECREMENT_MASK 0xe00
#define MC_HUB_WDP_WTM_CNTL__GROUP3_DECREMENT__SHIFT 0x9
#define MC_HUB_WDP_WTM_CNTL__GROUP4_DECREMENT_MASK 0x7000
#define MC_HUB_WDP_WTM_CNTL__GROUP4_DECREMENT__SHIFT 0xc
#define MC_HUB_WDP_WTM_CNTL__GROUP5_DECREMENT_MASK 0x38000
#define MC_HUB_WDP_WTM_CNTL__GROUP5_DECREMENT__SHIFT 0xf
#define MC_HUB_WDP_WTM_CNTL__GROUP6_DECREMENT_MASK 0x1c0000
#define MC_HUB_WDP_WTM_CNTL__GROUP6_DECREMENT__SHIFT 0x12
#define MC_HUB_WDP_WTM_CNTL__GROUP7_DECREMENT_MASK 0xe00000
#define MC_HUB_WDP_WTM_CNTL__GROUP7_DECREMENT__SHIFT 0x15
#define MC_HUB_WDP_CREDITS__VM0_MASK 0xff
#define MC_HUB_WDP_CREDITS__VM0__SHIFT 0x0
#define MC_HUB_WDP_CREDITS__VM1_MASK 0xff00
#define MC_HUB_WDP_CREDITS__VM1__SHIFT 0x8
#define MC_HUB_WDP_CREDITS__STOR0_MASK 0xff0000
#define MC_HUB_WDP_CREDITS__STOR0__SHIFT 0x10
#define MC_HUB_WDP_CREDITS__STOR1_MASK 0xff000000
#define MC_HUB_WDP_CREDITS__STOR1__SHIFT 0x18
#define MC_HUB_WDP_MGPU2__CID2_MASK 0xff
#define MC_HUB_WDP_MGPU2__CID2__SHIFT 0x0
#define MC_HUB_WDP_GBL0__MAXBURST_MASK 0xf
#define MC_HUB_WDP_GBL0__MAXBURST__SHIFT 0x0
#define MC_HUB_WDP_GBL0__LAZY_TIMER_MASK 0xf0
#define MC_HUB_WDP_GBL0__LAZY_TIMER__SHIFT 0x4
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD_MASK 0xff00
#define MC_HUB_WDP_GBL0__STALL_THRESHOLD__SHIFT 0x8
#define MC_HUB_WDP_GBL0__STALL_MODE_MASK 0x10000
#define MC_HUB_WDP_GBL0__STALL_MODE__SHIFT 0x10
#define MC_HUB_WDP_GBL1__MAXBURST_MASK 0xf
#define MC_HUB_WDP_GBL1__MAXBURST__SHIFT 0x0
#define MC_HUB_WDP_GBL1__LAZY_TIMER_MASK 0xf0
#define MC_HUB_WDP_GBL1__LAZY_TIMER__SHIFT 0x4
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD_MASK 0xff00
#define MC_HUB_WDP_GBL1__STALL_THRESHOLD__SHIFT 0x8
#define MC_HUB_WDP_GBL1__STALL_MODE_MASK 0x10000
#define MC_HUB_WDP_GBL1__STALL_MODE__SHIFT 0x10
#define MC_HUB_WDP_MGPU__STOR_MASK 0xff
#define MC_HUB_WDP_MGPU__STOR__SHIFT 0x0
#define MC_HUB_WDP_MGPU__CID_MASK 0xff00
#define MC_HUB_WDP_MGPU__CID__SHIFT 0x8
#define MC_HUB_WDP_MGPU__MGPU_PRIORITY_TIME_MASK 0x7f0000
#define MC_HUB_WDP_MGPU__MGPU_PRIORITY_TIME__SHIFT 0x10
#define MC_HUB_WDP_MGPU__ENABLE_MASK 0x800000
#define MC_HUB_WDP_MGPU__ENABLE__SHIFT 0x17
#define MC_HUB_WDP_MGPU__OTH_PRIORITY_TIME_MASK 0x7f000000
#define MC_HUB_WDP_MGPU__OTH_PRIORITY_TIME__SHIFT 0x18
#define MC_HUB_RDREQ_CREDITS__VM0_MASK 0xff
#define MC_HUB_RDREQ_CREDITS__VM0__SHIFT 0x0
#define MC_HUB_RDREQ_CREDITS__VM1_MASK 0xff00
#define MC_HUB_RDREQ_CREDITS__VM1__SHIFT 0x8
#define MC_HUB_RDREQ_CREDITS__STOR0_MASK 0xff0000
#define MC_HUB_RDREQ_CREDITS__STOR0__SHIFT 0x10
#define MC_HUB_RDREQ_CREDITS__STOR1_MASK 0xff000000
#define MC_HUB_RDREQ_CREDITS__STOR1__SHIFT 0x18
#define MC_HUB_RDREQ_CREDITS2__STOR1_PRI_MASK 0xff
#define MC_HUB_RDREQ_CREDITS2__STOR1_PRI__SHIFT 0x0
#define MC_HUB_SHARED_DAGB_DLY__DLY_MASK 0x3f
#define MC_HUB_SHARED_DAGB_DLY__DLY__SHIFT 0x0
#define MC_HUB_SHARED_DAGB_DLY__CLI_MASK 0x1f0000
#define MC_HUB_SHARED_DAGB_DLY__CLI__SHIFT 0x10
#define MC_HUB_SHARED_DAGB_DLY__POS_MASK 0x1f000000
#define MC_HUB_SHARED_DAGB_DLY__POS__SHIFT 0x18
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_READ_MASK 0x1
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_READ__SHIFT 0x0
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_WRITE_MASK 0x2
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_GFX_WRITE__SHIFT 0x1
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_READ_MASK 0x4
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_READ__SHIFT 0x2
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_WRITE_MASK 0x8
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_RLC_WRITE__SHIFT 0x3
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_READ_MASK 0x10
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_READ__SHIFT 0x4
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_WRITE_MASK 0x20
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA0_WRITE__SHIFT 0x5
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_READ_MASK 0x40
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_READ__SHIFT 0x6
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_WRITE_MASK 0x80
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SDMA1_WRITE__SHIFT 0x7
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_READ_MASK 0x100
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_READ__SHIFT 0x8
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_WRITE_MASK 0x200
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_DISP_WRITE__SHIFT 0x9
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_READ_MASK 0x400
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_READ__SHIFT 0xa
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_WRITE_MASK 0x800
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_UVD_WRITE__SHIFT 0xb
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_READ_MASK 0x1000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_READ__SHIFT 0xc
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_WRITE_MASK 0x2000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_SMU_WRITE__SHIFT 0xd
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_READ_MASK 0x4000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_READ__SHIFT 0xe
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_WRITE_MASK 0x8000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_HDP_WRITE__SHIFT 0xf
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_READ_MASK 0x10000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_READ__SHIFT 0x10
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_WRITE_MASK 0x20000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_OTH_WRITE__SHIFT 0x11
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_READ_MASK 0x40000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_READ__SHIFT 0x12
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_WRITE_MASK 0x80000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VMC_WRITE__SHIFT 0x13
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_IA_READ_MASK 0x100000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_IA_READ__SHIFT 0x14
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_IA_WRITE_MASK 0x200000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_IA_WRITE__SHIFT 0x15
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_READ_MASK 0x400000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_READ__SHIFT 0x16
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_WRITE_MASK 0x800000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_VCE_WRITE__SHIFT 0x17
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_READ_MASK 0x1000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_READ__SHIFT 0x18
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_WRITE_MASK 0x2000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_ACP_WRITE__SHIFT 0x19
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_CP_READ_MASK 0x4000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_CP_READ__SHIFT 0x1a
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_CP_WRITE_MASK 0x8000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_CP_WRITE__SHIFT 0x1b
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_READ_MASK 0x10000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_READ__SHIFT 0x1c
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_WRITE_MASK 0x20000000
#define MC_HUB_MISC_IDLE_STATUS__OUTSTANDING_XDMA_WRITE__SHIFT 0x1d
#define MC_HUB_RDREQ_DMIF_LIMIT__ENABLE_MASK 0x3
#define MC_HUB_RDREQ_DMIF_LIMIT__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_DMIF_LIMIT__LIMIT_COUNT_MASK 0x7c
#define MC_HUB_RDREQ_DMIF_LIMIT__LIMIT_COUNT__SHIFT 0x2
#define MC_HUB_RDREQ_ACPG_LIMIT__ENABLE_MASK 0x3
#define MC_HUB_RDREQ_ACPG_LIMIT__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPG_LIMIT__LIMIT_COUNT_MASK 0x7c
#define MC_HUB_RDREQ_ACPG_LIMIT__LIMIT_COUNT__SHIFT 0x2
#define MC_HUB_WDP_SH2__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH2__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH2__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH2__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH2__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH2__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH2__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH2__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH2__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH2__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH2__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH2__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH2__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH2__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH3__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH3__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH3__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH3__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH3__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH3__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH3__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH3__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH3__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH3__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH3__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH3__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH3__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH3__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_IA0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_IA0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_IA0__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_IA0__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_IA0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_IA0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_IA0__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_IA0__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_IA0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_IA0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_IA0__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_IA0__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_IA0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_IA0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_IA0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_IA0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_IA1__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_IA1__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_IA1__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_IA1__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_IA1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_IA1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_IA1__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_IA1__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_IA1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_IA1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_IA1__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_IA1__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_IA1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_IA1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_IA1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_IA1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_MCDW__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDW__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDW__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDW__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDW__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDW__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDW__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDW__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDW__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDW__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDW__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDW__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDW__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDW__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDW__STALL_THRESHOLD_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDW__STALL_THRESHOLD__SHIFT 0x19
#define MC_HUB_RDREQ_MCDX__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDX__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDX__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDX__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDX__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDX__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDX__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDX__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDX__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDX__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDX__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDX__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDX__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDX__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDX__STALL_THRESHOLD_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDX__STALL_THRESHOLD__SHIFT 0x19
#define MC_HUB_RDREQ_MCDY__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDY__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDY__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDY__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDY__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDY__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDY__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDY__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDY__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDY__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDY__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDY__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDY__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDY__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDY__STALL_THRESHOLD_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDY__STALL_THRESHOLD__SHIFT 0x19
#define MC_HUB_RDREQ_MCDZ__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCDZ__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCDZ__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_RDREQ_MCDZ__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_RDREQ_MCDZ__BUS_MASK 0x4
#define MC_HUB_RDREQ_MCDZ__BUS__SHIFT 0x2
#define MC_HUB_RDREQ_MCDZ__MAXBURST_MASK 0x78
#define MC_HUB_RDREQ_MCDZ__MAXBURST__SHIFT 0x3
#define MC_HUB_RDREQ_MCDZ__LAZY_TIMER_MASK 0x780
#define MC_HUB_RDREQ_MCDZ__LAZY_TIMER__SHIFT 0x7
#define MC_HUB_RDREQ_MCDZ__ASK_CREDITS_MASK 0x3f800
#define MC_HUB_RDREQ_MCDZ__ASK_CREDITS__SHIFT 0xb
#define MC_HUB_RDREQ_MCDZ__DISPLAY_CREDITS_MASK 0x1fc0000
#define MC_HUB_RDREQ_MCDZ__DISPLAY_CREDITS__SHIFT 0x12
#define MC_HUB_RDREQ_MCDZ__STALL_THRESHOLD_MASK 0xfe000000
#define MC_HUB_RDREQ_MCDZ__STALL_THRESHOLD__SHIFT 0x19
#define MC_HUB_RDREQ_SIP__ASK_CREDITS_MASK 0x7f
#define MC_HUB_RDREQ_SIP__ASK_CREDITS__SHIFT 0x0
#define MC_HUB_RDREQ_SIP__DUMMY_MASK 0x80
#define MC_HUB_RDREQ_SIP__DUMMY__SHIFT 0x7
#define MC_HUB_RDREQ_SIP__DISPLAY_CREDITS_MASK 0x7f00
#define MC_HUB_RDREQ_SIP__DISPLAY_CREDITS__SHIFT 0x8
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD_MASK 0xff
#define MC_HUB_RDREQ_GBL0__STALL_THRESHOLD__SHIFT 0x0
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD_MASK 0xff
#define MC_HUB_RDREQ_GBL1__STALL_THRESHOLD__SHIFT 0x0
#define MC_HUB_RDREQ_SMU__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SMU__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SMU__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SMU__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SMU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SMU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SMU__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SMU__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SMU__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SMU__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SMU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SMU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SMU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_CPG__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_CPG__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_CPG__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_CPG__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_CPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_CPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_CPG__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_CPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_CPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_CPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_CPG__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_CPG__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_CPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_CPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_CPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_CPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SDMA0__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SDMA0__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SDMA0__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SDMA0__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SDMA0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SDMA0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SDMA0__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SDMA0__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SDMA0__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SDMA0__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SDMA0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SDMA0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SDMA0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_HDP__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_HDP__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_HDP__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_HDP__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_HDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_HDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_HDP__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_HDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_HDP__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_HDP__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_HDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_HDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_HDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SDMA1__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SDMA1__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SDMA1__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SDMA1__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SDMA1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SDMA1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SDMA1__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SDMA1__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SDMA1__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SDMA1__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SDMA1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SDMA1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SDMA1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_RLC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_RLC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_RLC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_RLC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_RLC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_RLC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_RLC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_RLC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_RLC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_RLC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_RLC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_RLC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_RLC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_SEM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SEM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SEM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SEM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SEM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SEM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SEM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SEM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SEM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SEM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SEM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SEM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SEM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCE__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCE__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCE__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCE__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCE__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCE__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCE__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCE__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCE__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCE__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCE__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCE__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCE__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCE__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCE__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCE__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_UMC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_UMC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_UMC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_UMC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_UMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_UMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_UMC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_UMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_UMC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_UMC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_UMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_UMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_UMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_UVD__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_UVD__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_UVD__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_UVD__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_UVD__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_UVD__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_UVD__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_UVD__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_UVD__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_UVD__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_UVD__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_UVD__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_UVD__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_UVD__VM_BYPASS_MASK 0x10000
#define MC_HUB_RDREQ_UVD__VM_BYPASS__SHIFT 0x10
#define MC_HUB_RDREQ_IA__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_IA__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_IA__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_IA__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_IA__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_IA__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_IA__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_IA__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_IA__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_IA__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_IA__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_IA__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_IA__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_IA__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_IA__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_IA__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_DMIF__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_DMIF__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_DMIF__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_DMIF__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_DMIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_DMIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_DMIF__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_DMIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_DMIF__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_DMIF__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_DMIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_DMIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_DMIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_MCIF__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_MCIF__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_MCIF__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_MCIF__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_MCIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_MCIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_MCIF__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_MCIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_MCIF__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_MCIF__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_MCIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_MCIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_MCIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VMC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VMC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VMC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VMC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VMC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VMC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VMC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_VCEU__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_VCEU__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_VCEU__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_VCEU__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_VCEU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_VCEU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_VCEU__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_VCEU__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_VCEU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_VCEU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_VCEU__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_VCEU__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_VCEU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_VCEU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_VCEU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_VCEU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_MCDW__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDW__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDW__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDW__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDW__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDW__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDW__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDW__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDW__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDW__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDW__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDW__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDW__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDW__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDW__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDW__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDX__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDX__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDX__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDX__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDX__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDX__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDX__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDX__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDX__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDX__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDX__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDX__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDX__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDX__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDX__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDX__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDY__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDY__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDY__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDY__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDY__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDY__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDY__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDY__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDY__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDY__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDY__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDY__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDY__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDY__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDY__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDY__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_MCDZ__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCDZ__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCDZ__BLACKOUT_EXEMPT_MASK 0x2
#define MC_HUB_WDP_MCDZ__BLACKOUT_EXEMPT__SHIFT 0x1
#define MC_HUB_WDP_MCDZ__STALL_MODE_MASK 0x4
#define MC_HUB_WDP_MCDZ__STALL_MODE__SHIFT 0x2
#define MC_HUB_WDP_MCDZ__MAXBURST_MASK 0x78
#define MC_HUB_WDP_MCDZ__MAXBURST__SHIFT 0x3
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_MASK 0x1f80
#define MC_HUB_WDP_MCDZ__ASK_CREDITS__SHIFT 0x7
#define MC_HUB_WDP_MCDZ__LAZY_TIMER_MASK 0x1e000
#define MC_HUB_WDP_MCDZ__LAZY_TIMER__SHIFT 0xd
#define MC_HUB_WDP_MCDZ__STALL_THRESHOLD_MASK 0xfe0000
#define MC_HUB_WDP_MCDZ__STALL_THRESHOLD__SHIFT 0x11
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_W_MASK 0x7f000000
#define MC_HUB_WDP_MCDZ__ASK_CREDITS_W__SHIFT 0x18
#define MC_HUB_WDP_SIP__STALL_MODE_MASK 0x3
#define MC_HUB_WDP_SIP__STALL_MODE__SHIFT 0x0
#define MC_HUB_WDP_SIP__ASK_CREDITS_MASK 0x1fc
#define MC_HUB_WDP_SIP__ASK_CREDITS__SHIFT 0x2
#define MC_HUB_WDP_CPG__ENABLE_MASK 0x1
#define MC_HUB_WDP_CPG__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_CPG__PRESCALE_MASK 0x6
#define MC_HUB_WDP_CPG__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_CPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_CPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_CPG__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_CPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_CPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_CPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_CPG__MAXBURST_MASK 0x780
#define MC_HUB_WDP_CPG__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_CPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_CPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_CPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_CPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SDMA1__ENABLE_MASK 0x1
#define MC_HUB_WDP_SDMA1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SDMA1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SDMA1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SDMA1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SDMA1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SDMA1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SDMA1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SDMA1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SDMA1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SDMA1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SDMA1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SDMA1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH0__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_MCIF__ENABLE_MASK 0x1
#define MC_HUB_WDP_MCIF__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_MCIF__PRESCALE_MASK 0x6
#define MC_HUB_WDP_MCIF__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_MCIF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_MCIF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_MCIF__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_MCIF__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_MCIF__MAXBURST_MASK 0x780
#define MC_HUB_WDP_MCIF__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_MCIF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_MCIF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_MCIF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_VCE__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCE__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCE__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCE__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCE__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCE__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCE__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCE__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCE__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCE__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCE__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCE__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCE__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCE__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCE__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCE__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDP__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDP__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDP__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDP__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDP__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDP__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_IH__ENABLE_MASK 0x1
#define MC_HUB_WDP_IH__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_IH__PRESCALE_MASK 0x6
#define MC_HUB_WDP_IH__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_IH__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_IH__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_IH__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_IH__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_IH__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_IH__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_IH__MAXBURST_MASK 0x780
#define MC_HUB_WDP_IH__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_IH__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_IH__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_IH__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_IH__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_RLC__ENABLE_MASK 0x1
#define MC_HUB_WDP_RLC__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_RLC__PRESCALE_MASK 0x6
#define MC_HUB_WDP_RLC__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_RLC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_RLC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_RLC__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_RLC__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_RLC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_RLC__MAXBURST_MASK 0x780
#define MC_HUB_WDP_RLC__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_RLC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_RLC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_RLC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SEM__ENABLE_MASK 0x1
#define MC_HUB_WDP_SEM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SEM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SEM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SEM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SEM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SEM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SEM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SEM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SEM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SEM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SEM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SEM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SEM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SMU__ENABLE_MASK 0x1
#define MC_HUB_WDP_SMU__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SMU__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SMU__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SMU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SMU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SMU__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SMU__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SMU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SMU__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SMU__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SMU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SMU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SMU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SH1__ENABLE_MASK 0x1
#define MC_HUB_WDP_SH1__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SH1__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SH1__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SH1__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SH1__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SH1__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SH1__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SH1__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SH1__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SH1__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SH1__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SH1__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SH1__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_UMC__ENABLE_MASK 0x1
#define MC_HUB_WDP_UMC__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_UMC__PRESCALE_MASK 0x6
#define MC_HUB_WDP_UMC__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_UMC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_UMC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_UMC__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_UMC__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_UMC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_UMC__MAXBURST_MASK 0x780
#define MC_HUB_WDP_UMC__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_UMC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_UMC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_UMC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_UVD__ENABLE_MASK 0x1
#define MC_HUB_WDP_UVD__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_UVD__PRESCALE_MASK 0x6
#define MC_HUB_WDP_UVD__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_UVD__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_UVD__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_UVD__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_UVD__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_UVD__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_UVD__MAXBURST_MASK 0x780
#define MC_HUB_WDP_UVD__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_UVD__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_UVD__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_UVD__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_UVD__VM_BYPASS_MASK 0x10000
#define MC_HUB_WDP_UVD__VM_BYPASS__SHIFT 0x10
#define MC_HUB_WDP_HDP__ENABLE_MASK 0x1
#define MC_HUB_WDP_HDP__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_HDP__PRESCALE_MASK 0x6
#define MC_HUB_WDP_HDP__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_HDP__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_HDP__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_HDP__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_HDP__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_HDP__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_HDP__MAXBURST_MASK 0x780
#define MC_HUB_WDP_HDP__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_HDP__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_HDP__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_HDP__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_SDMA0__ENABLE_MASK 0x1
#define MC_HUB_WDP_SDMA0__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SDMA0__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SDMA0__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SDMA0__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SDMA0__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SDMA0__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SDMA0__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SDMA0__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SDMA0__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SDMA0__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SDMA0__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SDMA0__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WRRET_MCDW__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDW__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDW__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDW__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDX__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDX__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDX__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDX__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDY__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDY__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDY__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDY__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WRRET_MCDZ__STALL_MODE_MASK 0x1
#define MC_HUB_WRRET_MCDZ__STALL_MODE__SHIFT 0x0
#define MC_HUB_WRRET_MCDZ__CREDIT_COUNT_MASK 0xfe
#define MC_HUB_WRRET_MCDZ__CREDIT_COUNT__SHIFT 0x1
#define MC_HUB_WDP_VCEU__ENABLE_MASK 0x1
#define MC_HUB_WDP_VCEU__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_VCEU__PRESCALE_MASK 0x6
#define MC_HUB_WDP_VCEU__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_VCEU__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_VCEU__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_VCEU__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_VCEU__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_VCEU__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_VCEU__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_VCEU__MAXBURST_MASK 0x780
#define MC_HUB_WDP_VCEU__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_VCEU__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_VCEU__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_VCEU__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_VCEU__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDMAM__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDMAM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDMAM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDMAM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDMAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDMAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDMAM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDMAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDMAM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDMAM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDMAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDMAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDMAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDMAM__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_XDMAM__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_XDMA__ENABLE_MASK 0x1
#define MC_HUB_WDP_XDMA__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_XDMA__PRESCALE_MASK 0x6
#define MC_HUB_WDP_XDMA__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_XDMA__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_XDMA__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_XDMA__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_XDMA__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_XDMA__MAXBURST_MASK 0x780
#define MC_HUB_WDP_XDMA__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_XDMA__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_XDMA__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_XDMA__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_XDMA__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_XDMA__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_XDMAM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_XDMAM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_XDMAM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_XDMAM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_XDMAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_XDMAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_XDMAM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_XDMAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_XDMAM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_XDMAM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_XDMAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_XDMAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_XDMAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ACPG__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ACPG__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPG__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ACPG__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ACPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ACPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ACPG__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ACPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ACPG__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ACPG__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ACPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ACPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ACPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ACPG__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ACPG__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ACPG__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ACPG__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ACPG__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ACPG__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ACPG__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ACPG__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_ACPO__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_ACPO__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_ACPO__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_ACPO__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_ACPO__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_ACPO__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_ACPO__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_ACPO__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_ACPO__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_ACPO__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_ACPO__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_ACPO__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_ACPO__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_ACPO__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_RDREQ_ACPO__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_RDREQ_ACPO__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_RDREQ_ACPO__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_RDREQ_ACPO__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_RDREQ_ACPO__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_RDREQ_ACPO__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_RDREQ_ACPO__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_RDREQ_SAM__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_SAM__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_SAM__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_SAM__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_SAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_SAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_SAM__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_SAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_SAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_SAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_SAM__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_SAM__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_SAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_SAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_SAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_SAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ACPG__ENABLE_MASK 0x1
#define MC_HUB_WDP_ACPG__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ACPG__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ACPG__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ACPG__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ACPG__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ACPG__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ACPG__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ACPG__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ACPG__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ACPG__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ACPG__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ACPG__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ACPG__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ACPG__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ACPG__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_WDP_ACPG__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_WDP_ACPG__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_WDP_ACPG__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_WDP_ACPG__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_WDP_ACPG__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_WDP_ACPO__ENABLE_MASK 0x1
#define MC_HUB_WDP_ACPO__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_ACPO__PRESCALE_MASK 0x6
#define MC_HUB_WDP_ACPO__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_ACPO__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_ACPO__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_ACPO__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_ACPO__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_ACPO__MAXBURST_MASK 0x780
#define MC_HUB_WDP_ACPO__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_ACPO__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_ACPO__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_ACPO__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_ACPO__BYPASS_AVAIL_OVERRIDE_MASK 0x10000
#define MC_HUB_WDP_ACPO__BYPASS_AVAIL_OVERRIDE__SHIFT 0x10
#define MC_HUB_WDP_ACPO__PRIORITY_DISABLE_MASK 0x20000
#define MC_HUB_WDP_ACPO__PRIORITY_DISABLE__SHIFT 0x11
#define MC_HUB_WDP_ACPO__STALL_FILTER_ENABLE_MASK 0x40000
#define MC_HUB_WDP_ACPO__STALL_FILTER_ENABLE__SHIFT 0x12
#define MC_HUB_WDP_ACPO__STALL_THRESHOLD_MASK 0x1f80000
#define MC_HUB_WDP_ACPO__STALL_THRESHOLD__SHIFT 0x13
#define MC_HUB_WDP_SAM__ENABLE_MASK 0x1
#define MC_HUB_WDP_SAM__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_SAM__PRESCALE_MASK 0x6
#define MC_HUB_WDP_SAM__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_SAM__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_SAM__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_SAM__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_SAM__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_SAM__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_SAM__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_SAM__MAXBURST_MASK 0x780
#define MC_HUB_WDP_SAM__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_SAM__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_SAM__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_SAM__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_SAM__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_CPC__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_CPC__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_CPC__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_CPC__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_CPC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_CPC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_CPC__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_CPC__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_CPC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_CPC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_CPC__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_CPC__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_CPC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_CPC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_CPC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_CPC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_RDREQ_CPF__ENABLE_MASK 0x1
#define MC_HUB_RDREQ_CPF__ENABLE__SHIFT 0x0
#define MC_HUB_RDREQ_CPF__PRESCALE_MASK 0x6
#define MC_HUB_RDREQ_CPF__PRESCALE__SHIFT 0x1
#define MC_HUB_RDREQ_CPF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_RDREQ_CPF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_RDREQ_CPF__STALL_MODE_MASK 0x30
#define MC_HUB_RDREQ_CPF__STALL_MODE__SHIFT 0x4
#define MC_HUB_RDREQ_CPF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_RDREQ_CPF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_RDREQ_CPF__MAXBURST_MASK 0x780
#define MC_HUB_RDREQ_CPF__MAXBURST__SHIFT 0x7
#define MC_HUB_RDREQ_CPF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_RDREQ_CPF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_RDREQ_CPF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_RDREQ_CPF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_CPC__ENABLE_MASK 0x1
#define MC_HUB_WDP_CPC__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_CPC__PRESCALE_MASK 0x6
#define MC_HUB_WDP_CPC__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_CPC__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_CPC__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_CPC__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_CPC__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_CPC__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_CPC__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_CPC__MAXBURST_MASK 0x780
#define MC_HUB_WDP_CPC__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_CPC__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_CPC__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_CPC__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_CPC__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_HUB_WDP_CPF__ENABLE_MASK 0x1
#define MC_HUB_WDP_CPF__ENABLE__SHIFT 0x0
#define MC_HUB_WDP_CPF__PRESCALE_MASK 0x6
#define MC_HUB_WDP_CPF__PRESCALE__SHIFT 0x1
#define MC_HUB_WDP_CPF__BLACKOUT_EXEMPT_MASK 0x8
#define MC_HUB_WDP_CPF__BLACKOUT_EXEMPT__SHIFT 0x3
#define MC_HUB_WDP_CPF__STALL_MODE_MASK 0x30
#define MC_HUB_WDP_CPF__STALL_MODE__SHIFT 0x4
#define MC_HUB_WDP_CPF__STALL_OVERRIDE_MASK 0x40
#define MC_HUB_WDP_CPF__STALL_OVERRIDE__SHIFT 0x6
#define MC_HUB_WDP_CPF__MAXBURST_MASK 0x780
#define MC_HUB_WDP_CPF__MAXBURST__SHIFT 0x7
#define MC_HUB_WDP_CPF__LAZY_TIMER_MASK 0x7800
#define MC_HUB_WDP_CPF__LAZY_TIMER__SHIFT 0xb
#define MC_HUB_WDP_CPF__STALL_OVERRIDE_WTM_MASK 0x8000
#define MC_HUB_WDP_CPF__STALL_OVERRIDE_WTM__SHIFT 0xf
#define MC_RPB_CONF__XPB_PCIE_ORDER_MASK 0x8000
#define MC_RPB_CONF__XPB_PCIE_ORDER__SHIFT 0xf
#define MC_RPB_CONF__RPB_RD_PCIE_ORDER_MASK 0x10000
#define MC_RPB_CONF__RPB_RD_PCIE_ORDER__SHIFT 0x10
#define MC_RPB_CONF__RPB_WR_PCIE_ORDER_MASK 0x20000
#define MC_RPB_CONF__RPB_WR_PCIE_ORDER__SHIFT 0x11
#define MC_RPB_IF_CONF__RPB_BIF_CREDITS_MASK 0xff
#define MC_RPB_IF_CONF__RPB_BIF_CREDITS__SHIFT 0x0
#define MC_RPB_IF_CONF__OUTSTANDING_WRRET_ASK_MASK 0xff00
#define MC_RPB_IF_CONF__OUTSTANDING_WRRET_ASK__SHIFT 0x8
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_MASK 0xff
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD__SHIFT 0x0
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_32B_MASK 0xfff00
#define MC_RPB_DBG1__RPB_BIF_OUTSTANDING_RD_32B__SHIFT 0x8
#define MC_RPB_DBG1__DEBUG_BITS_MASK 0xfff00000
#define MC_RPB_DBG1__DEBUG_BITS__SHIFT 0x14
#define MC_RPB_EFF_CNTL__WR_LAZY_TIMER_MASK 0xff
#define MC_RPB_EFF_CNTL__WR_LAZY_TIMER__SHIFT 0x0
#define MC_RPB_EFF_CNTL__RD_LAZY_TIMER_MASK 0xff00
#define MC_RPB_EFF_CNTL__RD_LAZY_TIMER__SHIFT 0x8
#define MC_RPB_ARB_CNTL__WR_SWITCH_NUM_MASK 0xff
#define MC_RPB_ARB_CNTL__WR_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_ARB_CNTL__RD_SWITCH_NUM_MASK 0xff00
#define MC_RPB_ARB_CNTL__RD_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_ARB_CNTL__ATC_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_ARB_CNTL__ATC_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_BIF_CNTL__ARB_SWITCH_NUM_MASK 0xff
#define MC_RPB_BIF_CNTL__ARB_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_BIF_CNTL__XPB_SWITCH_NUM_MASK 0xff00
#define MC_RPB_BIF_CNTL__XPB_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_WR_SWITCH_CNTL__QUEUE0_SWITCH_NUM_MASK 0xff
#define MC_RPB_WR_SWITCH_CNTL__QUEUE0_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_WR_SWITCH_CNTL__QUEUE1_SWITCH_NUM_MASK 0xff00
#define MC_RPB_WR_SWITCH_CNTL__QUEUE1_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_WR_SWITCH_CNTL__QUEUE2_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_WR_SWITCH_CNTL__QUEUE2_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_WR_SWITCH_CNTL__QUEUE3_SWITCH_NUM_MASK 0xff000000
#define MC_RPB_WR_SWITCH_CNTL__QUEUE3_SWITCH_NUM__SHIFT 0x18
#define MC_RPB_WR_COMBINE_CNTL__WC_ENABLE_MASK 0x1
#define MC_RPB_WR_COMBINE_CNTL__WC_ENABLE__SHIFT 0x0
#define MC_RPB_WR_COMBINE_CNTL__WC_MAX_PACKET_SIZE_MASK 0x6
#define MC_RPB_WR_COMBINE_CNTL__WC_MAX_PACKET_SIZE__SHIFT 0x1
#define MC_RPB_WR_COMBINE_CNTL__WC_FLUSH_TIMER_MASK 0x78
#define MC_RPB_WR_COMBINE_CNTL__WC_FLUSH_TIMER__SHIFT 0x3
#define MC_RPB_WR_COMBINE_CNTL__WC_ALIGN_MASK 0x80
#define MC_RPB_WR_COMBINE_CNTL__WC_ALIGN__SHIFT 0x7
#define MC_RPB_RD_SWITCH_CNTL__QUEUE0_SWITCH_NUM_MASK 0xff
#define MC_RPB_RD_SWITCH_CNTL__QUEUE0_SWITCH_NUM__SHIFT 0x0
#define MC_RPB_RD_SWITCH_CNTL__QUEUE1_SWITCH_NUM_MASK 0xff00
#define MC_RPB_RD_SWITCH_CNTL__QUEUE1_SWITCH_NUM__SHIFT 0x8
#define MC_RPB_RD_SWITCH_CNTL__QUEUE2_SWITCH_NUM_MASK 0xff0000
#define MC_RPB_RD_SWITCH_CNTL__QUEUE2_SWITCH_NUM__SHIFT 0x10
#define MC_RPB_RD_SWITCH_CNTL__QUEUE3_SWITCH_NUM_MASK 0xff000000
#define MC_RPB_RD_SWITCH_CNTL__QUEUE3_SWITCH_NUM__SHIFT 0x18
#define MC_RPB_CID_QUEUE_WR__CLIENT_ID_MASK 0xff
#define MC_RPB_CID_QUEUE_WR__CLIENT_ID__SHIFT 0x0
#define MC_RPB_CID_QUEUE_WR__UPDATE_MODE_MASK 0x100
#define MC_RPB_CID_QUEUE_WR__UPDATE_MODE__SHIFT 0x8
#define MC_RPB_CID_QUEUE_WR__WRITE_QUEUE_MASK 0x600
#define MC_RPB_CID_QUEUE_WR__WRITE_QUEUE__SHIFT 0x9
#define MC_RPB_CID_QUEUE_WR__READ_QUEUE_MASK 0x1800
#define MC_RPB_CID_QUEUE_WR__READ_QUEUE__SHIFT 0xb
#define MC_RPB_CID_QUEUE_WR__UPDATE_MASK 0x2000
#define MC_RPB_CID_QUEUE_WR__UPDATE__SHIFT 0xd
#define MC_RPB_CID_QUEUE_RD__CLIENT_ID_MASK 0xff
#define MC_RPB_CID_QUEUE_RD__CLIENT_ID__SHIFT 0x0
#define MC_RPB_CID_QUEUE_RD__WRITE_QUEUE_MASK 0x300
#define MC_RPB_CID_QUEUE_RD__WRITE_QUEUE__SHIFT 0x8
#define MC_RPB_CID_QUEUE_RD__READ_QUEUE_MASK 0xc00
#define MC_RPB_CID_QUEUE_RD__READ_QUEUE__SHIFT 0xa
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_SELECT_MASK 0x3
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_SELECTED_PERF_COUNTER_MASK 0x4
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_SELECTED_PERF_COUNTER__SHIFT 0x2
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_ALL_PERF_COUNTERS_MASK 0x8
#define MC_RPB_PERF_COUNTER_CNTL__CLEAR_ALL_PERF_COUNTERS__SHIFT 0x3
#define MC_RPB_PERF_COUNTER_CNTL__STOP_ON_COUNTER_SATURATION_MASK 0x10
#define MC_RPB_PERF_COUNTER_CNTL__STOP_ON_COUNTER_SATURATION__SHIFT 0x4
#define MC_RPB_PERF_COUNTER_CNTL__ENABLE_PERF_COUNTERS_MASK 0x1e0
#define MC_RPB_PERF_COUNTER_CNTL__ENABLE_PERF_COUNTERS__SHIFT 0x5
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_0_MASK 0x3e00
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_0__SHIFT 0x9
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_1_MASK 0x7c000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_1__SHIFT 0xe
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_2_MASK 0xf80000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_2__SHIFT 0x13
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_3_MASK 0x1f000000
#define MC_RPB_PERF_COUNTER_CNTL__PERF_COUNTER_ASSIGN_3__SHIFT 0x18
#define MC_RPB_PERF_COUNTER_STATUS__PERFORMANCE_COUNTER_VALUE_MASK 0xffffffff
#define MC_RPB_PERF_COUNTER_STATUS__PERFORMANCE_COUNTER_VALUE__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX__START_MASK 0x1
#define MC_RPB_CID_QUEUE_EX__START__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX__OFFSET_MASK 0x3e
#define MC_RPB_CID_QUEUE_EX__OFFSET__SHIFT 0x1
#define MC_RPB_CID_QUEUE_EX_DATA__WRITE_ENTRIES_MASK 0xffff
#define MC_RPB_CID_QUEUE_EX_DATA__WRITE_ENTRIES__SHIFT 0x0
#define MC_RPB_CID_QUEUE_EX_DATA__READ_ENTRIES_MASK 0xffff0000
#define MC_RPB_CID_QUEUE_EX_DATA__READ_ENTRIES__SHIFT 0x10
#define MC_SHARED_CHMAP__CHAN0_MASK 0xf
#define MC_SHARED_CHMAP__CHAN0__SHIFT 0x0
#define MC_SHARED_CHMAP__CHAN1_MASK 0xf0
#define MC_SHARED_CHMAP__CHAN1__SHIFT 0x4
#define MC_SHARED_CHMAP__CHAN2_MASK 0xf00
#define MC_SHARED_CHMAP__CHAN2__SHIFT 0x8
#define MC_SHARED_CHMAP__NOOFCHAN_MASK 0xf000
#define MC_SHARED_CHMAP__NOOFCHAN__SHIFT 0xc
#define MC_SHARED_CHREMAP__CHAN0_MASK 0x7
#define MC_SHARED_CHREMAP__CHAN0__SHIFT 0x0
#define MC_SHARED_CHREMAP__CHAN1_MASK 0x38
#define MC_SHARED_CHREMAP__CHAN1__SHIFT 0x3
#define MC_SHARED_CHREMAP__CHAN2_MASK 0x1c0
#define MC_SHARED_CHREMAP__CHAN2__SHIFT 0x6
#define MC_SHARED_CHREMAP__CHAN3_MASK 0xe00
#define MC_SHARED_CHREMAP__CHAN3__SHIFT 0x9
#define MC_SHARED_CHREMAP__CHAN4_MASK 0x7000
#define MC_SHARED_CHREMAP__CHAN4__SHIFT 0xc
#define MC_SHARED_CHREMAP__CHAN5_MASK 0x38000
#define MC_SHARED_CHREMAP__CHAN5__SHIFT 0xf
#define MC_SHARED_CHREMAP__CHAN6_MASK 0x1c0000
#define MC_SHARED_CHREMAP__CHAN6__SHIFT 0x12
#define MC_SHARED_CHREMAP__CHAN7_MASK 0xe00000
#define MC_SHARED_CHREMAP__CHAN7__SHIFT 0x15
#define MC_RD_GRP_GFX__CP_MASK 0xf
#define MC_RD_GRP_GFX__CP__SHIFT 0x0
#define MC_RD_GRP_GFX__SH_MASK 0xf0
#define MC_RD_GRP_GFX__SH__SHIFT 0x4
#define MC_RD_GRP_GFX__IA_MASK 0xf00
#define MC_RD_GRP_GFX__IA__SHIFT 0x8
#define MC_RD_GRP_GFX__ACPG_MASK 0xf000
#define MC_RD_GRP_GFX__ACPG__SHIFT 0xc
#define MC_RD_GRP_GFX__ACPO_MASK 0xf0000
#define MC_RD_GRP_GFX__ACPO__SHIFT 0x10
#define MC_RD_GRP_GFX__XDMAM_MASK 0xf00000
#define MC_RD_GRP_GFX__XDMAM__SHIFT 0x14
#define MC_WR_GRP_GFX__CP_MASK 0xf
#define MC_WR_GRP_GFX__CP__SHIFT 0x0
#define MC_WR_GRP_GFX__SH_MASK 0xf0
#define MC_WR_GRP_GFX__SH__SHIFT 0x4
#define MC_WR_GRP_GFX__ACPG_MASK 0xf00
#define MC_WR_GRP_GFX__ACPG__SHIFT 0x8
#define MC_WR_GRP_GFX__ACPO_MASK 0xf000
#define MC_WR_GRP_GFX__ACPO__SHIFT 0xc
#define MC_WR_GRP_GFX__XDMA_MASK 0xf0000
#define MC_WR_GRP_GFX__XDMA__SHIFT 0x10
#define MC_WR_GRP_GFX__XDMAM_MASK 0xf00000
#define MC_WR_GRP_GFX__XDMAM__SHIFT 0x14
#define MC_RD_GRP_SYS__RLC_MASK 0xf
#define MC_RD_GRP_SYS__RLC__SHIFT 0x0
#define MC_RD_GRP_SYS__VMC_MASK 0xf0
#define MC_RD_GRP_SYS__VMC__SHIFT 0x4
#define MC_RD_GRP_SYS__SDMA1_MASK 0xf00
#define MC_RD_GRP_SYS__SDMA1__SHIFT 0x8
#define MC_RD_GRP_SYS__DMIF_MASK 0xf000
#define MC_RD_GRP_SYS__DMIF__SHIFT 0xc
#define MC_RD_GRP_SYS__MCIF_MASK 0xf0000
#define MC_RD_GRP_SYS__MCIF__SHIFT 0x10
#define MC_RD_GRP_SYS__SMU_MASK 0xf00000
#define MC_RD_GRP_SYS__SMU__SHIFT 0x14
#define MC_RD_GRP_SYS__VCE_MASK 0xf000000
#define MC_RD_GRP_SYS__VCE__SHIFT 0x18
#define MC_RD_GRP_SYS__VCEU_MASK 0xf0000000
#define MC_RD_GRP_SYS__VCEU__SHIFT 0x1c
#define MC_WR_GRP_SYS__IH_MASK 0xf
#define MC_WR_GRP_SYS__IH__SHIFT 0x0
#define MC_WR_GRP_SYS__MCIF_MASK 0xf0
#define MC_WR_GRP_SYS__MCIF__SHIFT 0x4
#define MC_WR_GRP_SYS__RLC_MASK 0xf00
#define MC_WR_GRP_SYS__RLC__SHIFT 0x8
#define MC_WR_GRP_SYS__SAM_MASK 0xf000
#define MC_WR_GRP_SYS__SAM__SHIFT 0xc
#define MC_WR_GRP_SYS__SMU_MASK 0xf0000
#define MC_WR_GRP_SYS__SMU__SHIFT 0x10
#define MC_WR_GRP_SYS__SDMA1_MASK 0xf00000
#define MC_WR_GRP_SYS__SDMA1__SHIFT 0x14
#define MC_WR_GRP_SYS__VCE_MASK 0xf000000
#define MC_WR_GRP_SYS__VCE__SHIFT 0x18
#define MC_WR_GRP_SYS__VCEU_MASK 0xf0000000
#define MC_WR_GRP_SYS__VCEU__SHIFT 0x1c
#define MC_RD_GRP_OTH__UVD_EXT0_MASK 0xf
#define MC_RD_GRP_OTH__UVD_EXT0__SHIFT 0x0
#define MC_RD_GRP_OTH__SDMA0_MASK 0xf0
#define MC_RD_GRP_OTH__SDMA0__SHIFT 0x4
#define MC_RD_GRP_OTH__HDP_MASK 0xf00
#define MC_RD_GRP_OTH__HDP__SHIFT 0x8
#define MC_RD_GRP_OTH__SEM_MASK 0xf000
#define MC_RD_GRP_OTH__SEM__SHIFT 0xc
#define MC_RD_GRP_OTH__UMC_MASK 0xf0000
#define MC_RD_GRP_OTH__UMC__SHIFT 0x10
#define MC_RD_GRP_OTH__UVD_MASK 0xf00000
#define MC_RD_GRP_OTH__UVD__SHIFT 0x14
#define MC_RD_GRP_OTH__UVD_EXT1_MASK 0xf000000
#define MC_RD_GRP_OTH__UVD_EXT1__SHIFT 0x18
#define MC_RD_GRP_OTH__SAM_MASK 0xf0000000
#define MC_RD_GRP_OTH__SAM__SHIFT 0x1c
#define MC_WR_GRP_OTH__UVD_EXT0_MASK 0xf
#define MC_WR_GRP_OTH__UVD_EXT0__SHIFT 0x0
#define MC_WR_GRP_OTH__SDMA0_MASK 0xf0
#define MC_WR_GRP_OTH__SDMA0__SHIFT 0x4
#define MC_WR_GRP_OTH__HDP_MASK 0xf00
#define MC_WR_GRP_OTH__HDP__SHIFT 0x8
#define MC_WR_GRP_OTH__SEM_MASK 0xf000
#define MC_WR_GRP_OTH__SEM__SHIFT 0xc
#define MC_WR_GRP_OTH__UMC_MASK 0xf0000
#define MC_WR_GRP_OTH__UMC__SHIFT 0x10
#define MC_WR_GRP_OTH__UVD_MASK 0xf00000
#define MC_WR_GRP_OTH__UVD__SHIFT 0x14
#define MC_WR_GRP_OTH__XDP_MASK 0xf000000
#define MC_WR_GRP_OTH__XDP__SHIFT 0x18
#define MC_WR_GRP_OTH__UVD_EXT1_MASK 0xf0000000
#define MC_WR_GRP_OTH__UVD_EXT1__SHIFT 0x1c
#define MC_VM_FB_LOCATION__FB_BASE_MASK 0xffff
#define MC_VM_FB_LOCATION__FB_BASE__SHIFT 0x0
#define MC_VM_FB_LOCATION__FB_TOP_MASK 0xffff0000
#define MC_VM_FB_LOCATION__FB_TOP__SHIFT 0x10
#define MC_VM_AGP_TOP__AGP_TOP_MASK 0x3ffff
#define MC_VM_AGP_TOP__AGP_TOP__SHIFT 0x0
#define MC_VM_AGP_BOT__AGP_BOT_MASK 0x3ffff
#define MC_VM_AGP_BOT__AGP_BOT__SHIFT 0x0
#define MC_VM_AGP_BASE__AGP_BASE_MASK 0x3ffff
#define MC_VM_AGP_BASE__AGP_BASE__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define MC_VM_SYSTEM_APERTURE_DEFAULT_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_0_MODE_MASK 0x3
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_0_MODE__SHIFT 0x0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_1_MODE_MASK 0xc
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_1_MODE__SHIFT 0x2
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_2_MODE_MASK 0x30
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_2_MODE__SHIFT 0x4
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_3_MODE_MASK 0xc0
#define MC_VM_DC_WRITE_CNTL__DC_WRITE_HIT_REGION_3_MODE__SHIFT 0x6
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_LOCAL_MASK 0x100
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_LOCAL__SHIFT 0x8
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_SYSTEM_MASK 0x200
#define MC_VM_DC_WRITE_CNTL__DC_MEMORY_WRITE_SYSTEM__SHIFT 0x9
#define MC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_0_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_1_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_2_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_3_LOW_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_0_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_1_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_2_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR__PHYSICAL_ADDRESS_MASK 0xfffffff
#define MC_VM_DC_WRITE_HIT_REGION_3_HIGH_ADDR__PHYSICAL_ADDRESS__SHIFT 0x0
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB_MASK 0x1
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_TLB__SHIFT 0x0
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_FRAGMENT_PROCESSING_MASK 0x2
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_L1_FRAGMENT_PROCESSING__SHIFT 0x1
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE_MASK 0x18
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_ACCESS_MODE__SHIFT 0x3
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS_MASK 0x20
#define MC_VM_MX_L1_TLB_CNTL__SYSTEM_APERTURE_UNMAPPED_ACCESS__SHIFT 0x5
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL_MASK 0x40
#define MC_VM_MX_L1_TLB_CNTL__ENABLE_ADVANCED_DRIVER_MODEL__SHIFT 0x6
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS_MASK 0x780
#define MC_VM_MX_L1_TLB_CNTL__ECO_BITS__SHIFT 0x7
#define MC_VM_FB_OFFSET__FB_OFFSET_MASK 0x3ffff
#define MC_VM_FB_OFFSET__FB_OFFSET__SHIFT 0x0
#define MC_VM_STEERING__DEFAULT_STEERING_MASK 0x3
#define MC_VM_STEERING__DEFAULT_STEERING__SHIFT 0x0
#define MC_CONFIG_MCD__MCD0_WR_ENABLE_MASK 0x1
#define MC_CONFIG_MCD__MCD0_WR_ENABLE__SHIFT 0x0
#define MC_CONFIG_MCD__MCD1_WR_ENABLE_MASK 0x2
#define MC_CONFIG_MCD__MCD1_WR_ENABLE__SHIFT 0x1
#define MC_CONFIG_MCD__MCD2_WR_ENABLE_MASK 0x4
#define MC_CONFIG_MCD__MCD2_WR_ENABLE__SHIFT 0x2
#define MC_CONFIG_MCD__MCD3_WR_ENABLE_MASK 0x8
#define MC_CONFIG_MCD__MCD3_WR_ENABLE__SHIFT 0x3
#define MC_CONFIG_MCD__MCD4_WR_ENABLE_MASK 0x10
#define MC_CONFIG_MCD__MCD4_WR_ENABLE__SHIFT 0x4
#define MC_CONFIG_MCD__MCD5_WR_ENABLE_MASK 0x20
#define MC_CONFIG_MCD__MCD5_WR_ENABLE__SHIFT 0x5
#define MC_CONFIG_MCD__MC_RD_ENABLE_MASK 0x700
#define MC_CONFIG_MCD__MC_RD_ENABLE__SHIFT 0x8
#define MC_CONFIG_MCD__MCD_INDEX_MODE_ENABLE_MASK 0x80000000
#define MC_CONFIG_MCD__MCD_INDEX_MODE_ENABLE__SHIFT 0x1f
#define MC_CG_CONFIG_MCD__MCD0_WR_ENABLE_MASK 0x1
#define MC_CG_CONFIG_MCD__MCD0_WR_ENABLE__SHIFT 0x0
#define MC_CG_CONFIG_MCD__MCD1_WR_ENABLE_MASK 0x2
#define MC_CG_CONFIG_MCD__MCD1_WR_ENABLE__SHIFT 0x1
#define MC_CG_CONFIG_MCD__MCD2_WR_ENABLE_MASK 0x4
#define MC_CG_CONFIG_MCD__MCD2_WR_ENABLE__SHIFT 0x2
#define MC_CG_CONFIG_MCD__MCD3_WR_ENABLE_MASK 0x8
#define MC_CG_CONFIG_MCD__MCD3_WR_ENABLE__SHIFT 0x3
#define MC_CG_CONFIG_MCD__MCD4_WR_ENABLE_MASK 0x10
#define MC_CG_CONFIG_MCD__MCD4_WR_ENABLE__SHIFT 0x4
#define MC_CG_CONFIG_MCD__MCD5_WR_ENABLE_MASK 0x20
#define MC_CG_CONFIG_MCD__MCD5_WR_ENABLE__SHIFT 0x5
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE_MASK 0x700
#define MC_CG_CONFIG_MCD__MC_RD_ENABLE__SHIFT 0x8
#define MC_CG_CONFIG_MCD__INDEX_MASK 0x1fffe000
#define MC_CG_CONFIG_MCD__INDEX__SHIFT 0xd
#define MC_MEM_POWER_LS__LS_SETUP_MASK 0x3f
#define MC_MEM_POWER_LS__LS_SETUP__SHIFT 0x0
#define MC_MEM_POWER_LS__LS_HOLD_MASK 0xfc0
#define MC_MEM_POWER_LS__LS_HOLD__SHIFT 0x6
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MODE_MASK 0x7
#define MC_SHARED_BLACKOUT_CNTL__BLACKOUT_MODE__SHIFT 0x0
#define MC_VM_MB_L1_TLB0_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB0_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB0_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB0_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB2_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB2_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB2_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB2_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB0_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB0_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L1_TLB1_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB1_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L1_TLB2_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB2_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MB_L2ARBITER_L2_CREDITS__L2_IF_CREDITS_MASK 0x3f
#define MC_VM_MB_L2ARBITER_L2_CREDITS__L2_IF_CREDITS__SHIFT 0x0
#define MC_VM_MB_L1_TLB3_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MB_L1_TLB3_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MB_L1_TLB3_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MB_L1_TLB3_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MB_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MB_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MB_L1_TLB3_STATUS__BUSY_MASK 0x1
#define MC_VM_MB_L1_TLB3_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB0_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB0_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB0_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB0_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB0_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB0_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB1_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB1_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB1_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB1_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB1_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB1_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB2_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB2_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB2_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB2_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB2_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB2_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB0_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB0_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB1_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB1_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L1_TLB2_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB2_STATUS__BUSY__SHIFT 0x0
#define MC_VM_MD_L2ARBITER_L2_CREDITS__L2_IF_CREDITS_MASK 0x3f
#define MC_VM_MD_L2ARBITER_L2_CREDITS__L2_IF_CREDITS__SHIFT 0x0
#define MC_VM_MD_L1_TLB3_DEBUG__INVALIDATE_L1_TLB_MASK 0x1
#define MC_VM_MD_L1_TLB3_DEBUG__INVALIDATE_L1_TLB__SHIFT 0x0
#define MC_VM_MD_L1_TLB3_DEBUG__SEND_FREE_AT_RTN_MASK 0x100
#define MC_VM_MD_L1_TLB3_DEBUG__SEND_FREE_AT_RTN__SHIFT 0x8
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE_MASK 0xe00
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_TLB_SIZE__SHIFT 0x9
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE_MASK 0x7000
#define MC_VM_MD_L1_TLB3_DEBUG__EFFECTIVE_L1_QUEUE_SIZE__SHIFT 0xc
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_DEBUG_MASK 0x78000
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_DEBUG__SHIFT 0xf
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS_MASK 0x80000
#define MC_VM_MD_L1_TLB3_DEBUG__L1_TLB_FORCE_MISS__SHIFT 0x13
#define MC_VM_MD_L1_TLB3_STATUS__BUSY_MASK 0x1
#define MC_VM_MD_L1_TLB3_STATUS__BUSY__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR0__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR0__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR1__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR1__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR2__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR2__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR3__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR3__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR4__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR4__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR5__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR5__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR6__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR6__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR7__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR7__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR8__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR8__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_SRC_APRTR9__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_RTR_SRC_APRTR9__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR0__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR0__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR1__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR1__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR2__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR2__BASE_ADDR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_SRC_APRTR3__BASE_ADDR_MASK 0x1ffffff
#define MC_XPB_XDMA_RTR_SRC_APRTR3__BASE_ADDR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP0__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP0__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP0__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP0__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP0__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP0__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP0__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP0__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP0__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP1__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP1__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP1__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP1__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP1__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP1__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP1__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP1__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP1__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP2__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP2__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP2__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP2__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP2__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP2__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP2__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP2__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP2__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP3__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP3__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP3__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP3__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP3__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP3__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP3__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP3__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP3__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP4__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP4__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP4__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP4__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP4__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP4__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP4__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP4__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP4__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP5__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP5__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP5__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP5__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP5__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP5__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP5__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP5__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP5__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP6__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP6__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP6__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP6__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP6__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP6__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP6__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP6__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP6__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP7__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP7__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP7__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP7__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP7__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP7__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP7__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP7__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP7__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP8__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP8__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP8__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP8__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP8__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP8__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP8__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP8__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP8__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_RTR_DEST_MAP9__NMR_MASK 0x1
#define MC_XPB_RTR_DEST_MAP9__NMR__SHIFT 0x0
#define MC_XPB_RTR_DEST_MAP9__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_RTR_DEST_MAP9__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_MASK 0xf00000
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL__SHIFT 0x14
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_RTR_DEST_MAP9__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_RTR_DEST_MAP9__SIDE_OK_MASK 0x2000000
#define MC_XPB_RTR_DEST_MAP9__SIDE_OK__SHIFT 0x19
#define MC_XPB_RTR_DEST_MAP9__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_RTR_DEST_MAP9__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP0__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP0__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP0__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP0__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP0__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP1__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP1__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP1__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP1__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP1__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP2__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP2__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP2__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP2__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP2__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_XDMA_RTR_DEST_MAP3__NMR_MASK 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP3__NMR__SHIFT 0x0
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_OFFSET_MASK 0xffffe
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_OFFSET__SHIFT 0x1
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_MASK 0xf00000
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL__SHIFT 0x14
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_RPB_MASK 0x1000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__DEST_SEL_RPB__SHIFT 0x18
#define MC_XPB_XDMA_RTR_DEST_MAP3__SIDE_OK_MASK 0x2000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__SIDE_OK__SHIFT 0x19
#define MC_XPB_XDMA_RTR_DEST_MAP3__APRTR_SIZE_MASK 0x7c000000
#define MC_XPB_XDMA_RTR_DEST_MAP3__APRTR_SIZE__SHIFT 0x1a
#define MC_XPB_CLG_CFG0__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG0__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG0__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG0__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG0__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG0__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG0__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG0__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG0__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG0__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG1__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG1__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG1__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG1__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG1__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG1__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG1__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG1__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG1__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG1__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG2__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG2__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG2__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG2__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG2__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG2__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG2__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG2__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG2__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG2__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG3__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG3__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG3__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG3__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG3__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG3__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG3__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG3__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG3__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG3__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG4__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG4__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG4__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG4__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG4__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG4__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG4__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG4__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG4__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG4__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG5__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG5__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG5__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG5__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG5__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG5__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG5__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG5__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG5__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG5__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG6__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG6__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG6__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG6__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG6__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG6__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG6__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG6__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG6__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG6__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG7__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG7__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG7__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG7__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG7__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG7__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG7__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG7__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG7__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG7__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG8__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG8__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG8__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG8__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG8__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG8__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG8__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG8__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG8__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG8__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG9__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG9__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG9__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG9__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG9__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG9__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG9__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG9__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG9__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG9__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG10__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG10__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG10__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG10__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG10__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG10__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG10__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG10__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG10__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG10__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG11__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG11__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG11__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG11__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG11__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG11__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG11__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG11__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG11__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG11__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG12__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG12__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG12__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG12__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG12__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG12__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG12__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG12__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG12__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG12__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG13__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG13__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG13__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG13__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG13__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG13__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG13__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG13__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG13__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG13__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG14__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG14__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG14__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG14__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG14__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG14__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG14__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG14__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG14__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG14__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG15__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG15__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG15__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG15__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG15__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG15__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG15__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG15__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG15__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG15__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG16__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG16__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG16__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG16__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG16__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG16__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG16__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG16__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG16__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG16__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG17__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG17__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG17__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG17__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG17__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG17__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG17__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG17__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG17__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG17__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG18__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG18__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG18__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG18__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG18__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG18__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG18__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG18__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG18__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG18__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG19__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG19__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG19__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG19__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG19__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG19__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG19__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG19__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG19__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG19__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_EXTRA__CMP0_MASK 0xff
#define MC_XPB_CLG_EXTRA__CMP0__SHIFT 0x0
#define MC_XPB_CLG_EXTRA__MSK0_MASK 0xff00
#define MC_XPB_CLG_EXTRA__MSK0__SHIFT 0x8
#define MC_XPB_CLG_EXTRA__VLD0_MASK 0x10000
#define MC_XPB_CLG_EXTRA__VLD0__SHIFT 0x10
#define MC_XPB_CLG_EXTRA__CMP1_MASK 0x1fe0000
#define MC_XPB_CLG_EXTRA__CMP1__SHIFT 0x11
#define MC_XPB_CLG_EXTRA__VLD1_MASK 0x2000000
#define MC_XPB_CLG_EXTRA__VLD1__SHIFT 0x19
#define MC_XPB_LB_ADDR__CMP0_MASK 0x3ff
#define MC_XPB_LB_ADDR__CMP0__SHIFT 0x0
#define MC_XPB_LB_ADDR__MASK0_MASK 0xffc00
#define MC_XPB_LB_ADDR__MASK0__SHIFT 0xa
#define MC_XPB_LB_ADDR__CMP1_MASK 0x3f00000
#define MC_XPB_LB_ADDR__CMP1__SHIFT 0x14
#define MC_XPB_LB_ADDR__MASK1_MASK 0xfc000000
#define MC_XPB_LB_ADDR__MASK1__SHIFT 0x1a
#define MC_XPB_UNC_THRESH_HST__CHANGE_PREF_MASK 0x3f
#define MC_XPB_UNC_THRESH_HST__CHANGE_PREF__SHIFT 0x0
#define MC_XPB_UNC_THRESH_HST__STRONG_PREF_MASK 0xfc0
#define MC_XPB_UNC_THRESH_HST__STRONG_PREF__SHIFT 0x6
#define MC_XPB_UNC_THRESH_HST__USE_UNFULL_MASK 0x3f000
#define MC_XPB_UNC_THRESH_HST__USE_UNFULL__SHIFT 0xc
#define MC_XPB_UNC_THRESH_SID__CHANGE_PREF_MASK 0x3f
#define MC_XPB_UNC_THRESH_SID__CHANGE_PREF__SHIFT 0x0
#define MC_XPB_UNC_THRESH_SID__STRONG_PREF_MASK 0xfc0
#define MC_XPB_UNC_THRESH_SID__STRONG_PREF__SHIFT 0x6
#define MC_XPB_UNC_THRESH_SID__USE_UNFULL_MASK 0x3f000
#define MC_XPB_UNC_THRESH_SID__USE_UNFULL__SHIFT 0xc
#define MC_XPB_WCB_STS__PBUF_VLD_MASK 0xffff
#define MC_XPB_WCB_STS__PBUF_VLD__SHIFT 0x0
#define MC_XPB_WCB_STS__WCB_HST_DATA_BUF_CNT_MASK 0x7f0000
#define MC_XPB_WCB_STS__WCB_HST_DATA_BUF_CNT__SHIFT 0x10
#define MC_XPB_WCB_STS__WCB_SID_DATA_BUF_CNT_MASK 0x3f800000
#define MC_XPB_WCB_STS__WCB_SID_DATA_BUF_CNT__SHIFT 0x17
#define MC_XPB_WCB_CFG__TIMEOUT_MASK 0xffff
#define MC_XPB_WCB_CFG__TIMEOUT__SHIFT 0x0
#define MC_XPB_WCB_CFG__HST_MAX_MASK 0x30000
#define MC_XPB_WCB_CFG__HST_MAX__SHIFT 0x10
#define MC_XPB_WCB_CFG__SID_MAX_MASK 0xc0000
#define MC_XPB_WCB_CFG__SID_MAX__SHIFT 0x12
#define MC_XPB_P2P_BAR_CFG__ADDR_SIZE_MASK 0xf
#define MC_XPB_P2P_BAR_CFG__ADDR_SIZE__SHIFT 0x0
#define MC_XPB_P2P_BAR_CFG__SEND_BAR_MASK 0x30
#define MC_XPB_P2P_BAR_CFG__SEND_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR_CFG__SNOOP_MASK 0x40
#define MC_XPB_P2P_BAR_CFG__SNOOP__SHIFT 0x6
#define MC_XPB_P2P_BAR_CFG__SEND_DIS_MASK 0x80
#define MC_XPB_P2P_BAR_CFG__SEND_DIS__SHIFT 0x7
#define MC_XPB_P2P_BAR_CFG__COMPRESS_DIS_MASK 0x100
#define MC_XPB_P2P_BAR_CFG__COMPRESS_DIS__SHIFT 0x8
#define MC_XPB_P2P_BAR_CFG__UPDATE_DIS_MASK 0x200
#define MC_XPB_P2P_BAR_CFG__UPDATE_DIS__SHIFT 0x9
#define MC_XPB_P2P_BAR_CFG__REGBAR_FROM_SYSBAR_MASK 0x400
#define MC_XPB_P2P_BAR_CFG__REGBAR_FROM_SYSBAR__SHIFT 0xa
#define MC_XPB_P2P_BAR_CFG__RD_EN_MASK 0x800
#define MC_XPB_P2P_BAR_CFG__RD_EN__SHIFT 0xb
#define MC_XPB_P2P_BAR_CFG__ATC_TRANSLATED_MASK 0x1000
#define MC_XPB_P2P_BAR_CFG__ATC_TRANSLATED__SHIFT 0xc
#define MC_XPB_P2P_BAR0__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR0__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR0__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR0__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR0__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR0__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR0__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR0__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR0__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR0__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR0__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR0__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR0__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR0__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR0__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR0__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR1__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR1__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR1__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR1__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR1__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR1__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR1__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR1__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR1__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR1__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR1__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR1__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR1__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR1__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR1__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR1__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR2__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR2__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR2__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR2__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR2__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR2__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR2__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR2__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR2__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR2__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR2__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR2__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR2__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR2__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR2__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR2__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR3__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR3__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR3__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR3__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR3__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR3__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR3__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR3__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR3__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR3__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR3__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR3__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR3__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR3__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR3__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR3__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR4__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR4__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR4__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR4__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR4__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR4__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR4__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR4__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR4__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR4__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR4__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR4__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR4__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR4__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR4__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR4__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR5__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR5__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR5__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR5__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR5__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR5__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR5__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR5__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR5__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR5__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR5__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR5__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR5__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR5__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR5__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR5__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR6__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR6__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR6__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR6__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR6__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR6__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR6__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR6__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR6__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR6__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR6__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR6__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR6__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR6__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR6__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR6__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR7__HOST_FLUSH_MASK 0xf
#define MC_XPB_P2P_BAR7__HOST_FLUSH__SHIFT 0x0
#define MC_XPB_P2P_BAR7__REG_SYS_BAR_MASK 0xf0
#define MC_XPB_P2P_BAR7__REG_SYS_BAR__SHIFT 0x4
#define MC_XPB_P2P_BAR7__MEM_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR7__MEM_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR7__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR7__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR7__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR7__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR7__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR7__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR7__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR7__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR7__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR7__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR_SETUP__SEL_MASK 0xff
#define MC_XPB_P2P_BAR_SETUP__SEL__SHIFT 0x0
#define MC_XPB_P2P_BAR_SETUP__REG_SYS_BAR_MASK 0xf00
#define MC_XPB_P2P_BAR_SETUP__REG_SYS_BAR__SHIFT 0x8
#define MC_XPB_P2P_BAR_SETUP__VALID_MASK 0x1000
#define MC_XPB_P2P_BAR_SETUP__VALID__SHIFT 0xc
#define MC_XPB_P2P_BAR_SETUP__SEND_DIS_MASK 0x2000
#define MC_XPB_P2P_BAR_SETUP__SEND_DIS__SHIFT 0xd
#define MC_XPB_P2P_BAR_SETUP__COMPRESS_DIS_MASK 0x4000
#define MC_XPB_P2P_BAR_SETUP__COMPRESS_DIS__SHIFT 0xe
#define MC_XPB_P2P_BAR_SETUP__RESERVED_MASK 0x8000
#define MC_XPB_P2P_BAR_SETUP__RESERVED__SHIFT 0xf
#define MC_XPB_P2P_BAR_SETUP__ADDRESS_MASK 0xffff0000
#define MC_XPB_P2P_BAR_SETUP__ADDRESS__SHIFT 0x10
#define MC_XPB_P2P_BAR_DEBUG__SEL_MASK 0xff
#define MC_XPB_P2P_BAR_DEBUG__SEL__SHIFT 0x0
#define MC_XPB_P2P_BAR_DEBUG__HOST_FLUSH_MASK 0xf00
#define MC_XPB_P2P_BAR_DEBUG__HOST_FLUSH__SHIFT 0x8
#define MC_XPB_P2P_BAR_DEBUG__MEM_SYS_BAR_MASK 0xf000
#define MC_XPB_P2P_BAR_DEBUG__MEM_SYS_BAR__SHIFT 0xc
#define MC_XPB_P2P_BAR_DELTA_ABOVE__EN_MASK 0xff
#define MC_XPB_P2P_BAR_DELTA_ABOVE__EN__SHIFT 0x0
#define MC_XPB_P2P_BAR_DELTA_ABOVE__DELTA_MASK 0xfffff00
#define MC_XPB_P2P_BAR_DELTA_ABOVE__DELTA__SHIFT 0x8
#define MC_XPB_P2P_BAR_DELTA_BELOW__EN_MASK 0xff
#define MC_XPB_P2P_BAR_DELTA_BELOW__EN__SHIFT 0x0
#define MC_XPB_P2P_BAR_DELTA_BELOW__DELTA_MASK 0xfffff00
#define MC_XPB_P2P_BAR_DELTA_BELOW__DELTA__SHIFT 0x8
#define MC_XPB_PEER_SYS_BAR0__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR0__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR0__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR0__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR0__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR0__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR1__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR1__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR1__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR1__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR1__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR1__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR2__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR2__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR2__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR2__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR2__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR2__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR3__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR3__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR3__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR3__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR3__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR3__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR4__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR4__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR4__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR4__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR4__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR4__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR5__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR5__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR5__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR5__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR5__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR5__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR6__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR6__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR6__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR6__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR6__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR6__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR7__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR7__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR7__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR7__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR7__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR7__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR8__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR8__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR8__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR8__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR8__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR8__ADDR__SHIFT 0x2
#define MC_XPB_PEER_SYS_BAR9__VALID_MASK 0x1
#define MC_XPB_PEER_SYS_BAR9__VALID__SHIFT 0x0
#define MC_XPB_PEER_SYS_BAR9__SIDE_OK_MASK 0x2
#define MC_XPB_PEER_SYS_BAR9__SIDE_OK__SHIFT 0x1
#define MC_XPB_PEER_SYS_BAR9__ADDR_MASK 0x7fffffc
#define MC_XPB_PEER_SYS_BAR9__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR0__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR0__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR0__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR0__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR0__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR0__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR1__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR1__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR1__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR1__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR1__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR1__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR2__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR2__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR2__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR2__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR2__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR2__ADDR__SHIFT 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR3__VALID_MASK 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR3__VALID__SHIFT 0x0
#define MC_XPB_XDMA_PEER_SYS_BAR3__SIDE_OK_MASK 0x2
#define MC_XPB_XDMA_PEER_SYS_BAR3__SIDE_OK__SHIFT 0x1
#define MC_XPB_XDMA_PEER_SYS_BAR3__ADDR_MASK 0x7fffffc
#define MC_XPB_XDMA_PEER_SYS_BAR3__ADDR__SHIFT 0x2
#define MC_XPB_CLK_GAT__ONDLY_MASK 0x3f
#define MC_XPB_CLK_GAT__ONDLY__SHIFT 0x0
#define MC_XPB_CLK_GAT__OFFDLY_MASK 0xfc0
#define MC_XPB_CLK_GAT__OFFDLY__SHIFT 0x6
#define MC_XPB_CLK_GAT__RDYDLY_MASK 0x3f000
#define MC_XPB_CLK_GAT__RDYDLY__SHIFT 0xc
#define MC_XPB_CLK_GAT__ENABLE_MASK 0x40000
#define MC_XPB_CLK_GAT__ENABLE__SHIFT 0x12
#define MC_XPB_CLK_GAT__MEM_LS_ENABLE_MASK 0x80000
#define MC_XPB_CLK_GAT__MEM_LS_ENABLE__SHIFT 0x13
#define MC_XPB_INTF_CFG__RPB_WRREQ_CRD_MASK 0xff
#define MC_XPB_INTF_CFG__RPB_WRREQ_CRD__SHIFT 0x0
#define MC_XPB_INTF_CFG__MC_WRRET_ASK_MASK 0xff00
#define MC_XPB_INTF_CFG__MC_WRRET_ASK__SHIFT 0x8
#define MC_XPB_INTF_CFG__XSP_REQ_CRD_MASK 0x7f0000
#define MC_XPB_INTF_CFG__XSP_REQ_CRD__SHIFT 0x10
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_SEL_MASK 0x800000
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_SEL__SHIFT 0x17
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_VAL_MASK 0x1000000
#define MC_XPB_INTF_CFG__BIF_REG_SNOOP_VAL__SHIFT 0x18
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_SEL_MASK 0x2000000
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_SEL__SHIFT 0x19
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_VAL_MASK 0x4000000
#define MC_XPB_INTF_CFG__BIF_MEM_SNOOP_VAL__SHIFT 0x1a
#define MC_XPB_INTF_CFG__XSP_SNOOP_SEL_MASK 0x18000000
#define MC_XPB_INTF_CFG__XSP_SNOOP_SEL__SHIFT 0x1b
#define MC_XPB_INTF_CFG__XSP_SNOOP_VAL_MASK 0x20000000
#define MC_XPB_INTF_CFG__XSP_SNOOP_VAL__SHIFT 0x1d
#define MC_XPB_INTF_CFG__XSP_ORDERING_SEL_MASK 0x40000000
#define MC_XPB_INTF_CFG__XSP_ORDERING_SEL__SHIFT 0x1e
#define MC_XPB_INTF_CFG__XSP_ORDERING_VAL_MASK 0x80000000
#define MC_XPB_INTF_CFG__XSP_ORDERING_VAL__SHIFT 0x1f
#define MC_XPB_INTF_STS__RPB_WRREQ_CRD_MASK 0xff
#define MC_XPB_INTF_STS__RPB_WRREQ_CRD__SHIFT 0x0
#define MC_XPB_INTF_STS__XSP_REQ_CRD_MASK 0x7f00
#define MC_XPB_INTF_STS__XSP_REQ_CRD__SHIFT 0x8
#define MC_XPB_INTF_STS__HOP_DATA_BUF_FULL_MASK 0x8000
#define MC_XPB_INTF_STS__HOP_DATA_BUF_FULL__SHIFT 0xf
#define MC_XPB_INTF_STS__HOP_ATTR_BUF_FULL_MASK 0x10000
#define MC_XPB_INTF_STS__HOP_ATTR_BUF_FULL__SHIFT 0x10
#define MC_XPB_INTF_STS__CNS_BUF_FULL_MASK 0x20000
#define MC_XPB_INTF_STS__CNS_BUF_FULL__SHIFT 0x11
#define MC_XPB_INTF_STS__CNS_BUF_BUSY_MASK 0x40000
#define MC_XPB_INTF_STS__CNS_BUF_BUSY__SHIFT 0x12
#define MC_XPB_INTF_STS__RPB_RDREQ_CRD_MASK 0x7f80000
#define MC_XPB_INTF_STS__RPB_RDREQ_CRD__SHIFT 0x13
#define MC_XPB_PIPE_STS__WCB_ANY_PBUF_MASK 0x1
#define MC_XPB_PIPE_STS__WCB_ANY_PBUF__SHIFT 0x0
#define MC_XPB_PIPE_STS__WCB_HST_DATA_BUF_CNT_MASK 0xfe
#define MC_XPB_PIPE_STS__WCB_HST_DATA_BUF_CNT__SHIFT 0x1
#define MC_XPB_PIPE_STS__WCB_SID_DATA_BUF_CNT_MASK 0x7f00
#define MC_XPB_PIPE_STS__WCB_SID_DATA_BUF_CNT__SHIFT 0x8
#define MC_XPB_PIPE_STS__WCB_HST_RD_PTR_BUF_FULL_MASK 0x8000
#define MC_XPB_PIPE_STS__WCB_HST_RD_PTR_BUF_FULL__SHIFT 0xf
#define MC_XPB_PIPE_STS__WCB_SID_RD_PTR_BUF_FULL_MASK 0x10000
#define MC_XPB_PIPE_STS__WCB_SID_RD_PTR_BUF_FULL__SHIFT 0x10
#define MC_XPB_PIPE_STS__WCB_HST_REQ_FIFO_FULL_MASK 0x20000
#define MC_XPB_PIPE_STS__WCB_HST_REQ_FIFO_FULL__SHIFT 0x11
#define MC_XPB_PIPE_STS__WCB_SID_REQ_FIFO_FULL_MASK 0x40000
#define MC_XPB_PIPE_STS__WCB_SID_REQ_FIFO_FULL__SHIFT 0x12
#define MC_XPB_PIPE_STS__WCB_HST_REQ_OBUF_FULL_MASK 0x80000
#define MC_XPB_PIPE_STS__WCB_HST_REQ_OBUF_FULL__SHIFT 0x13
#define MC_XPB_PIPE_STS__WCB_SID_REQ_OBUF_FULL_MASK 0x100000
#define MC_XPB_PIPE_STS__WCB_SID_REQ_OBUF_FULL__SHIFT 0x14
#define MC_XPB_PIPE_STS__WCB_HST_DATA_OBUF_FULL_MASK 0x200000
#define MC_XPB_PIPE_STS__WCB_HST_DATA_OBUF_FULL__SHIFT 0x15
#define MC_XPB_PIPE_STS__WCB_SID_DATA_OBUF_FULL_MASK 0x400000
#define MC_XPB_PIPE_STS__WCB_SID_DATA_OBUF_FULL__SHIFT 0x16
#define MC_XPB_PIPE_STS__RET_BUF_FULL_MASK 0x800000
#define MC_XPB_PIPE_STS__RET_BUF_FULL__SHIFT 0x17
#define MC_XPB_PIPE_STS__XPB_CLK_BUSY_BITS_MASK 0xff000000
#define MC_XPB_PIPE_STS__XPB_CLK_BUSY_BITS__SHIFT 0x18
#define MC_XPB_SUB_CTRL__WRREQ_BYPASS_XPB_MASK 0x1
#define MC_XPB_SUB_CTRL__WRREQ_BYPASS_XPB__SHIFT 0x0
#define MC_XPB_SUB_CTRL__STALL_CNS_RTR_REQ_MASK 0x2
#define MC_XPB_SUB_CTRL__STALL_CNS_RTR_REQ__SHIFT 0x1
#define MC_XPB_SUB_CTRL__STALL_RTR_RPB_WRREQ_MASK 0x4
#define MC_XPB_SUB_CTRL__STALL_RTR_RPB_WRREQ__SHIFT 0x2
#define MC_XPB_SUB_CTRL__STALL_RTR_MAP_REQ_MASK 0x8
#define MC_XPB_SUB_CTRL__STALL_RTR_MAP_REQ__SHIFT 0x3
#define MC_XPB_SUB_CTRL__STALL_MAP_WCB_REQ_MASK 0x10
#define MC_XPB_SUB_CTRL__STALL_MAP_WCB_REQ__SHIFT 0x4
#define MC_XPB_SUB_CTRL__STALL_WCB_SID_REQ_MASK 0x20
#define MC_XPB_SUB_CTRL__STALL_WCB_SID_REQ__SHIFT 0x5
#define MC_XPB_SUB_CTRL__STALL_MC_XSP_REQ_SEND_MASK 0x40
#define MC_XPB_SUB_CTRL__STALL_MC_XSP_REQ_SEND__SHIFT 0x6
#define MC_XPB_SUB_CTRL__STALL_WCB_HST_REQ_MASK 0x80
#define MC_XPB_SUB_CTRL__STALL_WCB_HST_REQ__SHIFT 0x7
#define MC_XPB_SUB_CTRL__STALL_HST_HOP_REQ_MASK 0x100
#define MC_XPB_SUB_CTRL__STALL_HST_HOP_REQ__SHIFT 0x8
#define MC_XPB_SUB_CTRL__STALL_XPB_RPB_REQ_ATTR_MASK 0x200
#define MC_XPB_SUB_CTRL__STALL_XPB_RPB_REQ_ATTR__SHIFT 0x9
#define MC_XPB_SUB_CTRL__RESET_CNS_MASK 0x400
#define MC_XPB_SUB_CTRL__RESET_CNS__SHIFT 0xa
#define MC_XPB_SUB_CTRL__RESET_RTR_MASK 0x800
#define MC_XPB_SUB_CTRL__RESET_RTR__SHIFT 0xb
#define MC_XPB_SUB_CTRL__RESET_RET_MASK 0x1000
#define MC_XPB_SUB_CTRL__RESET_RET__SHIFT 0xc
#define MC_XPB_SUB_CTRL__RESET_MAP_MASK 0x2000
#define MC_XPB_SUB_CTRL__RESET_MAP__SHIFT 0xd
#define MC_XPB_SUB_CTRL__RESET_WCB_MASK 0x4000
#define MC_XPB_SUB_CTRL__RESET_WCB__SHIFT 0xe
#define MC_XPB_SUB_CTRL__RESET_HST_MASK 0x8000
#define MC_XPB_SUB_CTRL__RESET_HST__SHIFT 0xf
#define MC_XPB_SUB_CTRL__RESET_HOP_MASK 0x10000
#define MC_XPB_SUB_CTRL__RESET_HOP__SHIFT 0x10
#define MC_XPB_SUB_CTRL__RESET_SID_MASK 0x20000
#define MC_XPB_SUB_CTRL__RESET_SID__SHIFT 0x11
#define MC_XPB_SUB_CTRL__RESET_SRB_MASK 0x40000
#define MC_XPB_SUB_CTRL__RESET_SRB__SHIFT 0x12
#define MC_XPB_SUB_CTRL__RESET_CGR_MASK 0x80000
#define MC_XPB_SUB_CTRL__RESET_CGR__SHIFT 0x13
#define MC_XPB_MAP_INVERT_FLUSH_NUM_LSB__ALTER_FLUSH_NUM_MASK 0xffff
#define MC_XPB_MAP_INVERT_FLUSH_NUM_LSB__ALTER_FLUSH_NUM__SHIFT 0x0
#define MC_XPB_PERF_KNOBS__CNS_FIFO_DEPTH_MASK 0x3f
#define MC_XPB_PERF_KNOBS__CNS_FIFO_DEPTH__SHIFT 0x0
#define MC_XPB_PERF_KNOBS__WCB_HST_FIFO_DEPTH_MASK 0xfc0
#define MC_XPB_PERF_KNOBS__WCB_HST_FIFO_DEPTH__SHIFT 0x6
#define MC_XPB_PERF_KNOBS__WCB_SID_FIFO_DEPTH_MASK 0x3f000
#define MC_XPB_PERF_KNOBS__WCB_SID_FIFO_DEPTH__SHIFT 0xc
#define MC_XPB_STICKY__BITS_MASK 0xffffffff
#define MC_XPB_STICKY__BITS__SHIFT 0x0
#define MC_XPB_STICKY_W1C__BITS_MASK 0xffffffff
#define MC_XPB_STICKY_W1C__BITS__SHIFT 0x0
#define MC_XPB_MISC_CFG__FIELDNAME0_MASK 0xff
#define MC_XPB_MISC_CFG__FIELDNAME0__SHIFT 0x0
#define MC_XPB_MISC_CFG__FIELDNAME1_MASK 0xff00
#define MC_XPB_MISC_CFG__FIELDNAME1__SHIFT 0x8
#define MC_XPB_MISC_CFG__FIELDNAME2_MASK 0xff0000
#define MC_XPB_MISC_CFG__FIELDNAME2__SHIFT 0x10
#define MC_XPB_MISC_CFG__FIELDNAME3_MASK 0x7f000000
#define MC_XPB_MISC_CFG__FIELDNAME3__SHIFT 0x18
#define MC_XPB_MISC_CFG__TRIGGERNAME_MASK 0x80000000
#define MC_XPB_MISC_CFG__TRIGGERNAME__SHIFT 0x1f
#define MC_XPB_CLG_CFG20__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG20__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG20__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG20__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG20__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG20__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG20__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG20__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG20__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG20__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG21__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG21__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG21__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG21__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG21__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG21__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG21__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG21__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG21__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG21__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG22__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG22__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG22__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG22__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG22__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG22__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG22__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG22__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG22__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG22__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG23__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG23__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG23__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG23__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG23__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG23__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG23__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG23__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG23__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG23__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG24__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG24__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG24__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG24__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG24__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG24__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG24__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG24__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG24__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG24__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG25__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG25__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG25__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG25__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG25__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG25__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG25__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG25__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG25__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG25__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG26__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG26__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG26__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG26__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG26__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG26__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG26__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG26__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG26__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG26__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG27__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG27__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG27__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG27__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG27__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG27__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG27__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG27__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG27__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG27__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG28__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG28__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG28__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG28__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG28__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG28__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG28__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG28__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG28__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG28__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG29__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG29__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG29__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG29__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG29__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG29__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG29__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG29__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG29__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG29__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG30__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG30__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG30__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG30__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG30__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG30__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG30__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG30__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG30__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG30__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG31__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG31__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG31__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG31__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG31__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG31__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG31__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG31__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG31__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG31__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_INTF_CFG2__RPB_RDREQ_CRD_MASK 0xff
#define MC_XPB_INTF_CFG2__RPB_RDREQ_CRD__SHIFT 0x0
#define MC_XPB_CLG_EXTRA_RD__CMP0_MASK 0xff
#define MC_XPB_CLG_EXTRA_RD__CMP0__SHIFT 0x0
#define MC_XPB_CLG_EXTRA_RD__MSK0_MASK 0xff00
#define MC_XPB_CLG_EXTRA_RD__MSK0__SHIFT 0x8
#define MC_XPB_CLG_EXTRA_RD__VLD0_MASK 0x10000
#define MC_XPB_CLG_EXTRA_RD__VLD0__SHIFT 0x10
#define MC_XPB_CLG_EXTRA_RD__CMP1_MASK 0x1fe0000
#define MC_XPB_CLG_EXTRA_RD__CMP1__SHIFT 0x11
#define MC_XPB_CLG_EXTRA_RD__VLD1_MASK 0x2000000
#define MC_XPB_CLG_EXTRA_RD__VLD1__SHIFT 0x19
#define MC_XPB_CLG_CFG32__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG32__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG32__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG32__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG32__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG32__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG32__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG32__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG32__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG32__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG33__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG33__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG33__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG33__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG33__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG33__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG33__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG33__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG33__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG33__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG34__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG34__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG34__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG34__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG34__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG34__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG34__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG34__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG34__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG34__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG35__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG35__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG35__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG35__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG35__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG35__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG35__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG35__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG35__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG35__SIDE_FLUSH__SHIFT 0xe
#define MC_XPB_CLG_CFG36__WCB_NUM_MASK 0xf
#define MC_XPB_CLG_CFG36__WCB_NUM__SHIFT 0x0
#define MC_XPB_CLG_CFG36__LB_TYPE_MASK 0x70
#define MC_XPB_CLG_CFG36__LB_TYPE__SHIFT 0x4
#define MC_XPB_CLG_CFG36__P2P_BAR_MASK 0x380
#define MC_XPB_CLG_CFG36__P2P_BAR__SHIFT 0x7
#define MC_XPB_CLG_CFG36__HOST_FLUSH_MASK 0x3c00
#define MC_XPB_CLG_CFG36__HOST_FLUSH__SHIFT 0xa
#define MC_XPB_CLG_CFG36__SIDE_FLUSH_MASK 0x3c000
#define MC_XPB_CLG_CFG36__SIDE_FLUSH__SHIFT 0xe
#define MC_XBAR_ADDR_DEC__NO_DIV_BY_3_MASK 0x1
#define MC_XBAR_ADDR_DEC__NO_DIV_BY_3__SHIFT 0x0
#define MC_XBAR_ADDR_DEC__GECC_MASK 0x2
#define MC_XBAR_ADDR_DEC__GECC__SHIFT 0x1
#define MC_XBAR_ADDR_DEC__RB_SPLIT_MASK 0x4
#define MC_XBAR_ADDR_DEC__RB_SPLIT__SHIFT 0x2
#define MC_XBAR_ADDR_DEC__RB_SPLIT_COLHI_MASK 0x8
#define MC_XBAR_ADDR_DEC__RB_SPLIT_COLHI__SHIFT 0x3
#define MC_XBAR_REMOTE__WRREQ_EN_GOQ_MASK 0x1
#define MC_XBAR_REMOTE__WRREQ_EN_GOQ__SHIFT 0x0
#define MC_XBAR_REMOTE__RDREQ_EN_GOQ_MASK 0x2
#define MC_XBAR_REMOTE__RDREQ_EN_GOQ__SHIFT 0x1
#define MC_XBAR_WRREQ_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_WRREQ_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_WRREQ_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_WRREQ_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_WRREQ_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_WRREQ_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_WRREQ_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_WRREQ_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_RDREQ_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_RDREQ_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_RDREQ_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_RDREQ_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_RDREQ_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_RDREQ_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_RDREQ_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_RDREQ_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT0_MASK 0xff
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT0__SHIFT 0x0
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT1_MASK 0xff00
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT1__SHIFT 0x8
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT2_MASK 0xff0000
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT2__SHIFT 0x10
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT3_MASK 0xff000000
#define MC_XBAR_RDREQ_PRI_CREDIT__OUT3__SHIFT 0x18
#define MC_XBAR_WRRET_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_WRRET_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_WRRET_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_WRRET_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_WRRET_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_WRRET_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_WRRET_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_WRRET_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_WRRET_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_WRRET_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_WRRET_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_WRRET_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_RDRET_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_RDRET_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_RDRET_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_RDRET_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_RDRET_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_RDRET_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_RDRET_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_RDRET_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_RDRET_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_RDRET_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_RDRET_CREDIT2__HUB_LP_RDRET_SKID_MASK 0xff0000
#define MC_XBAR_RDRET_CREDIT2__HUB_LP_RDRET_SKID__SHIFT 0x10
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT0_MASK 0xff
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT0__SHIFT 0x0
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT1_MASK 0xff00
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT1__SHIFT 0x8
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT2_MASK 0xff0000
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT2__SHIFT 0x10
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT3_MASK 0xff000000
#define MC_XBAR_RDRET_PRI_CREDIT1__OUT3__SHIFT 0x18
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT4_MASK 0xff
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT4__SHIFT 0x0
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT5_MASK 0xff00
#define MC_XBAR_RDRET_PRI_CREDIT2__OUT5__SHIFT 0x8
#define MC_XBAR_CHTRIREMAP__CH0_MASK 0x3
#define MC_XBAR_CHTRIREMAP__CH0__SHIFT 0x0
#define MC_XBAR_CHTRIREMAP__CH1_MASK 0xc
#define MC_XBAR_CHTRIREMAP__CH1__SHIFT 0x2
#define MC_XBAR_CHTRIREMAP__CH2_MASK 0x30
#define MC_XBAR_CHTRIREMAP__CH2__SHIFT 0x4
#define MC_XBAR_TWOCHAN__DISABLE_ONEPORT_MASK 0x1
#define MC_XBAR_TWOCHAN__DISABLE_ONEPORT__SHIFT 0x0
#define MC_XBAR_TWOCHAN__CH0_MASK 0x6
#define MC_XBAR_TWOCHAN__CH0__SHIFT 0x1
#define MC_XBAR_TWOCHAN__CH1_MASK 0x18
#define MC_XBAR_TWOCHAN__CH1__SHIFT 0x3
#define MC_XBAR_ARB__HUBRD_HIGHEST_MASK 0x1
#define MC_XBAR_ARB__HUBRD_HIGHEST__SHIFT 0x0
#define MC_XBAR_ARB__DISABLE_HUB_STALL_HIGHEST_MASK 0x2
#define MC_XBAR_ARB__DISABLE_HUB_STALL_HIGHEST__SHIFT 0x1
#define MC_XBAR_ARB__BREAK_BURST_CID_CHANGE_MASK 0x4
#define MC_XBAR_ARB__BREAK_BURST_CID_CHANGE__SHIFT 0x2
#define MC_XBAR_ARB_MAX_BURST__RD_PORT0_MASK 0xf
#define MC_XBAR_ARB_MAX_BURST__RD_PORT0__SHIFT 0x0
#define MC_XBAR_ARB_MAX_BURST__RD_PORT1_MASK 0xf0
#define MC_XBAR_ARB_MAX_BURST__RD_PORT1__SHIFT 0x4
#define MC_XBAR_ARB_MAX_BURST__RD_PORT2_MASK 0xf00
#define MC_XBAR_ARB_MAX_BURST__RD_PORT2__SHIFT 0x8
#define MC_XBAR_ARB_MAX_BURST__RD_PORT3_MASK 0xf000
#define MC_XBAR_ARB_MAX_BURST__RD_PORT3__SHIFT 0xc
#define MC_XBAR_ARB_MAX_BURST__WR_PORT0_MASK 0xf0000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT0__SHIFT 0x10
#define MC_XBAR_ARB_MAX_BURST__WR_PORT1_MASK 0xf00000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT1__SHIFT 0x14
#define MC_XBAR_ARB_MAX_BURST__WR_PORT2_MASK 0xf000000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT2__SHIFT 0x18
#define MC_XBAR_ARB_MAX_BURST__WR_PORT3_MASK 0xf0000000
#define MC_XBAR_ARB_MAX_BURST__WR_PORT3__SHIFT 0x1c
#define MC_XBAR_PERF_MON_CNTL0__START_THRESH_MASK 0xfff
#define MC_XBAR_PERF_MON_CNTL0__START_THRESH__SHIFT 0x0
#define MC_XBAR_PERF_MON_CNTL0__STOP_THRESH_MASK 0xfff000
#define MC_XBAR_PERF_MON_CNTL0__STOP_THRESH__SHIFT 0xc
#define MC_XBAR_PERF_MON_CNTL0__START_MODE_MASK 0x3000000
#define MC_XBAR_PERF_MON_CNTL0__START_MODE__SHIFT 0x18
#define MC_XBAR_PERF_MON_CNTL0__STOP_MODE_MASK 0xc000000
#define MC_XBAR_PERF_MON_CNTL0__STOP_MODE__SHIFT 0x1a
#define MC_XBAR_PERF_MON_CNTL0__ALLOW_WRAP_MASK 0x10000000
#define MC_XBAR_PERF_MON_CNTL0__ALLOW_WRAP__SHIFT 0x1c
#define MC_XBAR_PERF_MON_CNTL1__THRESH_CNTR_ID_MASK 0xff
#define MC_XBAR_PERF_MON_CNTL1__THRESH_CNTR_ID__SHIFT 0x0
#define MC_XBAR_PERF_MON_CNTL1__START_TRIG_ID_MASK 0xff00
#define MC_XBAR_PERF_MON_CNTL1__START_TRIG_ID__SHIFT 0x8
#define MC_XBAR_PERF_MON_CNTL1__STOP_TRIG_ID_MASK 0xff0000
#define MC_XBAR_PERF_MON_CNTL1__STOP_TRIG_ID__SHIFT 0x10
#define MC_XBAR_PERF_MON_CNTL2__MON0_ID_MASK 0xff
#define MC_XBAR_PERF_MON_CNTL2__MON0_ID__SHIFT 0x0
#define MC_XBAR_PERF_MON_CNTL2__MON1_ID_MASK 0xff00
#define MC_XBAR_PERF_MON_CNTL2__MON1_ID__SHIFT 0x8
#define MC_XBAR_PERF_MON_CNTL2__MON2_ID_MASK 0xff0000
#define MC_XBAR_PERF_MON_CNTL2__MON2_ID__SHIFT 0x10
#define MC_XBAR_PERF_MON_CNTL2__MON3_ID_MASK 0xff000000
#define MC_XBAR_PERF_MON_CNTL2__MON3_ID__SHIFT 0x18
#define MC_XBAR_PERF_MON_RSLT0__COUNT_MASK 0xffffffff
#define MC_XBAR_PERF_MON_RSLT0__COUNT__SHIFT 0x0
#define MC_XBAR_PERF_MON_RSLT1__COUNT_MASK 0xffffffff
#define MC_XBAR_PERF_MON_RSLT1__COUNT__SHIFT 0x0
#define MC_XBAR_PERF_MON_RSLT2__COUNT_MASK 0xffffffff
#define MC_XBAR_PERF_MON_RSLT2__COUNT__SHIFT 0x0
#define MC_XBAR_PERF_MON_RSLT3__COUNT_MASK 0xffffffff
#define MC_XBAR_PERF_MON_RSLT3__COUNT__SHIFT 0x0
#define MC_XBAR_PERF_MON_MAX_THSH__MON0_MASK 0xff
#define MC_XBAR_PERF_MON_MAX_THSH__MON0__SHIFT 0x0
#define MC_XBAR_PERF_MON_MAX_THSH__MON1_MASK 0xff00
#define MC_XBAR_PERF_MON_MAX_THSH__MON1__SHIFT 0x8
#define MC_XBAR_PERF_MON_MAX_THSH__MON2_MASK 0xff0000
#define MC_XBAR_PERF_MON_MAX_THSH__MON2__SHIFT 0x10
#define MC_XBAR_PERF_MON_MAX_THSH__MON3_MASK 0xff000000
#define MC_XBAR_PERF_MON_MAX_THSH__MON3__SHIFT 0x18
#define MC_XBAR_SPARE0__BIT_MASK 0xffffffff
#define MC_XBAR_SPARE0__BIT__SHIFT 0x0
#define MC_XBAR_SPARE1__BIT_MASK 0xffffffff
#define MC_XBAR_SPARE1__BIT__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_CITF_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_HUB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_RPB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_MCBVM_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_MCDVM_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_VM_L2_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define MC_ARB_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define ATC_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define ATC_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_CITF_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_CITF_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_HUB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_HUB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_HUB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_MCBVM_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_MCBVM_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_MCBVM_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_MCDVM_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_MCDVM_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_MCDVM_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_RPB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_RPB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_RPB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_VM_L2_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_VM_L2_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_VM_L2_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_ARB_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define MC_ARB_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define MC_ARB_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define ATC_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define ATC_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define ATC_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define ATC_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_CITF_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_CITF_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_CITF_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_CITF_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_CITF_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_CITF_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_CITF_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_HUB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_HUB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_HUB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_HUB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_HUB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_HUB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_HUB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_RPB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_RPB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_RPB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_RPB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_RPB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_RPB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_RPB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_ARB_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_ARB_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_ARB_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_ARB_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_ARB_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_ARB_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_ARB_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCBVM_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_MCBVM_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_MCBVM_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_MCBVM_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define MC_MCDVM_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define MC_MCDVM_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define MC_MCDVM_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define MC_MCDVM_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER2_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER2_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER2_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER2_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER2_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER2_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER2_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER2_CFG__CLEAR__SHIFT 0x1d
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_MASK 0xff
#define ATC_PERFCOUNTER3_CFG__PERF_SEL__SHIFT 0x0
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_END_MASK 0xff00
#define ATC_PERFCOUNTER3_CFG__PERF_SEL_END__SHIFT 0x8
#define ATC_PERFCOUNTER3_CFG__PERF_MODE_MASK 0xf000000
#define ATC_PERFCOUNTER3_CFG__PERF_MODE__SHIFT 0x18
#define ATC_PERFCOUNTER3_CFG__ENABLE_MASK 0x10000000
#define ATC_PERFCOUNTER3_CFG__ENABLE__SHIFT 0x1c
#define ATC_PERFCOUNTER3_CFG__CLEAR_MASK 0x20000000
#define ATC_PERFCOUNTER3_CFG__CLEAR__SHIFT 0x1d
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define MC_VM_L2_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define MC_VM_L2_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define MC_VM_L2_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define MC_VM_L2_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define MC_VM_L2_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define MC_VM_L2_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define MC_VM_L2_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define MC_VM_L2_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_CITF_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_HUB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_RPB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_MCBVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_MCDVM_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_VM_L2_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define MC_ARB_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define CHUB_ATC_PERFCOUNTER_LO__COUNTER_LO_MASK 0xffffffff
#define CHUB_ATC_PERFCOUNTER_LO__COUNTER_LO__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_HI__COUNTER_HI_MASK 0xffff
#define CHUB_ATC_PERFCOUNTER_HI__COUNTER_HI__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_HI__COMPARE_VALUE_MASK 0xffff0000
#define CHUB_ATC_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT 0x10
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_MASK 0xff
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_END_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_MODE_MASK 0xf000000
#define CHUB_ATC_PERFCOUNTER0_CFG__PERF_MODE__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER0_CFG__ENABLE_MASK 0x10000000
#define CHUB_ATC_PERFCOUNTER0_CFG__ENABLE__SHIFT 0x1c
#define CHUB_ATC_PERFCOUNTER0_CFG__CLEAR_MASK 0x20000000
#define CHUB_ATC_PERFCOUNTER0_CFG__CLEAR__SHIFT 0x1d
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_MASK 0xff
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_END_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_MODE_MASK 0xf000000
#define CHUB_ATC_PERFCOUNTER1_CFG__PERF_MODE__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER1_CFG__ENABLE_MASK 0x10000000
#define CHUB_ATC_PERFCOUNTER1_CFG__ENABLE__SHIFT 0x1c
#define CHUB_ATC_PERFCOUNTER1_CFG__CLEAR_MASK 0x20000000
#define CHUB_ATC_PERFCOUNTER1_CFG__CLEAR__SHIFT 0x1d
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK 0xf
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT 0x0
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK 0xff00
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT 0x8
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK 0xff0000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT 0x10
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK 0x1000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT 0x18
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK 0x2000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT 0x19
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK 0x4000000
#define CHUB_ATC_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT 0x1a
#define MC_ARB_PERF_MON_CNTL0_ECC__ALLOW_WRAP_MASK 0x1
#define MC_ARB_PERF_MON_CNTL0_ECC__ALLOW_WRAP__SHIFT 0x0
#define ATC_VM_APERTURE0_LOW_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE0_LOW_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE1_LOW_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE1_LOW_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE0_HIGH_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE0_HIGH_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE1_HIGH_ADDR__VIRTUAL_PAGE_NUMBER_MASK 0xfffffff
#define ATC_VM_APERTURE1_HIGH_ADDR__VIRTUAL_PAGE_NUMBER__SHIFT 0x0
#define ATC_VM_APERTURE0_CNTL__ATS_ACCESS_MODE_MASK 0x3
#define ATC_VM_APERTURE0_CNTL__ATS_ACCESS_MODE__SHIFT 0x0
#define ATC_VM_APERTURE1_CNTL__ATS_ACCESS_MODE_MASK 0x3
#define ATC_VM_APERTURE1_CNTL__ATS_ACCESS_MODE__SHIFT 0x0
#define ATC_VM_APERTURE0_CNTL2__VMIDS_USING_RANGE_MASK 0xffff
#define ATC_VM_APERTURE0_CNTL2__VMIDS_USING_RANGE__SHIFT 0x0
#define ATC_VM_APERTURE1_CNTL2__VMIDS_USING_RANGE_MASK 0xffff
#define ATC_VM_APERTURE1_CNTL2__VMIDS_USING_RANGE__SHIFT 0x0
#define ATC_ATS_CNTL__DISABLE_ATC_MASK 0x1
#define ATC_ATS_CNTL__DISABLE_ATC__SHIFT 0x0
#define ATC_ATS_CNTL__DISABLE_PRI_MASK 0x2
#define ATC_ATS_CNTL__DISABLE_PRI__SHIFT 0x1
#define ATC_ATS_CNTL__DISABLE_PASID_MASK 0x4
#define ATC_ATS_CNTL__DISABLE_PASID__SHIFT 0x2
#define ATC_ATS_CNTL__CREDITS_ATS_RPB_MASK 0x3f00
#define ATC_ATS_CNTL__CREDITS_ATS_RPB__SHIFT 0x8
#define ATC_ATS_CNTL__DEBUG_ECO_MASK 0xf0000
#define ATC_ATS_CNTL__DEBUG_ECO__SHIFT 0x10
#define ATC_ATS_DEBUG__INVALIDATE_ALL_MASK 0x1
#define ATC_ATS_DEBUG__INVALIDATE_ALL__SHIFT 0x0
#define ATC_ATS_DEBUG__IDENT_RETURN_MASK 0x2
#define ATC_ATS_DEBUG__IDENT_RETURN__SHIFT 0x1
#define ATC_ATS_DEBUG__ADDRESS_TRANSLATION_REQUEST_WRITE_PERMS_MASK 0x4
#define ATC_ATS_DEBUG__ADDRESS_TRANSLATION_REQUEST_WRITE_PERMS__SHIFT 0x2
#define ATC_ATS_DEBUG__PAGE_REQUESTS_USE_RELAXED_ORDERING_MASK 0x20
#define ATC_ATS_DEBUG__PAGE_REQUESTS_USE_RELAXED_ORDERING__SHIFT 0x5
#define ATC_ATS_DEBUG__PRIV_BIT_MASK 0x40
#define ATC_ATS_DEBUG__PRIV_BIT__SHIFT 0x6
#define ATC_ATS_DEBUG__EXE_BIT_MASK 0x80
#define ATC_ATS_DEBUG__EXE_BIT__SHIFT 0x7
#define ATC_ATS_DEBUG__PAGE_REQUEST_PERMS_MASK 0x100
#define ATC_ATS_DEBUG__PAGE_REQUEST_PERMS__SHIFT 0x8
#define ATC_ATS_DEBUG__UNTRANSLATED_ONLY_REQUESTS_CARRY_SIZE_MASK 0x200
#define ATC_ATS_DEBUG__UNTRANSLATED_ONLY_REQUESTS_CARRY_SIZE__SHIFT 0x9
#define ATC_ATS_DEBUG__NUM_REQUESTS_AT_ERR_MASK 0x3c00
#define ATC_ATS_DEBUG__NUM_REQUESTS_AT_ERR__SHIFT 0xa
#define ATC_ATS_DEBUG__DISALLOW_ERR_TO_DONE_MASK 0x4000
#define ATC_ATS_DEBUG__DISALLOW_ERR_TO_DONE__SHIFT 0xe
#define ATC_ATS_DEBUG__IGNORE_FED_MASK 0x8000
#define ATC_ATS_DEBUG__IGNORE_FED__SHIFT 0xf
#define ATC_ATS_DEBUG__INVALIDATION_REQUESTS_DISALLOWED_WHEN_ATC_IS_DISABLED_MASK 0x10000
#define ATC_ATS_DEBUG__INVALIDATION_REQUESTS_DISALLOWED_WHEN_ATC_IS_DISABLED__SHIFT 0x10
#define ATC_ATS_DEBUG__DEBUG_BUS_SELECT_MASK 0x20000
#define ATC_ATS_DEBUG__DEBUG_BUS_SELECT__SHIFT 0x11
#define ATC_ATS_FAULT_DEBUG__CREDITS_ATS_IH_MASK 0x1f
#define ATC_ATS_FAULT_DEBUG__CREDITS_ATS_IH__SHIFT 0x0
#define ATC_ATS_FAULT_DEBUG__ALLOW_SUBSEQUENT_FAULT_STATUS_ADDR_UPDATES_MASK 0x100
#define ATC_ATS_FAULT_DEBUG__ALLOW_SUBSEQUENT_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x8
#define ATC_ATS_FAULT_DEBUG__CLEAR_FAULT_STATUS_ADDR_MASK 0x10000
#define ATC_ATS_FAULT_DEBUG__CLEAR_FAULT_STATUS_ADDR__SHIFT 0x10
#define ATC_ATS_STATUS__BUSY_MASK 0x1
#define ATC_ATS_STATUS__BUSY__SHIFT 0x0
#define ATC_ATS_STATUS__CRASHED_MASK 0x2
#define ATC_ATS_STATUS__CRASHED__SHIFT 0x1
#define ATC_ATS_STATUS__DEADLOCK_DETECTION_MASK 0x4
#define ATC_ATS_STATUS__DEADLOCK_DETECTION__SHIFT 0x2
#define ATC_ATS_FAULT_CNTL__FAULT_REGISTER_LOG_MASK 0x3f
#define ATC_ATS_FAULT_CNTL__FAULT_REGISTER_LOG__SHIFT 0x0
#define ATC_ATS_FAULT_CNTL__FAULT_INTERRUPT_TABLE_MASK 0xfc00
#define ATC_ATS_FAULT_CNTL__FAULT_INTERRUPT_TABLE__SHIFT 0xa
#define ATC_ATS_FAULT_CNTL__FAULT_CRASH_TABLE_MASK 0x3f00000
#define ATC_ATS_FAULT_CNTL__FAULT_CRASH_TABLE__SHIFT 0x14
#define ATC_ATS_FAULT_STATUS_INFO__FAULT_TYPE_MASK 0x3f
#define ATC_ATS_FAULT_STATUS_INFO__FAULT_TYPE__SHIFT 0x0
#define ATC_ATS_FAULT_STATUS_INFO__VMID_MASK 0x7c00
#define ATC_ATS_FAULT_STATUS_INFO__VMID__SHIFT 0xa
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO_MASK 0x8000
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO__SHIFT 0xf
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO2_MASK 0x10000
#define ATC_ATS_FAULT_STATUS_INFO__EXTRA_INFO2__SHIFT 0x10
#define ATC_ATS_FAULT_STATUS_INFO__INVALIDATION_MASK 0x20000
#define ATC_ATS_FAULT_STATUS_INFO__INVALIDATION__SHIFT 0x11
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_REQUEST_MASK 0x40000
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_REQUEST__SHIFT 0x12
#define ATC_ATS_FAULT_STATUS_INFO__STATUS_MASK 0xf80000
#define ATC_ATS_FAULT_STATUS_INFO__STATUS__SHIFT 0x13
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_ADDR_HIGH_MASK 0xf000000
#define ATC_ATS_FAULT_STATUS_INFO__PAGE_ADDR_HIGH__SHIFT 0x18
#define ATC_ATS_FAULT_STATUS_ADDR__PAGE_ADDR_MASK 0xffffffff
#define ATC_ATS_FAULT_STATUS_ADDR__PAGE_ADDR__SHIFT 0x0
#define ATC_ATS_DEFAULT_PAGE_LOW__DEFAULT_PAGE_MASK 0xffffffff
#define ATC_ATS_DEFAULT_PAGE_LOW__DEFAULT_PAGE__SHIFT 0x0
#define ATC_ATS_DEFAULT_PAGE_CNTL__SEND_DEFAULT_PAGE_MASK 0x1
#define ATC_ATS_DEFAULT_PAGE_CNTL__SEND_DEFAULT_PAGE__SHIFT 0x0
#define ATC_ATS_DEFAULT_PAGE_CNTL__DEFAULT_PAGE_HIGH_MASK 0x3c
#define ATC_ATS_DEFAULT_PAGE_CNTL__DEFAULT_PAGE_HIGH__SHIFT 0x2
#define ATC_MISC_CG__OFFDLY_MASK 0xfc0
#define ATC_MISC_CG__OFFDLY__SHIFT 0x6
#define ATC_MISC_CG__ENABLE_MASK 0x40000
#define ATC_MISC_CG__ENABLE__SHIFT 0x12
#define ATC_MISC_CG__MEM_LS_ENABLE_MASK 0x80000
#define ATC_MISC_CG__MEM_LS_ENABLE__SHIFT 0x13
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS_MASK 0x3
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READ_REQUESTS__SHIFT 0x0
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS_MASK 0x30
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITE_REQUESTS__SHIFT 0x4
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD_MASK 0x100
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_READS_DEPENDS_ON_ADDR_MOD__SHIFT 0x8
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD_MASK 0x200
#define ATC_L2_CNTL__NUMBER_OF_TRANSLATION_WRITES_DEPENDS_ON_ADDR_MOD__SHIFT 0x9
#define ATC_L2_CNTL2__BANK_SELECT_MASK 0x3f
#define ATC_L2_CNTL2__BANK_SELECT__SHIFT 0x0
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE_MASK 0xc0
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_MODE__SHIFT 0x6
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x100
#define ATC_L2_CNTL2__ENABLE_L2_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0x8
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS_MASK 0xe00
#define ATC_L2_CNTL2__L2_CACHE_SWAP_TAG_INDEX_LSBS__SHIFT 0x9
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE_MASK 0x7000
#define ATC_L2_CNTL2__L2_CACHE_VMID_MODE__SHIFT 0xc
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK 0x1f8000
#define ATC_L2_CNTL2__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT 0xf
#define ATC_L2_DEBUG__CREDITS_L2_ATS_MASK 0x3f
#define ATC_L2_DEBUG__CREDITS_L2_ATS__SHIFT 0x0
#define ATC_L2_DEBUG2__EFFECTIVE_CACHE_SIZE_MASK 0x1f
#define ATC_L2_DEBUG2__EFFECTIVE_CACHE_SIZE__SHIFT 0x0
#define ATC_L2_DEBUG2__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0xe0
#define ATC_L2_DEBUG2__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x5
#define ATC_L2_DEBUG2__FORCE_CACHE_MISS_MASK 0x100
#define ATC_L2_DEBUG2__FORCE_CACHE_MISS__SHIFT 0x8
#define ATC_L2_DEBUG2__INVALIDATE_ALL_MASK 0x200
#define ATC_L2_DEBUG2__INVALIDATE_ALL__SHIFT 0x9
#define ATC_L2_DEBUG2__DISABLE_INVALIDATE_PER_DOMAIN_MASK 0x400
#define ATC_L2_DEBUG2__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT 0xa
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_READ_RETURNS_MASK 0x800
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_READ_RETURNS__SHIFT 0xb
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_WRITE_RETURNS_MASK 0x1000
#define ATC_L2_DEBUG2__DISABLE_CACHING_SPECULATIVE_WRITE_RETURNS__SHIFT 0xc
#define ATC_L2_DEBUG2__DISABLE_CACHING_FAULT_RETURNS_MASK 0x4000
#define ATC_L2_DEBUG2__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0xe
#define ATC_L2_DEBUG2__DEBUG_BUS_SELECT_MASK 0x18000
#define ATC_L2_DEBUG2__DEBUG_BUS_SELECT__SHIFT 0xf
#define ATC_L2_DEBUG2__DEBUG_ECO_MASK 0x60000
#define ATC_L2_DEBUG2__DEBUG_ECO__SHIFT 0x11
#define ATC_L1_CNTL__DONT_NEED_ATS_BEHAVIOR_MASK 0x3
#define ATC_L1_CNTL__DONT_NEED_ATS_BEHAVIOR__SHIFT 0x0
#define ATC_L1_CNTL__NEED_ATS_BEHAVIOR_MASK 0x4
#define ATC_L1_CNTL__NEED_ATS_BEHAVIOR__SHIFT 0x2
#define ATC_L1_CNTL__NEED_ATS_SNOOP_DEFAULT_MASK 0x10
#define ATC_L1_CNTL__NEED_ATS_SNOOP_DEFAULT__SHIFT 0x4
#define ATC_L1_ADDRESS_OFFSET__LOGICAL_ADDRESS_MASK 0xffffffff
#define ATC_L1_ADDRESS_OFFSET__LOGICAL_ADDRESS__SHIFT 0x0
#define ATC_L1RD_DEBUG_TLB__DISABLE_FRAGMENTS_MASK 0x1
#define ATC_L1RD_DEBUG_TLB__DISABLE_FRAGMENTS__SHIFT 0x0
#define ATC_L1RD_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE_MASK 0x2
#define ATC_L1RD_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE__SHIFT 0x1
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_CAM_SIZE_MASK 0xf0
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_CAM_SIZE__SHIFT 0x4
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0x700
#define ATC_L1RD_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x8
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_L2_MASK 0x3f000
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_L2__SHIFT 0xc
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_RPB_MASK 0xff00000
#define ATC_L1RD_DEBUG_TLB__CREDITS_L1_RPB__SHIFT 0x14
#define ATC_L1RD_DEBUG_TLB__DEBUG_ECO_MASK 0x30000000
#define ATC_L1RD_DEBUG_TLB__DEBUG_ECO__SHIFT 0x1c
#define ATC_L1RD_DEBUG_TLB__INVALIDATE_ALL_MASK 0x40000000
#define ATC_L1RD_DEBUG_TLB__INVALIDATE_ALL__SHIFT 0x1e
#define ATC_L1RD_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS_MASK 0x80000000
#define ATC_L1RD_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0x1f
#define ATC_L1WR_DEBUG_TLB__DISABLE_FRAGMENTS_MASK 0x1
#define ATC_L1WR_DEBUG_TLB__DISABLE_FRAGMENTS__SHIFT 0x0
#define ATC_L1WR_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE_MASK 0x2
#define ATC_L1WR_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE__SHIFT 0x1
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_CAM_SIZE_MASK 0xf0
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_CAM_SIZE__SHIFT 0x4
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0x700
#define ATC_L1WR_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x8
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_L2_MASK 0x3f000
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_L2__SHIFT 0xc
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_RPB_MASK 0xff00000
#define ATC_L1WR_DEBUG_TLB__CREDITS_L1_RPB__SHIFT 0x14
#define ATC_L1WR_DEBUG_TLB__DEBUG_ECO_MASK 0x30000000
#define ATC_L1WR_DEBUG_TLB__DEBUG_ECO__SHIFT 0x1c
#define ATC_L1WR_DEBUG_TLB__INVALIDATE_ALL_MASK 0x40000000
#define ATC_L1WR_DEBUG_TLB__INVALIDATE_ALL__SHIFT 0x1e
#define ATC_L1WR_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS_MASK 0x80000000
#define ATC_L1WR_DEBUG_TLB__DISABLE_CACHING_FAULT_RETURNS__SHIFT 0x1f
#define ATC_L1RD_STATUS__BUSY_MASK 0x1
#define ATC_L1RD_STATUS__BUSY__SHIFT 0x0
#define ATC_L1RD_STATUS__DEADLOCK_DETECTION_MASK 0x2
#define ATC_L1RD_STATUS__DEADLOCK_DETECTION__SHIFT 0x1
#define ATC_L1RD_STATUS__BAD_NEED_ATS_MASK 0x100
#define ATC_L1RD_STATUS__BAD_NEED_ATS__SHIFT 0x8
#define ATC_L1WR_STATUS__BUSY_MASK 0x1
#define ATC_L1WR_STATUS__BUSY__SHIFT 0x0
#define ATC_L1WR_STATUS__DEADLOCK_DETECTION_MASK 0x2
#define ATC_L1WR_STATUS__DEADLOCK_DETECTION__SHIFT 0x1
#define ATC_L1WR_STATUS__BAD_NEED_ATS_MASK 0x100
#define ATC_L1WR_STATUS__BAD_NEED_ATS__SHIFT 0x8
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID0_REMAPPING_FINISHED_MASK 0x1
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID0_REMAPPING_FINISHED__SHIFT 0x0
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID1_REMAPPING_FINISHED_MASK 0x2
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID1_REMAPPING_FINISHED__SHIFT 0x1
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID2_REMAPPING_FINISHED_MASK 0x4
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID2_REMAPPING_FINISHED__SHIFT 0x2
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID3_REMAPPING_FINISHED_MASK 0x8
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID3_REMAPPING_FINISHED__SHIFT 0x3
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID4_REMAPPING_FINISHED_MASK 0x10
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID4_REMAPPING_FINISHED__SHIFT 0x4
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID5_REMAPPING_FINISHED_MASK 0x20
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID5_REMAPPING_FINISHED__SHIFT 0x5
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID6_REMAPPING_FINISHED_MASK 0x40
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID6_REMAPPING_FINISHED__SHIFT 0x6
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID7_REMAPPING_FINISHED_MASK 0x80
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID7_REMAPPING_FINISHED__SHIFT 0x7
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID8_REMAPPING_FINISHED_MASK 0x100
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID8_REMAPPING_FINISHED__SHIFT 0x8
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID9_REMAPPING_FINISHED_MASK 0x200
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID9_REMAPPING_FINISHED__SHIFT 0x9
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID10_REMAPPING_FINISHED_MASK 0x400
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID10_REMAPPING_FINISHED__SHIFT 0xa
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID11_REMAPPING_FINISHED_MASK 0x800
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID11_REMAPPING_FINISHED__SHIFT 0xb
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID12_REMAPPING_FINISHED_MASK 0x1000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID12_REMAPPING_FINISHED__SHIFT 0xc
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID13_REMAPPING_FINISHED_MASK 0x2000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID13_REMAPPING_FINISHED__SHIFT 0xd
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID14_REMAPPING_FINISHED_MASK 0x4000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID14_REMAPPING_FINISHED__SHIFT 0xe
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID15_REMAPPING_FINISHED_MASK 0x8000
#define ATC_VMID_PASID_MAPPING_UPDATE_STATUS__VMID15_REMAPPING_FINISHED__SHIFT 0xf
#define ATC_VMID0_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID0_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID0_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID0_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID1_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID1_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID1_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID1_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID2_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID2_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID2_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID2_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID3_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID3_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID3_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID3_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID4_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID4_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID4_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID4_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID5_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID5_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID5_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID5_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID6_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID6_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID6_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID6_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID7_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID7_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID7_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID7_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID8_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID8_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID8_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID8_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID9_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID9_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID9_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID9_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID10_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID10_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID10_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID10_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID11_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID11_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID11_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID11_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID12_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID12_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID12_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID12_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID13_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID13_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID13_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID13_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID14_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID14_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID14_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID14_PASID_MAPPING__VALID__SHIFT 0x1f
#define ATC_VMID15_PASID_MAPPING__PASID_MASK 0xffff
#define ATC_VMID15_PASID_MAPPING__PASID__SHIFT 0x0
#define ATC_VMID15_PASID_MAPPING__VALID_MASK 0x80000000
#define ATC_VMID15_PASID_MAPPING__VALID__SHIFT 0x1f
#define GMCON_RENG_RAM_INDEX__RENG_RAM_INDEX_MASK 0x3ff
#define GMCON_RENG_RAM_INDEX__RENG_RAM_INDEX__SHIFT 0x0
#define GMCON_RENG_RAM_DATA__RENG_RAM_DATA_MASK 0xffffffff
#define GMCON_RENG_RAM_DATA__RENG_RAM_DATA__SHIFT 0x0
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_ON_PWR_UP_MASK 0x1
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_ON_PWR_UP__SHIFT 0x0
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_MASK 0x2
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW__SHIFT 0x1
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_START_PTR_MASK 0xffc
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_NOW_START_PTR__SHIFT 0x2
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_DSP_END_PTR_MASK 0x3ff000
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_DSP_END_PTR__SHIFT 0xc
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_END_PTR_MASK 0xffc00000
#define GMCON_RENG_EXECUTE__RENG_EXECUTE_END_PTR__SHIFT 0x16
#define GMCON_MISC__RENG_EXECUTE_NOW_MODE_MASK 0x400
#define GMCON_MISC__RENG_EXECUTE_NOW_MODE__SHIFT 0xa
#define GMCON_MISC__RENG_EXECUTE_ON_REG_UPDATE_MASK 0x800
#define GMCON_MISC__RENG_EXECUTE_ON_REG_UPDATE__SHIFT 0xb
#define GMCON_MISC__RENG_SRBM_CREDITS_MCD_MASK 0xf000
#define GMCON_MISC__RENG_SRBM_CREDITS_MCD__SHIFT 0xc
#define GMCON_MISC__STCTRL_STUTTER_EN_MASK 0x10000
#define GMCON_MISC__STCTRL_STUTTER_EN__SHIFT 0x10
#define GMCON_MISC__STCTRL_GMC_IDLE_THRESHOLD_MASK 0x60000
#define GMCON_MISC__STCTRL_GMC_IDLE_THRESHOLD__SHIFT 0x11
#define GMCON_MISC__STCTRL_SRBM_IDLE_THRESHOLD_MASK 0x180000
#define GMCON_MISC__STCTRL_SRBM_IDLE_THRESHOLD__SHIFT 0x13
#define GMCON_MISC__STCTRL_IGNORE_PRE_SR_MASK 0x200000
#define GMCON_MISC__STCTRL_IGNORE_PRE_SR__SHIFT 0x15
#define GMCON_MISC__STCTRL_IGNORE_ALLOW_STOP_MASK 0x400000
#define GMCON_MISC__STCTRL_IGNORE_ALLOW_STOP__SHIFT 0x16
#define GMCON_MISC__STCTRL_IGNORE_SR_COMMIT_MASK 0x800000
#define GMCON_MISC__STCTRL_IGNORE_SR_COMMIT__SHIFT 0x17
#define GMCON_MISC__STCTRL_IGNORE_PROTECTION_FAULT_MASK 0x1000000
#define GMCON_MISC__STCTRL_IGNORE_PROTECTION_FAULT__SHIFT 0x18
#define GMCON_MISC__STCTRL_DISABLE_ALLOW_SR_MASK 0x2000000
#define GMCON_MISC__STCTRL_DISABLE_ALLOW_SR__SHIFT 0x19
#define GMCON_MISC__STCTRL_DISABLE_GMC_OFFLINE_MASK 0x4000000
#define GMCON_MISC__STCTRL_DISABLE_GMC_OFFLINE__SHIFT 0x1a
#define GMCON_MISC__CRITICAL_REGS_LOCK_MASK 0x8000000
#define GMCON_MISC__CRITICAL_REGS_LOCK__SHIFT 0x1b
#define GMCON_MISC__ALLOW_DEEP_SLEEP_MODE_MASK 0x70000000
#define GMCON_MISC__ALLOW_DEEP_SLEEP_MODE__SHIFT 0x1c
#define GMCON_MISC__STCTRL_FORCE_ALLOW_SR_MASK 0x80000000
#define GMCON_MISC__STCTRL_FORCE_ALLOW_SR__SHIFT 0x1f
#define GMCON_MISC2__RENG_MEM_POWER_CTRL_OVERRIDE0_MASK 0x7
#define GMCON_MISC2__RENG_MEM_POWER_CTRL_OVERRIDE0__SHIFT 0x0
#define GMCON_MISC2__RENG_MEM_POWER_CTRL_OVERRIDE1_MASK 0x38
#define GMCON_MISC2__RENG_MEM_POWER_CTRL_OVERRIDE1__SHIFT 0x3
#define GMCON_MISC2__STCTRL_NONDISP_IDLE_THRESHOLD_MASK 0x7c0
#define GMCON_MISC2__STCTRL_NONDISP_IDLE_THRESHOLD__SHIFT 0x6
#define GMCON_MISC2__RENG_SR_HOLD_THRESHOLD_MASK 0x1f800
#define GMCON_MISC2__RENG_SR_HOLD_THRESHOLD__SHIFT 0xb
#define GMCON_MISC2__STCTRL_LPT_TARGET_MASK 0x1ffe0000
#define GMCON_MISC2__STCTRL_LPT_TARGET__SHIFT 0x11
#define GMCON_MISC2__STCTRL_IGNORE_ARB_BUSY_MASK 0x20000000
#define GMCON_MISC2__STCTRL_IGNORE_ARB_BUSY__SHIFT 0x1d
#define GMCON_MISC2__STCTRL_EXTEND_GMC_OFFLINE_MASK 0x40000000
#define GMCON_MISC2__STCTRL_EXTEND_GMC_OFFLINE__SHIFT 0x1e
#define GMCON_MISC2__STCTRL_TIMER_PULSE_OVERRIDE_MASK 0x80000000
#define GMCON_MISC2__STCTRL_TIMER_PULSE_OVERRIDE__SHIFT 0x1f
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_BASE0_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_BASE0__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_LIMIT0_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE0__STCTRL_REGISTER_SAVE_LIMIT0__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_BASE1_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_BASE1__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_LIMIT1_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE1__STCTRL_REGISTER_SAVE_LIMIT1__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_BASE2_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_BASE2__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_LIMIT2_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_RANGE2__STCTRL_REGISTER_SAVE_LIMIT2__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL0_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL0__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL1_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET0__STCTRL_REGISTER_SAVE_EXCL1__SHIFT 0x10
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL2_MASK 0xffff
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL2__SHIFT 0x0
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL3_MASK 0xffff0000
#define GMCON_STCTRL_REGISTER_SAVE_EXCL_SET1__STCTRL_REGISTER_SAVE_EXCL3__SHIFT 0x10
#define GMCON_PERF_MON_CNTL0__START_THRESH_MASK 0xfff
#define GMCON_PERF_MON_CNTL0__START_THRESH__SHIFT 0x0
#define GMCON_PERF_MON_CNTL0__STOP_THRESH_MASK 0xfff000
#define GMCON_PERF_MON_CNTL0__STOP_THRESH__SHIFT 0xc
#define GMCON_PERF_MON_CNTL0__START_MODE_MASK 0x3000000
#define GMCON_PERF_MON_CNTL0__START_MODE__SHIFT 0x18
#define GMCON_PERF_MON_CNTL0__STOP_MODE_MASK 0xc000000
#define GMCON_PERF_MON_CNTL0__STOP_MODE__SHIFT 0x1a
#define GMCON_PERF_MON_CNTL0__ALLOW_WRAP_MASK 0x10000000
#define GMCON_PERF_MON_CNTL0__ALLOW_WRAP__SHIFT 0x1c
#define GMCON_PERF_MON_CNTL1__THRESH_CNTR_ID_MASK 0x3f
#define GMCON_PERF_MON_CNTL1__THRESH_CNTR_ID__SHIFT 0x0
#define GMCON_PERF_MON_CNTL1__START_TRIG_ID_MASK 0xfc0
#define GMCON_PERF_MON_CNTL1__START_TRIG_ID__SHIFT 0x6
#define GMCON_PERF_MON_CNTL1__STOP_TRIG_ID_MASK 0x3f000
#define GMCON_PERF_MON_CNTL1__STOP_TRIG_ID__SHIFT 0xc
#define GMCON_PERF_MON_CNTL1__MON0_ID_MASK 0xfc0000
#define GMCON_PERF_MON_CNTL1__MON0_ID__SHIFT 0x12
#define GMCON_PERF_MON_CNTL1__MON1_ID_MASK 0x3f000000
#define GMCON_PERF_MON_CNTL1__MON1_ID__SHIFT 0x18
#define GMCON_PERF_MON_RSLT0__COUNT_MASK 0xffffffff
#define GMCON_PERF_MON_RSLT0__COUNT__SHIFT 0x0
#define GMCON_PERF_MON_RSLT1__COUNT_MASK 0xffffffff
#define GMCON_PERF_MON_RSLT1__COUNT__SHIFT 0x0
#define GMCON_PGFSM_CONFIG__FSM_ADDR_MASK 0xff
#define GMCON_PGFSM_CONFIG__FSM_ADDR__SHIFT 0x0
#define GMCON_PGFSM_CONFIG__POWER_DOWN_MASK 0x100
#define GMCON_PGFSM_CONFIG__POWER_DOWN__SHIFT 0x8
#define GMCON_PGFSM_CONFIG__POWER_UP_MASK 0x200
#define GMCON_PGFSM_CONFIG__POWER_UP__SHIFT 0x9
#define GMCON_PGFSM_CONFIG__P1_SELECT_MASK 0x400
#define GMCON_PGFSM_CONFIG__P1_SELECT__SHIFT 0xa
#define GMCON_PGFSM_CONFIG__P2_SELECT_MASK 0x800
#define GMCON_PGFSM_CONFIG__P2_SELECT__SHIFT 0xb
#define GMCON_PGFSM_CONFIG__WRITE_MASK 0x1000
#define GMCON_PGFSM_CONFIG__WRITE__SHIFT 0xc
#define GMCON_PGFSM_CONFIG__READ_MASK 0x2000
#define GMCON_PGFSM_CONFIG__READ__SHIFT 0xd
#define GMCON_PGFSM_CONFIG__RSRVD_MASK 0x7ffc000
#define GMCON_PGFSM_CONFIG__RSRVD__SHIFT 0xe
#define GMCON_PGFSM_CONFIG__SRBM_OVERRIDE_MASK 0x8000000
#define GMCON_PGFSM_CONFIG__SRBM_OVERRIDE__SHIFT 0x1b
#define GMCON_PGFSM_CONFIG__REG_ADDR_MASK 0xf0000000
#define GMCON_PGFSM_CONFIG__REG_ADDR__SHIFT 0x1c
#define GMCON_PGFSM_WRITE__WRITE_VALUE_MASK 0xffffffff
#define GMCON_PGFSM_WRITE__WRITE_VALUE__SHIFT 0x0
#define GMCON_PGFSM_READ__READ_VALUE_MASK 0xffffff
#define GMCON_PGFSM_READ__READ_VALUE__SHIFT 0x0
#define GMCON_PGFSM_READ__PGFSM_SELECT_MASK 0xf000000
#define GMCON_PGFSM_READ__PGFSM_SELECT__SHIFT 0x18
#define GMCON_PGFSM_READ__SERDES_MASTER_BUSY_MASK 0x10000000
#define GMCON_PGFSM_READ__SERDES_MASTER_BUSY__SHIFT 0x1c
#define GMCON_MISC3__RENG_DISABLE_MCC_MASK 0x3f
#define GMCON_MISC3__RENG_DISABLE_MCC__SHIFT 0x0
#define GMCON_MISC3__RENG_DISABLE_MCD_MASK 0xfc0
#define GMCON_MISC3__RENG_DISABLE_MCD__SHIFT 0x6
#define GMCON_MISC3__STCTRL_FORCE_PGFSM_CMD_DONE_MASK 0xfff000
#define GMCON_MISC3__STCTRL_FORCE_PGFSM_CMD_DONE__SHIFT 0xc
#define GMCON_MISC3__STCTRL_IGNORE_ALLOW_STUTTER_MASK 0x1000000
#define GMCON_MISC3__STCTRL_IGNORE_ALLOW_STUTTER__SHIFT 0x18
#define GMCON_MISC3__RENG_MEM_LS_ENABLE_MASK 0x2000000
#define GMCON_MISC3__RENG_MEM_LS_ENABLE__SHIFT 0x19
#define GMCON_MISC3__STCTRL_EXCLUDE_NONMEM_CLIENTS_MASK 0x4000000
#define GMCON_MISC3__STCTRL_EXCLUDE_NONMEM_CLIENTS__SHIFT 0x1a
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_RD_MASK 0x1
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_RD__SHIFT 0x0
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_WR_MASK 0x2
#define GMCON_MASK__STCTRL_BUSY_MASK_ACP_WR__SHIFT 0x1
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_RD_MASK 0x4
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_RD__SHIFT 0x2
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_WR_MASK 0x8
#define GMCON_MASK__STCTRL_BUSY_MASK_VCE_WR__SHIFT 0x3
#define GMCON_MASK__STCTRL_SR_HANDSHAKE_MASK_MASK 0x3f0
#define GMCON_MASK__STCTRL_SR_HANDSHAKE_MASK__SHIFT 0x4
#define GMCON_DEBUG__GFX_STALL_MASK 0x1
#define GMCON_DEBUG__GFX_STALL__SHIFT 0x0
#define GMCON_DEBUG__GFX_CLEAR_MASK 0x2
#define GMCON_DEBUG__GFX_CLEAR__SHIFT 0x1
#define GMCON_DEBUG__MISC_FLAGS_MASK 0x3ffffffc
#define GMCON_DEBUG__MISC_FLAGS__SHIFT 0x2
#define VM_L2_CNTL__ENABLE_L2_CACHE_MASK 0x1
#define VM_L2_CNTL__ENABLE_L2_CACHE__SHIFT 0x0
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING_MASK 0x2
#define VM_L2_CNTL__ENABLE_L2_FRAGMENT_PROCESSING__SHIFT 0x1
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE_MASK 0xc
#define VM_L2_CNTL__L2_CACHE_PTE_ENDIAN_SWAP_MODE__SHIFT 0x2
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE_MASK 0x30
#define VM_L2_CNTL__L2_CACHE_PDE_ENDIAN_SWAP_MODE__SHIFT 0x4
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE_MASK 0x100
#define VM_L2_CNTL__L2_PDE0_CACHE_TAG_GENERATION_MODE__SHIFT 0x8
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x200
#define VM_L2_CNTL__ENABLE_L2_PTE_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0x9
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE_MASK 0x400
#define VM_L2_CNTL__ENABLE_L2_PDE0_CACHE_LRU_UPDATE_BY_WRITE__SHIFT 0xa
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY_MASK 0x800
#define VM_L2_CNTL__ENABLE_DEFAULT_PAGE_OUT_TO_SYSTEM_MEMORY__SHIFT 0xb
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE_MASK 0x7000
#define VM_L2_CNTL__L2_PDE0_CACHE_SPLIT_MODE__SHIFT 0xc
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE_MASK 0x38000
#define VM_L2_CNTL__EFFECTIVE_L2_QUEUE_SIZE__SHIFT 0xf
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION_MASK 0x40000
#define VM_L2_CNTL__PDE_FAULT_CLASSIFICATION__SHIFT 0x12
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE_MASK 0x180000
#define VM_L2_CNTL__CONTEXT1_IDENTITY_ACCESS_MODE__SHIFT 0x13
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE_MASK 0x3e00000
#define VM_L2_CNTL__IDENTITY_MODE_FRAGMENT_SIZE__SHIFT 0x15
#define VM_L2_CNTL__L2_CACHE_4K_SWAP_TAG_INDEX_LSBS_MASK 0xc000000
#define VM_L2_CNTL__L2_CACHE_4K_SWAP_TAG_INDEX_LSBS__SHIFT 0x1a
#define VM_L2_CNTL__L2_CACHE_BIGK_SWAP_TAG_INDEX_LSBS_MASK 0x70000000
#define VM_L2_CNTL__L2_CACHE_BIGK_SWAP_TAG_INDEX_LSBS__SHIFT 0x1c
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS_MASK 0x1
#define VM_L2_CNTL2__INVALIDATE_ALL_L1_TLBS__SHIFT 0x0
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE_MASK 0x2
#define VM_L2_CNTL2__INVALIDATE_L2_CACHE__SHIFT 0x1
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN_MASK 0x200000
#define VM_L2_CNTL2__DISABLE_INVALIDATE_PER_DOMAIN__SHIFT 0x15
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION_MASK 0x400000
#define VM_L2_CNTL2__DISABLE_BIGK_CACHE_OPTIMIZATION__SHIFT 0x16
#define VM_L2_CNTL2__L2_CACHE_BIGK_VMID_MODE_MASK 0x3800000
#define VM_L2_CNTL2__L2_CACHE_BIGK_VMID_MODE__SHIFT 0x17
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE_MASK 0xc000000
#define VM_L2_CNTL2__INVALIDATE_CACHE_MODE__SHIFT 0x1a
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE_MASK 0x70000000
#define VM_L2_CNTL2__PDE_CACHE_EFFECTIVE_SIZE__SHIFT 0x1c
#define VM_L2_CNTL3__BANK_SELECT_MASK 0x3f
#define VM_L2_CNTL3__BANK_SELECT__SHIFT 0x0
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE_MASK 0xc0
#define VM_L2_CNTL3__L2_CACHE_UPDATE_MODE__SHIFT 0x6
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE_MASK 0x1f00
#define VM_L2_CNTL3__L2_CACHE_UPDATE_WILDCARD_REFERENCE_VALUE__SHIFT 0x8
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE_MASK 0xf8000
#define VM_L2_CNTL3__L2_CACHE_BIGK_FRAGMENT_SIZE__SHIFT 0xf
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY_MASK 0x100000
#define VM_L2_CNTL3__L2_CACHE_BIGK_ASSOCIATIVITY__SHIFT 0x14
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE_MASK 0xe00000
#define VM_L2_CNTL3__L2_CACHE_4K_EFFECTIVE_SIZE__SHIFT 0x15
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE_MASK 0xf000000
#define VM_L2_CNTL3__L2_CACHE_BIGK_EFFECTIVE_SIZE__SHIFT 0x18
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS_MASK 0x10000000
#define VM_L2_CNTL3__L2_CACHE_4K_FORCE_MISS__SHIFT 0x1c
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS_MASK 0x20000000
#define VM_L2_CNTL3__L2_CACHE_BIGK_FORCE_MISS__SHIFT 0x1d
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS_MASK 0x40000000
#define VM_L2_CNTL3__PDE_CACHE_FORCE_MISS__SHIFT 0x1e
#define VM_L2_STATUS__L2_BUSY_MASK 0x1
#define VM_L2_STATUS__L2_BUSY__SHIFT 0x0
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY_MASK 0x1fffe
#define VM_L2_STATUS__CONTEXT_DOMAIN_BUSY__SHIFT 0x1
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT_MASK 0x1
#define VM_CONTEXT0_CNTL__ENABLE_CONTEXT__SHIFT 0x0
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH_MASK 0x6
#define VM_CONTEXT0_CNTL__PAGE_TABLE_DEPTH__SHIFT 0x1
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x3
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10
#define VM_CONTEXT0_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x4
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x6
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80
#define VM_CONTEXT0_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x7
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x9
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xa
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800
#define VM_CONTEXT0_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xb
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x1000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xc
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x2000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xd
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x4000
#define VM_CONTEXT0_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xe
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xf
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x10
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x20000
#define VM_CONTEXT0_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x11
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x12
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x13
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x100000
#define VM_CONTEXT0_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x14
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200000
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x15
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400000
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x16
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800000
#define VM_CONTEXT0_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x17
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK 0xf000000
#define VM_CONTEXT0_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT 0x18
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT_MASK 0x1
#define VM_CONTEXT1_CNTL__ENABLE_CONTEXT__SHIFT 0x0
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH_MASK 0x6
#define VM_CONTEXT1_CNTL__PAGE_TABLE_DEPTH__SHIFT 0x1
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x3
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10
#define VM_CONTEXT1_CNTL__RANGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x4
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x6
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80
#define VM_CONTEXT1_CNTL__DUMMY_PAGE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x7
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x9
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xa
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800
#define VM_CONTEXT1_CNTL__PDE0_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xb
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x1000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xc
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x2000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0xd
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x4000
#define VM_CONTEXT1_CNTL__VALID_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0xe
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x8000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0xf
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x10000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x10
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x20000
#define VM_CONTEXT1_CNTL__READ_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x11
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x40000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x12
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x80000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x13
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x100000
#define VM_CONTEXT1_CNTL__WRITE_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x14
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_INTERRUPT_MASK 0x200000
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_INTERRUPT__SHIFT 0x15
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_DEFAULT_MASK 0x400000
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_DEFAULT__SHIFT 0x16
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_SAVE_MASK 0x800000
#define VM_CONTEXT1_CNTL__PRIVILEGED_PROTECTION_FAULT_ENABLE_SAVE__SHIFT 0x17
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE_MASK 0xf000000
#define VM_CONTEXT1_CNTL__PAGE_TABLE_BLOCK_SIZE__SHIFT 0x18
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE_MASK 0x1
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_FAULT_ENABLE__SHIFT 0x0
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL_MASK 0x2
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_ADDRESS_LOGICAL__SHIFT 0x1
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MASK_MASK 0xc
#define VM_DUMMY_PAGE_FAULT_CNTL__DUMMY_PAGE_COMPARE_MASK__SHIFT 0x2
#define VM_DUMMY_PAGE_FAULT_ADDR__DUMMY_PAGE_ADDR_MASK 0xfffffff
#define VM_DUMMY_PAGE_FAULT_ADDR__DUMMY_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT0_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK 0x1
#define VM_CONTEXT0_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT 0x0
#define VM_CONTEXT0_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT_MASK 0x2
#define VM_CONTEXT0_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT__SHIFT 0x1
#define VM_CONTEXT0_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT_MASK 0x4
#define VM_CONTEXT0_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT__SHIFT 0x2
#define VM_CONTEXT0_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK 0x8
#define VM_CONTEXT0_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x3
#define VM_CONTEXT0_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE_MASK 0x10
#define VM_CONTEXT0_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE__SHIFT 0x4
#define VM_CONTEXT1_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR_MASK 0x1
#define VM_CONTEXT1_CNTL2__CLEAR_PROTECTION_FAULT_STATUS_ADDR__SHIFT 0x0
#define VM_CONTEXT1_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT_MASK 0x2
#define VM_CONTEXT1_CNTL2__ENABLE_CLEAR_PROTECTION_FAULT_STATUS_ADDR_WHEN_INVALIDATE_CONTEXT__SHIFT 0x1
#define VM_CONTEXT1_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT_MASK 0x4
#define VM_CONTEXT1_CNTL2__ENABLE_INTERRUPT_PROCESSING_FOR_SUBSEQUENT_FAULTS_PER_CONTEXT__SHIFT 0x2
#define VM_CONTEXT1_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES_MASK 0x8
#define VM_CONTEXT1_CNTL2__ALLOW_SUBSEQUENT_PROTECTION_FAULT_STATUS_ADDR_UPDATES__SHIFT 0x3
#define VM_CONTEXT1_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE_MASK 0x10
#define VM_CONTEXT1_CNTL2__WAIT_FOR_IDLE_WHEN_INVALIDATE__SHIFT 0x4
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT8_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT9_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT10_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT11_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT12_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT13_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT14_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT15_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_0_MASK 0x1
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_0__SHIFT 0x0
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_1_MASK 0x2
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_1__SHIFT 0x1
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_2_MASK 0x4
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_2__SHIFT 0x2
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_3_MASK 0x8
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_3__SHIFT 0x3
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_4_MASK 0x10
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_4__SHIFT 0x4
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_5_MASK 0x20
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_5__SHIFT 0x5
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_6_MASK 0x40
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_6__SHIFT 0x6
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_7_MASK 0x80
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_7__SHIFT 0x7
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_8_MASK 0x100
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_8__SHIFT 0x8
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_9_MASK 0x200
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_9__SHIFT 0x9
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_10_MASK 0x400
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_10__SHIFT 0xa
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_11_MASK 0x800
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_11__SHIFT 0xb
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_12_MASK 0x1000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_12__SHIFT 0xc
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_13_MASK 0x2000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_13__SHIFT 0xd
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_14_MASK 0x4000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_14__SHIFT 0xe
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_15_MASK 0x8000
#define VM_INVALIDATE_REQUEST__INVALIDATE_DOMAIN_15__SHIFT 0xf
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_0_MASK 0x1
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_0__SHIFT 0x0
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_1_MASK 0x2
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_1__SHIFT 0x1
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_2_MASK 0x4
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_2__SHIFT 0x2
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_3_MASK 0x8
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_3__SHIFT 0x3
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_4_MASK 0x10
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_4__SHIFT 0x4
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_5_MASK 0x20
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_5__SHIFT 0x5
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_6_MASK 0x40
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_6__SHIFT 0x6
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_7_MASK 0x80
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_7__SHIFT 0x7
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_8_MASK 0x100
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_8__SHIFT 0x8
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_9_MASK 0x200
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_9__SHIFT 0x9
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_10_MASK 0x400
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_10__SHIFT 0xa
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_11_MASK 0x800
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_11__SHIFT 0xb
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_12_MASK 0x1000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_12__SHIFT 0xc
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_13_MASK 0x2000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_13__SHIFT 0xd
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_14_MASK 0x4000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_14__SHIFT 0xe
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_15_MASK 0x8000
#define VM_INVALIDATE_RESPONSE__DOMAIN_INVALIDATED_15__SHIFT 0xf
#define VM_PRT_APERTURE0_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE0_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE1_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE1_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE2_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE2_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE3_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE3_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE0_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE0_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE1_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE1_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE2_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE2_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_APERTURE3_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_PRT_APERTURE3_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_PRT_CNTL__CB_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS_MASK 0x1
#define VM_PRT_CNTL__CB_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x0
#define VM_PRT_CNTL__TC_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS_MASK 0x2
#define VM_PRT_CNTL__TC_DISABLE_READ_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x1
#define VM_PRT_CNTL__L2_CACHE_STORE_INVALID_ENTRIES_MASK 0x4
#define VM_PRT_CNTL__L2_CACHE_STORE_INVALID_ENTRIES__SHIFT 0x2
#define VM_PRT_CNTL__L1_TLB_STORE_INVALID_ENTRIES_MASK 0x8
#define VM_PRT_CNTL__L1_TLB_STORE_INVALID_ENTRIES__SHIFT 0x3
#define VM_PRT_CNTL__CB_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS_MASK 0x10
#define VM_PRT_CNTL__CB_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x4
#define VM_PRT_CNTL__TC_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS_MASK 0x20
#define VM_PRT_CNTL__TC_DISABLE_WRITE_FAULT_ON_UNMAPPED_ACCESS__SHIFT 0x5
#define VM_PRT_CNTL__MASK_PDE0_FAULT_MASK 0x40
#define VM_PRT_CNTL__MASK_PDE0_FAULT__SHIFT 0x6
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0_MASK 0x1
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_0__SHIFT 0x0
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1_MASK 0x2
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_1__SHIFT 0x1
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2_MASK 0x4
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_2__SHIFT 0x2
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3_MASK 0x8
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_3__SHIFT 0x3
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4_MASK 0x10
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_4__SHIFT 0x4
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5_MASK 0x20
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_5__SHIFT 0x5
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6_MASK 0x40
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_6__SHIFT 0x6
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7_MASK 0x80
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_7__SHIFT 0x7
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8_MASK 0x100
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_8__SHIFT 0x8
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9_MASK 0x200
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_9__SHIFT 0x9
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10_MASK 0x400
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_10__SHIFT 0xa
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11_MASK 0x800
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_11__SHIFT 0xb
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12_MASK 0x1000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_12__SHIFT 0xc
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13_MASK 0x2000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_13__SHIFT 0xd
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14_MASK 0x4000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_14__SHIFT 0xe
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15_MASK 0x8000
#define VM_CONTEXTS_DISABLE__DISABLE_CONTEXT_15__SHIFT 0xf
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__PROTECTIONS_MASK 0xff
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__PROTECTIONS__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID_MASK 0xff000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID__SHIFT 0xc
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW_MASK 0x1000000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW__SHIFT 0x18
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__VMID_MASK 0x1e000000
#define VM_CONTEXT0_PROTECTION_FAULT_STATUS__VMID__SHIFT 0x19
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__PROTECTIONS_MASK 0xff
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__PROTECTIONS__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID_MASK 0xff000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_ID__SHIFT 0xc
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW_MASK 0x1000000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__MEMORY_CLIENT_RW__SHIFT 0x18
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__VMID_MASK 0x1e000000
#define VM_CONTEXT1_PROTECTION_FAULT_STATUS__VMID__SHIFT 0x19
#define VM_CONTEXT0_PROTECTION_FAULT_MCCLIENT__NAME_MASK 0xffffffff
#define VM_CONTEXT0_PROTECTION_FAULT_MCCLIENT__NAME__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_MCCLIENT__NAME_MASK 0xffffffff
#define VM_CONTEXT1_PROTECTION_FAULT_MCCLIENT__NAME__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT0_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT1_PROTECTION_FAULT_ADDR__LOGICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT0_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR__SHIFT 0x0
#define VM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR_MASK 0xfffffff
#define VM_CONTEXT1_PROTECTION_FAULT_DEFAULT_ADDR__PHYSICAL_PAGE_ADDR__SHIFT 0x0
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK 0x1ff
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT__SHIFT 0x0
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK_MASK 0x3fe00
#define VM_FAULT_CLIENT_ID__MEMORY_CLIENT_MASK__SHIFT 0x9
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT2_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT3_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT4_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT5_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT6_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT7_PAGE_TABLE_BASE_ADDR__PHYSICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_START_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT0_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_CONTEXT1_PAGE_TABLE_END_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_DEBUG__FLAGS_MASK 0xffffffff
#define VM_DEBUG__FLAGS__SHIFT 0x0
#define VM_L2_CG__OFFDLY_MASK 0xfc0
#define VM_L2_CG__OFFDLY__SHIFT 0x6
#define VM_L2_CG__ENABLE_MASK 0x40000
#define VM_L2_CG__ENABLE__SHIFT 0x12
#define VM_L2_CG__MEM_LS_ENABLE_MASK 0x80000
#define VM_L2_CG__MEM_LS_ENABLE__SHIFT 0x13
#define VM_L2_BANK_SELECT_MASKA__BANK_SELECT_MASK_MASK 0xfffffff
#define VM_L2_BANK_SELECT_MASKA__BANK_SELECT_MASK__SHIFT 0x0
#define VM_L2_BANK_SELECT_MASKB__BANK_SELECT_MASK_MASK 0xff
#define VM_L2_BANK_SELECT_MASKB__BANK_SELECT_MASK__SHIFT 0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER_MASK 0xfffffff
#define VM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR__LOGICAL_PAGE_NUMBER__SHIFT 0x0
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET__PHYSICAL_PAGE_OFFSET_MASK 0xfffffff
#define VM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET__PHYSICAL_PAGE_OFFSET__SHIFT 0x0
#define MC_ARB_HARSH_EN_RD__TX_PRI_MASK 0xff
#define MC_ARB_HARSH_EN_RD__TX_PRI__SHIFT 0x0
#define MC_ARB_HARSH_EN_RD__BW_PRI_MASK 0xff00
#define MC_ARB_HARSH_EN_RD__BW_PRI__SHIFT 0x8
#define MC_ARB_HARSH_EN_RD__FIX_PRI_MASK 0xff0000
#define MC_ARB_HARSH_EN_RD__FIX_PRI__SHIFT 0x10
#define MC_ARB_HARSH_EN_RD__ST_PRI_MASK 0xff000000
#define MC_ARB_HARSH_EN_RD__ST_PRI__SHIFT 0x18
#define MC_ARB_HARSH_EN_WR__TX_PRI_MASK 0xff
#define MC_ARB_HARSH_EN_WR__TX_PRI__SHIFT 0x0
#define MC_ARB_HARSH_EN_WR__BW_PRI_MASK 0xff00
#define MC_ARB_HARSH_EN_WR__BW_PRI__SHIFT 0x8
#define MC_ARB_HARSH_EN_WR__FIX_PRI_MASK 0xff0000
#define MC_ARB_HARSH_EN_WR__FIX_PRI__SHIFT 0x10
#define MC_ARB_HARSH_EN_WR__ST_PRI_MASK 0xff000000
#define MC_ARB_HARSH_EN_WR__ST_PRI__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_HI0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_HI0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_HI0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_HI0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_HI1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_HI1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_HI1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_HI1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_HI1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_HI1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_HI1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_HI1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_HI1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_HI1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_LO0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_LO0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_TX_LO0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_TX_LO0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_LO1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_LO1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_TX_LO1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_TX_LO1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_TX_LO1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_TX_LO1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_TX_LO1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_TX_LO1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_TX_LO1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_TX_LO1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWPERIOD1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWCNT0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWCNT0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_BWCNT0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_BWCNT0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWCNT1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWCNT1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_BWCNT1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_BWCNT1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_BWCNT1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_BWCNT1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_BWCNT1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_BWCNT1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_BWCNT1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_BWCNT1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_SAT0_RD__GROUP0_MASK 0xff
#define MC_ARB_HARSH_SAT0_RD__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_SAT0_RD__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_SAT0_RD__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_SAT0_RD__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_SAT0_RD__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_SAT0_RD__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_SAT0_RD__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_SAT0_WR__GROUP0_MASK 0xff
#define MC_ARB_HARSH_SAT0_WR__GROUP0__SHIFT 0x0
#define MC_ARB_HARSH_SAT0_WR__GROUP1_MASK 0xff00
#define MC_ARB_HARSH_SAT0_WR__GROUP1__SHIFT 0x8
#define MC_ARB_HARSH_SAT0_WR__GROUP2_MASK 0xff0000
#define MC_ARB_HARSH_SAT0_WR__GROUP2__SHIFT 0x10
#define MC_ARB_HARSH_SAT0_WR__GROUP3_MASK 0xff000000
#define MC_ARB_HARSH_SAT0_WR__GROUP3__SHIFT 0x18
#define MC_ARB_HARSH_SAT1_RD__GROUP4_MASK 0xff
#define MC_ARB_HARSH_SAT1_RD__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_SAT1_RD__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_SAT1_RD__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_SAT1_RD__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_SAT1_RD__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_SAT1_RD__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_SAT1_RD__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_SAT1_WR__GROUP4_MASK 0xff
#define MC_ARB_HARSH_SAT1_WR__GROUP4__SHIFT 0x0
#define MC_ARB_HARSH_SAT1_WR__GROUP5_MASK 0xff00
#define MC_ARB_HARSH_SAT1_WR__GROUP5__SHIFT 0x8
#define MC_ARB_HARSH_SAT1_WR__GROUP6_MASK 0xff0000
#define MC_ARB_HARSH_SAT1_WR__GROUP6__SHIFT 0x10
#define MC_ARB_HARSH_SAT1_WR__GROUP7_MASK 0xff000000
#define MC_ARB_HARSH_SAT1_WR__GROUP7__SHIFT 0x18
#define MC_ARB_HARSH_CTL_RD__FORCE_HIGHEST_MASK 0xff
#define MC_ARB_HARSH_CTL_RD__FORCE_HIGHEST__SHIFT 0x0
#define MC_ARB_HARSH_CTL_RD__HARSH_RR_MASK 0x100
#define MC_ARB_HARSH_CTL_RD__HARSH_RR__SHIFT 0x8
#define MC_ARB_HARSH_CTL_RD__BANK_AGE_ONLY_MASK 0x200
#define MC_ARB_HARSH_CTL_RD__BANK_AGE_ONLY__SHIFT 0x9
#define MC_ARB_HARSH_CTL_RD__USE_LEGACY_HARSH_MASK 0x400
#define MC_ARB_HARSH_CTL_RD__USE_LEGACY_HARSH__SHIFT 0xa
#define MC_ARB_HARSH_CTL_RD__BWCNT_CATCHUP_MASK 0x800
#define MC_ARB_HARSH_CTL_RD__BWCNT_CATCHUP__SHIFT 0xb
#define MC_ARB_HARSH_CTL_RD__ST_MODE_MASK 0x3000
#define MC_ARB_HARSH_CTL_RD__ST_MODE__SHIFT 0xc
#define MC_ARB_HARSH_CTL_RD__FORCE_STALL_MASK 0x3fc000
#define MC_ARB_HARSH_CTL_RD__FORCE_STALL__SHIFT 0xe
#define MC_ARB_HARSH_CTL_RD__PERF_MON_SEL_MASK 0x1c00000
#define MC_ARB_HARSH_CTL_RD__PERF_MON_SEL__SHIFT 0x16
#define MC_ARB_HARSH_CTL_WR__FORCE_HIGHEST_MASK 0xff
#define MC_ARB_HARSH_CTL_WR__FORCE_HIGHEST__SHIFT 0x0
#define MC_ARB_HARSH_CTL_WR__HARSH_RR_MASK 0x100
#define MC_ARB_HARSH_CTL_WR__HARSH_RR__SHIFT 0x8
#define MC_ARB_HARSH_CTL_WR__BANK_AGE_ONLY_MASK 0x200
#define MC_ARB_HARSH_CTL_WR__BANK_AGE_ONLY__SHIFT 0x9
#define MC_ARB_HARSH_CTL_WR__USE_LEGACY_HARSH_MASK 0x400
#define MC_ARB_HARSH_CTL_WR__USE_LEGACY_HARSH__SHIFT 0xa
#define MC_ARB_HARSH_CTL_WR__BWCNT_CATCHUP_MASK 0x800
#define MC_ARB_HARSH_CTL_WR__BWCNT_CATCHUP__SHIFT 0xb
#define MC_ARB_HARSH_CTL_WR__ST_MODE_MASK 0x3000
#define MC_ARB_HARSH_CTL_WR__ST_MODE__SHIFT 0xc
#define MC_ARB_HARSH_CTL_WR__FORCE_STALL_MASK 0x3fc000
#define MC_ARB_HARSH_CTL_WR__FORCE_STALL__SHIFT 0xe
#define MC_ARB_HARSH_CTL_WR__PERF_MON_SEL_MASK 0x1c00000
#define MC_ARB_HARSH_CTL_WR__PERF_MON_SEL__SHIFT 0x16
#define MC_FUS_DRAM0_CS0_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM0_CS0_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM0_CS0_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM0_CS0_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM0_CS0_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM0_CS0_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM1_CS0_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM1_CS0_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM1_CS0_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM1_CS0_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM1_CS0_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM1_CS0_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM0_CS1_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM0_CS1_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM0_CS1_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM0_CS1_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM0_CS1_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM0_CS1_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM1_CS1_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM1_CS1_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM1_CS1_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM1_CS1_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM1_CS1_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM1_CS1_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM0_CS2_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM0_CS2_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM0_CS2_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM0_CS2_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM0_CS2_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM0_CS2_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM1_CS2_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM1_CS2_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM1_CS2_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM1_CS2_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM1_CS2_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM1_CS2_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM0_CS3_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM0_CS3_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM0_CS3_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM0_CS3_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM0_CS3_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM0_CS3_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM1_CS3_BASE__CSENABLE_MASK 0x1
#define MC_FUS_DRAM1_CS3_BASE__CSENABLE__SHIFT 0x0
#define MC_FUS_DRAM1_CS3_BASE__BASEADDR21_11_MASK 0xffe0
#define MC_FUS_DRAM1_CS3_BASE__BASEADDR21_11__SHIFT 0x5
#define MC_FUS_DRAM1_CS3_BASE__BASEADDR38_27_MASK 0x7ff80000
#define MC_FUS_DRAM1_CS3_BASE__BASEADDR38_27__SHIFT 0x13
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__DIMM0ADDRMAP_MASK 0xf
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__DIMM0ADDRMAP__SHIFT 0x0
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__DIMM1ADDRMAP_MASK 0xf0
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__DIMM1ADDRMAP__SHIFT 0x4
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__BANKSWIZZLEMODE_MASK 0x100
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__BANKSWIZZLEMODE__SHIFT 0x8
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__BANKSWAP_MASK 0x200
#define MC_FUS_DRAM0_BANK_ADDR_MAPPING__BANKSWAP__SHIFT 0x9
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__DIMM0ADDRMAP_MASK 0xf
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__DIMM0ADDRMAP__SHIFT 0x0
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__DIMM1ADDRMAP_MASK 0xf0
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__DIMM1ADDRMAP__SHIFT 0x4
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__BANKSWIZZLEMODE_MASK 0x100
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__BANKSWIZZLEMODE__SHIFT 0x8
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__BANKSWAP_MASK 0x200
#define MC_FUS_DRAM1_BANK_ADDR_MAPPING__BANKSWAP__SHIFT 0x9
#define MC_FUS_DRAM0_CTL_BASE__DCTSEL_MASK 0x7
#define MC_FUS_DRAM0_CTL_BASE__DCTSEL__SHIFT 0x0
#define MC_FUS_DRAM0_CTL_BASE__DCTINTLVEN_MASK 0x78
#define MC_FUS_DRAM0_CTL_BASE__DCTINTLVEN__SHIFT 0x3
#define MC_FUS_DRAM0_CTL_BASE__DCTBASEADDR_MASK 0xfffff80
#define MC_FUS_DRAM0_CTL_BASE__DCTBASEADDR__SHIFT 0x7
#define MC_FUS_DRAM0_CTL_BASE__DCTOFFSETEN_MASK 0x10000000
#define MC_FUS_DRAM0_CTL_BASE__DCTOFFSETEN__SHIFT 0x1c
#define MC_FUS_DRAM1_CTL_BASE__DCTSEL_MASK 0x7
#define MC_FUS_DRAM1_CTL_BASE__DCTSEL__SHIFT 0x0
#define MC_FUS_DRAM1_CTL_BASE__DCTINTLVEN_MASK 0x78
#define MC_FUS_DRAM1_CTL_BASE__DCTINTLVEN__SHIFT 0x3
#define MC_FUS_DRAM1_CTL_BASE__DCTBASEADDR_MASK 0xfffff80
#define MC_FUS_DRAM1_CTL_BASE__DCTBASEADDR__SHIFT 0x7
#define MC_FUS_DRAM1_CTL_BASE__DCTOFFSETEN_MASK 0x10000000
#define MC_FUS_DRAM1_CTL_BASE__DCTOFFSETEN__SHIFT 0x1c
#define MC_FUS_DRAM0_CTL_LIMIT__DCTLIMITADDR_MASK 0x1fffff
#define MC_FUS_DRAM0_CTL_LIMIT__DCTLIMITADDR__SHIFT 0x0
#define MC_FUS_DRAM0_CTL_LIMIT__DRAMHOLEVALID_MASK 0x200000
#define MC_FUS_DRAM0_CTL_LIMIT__DRAMHOLEVALID__SHIFT 0x15
#define MC_FUS_DRAM1_CTL_LIMIT__DCTLIMITADDR_MASK 0x1fffff
#define MC_FUS_DRAM1_CTL_LIMIT__DCTLIMITADDR__SHIFT 0x0
#define MC_FUS_DRAM1_CTL_LIMIT__DRAMHOLEVALID_MASK 0x200000
#define MC_FUS_DRAM1_CTL_LIMIT__DRAMHOLEVALID__SHIFT 0x15
#define MC_FUS_DRAM_CTL_HIGH_01__DCTHIGHADDROFF0_MASK 0xfff
#define MC_FUS_DRAM_CTL_HIGH_01__DCTHIGHADDROFF0__SHIFT 0x0
#define MC_FUS_DRAM_CTL_HIGH_01__DCTHIGHADDROFF1_MASK 0xfff000
#define MC_FUS_DRAM_CTL_HIGH_01__DCTHIGHADDROFF1__SHIFT 0xc
#define MC_FUS_DRAM_CTL_HIGH_23__DCTHIGHADDROFF2_MASK 0xfff
#define MC_FUS_DRAM_CTL_HIGH_23__DCTHIGHADDROFF2__SHIFT 0x0
#define MC_FUS_DRAM_CTL_HIGH_23__DCTHIGHADDROFF3_MASK 0xfff000
#define MC_FUS_DRAM_CTL_HIGH_23__DCTHIGHADDROFF3__SHIFT 0xc
#define MC_FUS_DRAM_MODE__DCTSELINTLVADDR_MASK 0x7
#define MC_FUS_DRAM_MODE__DCTSELINTLVADDR__SHIFT 0x0
#define MC_FUS_DRAM_MODE__GDDR5EN_MASK 0x8
#define MC_FUS_DRAM_MODE__GDDR5EN__SHIFT 0x3
#define MC_FUS_DRAM_MODE__DRAMHOLEOFFSET_MASK 0x1ff0
#define MC_FUS_DRAM_MODE__DRAMHOLEOFFSET__SHIFT 0x4
#define MC_FUS_DRAM_APER_BASE__BASE_MASK 0xfffff
#define MC_FUS_DRAM_APER_BASE__BASE__SHIFT 0x0
#define MC_FUS_DRAM_APER_TOP__TOP_MASK 0xfffff
#define MC_FUS_DRAM_APER_TOP__TOP__SHIFT 0x0
#define MC_FUS_DRAM_C6SAVE_APER_BASE__BASE_MASK 0xfffff
#define MC_FUS_DRAM_C6SAVE_APER_BASE__BASE__SHIFT 0x0
#define MC_FUS_DRAM_C6SAVE_APER_TOP__TOP_MASK 0xfffff
#define MC_FUS_DRAM_C6SAVE_APER_TOP__TOP__SHIFT 0x0
#define MC_FUS_DRAM_APER_DEF__DEF_MASK 0xfffffff
#define MC_FUS_DRAM_APER_DEF__DEF__SHIFT 0x0
#define MC_FUS_DRAM_APER_DEF__LOCK_MC_FUS_DRAM_REGS_MASK 0x10000000
#define MC_FUS_DRAM_APER_DEF__LOCK_MC_FUS_DRAM_REGS__SHIFT 0x1c
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_TOKURG_EN_MASK 0x1
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_TOKURG_EN__SHIFT 0x0
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_TOKURG_EN_MASK 0x2
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_TOKURG_EN__SHIFT 0x1
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_TOKURG_EN_MASK 0x4
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_TOKURG_EN__SHIFT 0x2
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_TOKURG_EN_MASK 0x8
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_TOKURG_EN__SHIFT 0x3
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_PRIURG_EN_MASK 0x10
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_PRIURG_EN__SHIFT 0x4
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_PRIURG_EN_MASK 0x20
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_PRIURG_EN__SHIFT 0x5
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_PRIURG_EN_MASK 0x40
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_PRIURG_EN__SHIFT 0x6
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_PRIURG_EN_MASK 0x80
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_PRIURG_EN__SHIFT 0x7
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_ISOC_EN_MASK 0x100
#define MC_FUS_ARB_GARLIC_ISOC_PRI__DMIF_RD_ISOC_EN__SHIFT 0x8
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_ISOC_EN_MASK 0x200
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UVD_RD_ISOC_EN__SHIFT 0x9
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_ISOC_EN_MASK 0x400
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCE_RD_ISOC_EN__SHIFT 0xa
#define MC_FUS_ARB_GARLIC_ISOC_PRI__MCIF_RD_ISOC_EN_MASK 0x800
#define MC_FUS_ARB_GARLIC_ISOC_PRI__MCIF_RD_ISOC_EN__SHIFT 0xb
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UMC_RD_ISOC_EN_MASK 0x1000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__UMC_RD_ISOC_EN__SHIFT 0xc
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCEU_RD_ISOC_EN_MASK 0x2000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__VCEU_RD_ISOC_EN__SHIFT 0xd
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_ISOC_EN_MASK 0x4000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__ACP_RD_ISOC_EN__SHIFT 0xe
#define MC_FUS_ARB_GARLIC_ISOC_PRI__REQPRI_OVERRIDE_EN_MASK 0x8000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__REQPRI_OVERRIDE_EN__SHIFT 0xf
#define MC_FUS_ARB_GARLIC_ISOC_PRI__REQPRI_OVERRIDE_VAL_MASK 0x30000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__REQPRI_OVERRIDE_VAL__SHIFT 0x10
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIPRMTE_OVERRIDE_EN_MASK 0x40000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIPRMTE_OVERRIDE_EN__SHIFT 0x12
#define MC_FUS_ARB_GARLIC_ISOC_PRI__TOKURG_OVERRIDE_EN_MASK 0x80000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__TOKURG_OVERRIDE_EN__SHIFT 0x13
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIURG_OVERRIDE_EN_MASK 0x100000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIURG_OVERRIDE_EN__SHIFT 0x14
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIPRMTE_OVERRIDE_VAL_MASK 0x200000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIPRMTE_OVERRIDE_VAL__SHIFT 0x15
#define MC_FUS_ARB_GARLIC_ISOC_PRI__TOKURG_OVERRIDE_VAL_MASK 0x400000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__TOKURG_OVERRIDE_VAL__SHIFT 0x16
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIURG_OVERRIDE_VAL_MASK 0x800000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__PRIURG_OVERRIDE_VAL__SHIFT 0x17
#define MC_FUS_ARB_GARLIC_ISOC_PRI__GARLIC_REQ_CREDITS_MASK 0x1f000000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__GARLIC_REQ_CREDITS__SHIFT 0x18
#define MC_FUS_ARB_GARLIC_ISOC_PRI__MM_REL_LATE_MASK 0x20000000
#define MC_FUS_ARB_GARLIC_ISOC_PRI__MM_REL_LATE__SHIFT 0x1d
#define MC_FUS_ARB_GARLIC_CNTL__RX_RDRESP_FIFO_PTR_INIT_VALUE_MASK 0xff
#define MC_FUS_ARB_GARLIC_CNTL__RX_RDRESP_FIFO_PTR_INIT_VALUE__SHIFT 0x0
#define MC_FUS_ARB_GARLIC_CNTL__RX_WRRESP_FIFO_PTR_INIT_VALUE_MASK 0x7f00
#define MC_FUS_ARB_GARLIC_CNTL__RX_WRRESP_FIFO_PTR_INIT_VALUE__SHIFT 0x8
#define MC_FUS_ARB_GARLIC_CNTL__EN_64_BYTE_WRITE_MASK 0x8000
#define MC_FUS_ARB_GARLIC_CNTL__EN_64_BYTE_WRITE__SHIFT 0xf
#define MC_FUS_ARB_GARLIC_CNTL__EDC_RESPONSE_ENABLE_MASK 0x10000
#define MC_FUS_ARB_GARLIC_CNTL__EDC_RESPONSE_ENABLE__SHIFT 0x10
#define MC_FUS_ARB_GARLIC_CNTL__OUTSTANDING_RDRESP_LIMIT_MASK 0x3fe0000
#define MC_FUS_ARB_GARLIC_CNTL__OUTSTANDING_RDRESP_LIMIT__SHIFT 0x11
#define MC_FUS_ARB_GARLIC_CNTL__OUTSTANDING_WRRESP_LIMIT_MASK 0xfc000000
#define MC_FUS_ARB_GARLIC_CNTL__OUTSTANDING_WRRESP_LIMIT__SHIFT 0x1a
#define MC_FUS_ARB_GARLIC_WR_PRI__CB_WR_PRI_MASK 0x3
#define MC_FUS_ARB_GARLIC_WR_PRI__CB_WR_PRI__SHIFT 0x0
#define MC_FUS_ARB_GARLIC_WR_PRI__DB_WR_PRI_MASK 0xc
#define MC_FUS_ARB_GARLIC_WR_PRI__DB_WR_PRI__SHIFT 0x2
#define MC_FUS_ARB_GARLIC_WR_PRI__TC_WR_PRI_MASK 0x30
#define MC_FUS_ARB_GARLIC_WR_PRI__TC_WR_PRI__SHIFT 0x4
#define MC_FUS_ARB_GARLIC_WR_PRI__CP_WR_PRI_MASK 0xc0
#define MC_FUS_ARB_GARLIC_WR_PRI__CP_WR_PRI__SHIFT 0x6
#define MC_FUS_ARB_GARLIC_WR_PRI__HDP_WR_PRI_MASK 0x300
#define MC_FUS_ARB_GARLIC_WR_PRI__HDP_WR_PRI__SHIFT 0x8
#define MC_FUS_ARB_GARLIC_WR_PRI__XDP_WR_PRI_MASK 0xc00
#define MC_FUS_ARB_GARLIC_WR_PRI__XDP_WR_PRI__SHIFT 0xa
#define MC_FUS_ARB_GARLIC_WR_PRI__UMC_WR_PRI_MASK 0x3000
#define MC_FUS_ARB_GARLIC_WR_PRI__UMC_WR_PRI__SHIFT 0xc
#define MC_FUS_ARB_GARLIC_WR_PRI__UVD_WR_PRI_MASK 0xc000
#define MC_FUS_ARB_GARLIC_WR_PRI__UVD_WR_PRI__SHIFT 0xe
#define MC_FUS_ARB_GARLIC_WR_PRI__RLC_WR_PRI_MASK 0x30000
#define MC_FUS_ARB_GARLIC_WR_PRI__RLC_WR_PRI__SHIFT 0x10
#define MC_FUS_ARB_GARLIC_WR_PRI__IH_WR_PRI_MASK 0xc0000
#define MC_FUS_ARB_GARLIC_WR_PRI__IH_WR_PRI__SHIFT 0x12
#define MC_FUS_ARB_GARLIC_WR_PRI__SDMA_WR_PRI_MASK 0x300000
#define MC_FUS_ARB_GARLIC_WR_PRI__SDMA_WR_PRI__SHIFT 0x14
#define MC_FUS_ARB_GARLIC_WR_PRI__SEM_WR_PRI_MASK 0xc00000
#define MC_FUS_ARB_GARLIC_WR_PRI__SEM_WR_PRI__SHIFT 0x16
#define MC_FUS_ARB_GARLIC_WR_PRI__SH_WR_PRI_MASK 0x3000000
#define MC_FUS_ARB_GARLIC_WR_PRI__SH_WR_PRI__SHIFT 0x18
#define MC_FUS_ARB_GARLIC_WR_PRI__MCIF_WR_PRI_MASK 0xc000000
#define MC_FUS_ARB_GARLIC_WR_PRI__MCIF_WR_PRI__SHIFT 0x1a
#define MC_FUS_ARB_GARLIC_WR_PRI__VCE_WR_PRI_MASK 0x30000000
#define MC_FUS_ARB_GARLIC_WR_PRI__VCE_WR_PRI__SHIFT 0x1c
#define MC_FUS_ARB_GARLIC_WR_PRI__VCEU_WR_PRI_MASK 0xc0000000
#define MC_FUS_ARB_GARLIC_WR_PRI__VCEU_WR_PRI__SHIFT 0x1e
#define MC_FUS_ARB_GARLIC_WR_PRI2__SMU_WR_PRI_MASK 0x3
#define MC_FUS_ARB_GARLIC_WR_PRI2__SMU_WR_PRI__SHIFT 0x0
#define MC_FUS_ARB_GARLIC_WR_PRI2__SAM_WR_PRI_MASK 0xc
#define MC_FUS_ARB_GARLIC_WR_PRI2__SAM_WR_PRI__SHIFT 0x2
#define MC_FUS_ARB_GARLIC_WR_PRI2__ACP_WR_PRI_MASK 0x30
#define MC_FUS_ARB_GARLIC_WR_PRI2__ACP_WR_PRI__SHIFT 0x4
#define MC_CG_DATAPORT__DATA_FIELD_MASK 0xffffffff
#define MC_CG_DATAPORT__DATA_FIELD__SHIFT 0x0
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_FRAGMENTS_MASK 0x1
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_FRAGMENTS__SHIFT 0x0
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE_MASK 0x2
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_INVALIDATE_BY_ADDRESS_RANGE__SHIFT 0x1
#define CHUB_ATC_L1_DEBUG_TLB__EFFECTIVE_CAM_SIZE_MASK 0xf0
#define CHUB_ATC_L1_DEBUG_TLB__EFFECTIVE_CAM_SIZE__SHIFT 0x4
#define CHUB_ATC_L1_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE_MASK 0x700
#define CHUB_ATC_L1_DEBUG_TLB__EFFECTIVE_WORK_QUEUE_SIZE__SHIFT 0x8
#define CHUB_ATC_L1_DEBUG_TLB__CREDITS_L1_L2_MASK 0x3f000
#define CHUB_ATC_L1_DEBUG_TLB__CREDITS_L1_L2__SHIFT 0xc
#define CHUB_ATC_L1_DEBUG_TLB__CREDITS_L1_RPB_MASK 0xff00000
#define CHUB_ATC_L1_DEBUG_TLB__CREDITS_L1_RPB__SHIFT 0x14
#define CHUB_ATC_L1_DEBUG_TLB__DEBUG_ECO_MASK 0x30000000
#define CHUB_ATC_L1_DEBUG_TLB__DEBUG_ECO__SHIFT 0x1c
#define CHUB_ATC_L1_DEBUG_TLB__INVALIDATE_ALL_MASK 0x40000000
#define CHUB_ATC_L1_DEBUG_TLB__INVALIDATE_ALL__SHIFT 0x1e
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_CACHING_UNTRANSLATED_RETURNS_MASK 0x80000000
#define CHUB_ATC_L1_DEBUG_TLB__DISABLE_CACHING_UNTRANSLATED_RETURNS__SHIFT 0x1f
#define CHUB_ATC_L1_STATUS__BUSY_MASK 0x1
#define CHUB_ATC_L1_STATUS__BUSY__SHIFT 0x0
#define CHUB_ATC_L1_STATUS__DEADLOCK_DETECTION_MASK 0x2
#define CHUB_ATC_L1_STATUS__DEADLOCK_DETECTION__SHIFT 0x1
#define CHUB_ATC_L1_STATUS__BAD_NEED_ATS_MASK 0x100
#define CHUB_ATC_L1_STATUS__BAD_NEED_ATS__SHIFT 0x8

#endif /* GMC_7_0_SH_MASK_H */
