/*	$NetBSD: imx51-pinfunc.h,v 1.1.1.1 2017/06/15 20:14:24 jmcneill Exp $	*/

/*
 * Copyright 2013 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __DTS_IMX51_PINFUNC_H
#define __DTS_IMX51_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define MX51_PAD_EIM_D16__AUD4_RXFS			0x05c 0x3f0 0x000 0x5 0x0
#define MX51_PAD_EIM_D16__AUD5_TXD			0x05c 0x3f0 0x8d8 0x7 0x0
#define MX51_PAD_EIM_D16__EIM_D16			0x05c 0x3f0 0x000 0x0 0x0
#define MX51_PAD_EIM_D16__GPIO2_0			0x05c 0x3f0 0x000 0x1 0x0
#define MX51_PAD_EIM_D16__I2C1_SDA			0x05c 0x3f0 0x9b4 0x4 0x0
#define MX51_PAD_EIM_D16__UART2_CTS			0x05c 0x3f0 0x000 0x3 0x0
#define MX51_PAD_EIM_D16__USBH2_DATA0			0x05c 0x3f0 0x000 0x2 0x0
#define MX51_PAD_EIM_D17__AUD5_RXD			0x060 0x3f4 0x8d4 0x7 0x0
#define MX51_PAD_EIM_D17__EIM_D17			0x060 0x3f4 0x000 0x0 0x0
#define MX51_PAD_EIM_D17__GPIO2_1			0x060 0x3f4 0x000 0x1 0x0
#define MX51_PAD_EIM_D17__UART2_RXD			0x060 0x3f4 0x9ec 0x3 0x0
#define MX51_PAD_EIM_D17__UART3_CTS			0x060 0x3f4 0x000 0x4 0x0
#define MX51_PAD_EIM_D17__USBH2_DATA1			0x060 0x3f4 0x000 0x2 0x0
#define MX51_PAD_EIM_D18__AUD5_TXC			0x064 0x3f8 0x8e4 0x7 0x0
#define MX51_PAD_EIM_D18__EIM_D18			0x064 0x3f8 0x000 0x0 0x0
#define MX51_PAD_EIM_D18__GPIO2_2			0x064 0x3f8 0x000 0x1 0x0
#define MX51_PAD_EIM_D18__UART2_TXD			0x064 0x3f8 0x000 0x3 0x0
#define MX51_PAD_EIM_D18__UART3_RTS			0x064 0x3f8 0x9f0 0x4 0x1
#define MX51_PAD_EIM_D18__USBH2_DATA2			0x064 0x3f8 0x000 0x2 0x0
#define MX51_PAD_EIM_D19__AUD4_RXC			0x068 0x3fc 0x000 0x5 0x0
#define MX51_PAD_EIM_D19__AUD5_TXFS			0x068 0x3fc 0x8e8 0x7 0x0
#define MX51_PAD_EIM_D19__EIM_D19			0x068 0x3fc 0x000 0x0 0x0
#define MX51_PAD_EIM_D19__GPIO2_3			0x068 0x3fc 0x000 0x1 0x0
#define MX51_PAD_EIM_D19__I2C1_SCL			0x068 0x3fc 0x9b0 0x4 0x0
#define MX51_PAD_EIM_D19__UART2_RTS			0x068 0x3fc 0x9e8 0x3 0x1
#define MX51_PAD_EIM_D19__USBH2_DATA3			0x068 0x3fc 0x000 0x2 0x0
#define MX51_PAD_EIM_D20__AUD4_TXD			0x06c 0x400 0x8c8 0x5 0x0
#define MX51_PAD_EIM_D20__EIM_D20			0x06c 0x400 0x000 0x0 0x0
#define MX51_PAD_EIM_D20__GPIO2_4			0x06c 0x400 0x000 0x1 0x0
#define MX51_PAD_EIM_D20__SRTC_ALARM_DEB		0x06c 0x400 0x000 0x4 0x0
#define MX51_PAD_EIM_D20__USBH2_DATA4			0x06c 0x400 0x000 0x2 0x0
#define MX51_PAD_EIM_D21__AUD4_RXD			0x070 0x404 0x8c4 0x5 0x0
#define MX51_PAD_EIM_D21__EIM_D21			0x070 0x404 0x000 0x0 0x0
#define MX51_PAD_EIM_D21__GPIO2_5			0x070 0x404 0x000 0x1 0x0
#define MX51_PAD_EIM_D21__SRTC_ALARM_DEB		0x070 0x404 0x000 0x3 0x0
#define MX51_PAD_EIM_D21__USBH2_DATA5			0x070 0x404 0x000 0x2 0x0
#define MX51_PAD_EIM_D22__AUD4_TXC			0x074 0x408 0x8cc 0x5 0x0
#define MX51_PAD_EIM_D22__EIM_D22			0x074 0x408 0x000 0x0 0x0
#define MX51_PAD_EIM_D22__GPIO2_6			0x074 0x408 0x000 0x1 0x0
#define MX51_PAD_EIM_D22__USBH2_DATA6			0x074 0x408 0x000 0x2 0x0
#define MX51_PAD_EIM_D23__AUD4_TXFS			0x078 0x40c 0x8d0 0x5 0x0
#define MX51_PAD_EIM_D23__EIM_D23			0x078 0x40c 0x000 0x0 0x0
#define MX51_PAD_EIM_D23__GPIO2_7			0x078 0x40c 0x000 0x1 0x0
#define MX51_PAD_EIM_D23__SPDIF_OUT1			0x078 0x40c 0x000 0x4 0x0
#define MX51_PAD_EIM_D23__USBH2_DATA7			0x078 0x40c 0x000 0x2 0x0
#define MX51_PAD_EIM_D24__AUD6_RXFS			0x07c 0x410 0x8f8 0x5 0x0
#define MX51_PAD_EIM_D24__EIM_D24			0x07c 0x410 0x000 0x0 0x0
#define MX51_PAD_EIM_D24__GPIO2_8			0x07c 0x410 0x000 0x1 0x0
#define MX51_PAD_EIM_D24__I2C2_SDA			0x07c 0x410 0x9bc 0x4 0x0
#define MX51_PAD_EIM_D24__UART3_CTS			0x07c 0x410 0x000 0x3 0x0
#define MX51_PAD_EIM_D24__USBOTG_DATA0			0x07c 0x410 0x000 0x2 0x0
#define MX51_PAD_EIM_D25__EIM_D25			0x080 0x414 0x000 0x0 0x0
#define MX51_PAD_EIM_D25__KEY_COL6			0x080 0x414 0x9c8 0x1 0x0
#define MX51_PAD_EIM_D25__UART2_CTS			0x080 0x414 0x000 0x4 0x0
#define MX51_PAD_EIM_D25__UART3_RXD			0x080 0x414 0x9f4 0x3 0x0
#define MX51_PAD_EIM_D25__USBOTG_DATA1			0x080 0x414 0x000 0x2 0x0
#define MX51_PAD_EIM_D26__EIM_D26			0x084 0x418 0x000 0x0 0x0
#define MX51_PAD_EIM_D26__KEY_COL7			0x084 0x418 0x9cc 0x1 0x0
#define MX51_PAD_EIM_D26__UART2_RTS			0x084 0x418 0x9e8 0x4 0x3
#define MX51_PAD_EIM_D26__UART3_TXD			0x084 0x418 0x000 0x3 0x0
#define MX51_PAD_EIM_D26__USBOTG_DATA2			0x084 0x418 0x000 0x2 0x0
#define MX51_PAD_EIM_D27__AUD6_RXC			0x088 0x41c 0x8f4 0x5 0x0
#define MX51_PAD_EIM_D27__EIM_D27			0x088 0x41c 0x000 0x0 0x0
#define MX51_PAD_EIM_D27__GPIO2_9			0x088 0x41c 0x000 0x1 0x0
#define MX51_PAD_EIM_D27__I2C2_SCL			0x088 0x41c 0x9b8 0x4 0x0
#define MX51_PAD_EIM_D27__UART3_RTS			0x088 0x41c 0x9f0 0x3 0x3
#define MX51_PAD_EIM_D27__USBOTG_DATA3			0x088 0x41c 0x000 0x2 0x0
#define MX51_PAD_EIM_D28__AUD6_TXD			0x08c 0x420 0x8f0 0x5 0x0
#define MX51_PAD_EIM_D28__EIM_D28			0x08c 0x420 0x000 0x0 0x0
#define MX51_PAD_EIM_D28__KEY_ROW4			0x08c 0x420 0x9d0 0x1 0x0
#define MX51_PAD_EIM_D28__USBOTG_DATA4			0x08c 0x420 0x000 0x2 0x0
#define MX51_PAD_EIM_D29__AUD6_RXD			0x090 0x424 0x8ec 0x5 0x0
#define MX51_PAD_EIM_D29__EIM_D29			0x090 0x424 0x000 0x0 0x0
#define MX51_PAD_EIM_D29__KEY_ROW5			0x090 0x424 0x9d4 0x1 0x0
#define MX51_PAD_EIM_D29__USBOTG_DATA5			0x090 0x424 0x000 0x2 0x0
#define MX51_PAD_EIM_D30__AUD6_TXC			0x094 0x428 0x8fc 0x5 0x0
#define MX51_PAD_EIM_D30__EIM_D30			0x094 0x428 0x000 0x0 0x0
#define MX51_PAD_EIM_D30__KEY_ROW6			0x094 0x428 0x9d8 0x1 0x0
#define MX51_PAD_EIM_D30__USBOTG_DATA6			0x094 0x428 0x000 0x2 0x0
#define MX51_PAD_EIM_D31__AUD6_TXFS			0x098 0x42c 0x900 0x5 0x0
#define MX51_PAD_EIM_D31__EIM_D31			0x098 0x42c 0x000 0x0 0x0
#define MX51_PAD_EIM_D31__KEY_ROW7			0x098 0x42c 0x9dc 0x1 0x0
#define MX51_PAD_EIM_D31__USBOTG_DATA7			0x098 0x42c 0x000 0x2 0x0
#define MX51_PAD_EIM_A16__EIM_A16			0x09c 0x430 0x000 0x0 0x0
#define MX51_PAD_EIM_A16__GPIO2_10			0x09c 0x430 0x000 0x1 0x0
#define MX51_PAD_EIM_A16__OSC_FREQ_SEL0			0x09c 0x430 0x000 0x7 0x0
#define MX51_PAD_EIM_A17__EIM_A17			0x0a0 0x434 0x000 0x0 0x0
#define MX51_PAD_EIM_A17__GPIO2_11			0x0a0 0x434 0x000 0x1 0x0
#define MX51_PAD_EIM_A17__OSC_FREQ_SEL1			0x0a0 0x434 0x000 0x7 0x0
#define MX51_PAD_EIM_A18__BOOT_LPB0			0x0a4 0x438 0x000 0x7 0x0
#define MX51_PAD_EIM_A18__EIM_A18			0x0a4 0x438 0x000 0x0 0x0
#define MX51_PAD_EIM_A18__GPIO2_12			0x0a4 0x438 0x000 0x1 0x0
#define MX51_PAD_EIM_A19__BOOT_LPB1			0x0a8 0x43c 0x000 0x7 0x0
#define MX51_PAD_EIM_A19__EIM_A19			0x0a8 0x43c 0x000 0x0 0x0
#define MX51_PAD_EIM_A19__GPIO2_13			0x0a8 0x43c 0x000 0x1 0x0
#define MX51_PAD_EIM_A20__BOOT_UART_SRC0		0x0ac 0x440 0x000 0x7 0x0
#define MX51_PAD_EIM_A20__EIM_A20			0x0ac 0x440 0x000 0x0 0x0
#define MX51_PAD_EIM_A20__GPIO2_14			0x0ac 0x440 0x000 0x1 0x0
#define MX51_PAD_EIM_A21__BOOT_UART_SRC1		0x0b0 0x444 0x000 0x7 0x0
#define MX51_PAD_EIM_A21__EIM_A21			0x0b0 0x444 0x000 0x0 0x0
#define MX51_PAD_EIM_A21__GPIO2_15			0x0b0 0x444 0x000 0x1 0x0
#define MX51_PAD_EIM_A22__EIM_A22			0x0b4 0x448 0x000 0x0 0x0
#define MX51_PAD_EIM_A22__GPIO2_16			0x0b4 0x448 0x000 0x1 0x0
#define MX51_PAD_EIM_A23__BOOT_HPN_EN			0x0b8 0x44c 0x000 0x7 0x0
#define MX51_PAD_EIM_A23__EIM_A23			0x0b8 0x44c 0x000 0x0 0x0
#define MX51_PAD_EIM_A23__GPIO2_17			0x0b8 0x44c 0x000 0x1 0x0
#define MX51_PAD_EIM_A24__EIM_A24			0x0bc 0x450 0x000 0x0 0x0
#define MX51_PAD_EIM_A24__GPIO2_18			0x0bc 0x450 0x000 0x1 0x0
#define MX51_PAD_EIM_A24__USBH2_CLK			0x0bc 0x450 0x000 0x2 0x0
#define MX51_PAD_EIM_A25__DISP1_PIN4			0x0c0 0x454 0x000 0x6 0x0
#define MX51_PAD_EIM_A25__EIM_A25			0x0c0 0x454 0x000 0x0 0x0
#define MX51_PAD_EIM_A25__GPIO2_19			0x0c0 0x454 0x000 0x1 0x0
#define MX51_PAD_EIM_A25__USBH2_DIR			0x0c0 0x454 0x000 0x2 0x0
#define MX51_PAD_EIM_A26__CSI1_DATA_EN			0x0c4 0x458 0x9a0 0x5 0x0
#define MX51_PAD_EIM_A26__DISP2_EXT_CLK			0x0c4 0x458 0x908 0x6 0x0
#define MX51_PAD_EIM_A26__EIM_A26			0x0c4 0x458 0x000 0x0 0x0
#define MX51_PAD_EIM_A26__GPIO2_20			0x0c4 0x458 0x000 0x1 0x0
#define MX51_PAD_EIM_A26__USBH2_STP			0x0c4 0x458 0x000 0x2 0x0
#define MX51_PAD_EIM_A27__CSI2_DATA_EN			0x0c8 0x45c 0x99c 0x5 0x0
#define MX51_PAD_EIM_A27__DISP1_PIN1			0x0c8 0x45c 0x9a4 0x6 0x0
#define MX51_PAD_EIM_A27__EIM_A27			0x0c8 0x45c 0x000 0x0 0x0
#define MX51_PAD_EIM_A27__GPIO2_21			0x0c8 0x45c 0x000 0x1 0x0
#define MX51_PAD_EIM_A27__USBH2_NXT			0x0c8 0x45c 0x000 0x2 0x0
#define MX51_PAD_EIM_EB0__EIM_EB0			0x0cc 0x460 0x000 0x0 0x0
#define MX51_PAD_EIM_EB1__EIM_EB1			0x0d0 0x464 0x000 0x0 0x0
#define MX51_PAD_EIM_EB2__AUD5_RXFS			0x0d4 0x468 0x8e0 0x6 0x0
#define MX51_PAD_EIM_EB2__CSI1_D2			0x0d4 0x468 0x000 0x5 0x0
#define MX51_PAD_EIM_EB2__EIM_EB2			0x0d4 0x468 0x000 0x0 0x0
#define MX51_PAD_EIM_EB2__FEC_MDIO			0x0d4 0x468 0x954 0x3 0x0
#define MX51_PAD_EIM_EB2__GPIO2_22			0x0d4 0x468 0x000 0x1 0x0
#define MX51_PAD_EIM_EB2__GPT_CMPOUT1			0x0d4 0x468 0x000 0x7 0x0
#define MX51_PAD_EIM_EB3__AUD5_RXC			0x0d8 0x46c 0x8dc 0x6 0x0
#define MX51_PAD_EIM_EB3__CSI1_D3			0x0d8 0x46c 0x000 0x5 0x0
#define MX51_PAD_EIM_EB3__EIM_EB3			0x0d8 0x46c 0x000 0x0 0x0
#define MX51_PAD_EIM_EB3__FEC_RDATA1			0x0d8 0x46c 0x95c 0x3 0x0
#define MX51_PAD_EIM_EB3__GPIO2_23			0x0d8 0x46c 0x000 0x1 0x0
#define MX51_PAD_EIM_EB3__GPT_CMPOUT2			0x0d8 0x46c 0x000 0x7 0x0
#define MX51_PAD_EIM_OE__EIM_OE				0x0dc 0x470 0x000 0x0 0x0
#define MX51_PAD_EIM_OE__GPIO2_24			0x0dc 0x470 0x000 0x1 0x0
#define MX51_PAD_EIM_CS0__EIM_CS0			0x0e0 0x474 0x000 0x0 0x0
#define MX51_PAD_EIM_CS0__GPIO2_25			0x0e0 0x474 0x000 0x1 0x0
#define MX51_PAD_EIM_CS1__EIM_CS1			0x0e4 0x478 0x000 0x0 0x0
#define MX51_PAD_EIM_CS1__GPIO2_26			0x0e4 0x478 0x000 0x1 0x0
#define MX51_PAD_EIM_CS2__AUD5_TXD			0x0e8 0x47c 0x8d8 0x6 0x1
#define MX51_PAD_EIM_CS2__CSI1_D4			0x0e8 0x47c 0x000 0x5 0x0
#define MX51_PAD_EIM_CS2__EIM_CS2			0x0e8 0x47c 0x000 0x0 0x0
#define MX51_PAD_EIM_CS2__FEC_RDATA2			0x0e8 0x47c 0x960 0x3 0x0
#define MX51_PAD_EIM_CS2__GPIO2_27			0x0e8 0x47c 0x000 0x1 0x0
#define MX51_PAD_EIM_CS2__USBOTG_STP			0x0e8 0x47c 0x000 0x2 0x0
#define MX51_PAD_EIM_CS3__AUD5_RXD			0x0ec 0x480 0x8d4 0x6 0x1
#define MX51_PAD_EIM_CS3__CSI1_D5			0x0ec 0x480 0x000 0x5 0x0
#define MX51_PAD_EIM_CS3__EIM_CS3			0x0ec 0x480 0x000 0x0 0x0
#define MX51_PAD_EIM_CS3__FEC_RDATA3			0x0ec 0x480 0x964 0x3 0x0
#define MX51_PAD_EIM_CS3__GPIO2_28			0x0ec 0x480 0x000 0x1 0x0
#define MX51_PAD_EIM_CS3__USBOTG_NXT			0x0ec 0x480 0x000 0x2 0x0
#define MX51_PAD_EIM_CS4__AUD5_TXC			0x0f0 0x484 0x8e4 0x6 0x1
#define MX51_PAD_EIM_CS4__CSI1_D6			0x0f0 0x484 0x000 0x5 0x0
#define MX51_PAD_EIM_CS4__EIM_CS4			0x0f0 0x484 0x000 0x0 0x0
#define MX51_PAD_EIM_CS4__FEC_RX_ER			0x0f0 0x484 0x970 0x3 0x0
#define MX51_PAD_EIM_CS4__GPIO2_29			0x0f0 0x484 0x000 0x1 0x0
#define MX51_PAD_EIM_CS4__USBOTG_CLK			0x0f0 0x484 0x000 0x2 0x0
#define MX51_PAD_EIM_CS5__AUD5_TXFS			0x0f4 0x488 0x8e8 0x6 0x1
#define MX51_PAD_EIM_CS5__CSI1_D7			0x0f4 0x488 0x000 0x5 0x0
#define MX51_PAD_EIM_CS5__DISP1_EXT_CLK			0x0f4 0x488 0x904 0x4 0x0
#define MX51_PAD_EIM_CS5__EIM_CS5			0x0f4 0x488 0x000 0x0 0x0
#define MX51_PAD_EIM_CS5__FEC_CRS			0x0f4 0x488 0x950 0x3 0x0
#define MX51_PAD_EIM_CS5__GPIO2_30			0x0f4 0x488 0x000 0x1 0x0
#define MX51_PAD_EIM_CS5__USBOTG_DIR			0x0f4 0x488 0x000 0x2 0x0
#define MX51_PAD_EIM_DTACK__EIM_DTACK			0x0f8 0x48c 0x000 0x0 0x0
#define MX51_PAD_EIM_DTACK__GPIO2_31			0x0f8 0x48c 0x000 0x1 0x0
#define MX51_PAD_EIM_LBA__EIM_LBA			0x0fc 0x494 0x000 0x0 0x0
#define MX51_PAD_EIM_LBA__GPIO3_1			0x0fc 0x494 0x978 0x1 0x0
#define MX51_PAD_EIM_CRE__EIM_CRE			0x100 0x4a0 0x000 0x0 0x0
#define MX51_PAD_EIM_CRE__GPIO3_2			0x100 0x4a0 0x97c 0x1 0x0
#define MX51_PAD_DRAM_CS1__DRAM_CS1			0x104 0x4d0 0x000 0x0 0x0
#define MX51_PAD_NANDF_WE_B__GPIO3_3			0x108 0x4e4 0x980 0x3 0x0
#define MX51_PAD_NANDF_WE_B__NANDF_WE_B			0x108 0x4e4 0x000 0x0 0x0
#define MX51_PAD_NANDF_WE_B__PATA_DIOW			0x108 0x4e4 0x000 0x1 0x0
#define MX51_PAD_NANDF_WE_B__SD3_DATA0			0x108 0x4e4 0x93c 0x2 0x0
#define MX51_PAD_NANDF_RE_B__GPIO3_4			0x10c 0x4e8 0x984 0x3 0x0
#define MX51_PAD_NANDF_RE_B__NANDF_RE_B			0x10c 0x4e8 0x000 0x0 0x0
#define MX51_PAD_NANDF_RE_B__PATA_DIOR			0x10c 0x4e8 0x000 0x1 0x0
#define MX51_PAD_NANDF_RE_B__SD3_DATA1			0x10c 0x4e8 0x940 0x2 0x0
#define MX51_PAD_NANDF_ALE__GPIO3_5			0x110 0x4ec 0x988 0x3 0x0
#define MX51_PAD_NANDF_ALE__NANDF_ALE			0x110 0x4ec 0x000 0x0 0x0
#define MX51_PAD_NANDF_ALE__PATA_BUFFER_EN		0x110 0x4ec 0x000 0x1 0x0
#define MX51_PAD_NANDF_CLE__GPIO3_6			0x114 0x4f0 0x98c 0x3 0x0
#define MX51_PAD_NANDF_CLE__NANDF_CLE			0x114 0x4f0 0x000 0x0 0x0
#define MX51_PAD_NANDF_CLE__PATA_RESET_B		0x114 0x4f0 0x000 0x1 0x0
#define MX51_PAD_NANDF_WP_B__GPIO3_7			0x118 0x4f4 0x990 0x3 0x0
#define MX51_PAD_NANDF_WP_B__NANDF_WP_B			0x118 0x4f4 0x000 0x0 0x0
#define MX51_PAD_NANDF_WP_B__PATA_DMACK			0x118 0x4f4 0x000 0x1 0x0
#define MX51_PAD_NANDF_WP_B__SD3_DATA2			0x118 0x4f4 0x944 0x2 0x0
#define MX51_PAD_NANDF_RB0__ECSPI2_SS1			0x11c 0x4f8 0x930 0x5 0x0
#define MX51_PAD_NANDF_RB0__GPIO3_8			0x11c 0x4f8 0x994 0x3 0x0
#define MX51_PAD_NANDF_RB0__NANDF_RB0			0x11c 0x4f8 0x000 0x0 0x0
#define MX51_PAD_NANDF_RB0__PATA_DMARQ			0x11c 0x4f8 0x000 0x1 0x0
#define MX51_PAD_NANDF_RB0__SD3_DATA3			0x11c 0x4f8 0x948 0x2 0x0
#define MX51_PAD_NANDF_RB1__CSPI_MOSI			0x120 0x4fc 0x91c 0x6 0x0
#define MX51_PAD_NANDF_RB1__ECSPI2_RDY			0x120 0x4fc 0x000 0x2 0x0
#define MX51_PAD_NANDF_RB1__GPIO3_9			0x120 0x4fc 0x000 0x3 0x0
#define MX51_PAD_NANDF_RB1__NANDF_RB1			0x120 0x4fc 0x000 0x0 0x0
#define MX51_PAD_NANDF_RB1__PATA_IORDY			0x120 0x4fc 0x000 0x1 0x0
#define MX51_PAD_NANDF_RB1__SD4_CMD			0x120 0x4fc 0x000 0x5 0x0
#define MX51_PAD_NANDF_RB2__DISP2_WAIT			0x124 0x500 0x9a8 0x5 0x0
#define MX51_PAD_NANDF_RB2__ECSPI2_SCLK			0x124 0x500 0x000 0x2 0x0
#define MX51_PAD_NANDF_RB2__FEC_COL			0x124 0x500 0x94c 0x1 0x0
#define MX51_PAD_NANDF_RB2__GPIO3_10			0x124 0x500 0x000 0x3 0x0
#define MX51_PAD_NANDF_RB2__NANDF_RB2			0x124 0x500 0x000 0x0 0x0
#define MX51_PAD_NANDF_RB2__USBH3_H3_DP			0x124 0x500 0x000 0x7 0x0
#define MX51_PAD_NANDF_RB2__USBH3_NXT			0x124 0x500 0xa20 0x6 0x0
#define MX51_PAD_NANDF_RB3__DISP1_WAIT			0x128 0x504 0x000 0x5 0x0
#define MX51_PAD_NANDF_RB3__ECSPI2_MISO			0x128 0x504 0x000 0x2 0x0
#define MX51_PAD_NANDF_RB3__FEC_RX_CLK			0x128 0x504 0x968 0x1 0x0
#define MX51_PAD_NANDF_RB3__GPIO3_11			0x128 0x504 0x000 0x3 0x0
#define MX51_PAD_NANDF_RB3__NANDF_RB3			0x128 0x504 0x000 0x0 0x0
#define MX51_PAD_NANDF_RB3__USBH3_CLK			0x128 0x504 0x9f8 0x6 0x0
#define MX51_PAD_NANDF_RB3__USBH3_H3_DM			0x128 0x504 0x000 0x7 0x0
#define MX51_PAD_GPIO_NAND__GPIO_NAND			0x12c 0x514 0x998 0x0 0x0
#define MX51_PAD_GPIO_NAND__PATA_INTRQ			0x12c 0x514 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS0__GPIO3_16			0x130 0x518 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS0__NANDF_CS0			0x130 0x518 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS1__GPIO3_17			0x134 0x51c 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS1__NANDF_CS1			0x134 0x51c 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS2__CSPI_SCLK			0x138 0x520 0x914 0x6 0x0
#define MX51_PAD_NANDF_CS2__FEC_TX_ER			0x138 0x520 0x000 0x2 0x0
#define MX51_PAD_NANDF_CS2__GPIO3_18			0x138 0x520 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS2__NANDF_CS2			0x138 0x520 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS2__PATA_CS_0			0x138 0x520 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS2__SD4_CLK			0x138 0x520 0x000 0x5 0x0
#define MX51_PAD_NANDF_CS2__USBH3_H1_DP			0x138 0x520 0x000 0x7 0x0
#define MX51_PAD_NANDF_CS3__FEC_MDC			0x13c 0x524 0x000 0x2 0x0
#define MX51_PAD_NANDF_CS3__GPIO3_19			0x13c 0x524 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS3__NANDF_CS3			0x13c 0x524 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS3__PATA_CS_1			0x13c 0x524 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS3__SD4_DAT0			0x13c 0x524 0x000 0x5 0x0
#define MX51_PAD_NANDF_CS3__USBH3_H1_DM			0x13c 0x524 0x000 0x7 0x0
#define MX51_PAD_NANDF_CS4__FEC_TDATA1			0x140 0x528 0x000 0x2 0x0
#define MX51_PAD_NANDF_CS4__GPIO3_20			0x140 0x528 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS4__NANDF_CS4			0x140 0x528 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS4__PATA_DA_0			0x140 0x528 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS4__SD4_DAT1			0x140 0x528 0x000 0x5 0x0
#define MX51_PAD_NANDF_CS4__USBH3_STP			0x140 0x528 0xa24 0x7 0x0
#define MX51_PAD_NANDF_CS5__FEC_TDATA2			0x144 0x52c 0x000 0x2 0x0
#define MX51_PAD_NANDF_CS5__GPIO3_21			0x144 0x52c 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS5__NANDF_CS5			0x144 0x52c 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS5__PATA_DA_1			0x144 0x52c 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS5__SD4_DAT2			0x144 0x52c 0x000 0x5 0x0
#define MX51_PAD_NANDF_CS5__USBH3_DIR			0x144 0x52c 0xa1c 0x7 0x0
#define MX51_PAD_NANDF_CS6__CSPI_SS3			0x148 0x530 0x928 0x7 0x0
#define MX51_PAD_NANDF_CS6__FEC_TDATA3			0x148 0x530 0x000 0x2 0x0
#define MX51_PAD_NANDF_CS6__GPIO3_22			0x148 0x530 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS6__NANDF_CS6			0x148 0x530 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS6__PATA_DA_2			0x148 0x530 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS6__SD4_DAT3			0x148 0x530 0x000 0x5 0x0
#define MX51_PAD_NANDF_CS7__FEC_TX_EN			0x14c 0x534 0x000 0x1 0x0
#define MX51_PAD_NANDF_CS7__GPIO3_23			0x14c 0x534 0x000 0x3 0x0
#define MX51_PAD_NANDF_CS7__NANDF_CS7			0x14c 0x534 0x000 0x0 0x0
#define MX51_PAD_NANDF_CS7__SD3_CLK			0x14c 0x534 0x000 0x5 0x0
#define MX51_PAD_NANDF_RDY_INT__ECSPI2_SS0		0x150 0x538 0x000 0x2 0x0
#define MX51_PAD_NANDF_RDY_INT__FEC_TX_CLK		0x150 0x538 0x974 0x1 0x0
#define MX51_PAD_NANDF_RDY_INT__GPIO3_24		0x150 0x538 0x000 0x3 0x0
#define MX51_PAD_NANDF_RDY_INT__NANDF_RDY_INT		0x150 0x538 0x938 0x0 0x0
#define MX51_PAD_NANDF_RDY_INT__SD3_CMD			0x150 0x538 0x000 0x5 0x0
#define MX51_PAD_NANDF_D15__ECSPI2_MOSI			0x154 0x53c 0x000 0x2 0x0
#define MX51_PAD_NANDF_D15__GPIO3_25			0x154 0x53c 0x000 0x3 0x0
#define MX51_PAD_NANDF_D15__NANDF_D15			0x154 0x53c 0x000 0x0 0x0
#define MX51_PAD_NANDF_D15__PATA_DATA15			0x154 0x53c 0x000 0x1 0x0
#define MX51_PAD_NANDF_D15__SD3_DAT7			0x154 0x53c 0x000 0x5 0x0
#define MX51_PAD_NANDF_D14__ECSPI2_SS3			0x158 0x540 0x934 0x2 0x0
#define MX51_PAD_NANDF_D14__GPIO3_26			0x158 0x540 0x000 0x3 0x0
#define MX51_PAD_NANDF_D14__NANDF_D14			0x158 0x540 0x000 0x0 0x0
#define MX51_PAD_NANDF_D14__PATA_DATA14			0x158 0x540 0x000 0x1 0x0
#define MX51_PAD_NANDF_D14__SD3_DAT6			0x158 0x540 0x000 0x5 0x0
#define MX51_PAD_NANDF_D13__ECSPI2_SS2			0x15c 0x544 0x000 0x2 0x0
#define MX51_PAD_NANDF_D13__GPIO3_27			0x15c 0x544 0x000 0x3 0x0
#define MX51_PAD_NANDF_D13__NANDF_D13			0x15c 0x544 0x000 0x0 0x0
#define MX51_PAD_NANDF_D13__PATA_DATA13			0x15c 0x544 0x000 0x1 0x0
#define MX51_PAD_NANDF_D13__SD3_DAT5			0x15c 0x544 0x000 0x5 0x0
#define MX51_PAD_NANDF_D12__ECSPI2_SS1			0x160 0x548 0x930 0x2 0x1
#define MX51_PAD_NANDF_D12__GPIO3_28			0x160 0x548 0x000 0x3 0x0
#define MX51_PAD_NANDF_D12__NANDF_D12			0x160 0x548 0x000 0x0 0x0
#define MX51_PAD_NANDF_D12__PATA_DATA12			0x160 0x548 0x000 0x1 0x0
#define MX51_PAD_NANDF_D12__SD3_DAT4			0x160 0x548 0x000 0x5 0x0
#define MX51_PAD_NANDF_D11__FEC_RX_DV			0x164 0x54c 0x96c 0x2 0x0
#define MX51_PAD_NANDF_D11__GPIO3_29			0x164 0x54c 0x000 0x3 0x0
#define MX51_PAD_NANDF_D11__NANDF_D11			0x164 0x54c 0x000 0x0 0x0
#define MX51_PAD_NANDF_D11__PATA_DATA11			0x164 0x54c 0x000 0x1 0x0
#define MX51_PAD_NANDF_D11__SD3_DATA3			0x164 0x54c 0x948 0x5 0x1
#define MX51_PAD_NANDF_D10__GPIO3_30			0x168 0x550 0x000 0x3 0x0
#define MX51_PAD_NANDF_D10__NANDF_D10			0x168 0x550 0x000 0x0 0x0
#define MX51_PAD_NANDF_D10__PATA_DATA10			0x168 0x550 0x000 0x1 0x0
#define MX51_PAD_NANDF_D10__SD3_DATA2			0x168 0x550 0x944 0x5 0x1
#define MX51_PAD_NANDF_D9__FEC_RDATA0			0x16c 0x554 0x958 0x2 0x0
#define MX51_PAD_NANDF_D9__GPIO3_31			0x16c 0x554 0x000 0x3 0x0
#define MX51_PAD_NANDF_D9__NANDF_D9			0x16c 0x554 0x000 0x0 0x0
#define MX51_PAD_NANDF_D9__PATA_DATA9			0x16c 0x554 0x000 0x1 0x0
#define MX51_PAD_NANDF_D9__SD3_DATA1			0x16c 0x554 0x940 0x5 0x1
#define MX51_PAD_NANDF_D8__FEC_TDATA0			0x170 0x558 0x000 0x2 0x0
#define MX51_PAD_NANDF_D8__GPIO4_0			0x170 0x558 0x000 0x3 0x0
#define MX51_PAD_NANDF_D8__NANDF_D8			0x170 0x558 0x000 0x0 0x0
#define MX51_PAD_NANDF_D8__PATA_DATA8			0x170 0x558 0x000 0x1 0x0
#define MX51_PAD_NANDF_D8__SD3_DATA0			0x170 0x558 0x93c 0x5 0x1
#define MX51_PAD_NANDF_D7__GPIO4_1			0x174 0x55c 0x000 0x3 0x0
#define MX51_PAD_NANDF_D7__NANDF_D7			0x174 0x55c 0x000 0x0 0x0
#define MX51_PAD_NANDF_D7__PATA_DATA7			0x174 0x55c 0x000 0x1 0x0
#define MX51_PAD_NANDF_D7__USBH3_DATA0			0x174 0x55c 0x9fc 0x5 0x0
#define MX51_PAD_NANDF_D6__GPIO4_2			0x178 0x560 0x000 0x3 0x0
#define MX51_PAD_NANDF_D6__NANDF_D6			0x178 0x560 0x000 0x0 0x0
#define MX51_PAD_NANDF_D6__PATA_DATA6			0x178 0x560 0x000 0x1 0x0
#define MX51_PAD_NANDF_D6__SD4_LCTL			0x178 0x560 0x000 0x2 0x0
#define MX51_PAD_NANDF_D6__USBH3_DATA1			0x178 0x560 0xa00 0x5 0x0
#define MX51_PAD_NANDF_D5__GPIO4_3			0x17c 0x564 0x000 0x3 0x0
#define MX51_PAD_NANDF_D5__NANDF_D5			0x17c 0x564 0x000 0x0 0x0
#define MX51_PAD_NANDF_D5__PATA_DATA5			0x17c 0x564 0x000 0x1 0x0
#define MX51_PAD_NANDF_D5__SD4_WP			0x17c 0x564 0x000 0x2 0x0
#define MX51_PAD_NANDF_D5__USBH3_DATA2			0x17c 0x564 0xa04 0x5 0x0
#define MX51_PAD_NANDF_D4__GPIO4_4			0x180 0x568 0x000 0x3 0x0
#define MX51_PAD_NANDF_D4__NANDF_D4			0x180 0x568 0x000 0x0 0x0
#define MX51_PAD_NANDF_D4__PATA_DATA4			0x180 0x568 0x000 0x1 0x0
#define MX51_PAD_NANDF_D4__SD4_CD			0x180 0x568 0x000 0x2 0x0
#define MX51_PAD_NANDF_D4__USBH3_DATA3			0x180 0x568 0xa08 0x5 0x0
#define MX51_PAD_NANDF_D3__GPIO4_5			0x184 0x56c 0x000 0x3 0x0
#define MX51_PAD_NANDF_D3__NANDF_D3			0x184 0x56c 0x000 0x0 0x0
#define MX51_PAD_NANDF_D3__PATA_DATA3			0x184 0x56c 0x000 0x1 0x0
#define MX51_PAD_NANDF_D3__SD4_DAT4			0x184 0x56c 0x000 0x2 0x0
#define MX51_PAD_NANDF_D3__USBH3_DATA4			0x184 0x56c 0xa0c 0x5 0x0
#define MX51_PAD_NANDF_D2__GPIO4_6			0x188 0x570 0x000 0x3 0x0
#define MX51_PAD_NANDF_D2__NANDF_D2			0x188 0x570 0x000 0x0 0x0
#define MX51_PAD_NANDF_D2__PATA_DATA2			0x188 0x570 0x000 0x1 0x0
#define MX51_PAD_NANDF_D2__SD4_DAT5			0x188 0x570 0x000 0x2 0x0
#define MX51_PAD_NANDF_D2__USBH3_DATA5			0x188 0x570 0xa10 0x5 0x0
#define MX51_PAD_NANDF_D1__GPIO4_7			0x18c 0x574 0x000 0x3 0x0
#define MX51_PAD_NANDF_D1__NANDF_D1			0x18c 0x574 0x000 0x0 0x0
#define MX51_PAD_NANDF_D1__PATA_DATA1			0x18c 0x574 0x000 0x1 0x0
#define MX51_PAD_NANDF_D1__SD4_DAT6			0x18c 0x574 0x000 0x2 0x0
#define MX51_PAD_NANDF_D1__USBH3_DATA6			0x18c 0x574 0xa14 0x5 0x0
#define MX51_PAD_NANDF_D0__GPIO4_8			0x190 0x578 0x000 0x3 0x0
#define MX51_PAD_NANDF_D0__NANDF_D0			0x190 0x578 0x000 0x0 0x0
#define MX51_PAD_NANDF_D0__PATA_DATA0			0x190 0x578 0x000 0x1 0x0
#define MX51_PAD_NANDF_D0__SD4_DAT7			0x190 0x578 0x000 0x2 0x0
#define MX51_PAD_NANDF_D0__USBH3_DATA7			0x190 0x578 0xa18 0x5 0x0
#define MX51_PAD_CSI1_D8__CSI1_D8			0x194 0x57c 0x000 0x0 0x0
#define MX51_PAD_CSI1_D8__GPIO3_12			0x194 0x57c 0x998 0x3 0x1
#define MX51_PAD_CSI1_D9__CSI1_D9			0x198 0x580 0x000 0x0 0x0
#define MX51_PAD_CSI1_D9__GPIO3_13			0x198 0x580 0x000 0x3 0x0
#define MX51_PAD_CSI1_D10__CSI1_D10			0x19c 0x584 0x000 0x0 0x0
#define MX51_PAD_CSI1_D11__CSI1_D11			0x1a0 0x588 0x000 0x0 0x0
#define MX51_PAD_CSI1_D12__CSI1_D12			0x1a4 0x58c 0x000 0x0 0x0
#define MX51_PAD_CSI1_D13__CSI1_D13			0x1a8 0x590 0x000 0x0 0x0
#define MX51_PAD_CSI1_D14__CSI1_D14			0x1ac 0x594 0x000 0x0 0x0
#define MX51_PAD_CSI1_D15__CSI1_D15			0x1b0 0x598 0x000 0x0 0x0
#define MX51_PAD_CSI1_D16__CSI1_D16			0x1b4 0x59c 0x000 0x0 0x0
#define MX51_PAD_CSI1_D17__CSI1_D17			0x1b8 0x5a0 0x000 0x0 0x0
#define MX51_PAD_CSI1_D18__CSI1_D18			0x1bc 0x5a4 0x000 0x0 0x0
#define MX51_PAD_CSI1_D19__CSI1_D19			0x1c0 0x5a8 0x000 0x0 0x0
#define MX51_PAD_CSI1_VSYNC__CSI1_VSYNC			0x1c4 0x5ac 0x000 0x0 0x0
#define MX51_PAD_CSI1_VSYNC__GPIO3_14			0x1c4 0x5ac 0x000 0x3 0x0
#define MX51_PAD_CSI1_HSYNC__CSI1_HSYNC			0x1c8 0x5b0 0x000 0x0 0x0
#define MX51_PAD_CSI1_HSYNC__GPIO3_15			0x1c8 0x5b0 0x000 0x3 0x0
#define MX51_PAD_CSI1_PIXCLK__CSI1_PIXCLK		0x000 0x5b4 0x000 0x0 0x0
#define MX51_PAD_CSI1_MCLK__CSI1_MCLK			0x000 0x5b8 0x000 0x0 0x0
#define MX51_PAD_CSI2_D12__CSI2_D12			0x1cc 0x5bc 0x000 0x0 0x0
#define MX51_PAD_CSI2_D12__GPIO4_9			0x1cc 0x5bc 0x000 0x3 0x0
#define MX51_PAD_CSI2_D13__CSI2_D13			0x1d0 0x5c0 0x000 0x0 0x0
#define MX51_PAD_CSI2_D13__GPIO4_10			0x1d0 0x5c0 0x000 0x3 0x0
#define MX51_PAD_CSI2_D14__CSI2_D14			0x1d4 0x5c4 0x000 0x0 0x0
#define MX51_PAD_CSI2_D15__CSI2_D15			0x1d8 0x5c8 0x000 0x0 0x0
#define MX51_PAD_CSI2_D16__CSI2_D16			0x1dc 0x5cc 0x000 0x0 0x0
#define MX51_PAD_CSI2_D17__CSI2_D17			0x1e0 0x5d0 0x000 0x0 0x0
#define MX51_PAD_CSI2_D18__CSI2_D18			0x1e4 0x5d4 0x000 0x0 0x0
#define MX51_PAD_CSI2_D18__GPIO4_11			0x1e4 0x5d4 0x000 0x3 0x0
#define MX51_PAD_CSI2_D19__CSI2_D19			0x1e8 0x5d8 0x000 0x0 0x0
#define MX51_PAD_CSI2_D19__GPIO4_12			0x1e8 0x5d8 0x000 0x3 0x0
#define MX51_PAD_CSI2_VSYNC__CSI2_VSYNC			0x1ec 0x5dc 0x000 0x0 0x0
#define MX51_PAD_CSI2_VSYNC__GPIO4_13			0x1ec 0x5dc 0x000 0x3 0x0
#define MX51_PAD_CSI2_HSYNC__CSI2_HSYNC			0x1f0 0x5e0 0x000 0x0 0x0
#define MX51_PAD_CSI2_HSYNC__GPIO4_14			0x1f0 0x5e0 0x000 0x3 0x0
#define MX51_PAD_CSI2_PIXCLK__CSI2_PIXCLK		0x1f4 0x5e4 0x000 0x0 0x0
#define MX51_PAD_CSI2_PIXCLK__GPIO4_15			0x1f4 0x5e4 0x000 0x3 0x0
#define MX51_PAD_I2C1_CLK__GPIO4_16			0x1f8 0x5e8 0x000 0x3 0x0
#define MX51_PAD_I2C1_CLK__I2C1_CLK			0x1f8 0x5e8 0x000 0x0 0x0
#define MX51_PAD_I2C1_DAT__GPIO4_17			0x1fc 0x5ec 0x000 0x3 0x0
#define MX51_PAD_I2C1_DAT__I2C1_DAT			0x1fc 0x5ec 0x000 0x0 0x0
#define MX51_PAD_AUD3_BB_TXD__AUD3_TXD			0x200 0x5f0 0x000 0x0 0x0
#define MX51_PAD_AUD3_BB_TXD__GPIO4_18			0x200 0x5f0 0x000 0x3 0x0
#define MX51_PAD_AUD3_BB_RXD__AUD3_RXD			0x204 0x5f4 0x000 0x0 0x0
#define MX51_PAD_AUD3_BB_RXD__GPIO4_19			0x204 0x5f4 0x000 0x3 0x0
#define MX51_PAD_AUD3_BB_RXD__UART3_RXD			0x204 0x5f4 0x9f4 0x1 0x2
#define MX51_PAD_AUD3_BB_CK__AUD3_TXC			0x208 0x5f8 0x000 0x0 0x0
#define MX51_PAD_AUD3_BB_CK__GPIO4_20			0x208 0x5f8 0x000 0x3 0x0
#define MX51_PAD_AUD3_BB_FS__AUD3_TXFS			0x20c 0x5fc 0x000 0x0 0x0
#define MX51_PAD_AUD3_BB_FS__GPIO4_21			0x20c 0x5fc 0x000 0x3 0x0
#define MX51_PAD_AUD3_BB_FS__UART3_TXD			0x20c 0x5fc 0x000 0x1 0x0
#define MX51_PAD_CSPI1_MOSI__ECSPI1_MOSI		0x210 0x600 0x000 0x0 0x0
#define MX51_PAD_CSPI1_MOSI__GPIO4_22			0x210 0x600 0x000 0x3 0x0
#define MX51_PAD_CSPI1_MOSI__I2C1_SDA			0x210 0x600 0x9b4 0x1 0x1
#define MX51_PAD_CSPI1_MISO__AUD4_RXD			0x214 0x604 0x8c4 0x1 0x1
#define MX51_PAD_CSPI1_MISO__ECSPI1_MISO		0x214 0x604 0x000 0x0 0x0
#define MX51_PAD_CSPI1_MISO__GPIO4_23			0x214 0x604 0x000 0x3 0x0
#define MX51_PAD_CSPI1_SS0__AUD4_TXC			0x218 0x608 0x8cc 0x1 0x1
#define MX51_PAD_CSPI1_SS0__ECSPI1_SS0			0x218 0x608 0x000 0x0 0x0
#define MX51_PAD_CSPI1_SS0__GPIO4_24			0x218 0x608 0x000 0x3 0x0
#define MX51_PAD_CSPI1_SS1__AUD4_TXD			0x21c 0x60c 0x8c8 0x1 0x1
#define MX51_PAD_CSPI1_SS1__ECSPI1_SS1			0x21c 0x60c 0x000 0x0 0x0
#define MX51_PAD_CSPI1_SS1__GPIO4_25			0x21c 0x60c 0x000 0x3 0x0
#define MX51_PAD_CSPI1_RDY__AUD4_TXFS			0x220 0x610 0x8d0 0x1 0x1
#define MX51_PAD_CSPI1_RDY__ECSPI1_RDY			0x220 0x610 0x000 0x0 0x0
#define MX51_PAD_CSPI1_RDY__GPIO4_26			0x220 0x610 0x000 0x3 0x0
#define MX51_PAD_CSPI1_SCLK__ECSPI1_SCLK		0x224 0x614 0x000 0x0 0x0
#define MX51_PAD_CSPI1_SCLK__GPIO4_27			0x224 0x614 0x000 0x3 0x0
#define MX51_PAD_CSPI1_SCLK__I2C1_SCL			0x224 0x614 0x9b0 0x1 0x1
#define MX51_PAD_UART1_RXD__GPIO4_28			0x228 0x618 0x000 0x3 0x0
#define MX51_PAD_UART1_RXD__UART1_RXD			0x228 0x618 0x9e4 0x0 0x0
#define MX51_PAD_UART1_TXD__GPIO4_29			0x22c 0x61c 0x000 0x3 0x0
#define MX51_PAD_UART1_TXD__PWM2_PWMO			0x22c 0x61c 0x000 0x1 0x0
#define MX51_PAD_UART1_TXD__UART1_TXD			0x22c 0x61c 0x000 0x0 0x0
#define MX51_PAD_UART1_RTS__GPIO4_30			0x230 0x620 0x000 0x3 0x0
#define MX51_PAD_UART1_RTS__UART1_RTS			0x230 0x620 0x9e0 0x0 0x0
#define MX51_PAD_UART1_CTS__GPIO4_31			0x234 0x624 0x000 0x3 0x0
#define MX51_PAD_UART1_CTS__UART1_CTS			0x234 0x624 0x000 0x0 0x0
#define MX51_PAD_UART2_RXD__FIRI_TXD			0x238 0x628 0x000 0x1 0x0
#define MX51_PAD_UART2_RXD__GPIO1_20			0x238 0x628 0x000 0x3 0x0
#define MX51_PAD_UART2_RXD__UART2_RXD			0x238 0x628 0x9ec 0x0 0x2
#define MX51_PAD_UART2_TXD__FIRI_RXD			0x23c 0x62c 0x000 0x1 0x0
#define MX51_PAD_UART2_TXD__GPIO1_21			0x23c 0x62c 0x000 0x3 0x0
#define MX51_PAD_UART2_TXD__UART2_TXD			0x23c 0x62c 0x000 0x0 0x0
#define MX51_PAD_UART3_RXD__CSI1_D0			0x240 0x630 0x000 0x2 0x0
#define MX51_PAD_UART3_RXD__GPIO1_22			0x240 0x630 0x000 0x3 0x0
#define MX51_PAD_UART3_RXD__UART1_DTR			0x240 0x630 0x000 0x0 0x0
#define MX51_PAD_UART3_RXD__UART3_RXD			0x240 0x630 0x9f4 0x1 0x4
#define MX51_PAD_UART3_TXD__CSI1_D1			0x244 0x634 0x000 0x2 0x0
#define MX51_PAD_UART3_TXD__GPIO1_23			0x244 0x634 0x000 0x3 0x0
#define MX51_PAD_UART3_TXD__UART1_DSR			0x244 0x634 0x000 0x0 0x0
#define MX51_PAD_UART3_TXD__UART3_TXD			0x244 0x634 0x000 0x1 0x0
#define MX51_PAD_OWIRE_LINE__GPIO1_24			0x248 0x638 0x000 0x3 0x0
#define MX51_PAD_OWIRE_LINE__OWIRE_LINE			0x248 0x638 0x000 0x0 0x0
#define MX51_PAD_OWIRE_LINE__SPDIF_OUT			0x248 0x638 0x000 0x6 0x0
#define MX51_PAD_KEY_ROW0__KEY_ROW0			0x24c 0x63c 0x000 0x0 0x0
#define MX51_PAD_KEY_ROW1__KEY_ROW1			0x250 0x640 0x000 0x0 0x0
#define MX51_PAD_KEY_ROW2__KEY_ROW2			0x254 0x644 0x000 0x0 0x0
#define MX51_PAD_KEY_ROW3__KEY_ROW3			0x258 0x648 0x000 0x0 0x0
#define MX51_PAD_KEY_COL0__KEY_COL0			0x25c 0x64c 0x000 0x0 0x0
#define MX51_PAD_KEY_COL0__PLL1_BYP			0x25c 0x64c 0x90c 0x7 0x0
#define MX51_PAD_KEY_COL1__KEY_COL1			0x260 0x650 0x000 0x0 0x0
#define MX51_PAD_KEY_COL1__PLL2_BYP			0x260 0x650 0x910 0x7 0x0
#define MX51_PAD_KEY_COL2__KEY_COL2			0x264 0x654 0x000 0x0 0x0
#define MX51_PAD_KEY_COL2__PLL3_BYP			0x264 0x654 0x000 0x7 0x0
#define MX51_PAD_KEY_COL3__KEY_COL3			0x268 0x658 0x000 0x0 0x0
#define MX51_PAD_KEY_COL4__I2C2_SCL			0x26c 0x65c 0x9b8 0x3 0x1
#define MX51_PAD_KEY_COL4__KEY_COL4			0x26c 0x65c 0x000 0x0 0x0
#define MX51_PAD_KEY_COL4__SPDIF_OUT1			0x26c 0x65c 0x000 0x6 0x0
#define MX51_PAD_KEY_COL4__UART1_RI			0x26c 0x65c 0x000 0x1 0x0
#define MX51_PAD_KEY_COL4__UART3_RTS			0x26c 0x65c 0x9f0 0x2 0x4
#define MX51_PAD_KEY_COL5__I2C2_SDA			0x270 0x660 0x9bc 0x3 0x1
#define MX51_PAD_KEY_COL5__KEY_COL5			0x270 0x660 0x000 0x0 0x0
#define MX51_PAD_KEY_COL5__UART1_DCD			0x270 0x660 0x000 0x1 0x0
#define MX51_PAD_KEY_COL5__UART3_CTS			0x270 0x660 0x000 0x2 0x0
#define MX51_PAD_USBH1_CLK__CSPI_SCLK			0x278 0x678 0x914 0x1 0x1
#define MX51_PAD_USBH1_CLK__GPIO1_25			0x278 0x678 0x000 0x2 0x0
#define MX51_PAD_USBH1_CLK__I2C2_SCL			0x278 0x678 0x9b8 0x5 0x2
#define MX51_PAD_USBH1_CLK__USBH1_CLK			0x278 0x678 0x000 0x0 0x0
#define MX51_PAD_USBH1_DIR__CSPI_MOSI			0x27c 0x67c 0x91c 0x1 0x1
#define MX51_PAD_USBH1_DIR__GPIO1_26			0x27c 0x67c 0x000 0x2 0x0
#define MX51_PAD_USBH1_DIR__I2C2_SDA			0x27c 0x67c 0x9bc 0x5 0x2
#define MX51_PAD_USBH1_DIR__USBH1_DIR			0x27c 0x67c 0x000 0x0 0x0
#define MX51_PAD_USBH1_STP__CSPI_RDY			0x280 0x680 0x000 0x1 0x0
#define MX51_PAD_USBH1_STP__GPIO1_27			0x280 0x680 0x000 0x2 0x0
#define MX51_PAD_USBH1_STP__UART3_RXD			0x280 0x680 0x9f4 0x5 0x6
#define MX51_PAD_USBH1_STP__USBH1_STP			0x280 0x680 0x000 0x0 0x0
#define MX51_PAD_USBH1_NXT__CSPI_MISO			0x284 0x684 0x918 0x1 0x0
#define MX51_PAD_USBH1_NXT__GPIO1_28			0x284 0x684 0x000 0x2 0x0
#define MX51_PAD_USBH1_NXT__UART3_TXD			0x284 0x684 0x000 0x5 0x0
#define MX51_PAD_USBH1_NXT__USBH1_NXT			0x284 0x684 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA0__GPIO1_11			0x288 0x688 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA0__UART2_CTS			0x288 0x688 0x000 0x1 0x0
#define MX51_PAD_USBH1_DATA0__USBH1_DATA0		0x288 0x688 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA1__GPIO1_12			0x28c 0x68c 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA1__UART2_RXD			0x28c 0x68c 0x9ec 0x1 0x4
#define MX51_PAD_USBH1_DATA1__USBH1_DATA1		0x28c 0x68c 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA2__GPIO1_13			0x290 0x690 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA2__UART2_TXD			0x290 0x690 0x000 0x1 0x0
#define MX51_PAD_USBH1_DATA2__USBH1_DATA2		0x290 0x690 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA3__GPIO1_14			0x294 0x694 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA3__UART2_RTS			0x294 0x694 0x9e8 0x1 0x5
#define MX51_PAD_USBH1_DATA3__USBH1_DATA3		0x294 0x694 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA4__CSPI_SS0			0x298 0x698 0x000 0x1 0x0
#define MX51_PAD_USBH1_DATA4__GPIO1_15			0x298 0x698 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA4__USBH1_DATA4		0x298 0x698 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA5__CSPI_SS1			0x29c 0x69c 0x920 0x1 0x0
#define MX51_PAD_USBH1_DATA5__GPIO1_16			0x29c 0x69c 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA5__USBH1_DATA5		0x29c 0x69c 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA6__CSPI_SS3			0x2a0 0x6a0 0x928 0x1 0x1
#define MX51_PAD_USBH1_DATA6__GPIO1_17			0x2a0 0x6a0 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA6__USBH1_DATA6		0x2a0 0x6a0 0x000 0x0 0x0
#define MX51_PAD_USBH1_DATA7__ECSPI1_SS3		0x2a4 0x6a4 0x000 0x1 0x0
#define MX51_PAD_USBH1_DATA7__ECSPI2_SS3		0x2a4 0x6a4 0x934 0x5 0x1
#define MX51_PAD_USBH1_DATA7__GPIO1_18			0x2a4 0x6a4 0x000 0x2 0x0
#define MX51_PAD_USBH1_DATA7__USBH1_DATA7		0x2a4 0x6a4 0x000 0x0 0x0
#define MX51_PAD_DI1_PIN11__DI1_PIN11			0x2a8 0x6a8 0x000 0x0 0x0
#define MX51_PAD_DI1_PIN11__ECSPI1_SS2			0x2a8 0x6a8 0x000 0x7 0x0
#define MX51_PAD_DI1_PIN11__GPIO3_0			0x2a8 0x6a8 0x000 0x4 0x0
#define MX51_PAD_DI1_PIN12__DI1_PIN12			0x2ac 0x6ac 0x000 0x0 0x0
#define MX51_PAD_DI1_PIN12__GPIO3_1			0x2ac 0x6ac 0x978 0x4 0x1
#define MX51_PAD_DI1_PIN13__DI1_PIN13			0x2b0 0x6b0 0x000 0x0 0x0
#define MX51_PAD_DI1_PIN13__GPIO3_2			0x2b0 0x6b0 0x97c 0x4 0x1
#define MX51_PAD_DI1_D0_CS__DI1_D0_CS			0x2b4 0x6b4 0x000 0x0 0x0
#define MX51_PAD_DI1_D0_CS__GPIO3_3			0x2b4 0x6b4 0x980 0x4 0x1
#define MX51_PAD_DI1_D1_CS__DI1_D1_CS			0x2b8 0x6b8 0x000 0x0 0x0
#define MX51_PAD_DI1_D1_CS__DISP1_PIN14			0x2b8 0x6b8 0x000 0x2 0x0
#define MX51_PAD_DI1_D1_CS__DISP1_PIN5			0x2b8 0x6b8 0x000 0x3 0x0
#define MX51_PAD_DI1_D1_CS__GPIO3_4			0x2b8 0x6b8 0x984 0x4 0x1
#define MX51_PAD_DISPB2_SER_DIN__DISP1_PIN1		0x2bc 0x6bc 0x9a4 0x2 0x1
#define MX51_PAD_DISPB2_SER_DIN__DISPB2_SER_DIN		0x2bc 0x6bc 0x9c4 0x0 0x0
#define MX51_PAD_DISPB2_SER_DIN__GPIO3_5		0x2bc 0x6bc 0x988 0x4 0x1
#define MX51_PAD_DISPB2_SER_DIO__DISP1_PIN6		0x2c0 0x6c0 0x000 0x3 0x0
#define MX51_PAD_DISPB2_SER_DIO__DISPB2_SER_DIO		0x2c0 0x6c0 0x9c4 0x0 0x1
#define MX51_PAD_DISPB2_SER_DIO__GPIO3_6		0x2c0 0x6c0 0x98c 0x4 0x1
#define MX51_PAD_DISPB2_SER_CLK__DISP1_PIN17		0x2c4 0x6c4 0x000 0x2 0x0
#define MX51_PAD_DISPB2_SER_CLK__DISP1_PIN7		0x2c4 0x6c4 0x000 0x3 0x0
#define MX51_PAD_DISPB2_SER_CLK__DISPB2_SER_CLK		0x2c4 0x6c4 0x000 0x0 0x0
#define MX51_PAD_DISPB2_SER_CLK__GPIO3_7		0x2c4 0x6c4 0x990 0x4 0x1
#define MX51_PAD_DISPB2_SER_RS__DISP1_PIN16		0x2c8 0x6c8 0x000 0x2 0x0
#define MX51_PAD_DISPB2_SER_RS__DISP1_PIN8		0x2c8 0x6c8 0x000 0x3 0x0
#define MX51_PAD_DISPB2_SER_RS__DISPB2_SER_RS		0x2c8 0x6c8 0x000 0x0 0x0
#define MX51_PAD_DISPB2_SER_RS__GPIO3_8			0x2c8 0x6c8 0x994 0x4 0x1
#define MX51_PAD_DISP1_DAT0__DISP1_DAT0			0x2cc 0x6cc 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT1__DISP1_DAT1			0x2d0 0x6d0 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT2__DISP1_DAT2			0x2d4 0x6d4 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT3__DISP1_DAT3			0x2d8 0x6d8 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT4__DISP1_DAT4			0x2dc 0x6dc 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT5__DISP1_DAT5			0x2e0 0x6e0 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT6__BOOT_USB_SRC		0x2e4 0x6e4 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT6__DISP1_DAT6			0x2e4 0x6e4 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT7__BOOT_EEPROM_CFG		0x2e8 0x6e8 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT7__DISP1_DAT7			0x2e8 0x6e8 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT8__BOOT_SRC0			0x2ec 0x6ec 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT8__DISP1_DAT8			0x2ec 0x6ec 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT9__BOOT_SRC1			0x2f0 0x6f0 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT9__DISP1_DAT9			0x2f0 0x6f0 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT10__BOOT_SPARE_SIZE		0x2f4 0x6f4 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT10__DISP1_DAT10		0x2f4 0x6f4 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT11__BOOT_LPB_FREQ2		0x2f8 0x6f8 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT11__DISP1_DAT11		0x2f8 0x6f8 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT12__BOOT_MLC_SEL		0x2fc 0x6fc 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT12__DISP1_DAT12		0x2fc 0x6fc 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT13__BOOT_MEM_CTL0		0x300 0x700 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT13__DISP1_DAT13		0x300 0x700 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT14__BOOT_MEM_CTL1		0x304 0x704 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT14__DISP1_DAT14		0x304 0x704 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT15__BOOT_BUS_WIDTH		0x308 0x708 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT15__DISP1_DAT15		0x308 0x708 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT16__BOOT_PAGE_SIZE0		0x30c 0x70c 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT16__DISP1_DAT16		0x30c 0x70c 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT17__BOOT_PAGE_SIZE1		0x310 0x710 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT17__DISP1_DAT17		0x310 0x710 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT18__BOOT_WEIM_MUXED0		0x314 0x714 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT18__DISP1_DAT18		0x314 0x714 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT18__DISP2_PIN11		0x314 0x714 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT18__DISP2_PIN5		0x314 0x714 0x000 0x4 0x0
#define MX51_PAD_DISP1_DAT19__BOOT_WEIM_MUXED1		0x318 0x718 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT19__DISP1_DAT19		0x318 0x718 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT19__DISP2_PIN12		0x318 0x718 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT19__DISP2_PIN6		0x318 0x718 0x000 0x4 0x0
#define MX51_PAD_DISP1_DAT20__BOOT_MEM_TYPE0		0x31c 0x71c 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT20__DISP1_DAT20		0x31c 0x71c 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT20__DISP2_PIN13		0x31c 0x71c 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT20__DISP2_PIN7		0x31c 0x71c 0x000 0x4 0x0
#define MX51_PAD_DISP1_DAT21__BOOT_MEM_TYPE1		0x320 0x720 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT21__DISP1_DAT21		0x320 0x720 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT21__DISP2_PIN14		0x320 0x720 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT21__DISP2_PIN8		0x320 0x720 0x000 0x4 0x0
#define MX51_PAD_DISP1_DAT22__BOOT_LPB_FREQ0		0x324 0x724 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT22__DISP1_DAT22		0x324 0x724 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT22__DISP2_D0_CS		0x324 0x724 0x000 0x6 0x0
#define MX51_PAD_DISP1_DAT22__DISP2_DAT16		0x324 0x724 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT23__BOOT_LPB_FREQ1		0x328 0x728 0x000 0x7 0x0
#define MX51_PAD_DISP1_DAT23__DISP1_DAT23		0x328 0x728 0x000 0x0 0x0
#define MX51_PAD_DISP1_DAT23__DISP2_D1_CS		0x328 0x728 0x000 0x6 0x0
#define MX51_PAD_DISP1_DAT23__DISP2_DAT17		0x328 0x728 0x000 0x5 0x0
#define MX51_PAD_DISP1_DAT23__DISP2_SER_CS		0x328 0x728 0x000 0x4 0x0
#define MX51_PAD_DI1_PIN3__DI1_PIN3			0x32c 0x72c 0x000 0x0 0x0
#define MX51_PAD_DI1_PIN2__DI1_PIN2			0x330 0x734 0x000 0x0 0x0
#define MX51_PAD_DI_GP2__DISP1_SER_CLK			0x338 0x740 0x000 0x0 0x0
#define MX51_PAD_DI_GP2__DISP2_WAIT			0x338 0x740 0x9a8 0x2 0x1
#define MX51_PAD_DI_GP3__CSI1_DATA_EN			0x33c 0x744 0x9a0 0x3 0x1
#define MX51_PAD_DI_GP3__DISP1_SER_DIO			0x33c 0x744 0x9c0 0x0 0x0
#define MX51_PAD_DI_GP3__FEC_TX_ER			0x33c 0x744 0x000 0x2 0x0
#define MX51_PAD_DI2_PIN4__CSI2_DATA_EN			0x340 0x748 0x99c 0x3 0x1
#define MX51_PAD_DI2_PIN4__DI2_PIN4			0x340 0x748 0x000 0x0 0x0
#define MX51_PAD_DI2_PIN4__FEC_CRS			0x340 0x748 0x950 0x2 0x1
#define MX51_PAD_DI2_PIN2__DI2_PIN2			0x344 0x74c 0x000 0x0 0x0
#define MX51_PAD_DI2_PIN2__FEC_MDC			0x344 0x74c 0x000 0x2 0x0
#define MX51_PAD_DI2_PIN3__DI2_PIN3			0x348 0x750 0x000 0x0 0x0
#define MX51_PAD_DI2_PIN3__FEC_MDIO			0x348 0x750 0x954 0x2 0x1
#define MX51_PAD_DI2_DISP_CLK__DI2_DISP_CLK		0x34c 0x754 0x000 0x0 0x0
#define MX51_PAD_DI2_DISP_CLK__FEC_RDATA1		0x34c 0x754 0x95c 0x2 0x1
#define MX51_PAD_DI_GP4__DI2_PIN15			0x350 0x758 0x000 0x4 0x0
#define MX51_PAD_DI_GP4__DISP1_SER_DIN			0x350 0x758 0x9c0 0x0 0x1
#define MX51_PAD_DI_GP4__DISP2_PIN1			0x350 0x758 0x000 0x3 0x0
#define MX51_PAD_DI_GP4__FEC_RDATA2			0x350 0x758 0x960 0x2 0x1
#define MX51_PAD_DISP2_DAT0__DISP2_DAT0			0x354 0x75c 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT0__FEC_RDATA3			0x354 0x75c 0x964 0x2 0x1
#define MX51_PAD_DISP2_DAT0__KEY_COL6			0x354 0x75c 0x9c8 0x4 0x1
#define MX51_PAD_DISP2_DAT0__UART3_RXD			0x354 0x75c 0x9f4 0x5 0x8
#define MX51_PAD_DISP2_DAT0__USBH3_CLK			0x354 0x75c 0x9f8 0x3 0x1
#define MX51_PAD_DISP2_DAT1__DISP2_DAT1			0x358 0x760 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT1__FEC_RX_ER			0x358 0x760 0x970 0x2 0x1
#define MX51_PAD_DISP2_DAT1__KEY_COL7			0x358 0x760 0x9cc 0x4 0x1
#define MX51_PAD_DISP2_DAT1__UART3_TXD			0x358 0x760 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT1__USBH3_DIR			0x358 0x760 0xa1c 0x3 0x1
#define MX51_PAD_DISP2_DAT2__DISP2_DAT2			0x35c 0x764 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT3__DISP2_DAT3			0x360 0x768 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT4__DISP2_DAT4			0x364 0x76c 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT5__DISP2_DAT5			0x368 0x770 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT6__DISP2_DAT6			0x36c 0x774 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT6__FEC_TDATA1			0x36c 0x774 0x000 0x2 0x0
#define MX51_PAD_DISP2_DAT6__GPIO1_19			0x36c 0x774 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT6__KEY_ROW4			0x36c 0x774 0x9d0 0x4 0x1
#define MX51_PAD_DISP2_DAT6__USBH3_STP			0x36c 0x774 0xa24 0x3 0x1
#define MX51_PAD_DISP2_DAT7__DISP2_DAT7			0x370 0x778 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT7__FEC_TDATA2			0x370 0x778 0x000 0x2 0x0
#define MX51_PAD_DISP2_DAT7__GPIO1_29			0x370 0x778 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT7__KEY_ROW5			0x370 0x778 0x9d4 0x4 0x1
#define MX51_PAD_DISP2_DAT7__USBH3_NXT			0x370 0x778 0xa20 0x3 0x1
#define MX51_PAD_DISP2_DAT8__DISP2_DAT8			0x374 0x77c 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT8__FEC_TDATA3			0x374 0x77c 0x000 0x2 0x0
#define MX51_PAD_DISP2_DAT8__GPIO1_30			0x374 0x77c 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT8__KEY_ROW6			0x374 0x77c 0x9d8 0x4 0x1
#define MX51_PAD_DISP2_DAT8__USBH3_DATA0		0x374 0x77c 0x9fc 0x3 0x1
#define MX51_PAD_DISP2_DAT9__AUD6_RXC			0x378 0x780 0x8f4 0x4 0x1
#define MX51_PAD_DISP2_DAT9__DISP2_DAT9			0x378 0x780 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT9__FEC_TX_EN			0x378 0x780 0x000 0x2 0x0
#define MX51_PAD_DISP2_DAT9__GPIO1_31			0x378 0x780 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT9__USBH3_DATA1		0x378 0x780 0xa00 0x3 0x1
#define MX51_PAD_DISP2_DAT10__DISP2_DAT10		0x37c 0x784 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT10__DISP2_SER_CS		0x37c 0x784 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT10__FEC_COL			0x37c 0x784 0x94c 0x2 0x1
#define MX51_PAD_DISP2_DAT10__KEY_ROW7			0x37c 0x784 0x9dc 0x4 0x1
#define MX51_PAD_DISP2_DAT10__USBH3_DATA2		0x37c 0x784 0xa04 0x3 0x1
#define MX51_PAD_DISP2_DAT11__AUD6_TXD			0x380 0x788 0x8f0 0x4 0x1
#define MX51_PAD_DISP2_DAT11__DISP2_DAT11		0x380 0x788 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT11__FEC_RX_CLK		0x380 0x788 0x968 0x2 0x1
#define MX51_PAD_DISP2_DAT11__GPIO1_10			0x380 0x788 0x000 0x7 0x0
#define MX51_PAD_DISP2_DAT11__USBH3_DATA3		0x380 0x788 0xa08 0x3 0x1
#define MX51_PAD_DISP2_DAT12__AUD6_RXD			0x384 0x78c 0x8ec 0x4 0x1
#define MX51_PAD_DISP2_DAT12__DISP2_DAT12		0x384 0x78c 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT12__FEC_RX_DV			0x384 0x78c 0x96c 0x2 0x1
#define MX51_PAD_DISP2_DAT12__USBH3_DATA4		0x384 0x78c 0xa0c 0x3 0x1
#define MX51_PAD_DISP2_DAT13__AUD6_TXC			0x388 0x790 0x8fc 0x4 0x1
#define MX51_PAD_DISP2_DAT13__DISP2_DAT13		0x388 0x790 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT13__FEC_TX_CLK		0x388 0x790 0x974 0x2 0x1
#define MX51_PAD_DISP2_DAT13__USBH3_DATA5		0x388 0x790 0xa10 0x3 0x1
#define MX51_PAD_DISP2_DAT14__AUD6_TXFS			0x38c 0x794 0x900 0x4 0x1
#define MX51_PAD_DISP2_DAT14__DISP2_DAT14		0x38c 0x794 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT14__FEC_RDATA0		0x38c 0x794 0x958 0x2 0x1
#define MX51_PAD_DISP2_DAT14__USBH3_DATA6		0x38c 0x794 0xa14 0x3 0x1
#define MX51_PAD_DISP2_DAT15__AUD6_RXFS			0x390 0x798 0x8f8 0x4 0x1
#define MX51_PAD_DISP2_DAT15__DISP1_SER_CS		0x390 0x798 0x000 0x5 0x0
#define MX51_PAD_DISP2_DAT15__DISP2_DAT15		0x390 0x798 0x000 0x0 0x0
#define MX51_PAD_DISP2_DAT15__FEC_TDATA0		0x390 0x798 0x000 0x2 0x0
#define MX51_PAD_DISP2_DAT15__USBH3_DATA7		0x390 0x798 0xa18 0x3 0x1
#define MX51_PAD_SD1_CMD__AUD5_RXFS			0x394 0x79c 0x8e0 0x1 0x1
#define MX51_PAD_SD1_CMD__CSPI_MOSI			0x394 0x79c 0x91c 0x2 0x2
#define MX51_PAD_SD1_CMD__SD1_CMD			0x394 0x79c 0x000 0x0 0x0
#define MX51_PAD_SD1_CLK__AUD5_RXC			0x398 0x7a0 0x8dc 0x1 0x1
#define MX51_PAD_SD1_CLK__CSPI_SCLK			0x398 0x7a0 0x914 0x2 0x2
#define MX51_PAD_SD1_CLK__SD1_CLK			0x398 0x7a0 0x000 0x0 0x0
#define MX51_PAD_SD1_DATA0__AUD5_TXD			0x39c 0x7a4 0x8d8 0x1 0x2
#define MX51_PAD_SD1_DATA0__CSPI_MISO			0x39c 0x7a4 0x918 0x2 0x1
#define MX51_PAD_SD1_DATA0__SD1_DATA0			0x39c 0x7a4 0x000 0x0 0x0
#define MX51_PAD_EIM_DA0__EIM_DA0			0x01c 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA1__EIM_DA1			0x020 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA2__EIM_DA2			0x024 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA3__EIM_DA3			0x028 0x000 0x000 0x0 0x0
#define MX51_PAD_SD1_DATA1__AUD5_RXD			0x3a0 0x7a8 0x8d4 0x1 0x2
#define MX51_PAD_SD1_DATA1__SD1_DATA1			0x3a0 0x7a8 0x000 0x0 0x0
#define MX51_PAD_EIM_DA4__EIM_DA4			0x02c 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA5__EIM_DA5			0x030 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA6__EIM_DA6			0x034 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA7__EIM_DA7			0x038 0x000 0x000 0x0 0x0
#define MX51_PAD_SD1_DATA2__AUD5_TXC			0x3a4 0x7ac 0x8e4 0x1 0x2
#define MX51_PAD_SD1_DATA2__SD1_DATA2			0x3a4 0x7ac 0x000 0x0 0x0
#define MX51_PAD_EIM_DA10__EIM_DA10			0x044 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA11__EIM_DA11			0x048 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA8__EIM_DA8			0x03c 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA9__EIM_DA9			0x040 0x000 0x000 0x0 0x0
#define MX51_PAD_SD1_DATA3__AUD5_TXFS			0x3a8 0x7b0 0x8e8 0x1 0x2
#define MX51_PAD_SD1_DATA3__CSPI_SS1			0x3a8 0x7b0 0x920 0x2 0x1
#define MX51_PAD_SD1_DATA3__SD1_DATA3			0x3a8 0x7b0 0x000 0x0 0x0
#define MX51_PAD_GPIO1_0__CSPI_SS2			0x3ac 0x7b4 0x924 0x2 0x0
#define MX51_PAD_GPIO1_0__GPIO1_0			0x3ac 0x7b4 0x000 0x1 0x0
#define MX51_PAD_GPIO1_0__SD1_CD			0x3ac 0x7b4 0x000 0x0 0x0
#define MX51_PAD_GPIO1_1__CSPI_MISO			0x3b0 0x7b8 0x918 0x2 0x2
#define MX51_PAD_GPIO1_1__GPIO1_1			0x3b0 0x7b8 0x000 0x1 0x0
#define MX51_PAD_GPIO1_1__SD1_WP			0x3b0 0x7b8 0x000 0x0 0x0
#define MX51_PAD_EIM_DA12__EIM_DA12			0x04c 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA13__EIM_DA13			0x050 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA14__EIM_DA14			0x054 0x000 0x000 0x0 0x0
#define MX51_PAD_EIM_DA15__EIM_DA15			0x058 0x000 0x000 0x0 0x0
#define MX51_PAD_SD2_CMD__CSPI_MOSI			0x3b4 0x7bc 0x91c 0x2 0x3
#define MX51_PAD_SD2_CMD__I2C1_SCL			0x3b4 0x7bc 0x9b0 0x1 0x2
#define MX51_PAD_SD2_CMD__SD2_CMD			0x3b4 0x7bc 0x000 0x0 0x0
#define MX51_PAD_SD2_CLK__CSPI_SCLK			0x3b8 0x7c0 0x914 0x2 0x3
#define MX51_PAD_SD2_CLK__I2C1_SDA			0x3b8 0x7c0 0x9b4 0x1 0x2
#define MX51_PAD_SD2_CLK__SD2_CLK			0x3b8 0x7c0 0x000 0x0 0x0
#define MX51_PAD_SD2_DATA0__CSPI_MISO			0x3bc 0x7c4 0x918 0x2 0x3
#define MX51_PAD_SD2_DATA0__SD1_DAT4			0x3bc 0x7c4 0x000 0x1 0x0
#define MX51_PAD_SD2_DATA0__SD2_DATA0			0x3bc 0x7c4 0x000 0x0 0x0
#define MX51_PAD_SD2_DATA1__SD1_DAT5			0x3c0 0x7c8 0x000 0x1 0x0
#define MX51_PAD_SD2_DATA1__SD2_DATA1			0x3c0 0x7c8 0x000 0x0 0x0
#define MX51_PAD_SD2_DATA1__USBH3_H2_DP			0x3c0 0x7c8 0x000 0x2 0x0
#define MX51_PAD_SD2_DATA2__SD1_DAT6			0x3c4 0x7cc 0x000 0x1 0x0
#define MX51_PAD_SD2_DATA2__SD2_DATA2			0x3c4 0x7cc 0x000 0x0 0x0
#define MX51_PAD_SD2_DATA2__USBH3_H2_DM			0x3c4 0x7cc 0x000 0x2 0x0
#define MX51_PAD_SD2_DATA3__CSPI_SS2			0x3c8 0x7d0 0x924 0x2 0x1
#define MX51_PAD_SD2_DATA3__SD1_DAT7			0x3c8 0x7d0 0x000 0x1 0x0
#define MX51_PAD_SD2_DATA3__SD2_DATA3			0x3c8 0x7d0 0x000 0x0 0x0
#define MX51_PAD_GPIO1_2__CCM_OUT_2			0x3cc 0x7d4 0x000 0x5 0x0
#define MX51_PAD_GPIO1_2__GPIO1_2			0x3cc 0x7d4 0x000 0x0 0x0
#define MX51_PAD_GPIO1_2__I2C2_SCL			0x3cc 0x7d4 0x9b8 0x2 0x3
#define MX51_PAD_GPIO1_2__PLL1_BYP			0x3cc 0x7d4 0x90c 0x7 0x1
#define MX51_PAD_GPIO1_2__PWM1_PWMO			0x3cc 0x7d4 0x000 0x1 0x0
#define MX51_PAD_GPIO1_3__GPIO1_3			0x3d0 0x7d8 0x000 0x0 0x0
#define MX51_PAD_GPIO1_3__I2C2_SDA			0x3d0 0x7d8 0x9bc 0x2 0x3
#define MX51_PAD_GPIO1_3__PLL2_BYP			0x3d0 0x7d8 0x910 0x7 0x1
#define MX51_PAD_GPIO1_3__PWM2_PWMO			0x3d0 0x7d8 0x000 0x1 0x0
#define MX51_PAD_PMIC_INT_REQ__PMIC_INT_REQ		0x3d4 0x7fc 0x000 0x0 0x0
#define MX51_PAD_PMIC_INT_REQ__PMIC_PMU_IRQ_B		0x3d4 0x7fc 0x000 0x1 0x0
#define MX51_PAD_GPIO1_4__DISP2_EXT_CLK			0x3d8 0x804 0x908 0x4 0x1
#define MX51_PAD_GPIO1_4__EIM_RDY			0x3d8 0x804 0x938 0x3 0x1
#define MX51_PAD_GPIO1_4__GPIO1_4			0x3d8 0x804 0x000 0x0 0x0
#define MX51_PAD_GPIO1_4__WDOG1_WDOG_B			0x3d8 0x804 0x000 0x2 0x0
#define MX51_PAD_GPIO1_5__CSI2_MCLK			0x3dc 0x808 0x000 0x6 0x0
#define MX51_PAD_GPIO1_5__DISP2_PIN16			0x3dc 0x808 0x000 0x3 0x0
#define MX51_PAD_GPIO1_5__GPIO1_5			0x3dc 0x808 0x000 0x0 0x0
#define MX51_PAD_GPIO1_5__WDOG2_WDOG_B			0x3dc 0x808 0x000 0x2 0x0
#define MX51_PAD_GPIO1_6__DISP2_PIN17			0x3e0 0x80c 0x000 0x4 0x0
#define MX51_PAD_GPIO1_6__GPIO1_6			0x3e0 0x80c 0x000 0x0 0x0
#define MX51_PAD_GPIO1_6__REF_EN_B			0x3e0 0x80c 0x000 0x3 0x0
#define MX51_PAD_GPIO1_7__CCM_OUT_0			0x3e4 0x810 0x000 0x3 0x0
#define MX51_PAD_GPIO1_7__GPIO1_7			0x3e4 0x810 0x000 0x0 0x0
#define MX51_PAD_GPIO1_7__SD2_WP			0x3e4 0x810 0x000 0x6 0x0
#define MX51_PAD_GPIO1_7__SPDIF_OUT1			0x3e4 0x810 0x000 0x2 0x0
#define MX51_PAD_GPIO1_8__CSI2_DATA_EN			0x3e8 0x814 0x99c 0x2 0x2
#define MX51_PAD_GPIO1_8__GPIO1_8			0x3e8 0x814 0x000 0x0 0x0
#define MX51_PAD_GPIO1_8__SD2_CD			0x3e8 0x814 0x000 0x6 0x0
#define MX51_PAD_GPIO1_8__USBH3_PWR			0x3e8 0x814 0x000 0x1 0x0
#define MX51_PAD_GPIO1_9__CCM_OUT_1			0x3ec 0x818 0x000 0x3 0x0
#define MX51_PAD_GPIO1_9__DISP2_D1_CS			0x3ec 0x818 0x000 0x2 0x0
#define MX51_PAD_GPIO1_9__DISP2_SER_CS			0x3ec 0x818 0x000 0x7 0x0
#define MX51_PAD_GPIO1_9__GPIO1_9			0x3ec 0x818 0x000 0x0 0x0
#define MX51_PAD_GPIO1_9__SD2_LCTL			0x3ec 0x818 0x000 0x6 0x0
#define MX51_PAD_GPIO1_9__USBH3_OC			0x3ec 0x818 0x000 0x1 0x0

#endif /* __DTS_IMX51_PINFUNC_H */
