/* 
 * Mach Operating System
 * Copyright (c) 1993-1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	kn03_cpu.h,v $
 * Revision 2.2  93/05/30  21:08:40  rvb
 * 	RCS-ed.
 * 	[93/05/29            af]
 * 
 */
/*
 *	File: kn03_cpu.h
 * 	Author: John Wroclawski, Massachusetts Institute of Technology
 *	Date:	?/93
 *
 *	SPL definitions for 3max+
 */

/* Interrupt masks associated to IPL levels */
/* see KN03_INTR_* in kn03.h for bit meanings */
/* XXX shut the turbos off at all H/W interrupt levels? */

#define	KN03_IM0	0xff0f3bf0	/* all good ones enabled */
					/* spl0, splsoftclock, splnet */

/* Try this instead if you need the tc slots off at splimp */
/* If you do, you might change the TC0-2 priorities in kn03_tcintr() too */
/* define KN03_IM1	0xff0e02f0	/* all but lance */

#define	KN03_IM1	0xff0e3af0	/* all but lance */
					/* splimp */

#define	KN03_IM2	0xff0000f0	/* all but scsi and lance  */
					/* splbio */

#define	KN03_IM3	0x00000030	/* all but serial lines, scsi, lance */
					/* spltty */
#define	KN03_IM4	0x00000020	/* memory errors and clock(!) */
					/* splclock */
#define	KN03_IM5	0x00000000	/* nothing at all */
					/* splhigh & co */

/* We add to the SR 5 bits to point to the current IM in effect */

#define	KN03_SR_IMASK	0x0f800000		/* this is where in the SR */
#define	KN03_SR_SHIFT	23

#define	KN03_SR_IM5	0x00
#define	KN03_SR_IM4	0x10
#define	KN03_SR_IM3	0x08
#define	KN03_SR_IM2	0x04
#define	KN03_SR_IM1	0x02
#define	KN03_SR_IM0	0x01

/* Interrupt masks for quickly recognizing certain device's interrupts */
/* see KN03_INTR_* in kn03.h for bit meanings */

#define	KN03_INTR_ASIC		0xff0f0004 /* asic-reported error conditions */
#define	KN03_INTR_SCC		0x000000c0 /* either serial line ready */
