.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_abort.man,v $
.\" Revision 2.5  93/03/18  15:15:34  mrt
.\" 	corrected types
.\" 	[93/03/12  16:53:42  lli]
.\" 
.\" Revision 2.4  91/05/14  17:13:39  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:03  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:15:53  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:44:58  rpd
.\" 	Created.
.\" 
.TH thread_abort 2 1/22/88
.CM 4
.SH NAME
.nf
thread_abort  \-  interrupts the specified thread
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_abort(target_thread)
	mach_port_t	target_thread;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_thread
The thread to be interrupted.

.SH DESCRIPTION

.B thread_abort
aborts the kernel primitives: 
.B msg_send, msg_receive
and
.B msg_rpc
and page-faults, making the call return a
code indicating that it was interrupted.  The call is interrupted
whether or not the thread (or task containing it) is currently suspended.
If it is supsended, the thread receives the interupt when it is resumed.

A thread will retry an aborted page-fault if its state is not modified
before it is resumed.  
.B Msg_send
returns
.B SEND_INTERRUPTED
; 
.B msg_receive
returns 
.B RCV_INTERRUPTED
; 
.B msg_rpc
returns either 
.B SEND_INTERRUPTED
or 
.B RCV_INTERRUPTED
, depending on
which half of the RPC was interrupted.

The main reason for this primitive is to allow one thread to cleanly stop
another thread in a manner that will allow the future execution of the
target thread to be controlled in a predictable way. 
.B thread_suspend
keeps the target thread from executing any further instructions at the
user level, including the return from a system call. 
.B thread_get/set_state
allows the examination or modification of the user state of a target
thread. However, if a suspended thread was executing within a system call,
it also has associated with it a kernel state. This kernel state can not be
modified by 
.B thread_set_state
with the result that when the thread is resumed
the system call may return changing the user state and possibly user memory.
.B thread_abort
aborts the kernel call from the target thread's point of view
by resetting the kernel state so that the thread will resume execution
at the system call return with the return code value set to one of the 
interrupted codes. The system call itself will either be entirely completed or
entirely aborted, depending on the precise moment at which the abort was received.
Thus if the thread's user state has been changed by
.B thread_set_state
, it will not be modified by any unexpected system
call side effects.


For example to simulate a Unix signal, the following sequence of calls may be used:

.B thread_suspend
Stops the thread

.B thread_abort
Interrupts any system call in progress,
setting the return value to 'interrupted'.
Since the thread is stopped, it will not
return to user code.

.B thread_set_state
Alters thread's state to simulate a
procedure call to the signal handler

.B thread_resume
Resumes execution at the signal handler.
If the thread's stack has been correctly
set up, the thread may return to the
interrupted system call.

(of course, the code to push an extra stack frame and change the registers
is VERY machine-dependent.)

Calling 
.B thread_abort
on a non-suspended thread is pretty risky, since
it is very difficult to know exactly what system trap, if any, the thread might be
executing and whether an interrupt return would cause the thread to do
something useful.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The thread received an interrupt
.TP 25
KERN_INVALID_ARGUMENT
.B target_thread
is not a thread.

.SH SEE ALSO
.B thread_info, thread_state, thread_terminate, thread_suspend


