# Makefile for SCO UNIX SYS V/386

SHELL = /bin/sh
INCLSYS = /usr/include/sys
LKDRVRDIR = /etc/conf/pack.d/fas
LKSCONFDIR = /etc/conf/sdevice.d
LKNCONFDIR = /etc/conf/node.d
LKICONFDIR = /etc/conf/init.d
LKKCONFDIR = /etc/conf/kconfig.d
DRVRNAME = Driver.o
CONFNAME = fas

CC = rcc
CFLAGS = -O -DINKERNEL -DSCO

OBJS = fas.o

fas.o:		fas.c $(INCLSYS)/fas.h Makefile

install:	fas.o space.c s_$(CONFNAME) n_$(CONFNAME) i_$(CONFNAME)
	-mkdir $(LKDRVRDIR) 2> /dev/null
	chmod 755 $(LKDRVRDIR)
	cp fas.o $(LKDRVRDIR)/$(DRVRNAME)
	chmod 644 $(LKDRVRDIR)/$(DRVRNAME)
	cp space.c $(LKDRVRDIR)/space.c
	chmod 644 $(LKDRVRDIR)/space.c
	cp s_$(CONFNAME) $(LKSCONFDIR)/$(CONFNAME)
	chmod 644 $(LKSCONFDIR)/$(CONFNAME)
	cp n_$(CONFNAME) $(LKNCONFDIR)/$(CONFNAME)
	chmod 644 $(LKNCONFDIR)/$(CONFNAME)
	cp i_$(CONFNAME) $(LKICONFDIR)/$(CONFNAME)
	chmod 644 $(LKICONFDIR)/$(CONFNAME)
	$(SHELL) update_desc $(LKKCONFDIR)/description

space.c:
	@echo "You must copy the proper space-xxxxx file to \`space.c'"
	@false
	
s_$(CONFNAME):
	@echo "You must copy the proper s_$(CONFNAME)-xxxxx file to \`s_$(CONFNAME)'"
	@false
		
n_$(CONFNAME):
	@echo "You must copy the proper n_$(CONFNAME)-xxxxx file to \`n_$(CONFNAME)'"
	@false
		
i_$(CONFNAME):
	@echo "You must copy the proper i_$(CONFNAME)-xxxxx file to \`i_$(CONFNAME)'"
	@false
		
$(INCLSYS)/fas.h:	fas.h
	cp fas.h $(INCLSYS)/fas.h

clean:
	rm -f fas.o

clobber:	clean

