import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

/*
 * PrefSlideCommandsGUI.java
 *
 * Created on 14. Dezember 2005, 09:59
 */

/**
 *
 *  This class simply implements a GUI letting the user manage some
 *  commands describing slides.
 *
 * @author  Olle Nebendahl
 */
 
public class PrefSlideCommandsGUI extends javax.swing.JDialog 
{

    private javax.swing.JButton moveUpButton;
    private javax.swing.JButton deleteButton;
    private javax.swing.JButton addButton;
    private javax.swing.JButton discardButton;
    private javax.swing.JButton saveButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    
    private boolean approved=false;
    public boolean hasChanged() { return approved; }

    DefaultListModel myListModel;

    /** Creates new form PrefSlideCommandsGUI */
    public PrefSlideCommandsGUI(java.awt.Frame parent, boolean modal, DefaultListModel lm) 
    {
        super(parent, modal);
        myListModel=lm;
        initComponents();
    }

    public PrefSlideCommandsGUI(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        myListModel= PrefSlideCommands.getThem();

        initComponents();
    }
    
    public void PSCGcomponentHidden(java.awt.event.ComponentEvent evt)
    {
        System.out.println(getLocation());
    }

    private void initComponents() 
    {
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                PSCGcomponentHidden(evt);
            }
        });
        
        approved=false;
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jList1 = new javax.swing.JList(myListModel);
        jPanel2 = new javax.swing.JPanel();
        addButton = new javax.swing.JButton();
        moveUpButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        discardButton = new javax.swing.JButton();
        saveButton = new javax.swing.JButton();

        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.Y_AXIS));

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        jLabel1.setText("Edit preferred slide defining commands");
        
        getContentPane().add(jLabel1);
        getContentPane().add(new javax.swing.JLabel("ordered by preference - highest first:"));

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(260, 32));
        
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListMouseClicked(evt);
            }
        });
        
        jScrollPane1.setViewportView(jList1);

        jPanel1.add(jScrollPane1);

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));

        addButton.setText("add");
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        jPanel2.add(addButton);


        moveUpButton.setText("move up");
        moveUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                moveUpButtonActionPerformed(evt);
            }
        });

        jPanel2.add(moveUpButton);

        deleteButton.setText("delete");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel2.add(deleteButton);


        jPanel1.add(jPanel2);

        getContentPane().add(jPanel1);

        discardButton.setText("discard & quit");
        discardButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                discardButtonActionPerformed(evt);
            }
        });
        getContentPane().add(discardButton);

        saveButton.setText("save changes & quit");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });
        getContentPane().add(saveButton);

        pack();
    }
    
    public void jListMouseClicked(java.awt.event.MouseEvent evt)
    {
        int clickCount=evt.getClickCount();
        if(2==clickCount)
        {
            doMoveUp();
        }
    }
    
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(Constants.prefSlideCommandsGUICoordinates);
            Constants.savePreferences();
            Logger.log("saved position");
        }
        else setLocation(Constants.prefSlideCommandsGUICoordinates);
        super.setVisible(b);
    }


    private void ChooseButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
    }

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        PrefSlideCommands.update(myListModel);
        approved=true;
        setVisible(false);
    }

    private void discardButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        setVisible(false);
    }

    private void addButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        AddTalkGUI addGUI = new AddTalkGUI((javax.swing.JDialog)this,true,true);
        //addGUI.hideTargetSpinners();
        addGUI.setScanButtontext("OK");
        addGUI.setLocationRelativeTo(this);
        int i=jList1.getSelectedIndex();
        if(i>=0) 
        {
            //addGUI.setFrameSyntax(((CommandRepresentation)myListModel.get(i)).s.substring(1));
            addGUI.setFrameSyntax(((CommandRepresentation)myListModel.get(i)));
        }
        else addGUI.setFrameSyntax("frame");
        addGUI.setVisible(true);
        if(addGUI.approved)
        {
            myListModel.addElement(addGUI.getCommandRepresentation());
            pack();
            jScrollPane1.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMaximum());
        }
    }

    private void moveUpButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        doMoveUp();
    }
    
    private void doMoveUp()
    {
        int i=jList1.getSelectedIndex();
        if(i>0) 
        {
            Object swap=myListModel.get(i-1);
            myListModel.set(i-1, myListModel.get(i));
            myListModel.set(i, swap);
            jList1.setSelectedIndex(i-1);
        }
    }
    
    

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int i=jList1.getSelectedIndex();
        if(i>-1)
        myListModel.remove(jList1.getSelectedIndex());
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) 
    {
        final PrefSlideCommandsGUI PCG = new PrefSlideCommandsGUI(new javax.swing.JFrame(), true);
//        PCG.setLocationRelativeTo(null);
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                PCG.setVisible(true);
            }
        });
//        PrefSlideCommands.getThem();
    }
}
