#include "VertexShader.hpp"

#include "Error.hpp"

namespace swShader
{
	float4 VertexShader::c[256];
	int4 VertexShader::i[16];
	bool VertexShader::b[16];

	void VertexShader::setFloatConstant(int index, const float value[4])
	{
		if(index < 0 || index >= 256) throw Error("Constant float register index out of [0, 255] range: %d", index);

		c[index][0] = value[0];
		c[index][1] = value[1];
		c[index][2] = value[2];
		c[index][3] = value[3];
	}

	void VertexShader::setIntegerConstant(int index, const int integer[4])
	{
		if(index < 0 || index >= 16) throw Error("Constant integer register index out of [0, 15] range: %d", index);

		i[index][0] = integer[0];
		i[index][1] = integer[1];
		i[index][2] = integer[2];
		i[index][3] = integer[3];
	}

	void VertexShader::setBooleanConstant(int index, bool boolean)
	{
		if(index < 0 || index >= 16) throw Error("Constant boolean register index out of [0, 15] range: %d", index);

		b[index] = boolean;
	}

	void VertexShader::setFloatConstant(int index, const Vector &V)
	{
		if(index < 0 || index >= 256) throw Error("Constant float register index out of [0, 255] range: %d", index);

		c[index][0] = V.x;
		c[index][1] = V.y;
		c[index][2] = V.z;
		c[index][3] = 0;
	}

	void VertexShader::setFloatConstant(int index, const Point &P)
	{
		if(index < 0 || index >= 256) throw Error("Constant float register index out of [0, 255] range: %d", index);

		c[index][0] = P.x;
		c[index][1] = P.y;
		c[index][2] = P.z;
		c[index][3] = 1;
	}

	void VertexShader::setFloatConstant(int index, const Matrix &M)
	{
		setFloatConstant(index + 0, M[0]);
		setFloatConstant(index + 1, M[1]);
		setFloatConstant(index + 2, M[2]);
		setFloatConstant(index + 3, M[3]);
	}
}