/*
 * mist.c
 * $Log:	mist.c,v $
 * Revision 4.0  91/07/17  14:40:42  kolb
 * Initial version.
 */
#include "atmosphe.h"
#include "mist.h"
 
Mist *
MistCreate(color, trans, zero, scale)
Color *color, *trans;
Float zero, scale;
{
	Mist *mist;
 
	mist = (Mist *)Malloc(sizeof(Mist));
	mist->color = *color;
	mist->trans = *trans;
	mist->zero = zero;
	mist->scale = 1. / scale;
	return mist;
}
 
/*
 * Add low-altitude mist to the given color.
 */
void
MistApply(mist, ray, pos, dist, color)
Mist *mist;
Ray *ray;
Vector *pos;
Float dist;
Color *color;
{
	Float deltaZ, d, atten;
	extern Float ExpAtten();
 
	deltaZ = mist->scale * (pos->z - ray->pos.z);
	if (fabs(deltaZ) > EPSILON)
		d = (exp(-ray->pos.z*mist->scale + mist->zero) -
			    exp(-pos->z*mist->scale + mist->zero)) / deltaZ;
	else
		d = exp(-pos->z*mist->scale + mist->zero);
 
	dist *= d;
 
	atten = ExpAtten(dist, mist->trans.r);
	color->r = atten*color->r + (1. - atten)*mist->color.r;
 
	atten = ExpAtten(dist, mist->trans.g);
	color->g = atten*color->g + (1. - atten)*mist->color.g;
 
	atten = ExpAtten(dist, mist->trans.b);
	color->b = atten*color->b + (1. - atten)*mist->color.b;
}
