#
# File:		pclient.pl
# Author:	G. Paul Ziemba
# Date:		93.01.25
# SCCS:		@(#)pclient.pl	1.11 9/29/94
# Purpose:	proxy ftp client for use with tcprelay
#

#########################
# Begin Configuration	#
#########################

#$debug = 1;
#$verbose = 1;

#########################
# End Configuration	#
#########################

sub usage
{
    print "usage: $0 [-v] <host> [<port>]\n";
    exit 1;
}

$SIG{'HUP'} = 'cleanup';
$SIG{'INT'} = 'cleanup';
$SIG{'TERM'} = 'cleanup';


$| = 1;

    #
    # ptelnet [-v] <host> [<port>]
    # pftp    [-v] <host> [<port>]
    #

    #
    # parse args
    #
    while ($ARGV[0] =~ /^-/) {
	    if ($ARGV[0] eq '-v') {
		    ++$VerboseMode;
	    } else {
		    #
		    # assume it's something to be passed to the application
		    #
		    push(@switches, $ARGV[0]);
	    }
	    shift;
    }

    $0 =~ s:^.*/::;	# basename
    if ($0 eq "pftp") {
	    $Application = $Mode = 'ftp';
	    $Service = 'ftp'; # unless port is specified
    } else {
	    #
	    # Thanks to Jim Kohli for this clever idea...
	    #
	    $Application = 'telnet';
	    $Service = substr( $0, 1 );
    }

    $server = shift;
    &usage if (!defined($server));

    if (defined($ARGV[0])) {
	    $Service = shift;
    }

    #
    # we tell these to the relay server for logging. These can be
    # easily spoofed, so don't treat them as infallible in the logs
    #
    $RuserName = getpwuid($<) . "($<)";
    $EuserName = getpwuid($>) . "($>)";

    #
    # permit "pfinger user@host", "pwhois user@host"
    # thanks to Jim Kohli for this and for the .netrc stuff below
    #
    if ($server =~ /\@/) {
	    ++$direct;
	    ($user, $server) = split(/\@/, $server);
	    print "user[$user], server[$server]\n" if $debug;
	    $user = "/W" if (($Service eq "finger") && ($user eq ''));
    } else {
	    if ($Service eq 'finger') {
		    ++$direct;
		    $user = $server;
		    $server = "localhost";
	    }
    }

    #
    # look up remote host name in .netrc aliases
    #
    &read_netrc;
    $server = &hostalias($server);


    unless (do 'sys/socket.ph') {
	eval 'sub SOCK_STREAM {1;} sub AF_INET {2;} sub PF_INET {2;}';
    }

    #
    # Set up relay spec (port + ipaddr)
    #
    ($name, $aliases, $port, $proto) = getservbyname("tcprpm", "tcp");
    if (!defined($port)) {
	    print STDERR "Can't find port number for tcprpm/tcp\n";
	    exit 1;
    }
    ($RELAYHOST, $aliases, $type, $len, $gw_ip) = gethostbyname($RELAYHOST);
    $them = pack('S n a4 x8', &AF_INET, $port, $gw_ip);

    #
    # spoof ftp .netrc. Do this after we look up RELAYHOST so that
    # spoof file has canonical name
    #
    if (($Service eq 'ftp') && $PCLIENT_SPOOFNETRC) {
	    $SpoofedNetrcDir = &spoof_netrc($server);
    }


    #
    # connect to relay
    #
    print "Connecting to relay server $RELAYHOST ...\n" if ($VerboseMode);
    ($name, $aliases, $proto) = getprotobyname('tcp');
    socket(S, &PF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
    connect(S, $them) || die "connect: $!";

    select(S); $| = 1; select(stdout);


    #
    # Do it
    #
    print "Requesting relay ...\n" if ($VerboseMode);
    &transact("", '220');

    &transact("ruser $RuserName", '250');
    &transact("euser $EuserName", '250');

    &transact("server $server", '250');
    &transact("service $Service", '250');
    if (defined($Mode)) {
	    &transact("mode $Mode", '250');
    }
    $port = &transact("relay", '212');

    $port =~ tr/A-Z/a-z/;
    $port =~ s/^\d\d\d\s+port\s+(\d+)(\s+.*)*$/\1/;

    if ($port !~ /^\d+$/) {
	    print STDERR "\nRelay protocol error\n";
	    exit 1;
    }

    if ($direct) {
	    #
	    # finger or whois
	    # thanks to Jim Kohli
	    #
	    $them = pack('S n a4 x8', &AF_INET, $port, $gw_ip);
	    socket(T, &PF_INET, &SOCK_STREAM, $proto) || die "socket: $!";
	    connect(T, $them) || die "connect: $!";

	    select(T); $| = 1;
	    print T $user."\r\n";	# write the username to the server

	    while (<T>) {
		    chop;
		    s/\r$//;
		    print STDOUT $_, "\n";
	    }

	    exit 0;
    }

    if (($Application =~ /^telnet/) && ($CHARMODE_PORT eq "-")) {
	    $port = "-$port";
    }

    if ($SpoofedNetrcDir ne '') {
	    $ENV{'HOME'} = $SpoofedNetrcDir;
    }

    system("$Application $RELAYHOST $port");

    close(S);

    if ($SpoofedNetrcDir ne '') {
	    system "rm -rf $SpoofedNetrcDir";
    }

    exit 0;


sub transact # $send $expect
{
	local($send, $expect) = @_[0,1];
	local(@responses) = ();

	printf("send[%s] expect[%s]\n", $send, $expect) if $debug;

	print S $send."\n" unless ($send eq "");
	while (<S>) {
		if (/^$expect/) {
			print if $verbose;
			print "gotit\n" if $debug;
			return $_;
		}
		if ($VerboseMode) {
			print;
		} else {
			push(@responses, $_);
		}
		last unless (/^\d\d\d-/);
	}
	if (!$VerboseMode) {
		for (@responses) {
			print;
		}
	}
	print "Error, closing connection\n";
	close(S);
	exit 1;
}

sub read_netrc
{
    local($netrcpath, @_, $_);

    $netrcpath = $ENV{'HOME'} . '/.netrc';
    if (open(NETRC, "<$netrcpath")) {
	    while (<NETRC>) {
		    chop;
		    s/\#.*$//;
		    s/^\s+//;
		    s/\s+$//;
		    split;

		    if ($_[0] eq 'alias') {
			    next if ($#_ < 2);
			    $NetrcAlias{$_[1]} = $_[2];
		    } else {
			    push(@NetrcLines, $_);	# save for later
		    }
	    }
	    close(NETRC);
    }
}

sub hostalias
{
    local($server) = @_;
    local($i);

    #
    # Do host aliases really need recursion?
    #
    for ($i = 0; defined($NetrcAlias{$server}); ++$i) {
	    $server = $NetrcAlias{$server};
	    if ($i > 32) {
		    print "$0: .netrc: excessive alias recursion\n";
		    exit 1;
	    }
    }

    return $server;
}

sub spoof_netrc
{
    local($server) = $_[0];
    local(@n, $_, $hn, $save, @SpoofLines, $tdir, $tfile);

    if ($#NetrcLines < 0) {
	    return '';
    }

    $save = 0;
    @Spooflines = ();

    for (@NetrcLines) {
	    if (/^machine\s+/) {
		    $save = 0;
		    @n = split;
		    if ($server eq &hostalias($n[1])) {
			    $n[1] = $RELAYHOST;
			    $_ = join(' ', @n);
			    ++$save;
		    }
	    }
	    push(@SpoofLines, $_) if $save;
    }

    if ($#SpoofLines < 0) {
	    return '';
    }

    $tdir = "/tmp/pclient." . getpwuid($<) . "." . $$;
    $tfile = $tdir . "/.netrc";
    mkdir($tdir, 0700);
    if (open(TN, ">$tfile")) {
	    chmod 0600, $tfile;
	    print TN join("\n", @SpoofLines), "\n";
	    close(TN);
	    return $tdir;
    } else {
	    print STDERR "$tfile: $!\n";
	    unlink $tfile;
	    unlink $tdir;
	    exit 1;
    }
}

sub cleanup
{
    if ($SpoofedNetrcDir ne '') {
	    system "rm -rf $SpoofedNetrcDir";
    }
    exit 0;
}
