; --------------------------------------------------------------------------
; This code written by Colin Plumb
;
; The accumulate function is designed to produce a large and
; high-quality, but not cryptographically secure hash of the input words
; very quickly based on the key scheduling technique used in the SHA.1
; secure hash algorithm, based on an irreducible word-wide polynomial
; (over the integers modulo 2, GF(2)) with a rotate thrown in mix the
; bits of each word amongst themselves.
;
; The pool is 512 bits, and the words are 16 bits wide, so there are
; 32 words in the pool, and thus we need a degree-32 polynomial.
;
; We've gone through several polynomials.  They all have the lowest
; number of non-zero terms possible which is consistent with having
; an irreducible polynomial of degree 32, namely 5.
; (If it were even, the polynomial would be divisible by (x+1), and
; since the degree is a multiple of 8, no trinomial is irreducible.)
;
; 0.3.4 used x^32 + x^25 + x^15 + x^2 + 1
;   This was changed to be primitive (as well as irreducible) and
;   have a lower third-lowest term, which causes faster mixing.
; 0.3.5 used x^32 + x^19 + x^6 + x^2 + 1
;   This was changed to have an *odd* third-lowest term,
;   since otherwise only the even words of the pool are affected
;   by stirring until 19 steps later.
; 0.3.6 and above use x^32 + x^17 + x^3 + x^2 + 1
;
; In pseudo-C code, for each new sampled word x, the mixing function is:
;   i = i+1 & 31;
;   x ^= pool[i] ^ pool[i-2 & 31] ^ pool[i-3 & 31] ^ pool[i-17 & 31]
;   rotate x left 7 bits
;   pool[i] = x

tap1	equ	2
tap2	equ	3
tap3	equ	17
tap4	equ	32	; Must equal pool size (and be a power of 2)
 
	mov	bx, index
	add	bx, (tap4-tap3)*2 + 2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, (tap3-tap2)*2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, (tap2-tap1)*2
	and	bx, (tap4-1)*2
	xor	ax, WORD PTR pool[bx]
	add	bx, tap1*2
	and	bx, (tap4-1)*2
	mov	index, bx
	xor	ax, WORD PTR pool[bx]
	rol	ax, 7
 
;;	mov	WORD PTR pool[bx], ax

