/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)test_dhkeyagree.C	1.6 96/06/03 Sun Microsystems"

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "ObjId.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "HashCert.h"
#include "Sig.h"
#include "bn.h"
#include "bn_glue.h"
#include "bnprint.h"

#define MY_REAL_SECRET_FILE	"my_dh_secret"
#define MY_NSID8_CERT_FILE	"my_nsid8_cert"
#define OTHER_SECRET_FILE	"other_dh_secret"
#define OTHER_NSID8_CERT_FILE	"other_nsid8_cert"

main()
{
	Bstream mysecret =  File_to_Bstr(MY_REAL_SECRET_FILE);
	Bstream mycert = File_to_Bstr(MY_NSID8_CERT_FILE);
	Bstream othersec =  File_to_Bstr(OTHER_SECRET_FILE);
	Bstream othercert = File_to_Bstr(OTHER_NSID8_CERT_FILE);
	Bstream nullbstr;
	Bigint	g, p;
	struct BigNum i, j, mypub, otherpub, mod, shared1, shared2;

	if (mysecret == nullbstr || mycert == nullbstr ||
		othersec == nullbstr || othercert == nullbstr) {
		fprintf(stderr, "could not read secrets or certs\n");
		exit(1);
	}
	fprintf(stderr, "mysecret: i = ");
	mysecret.print();
	fprintf(stderr, "\n");
	fprintf(stderr, "othersecret: j = ");
	othersec.print();
	fprintf(stderr, "\n");

	HashCert myhcert, otherhcert;
	if (myhcert.decode(mycert)) {
		fprintf(stderr, "error decoding my cert\n");
		exit(1);
	}
	fprintf(stderr, "My hashed cert:\n");
	myhcert.print();
	if (otherhcert.decode(othercert)) {
		fprintf(stderr, "error decoding other cert\n");
		exit(1);
	}
	fprintf(stderr, "Other hashed cert:\n");
	otherhcert.print();

	bnInit();
	bnBegin(&i);
	bnBegin(&j);
	bnBegin(&mod);
	bnBegin(&mypub);
	bnBegin(&otherpub);
	bnBegin(&shared1);
	bnBegin(&shared2);

	Bstream_to_BigNum(&mysecret, &i);
	Bstream_to_BigNum(&othersec, &j);
	myhcert.skip_params(g, p);
	Bigint_to_BigNum(&p, &mod);
	Bigint_to_BigNum(&myhcert.skip_pubkey(), &mypub);
	Bigint_to_BigNum(&otherhcert.skip_pubkey(), &otherpub);

	fprintf(stderr, "Calculating shared secret 'pubj^i': ");
	if (bnExpMod(&shared1, &otherpub, &i, &mod) < 0) {
		fprintf(stderr, "Error in calculating shared secret\n");
		exit(1);
	}
	bnPrint(stderr, NULL, &shared1,NULL);
	fprintf(stderr, "\n");

	fprintf(stderr, "Calculating shared secret 'pubi^j': ");
	if (bnExpMod(&shared2, &mypub, &j, &mod) < 0) {
		fprintf(stderr, "Error in calculating shared secret\n");
		exit(1);
	}
	bnPrint(stderr, NULL,&shared2,NULL);
	fprintf(stderr, "\n");

	if (bnCmp(&shared1, &shared2) != 0) {
		fprintf(stderr, "diffie-hellman key agreement failed\n");
	} else
		fprintf(stderr, "test passed\n");
	bnEnd(&i);
	bnEnd(&mypub);
	bnEnd(&j);
	bnEnd(&otherpub);
	bnEnd(&shared1);
	bnEnd(&shared2);

	exit(0);
}
