/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_keymgrmsgs.c	1.23 96/10/01 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_ioctl.h>

#ifdef SKIP_DEBUG
#undef SKIP_DEBUG
#endif
#define SKIP_DEBUG printf

int	skip_server_port = 0;
int	skip_check_cdp_addr = B_FALSE;

/* skip_fmt_kmgr()
 *
 * format a message to send to the key manager daemon
 *
 * Returns: size of the message
 */
int
skip_fmt_kmgr(union skip_messages *sm, skip_keycb_t *cp)
{
	register unsigned int		size = 0;

	SKIP_DEBUG1("skip_fmt_kmgr: send to keymgr VI = %d\n",
						cp->hdr.params.version);
	switch (sm->msgtype) {

	case SKIP_ENCRYPTED_PKT_KEY_REQ:
		/*
		 * request key to encrypt packet
		 */
		PARAMSCOPY(&cp->hdr.params, &sm->enc_req.params);
		size = sizeof (sm->enc_req);
		SKIP_PRINT("skip_fmt_kmgr : SKIP_ENCRYPTED_PKT_KEY_REQ",
							&sm->enc_req.params);
		break;


	case SKIP_DECRYPTED_PKT_KEY_REQ:
		/*
		 * request key to decrypt packet
		 */
		PARAMSCOPY(&cp->hdr.params, &sm->dec_req.params);
		KEYVARSET(sm->dec_req.ekp, cp->hdr.ekp);
		size = sizeof (sm->dec_req);
		SKIP_PRINT("skip_fmt_kmgr : SKIP_DECRYPTED_PKT_KEY_REQ",
							&sm->dec_req.params);
		break;

	default:
		/*
		 * Unknow key manager request message...
		 */
		printf("skip_fmt_kmgr: unknown message=%d\n", sm->msgtype);
	}

	return(size);
}

/* skip_key_fromkm()
 *
 * receive a message from the key manager daemon
 *
 * Returns: none
 */
void
skip_key_fromkm(union skip_messages *sm, unsigned int size)
{
	struct Encrypted_key_rsp	*er = &sm->enc_rsp;
	struct Decrypted_key_rsp	*dr = &sm->dec_rsp;
	struct Set_supported_kij	*ks = &sm->set_kij_alg;
	skip_param_t			*params;

	if (size < sizeof (sm->msgtype)) {
		SKIP_DEBUG("skip_key_fromkm: short message received\n");
		return;
	}

	switch (sm->msgtype) {

	/*
	 * key to encrypt packet returned
	 */
	case SKIP_ENCRYPTED_PKT_KEY_RSP:

		/*
		 *  Check  the response size
		 */
		if (size < sizeof (*er)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"short SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		params = &er->params;

		/*
		 * Check is Kp is supported...
		 */
		if (params->kp_alg > SKIP_MAXCRYPTORS) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp_alg in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		/*
		 * Check is MAC is supported...
		 */
		if (params->mac_alg > SKIP_MAX_MAC) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp_alg in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		/*
		 * Check E_kp...
		 */
		if (params->kp_alg && (er->E_kp.len == 0)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"E_kp length == 0 in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (er->E_kp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: E_kp length in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Check A_kp...
		 */
		if (params->mac_alg && (er->A_kp.len == 0)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"A_kp length == 0 in SKIP_ENCRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (er->A_kp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: A_kp length in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Check the IV...
		 */
		if (er->iv.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: IV length in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Check the encrypted Kp...
		 */
		if (er->ekp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: ekp length in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Protect against alignment problems...
		 */
		if (er->ekp.len % 4) {
			SKIP_DEBUG("skip_key_fromkm: ekp length in "
			"SKIP_ENCRYPTED_PKT_KEY_RSP is not x4\n");
			break;
		}

		/*
		 * update the keystore control block with the response
		 */
		skip_update_encrypt_key(er);
		break;

	/*
	 * key to decrypt packet returned
	 */
	case SKIP_DECRYPTED_PKT_KEY_RSP:

		/*
		 *  Check  the response size
		 */
		if (size < sizeof (*dr)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"short SKIP_DECRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		params = &dr->params;

		/*
		 * Check is Kp is supported...
		 */
		if (params->kp_alg > SKIP_MAXCRYPTORS) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp_alg in SKIP_DECRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		/*
		 * Check is MAC is supported...
		 */
		if (params->mac_alg > SKIP_MAX_MAC) {
			SKIP_DEBUG("skip_key_fromkm: "
			"invalid kp_alg in SKIP_DECRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		/*
		 * Check E_kp...
		 */
		if (params->kp_alg && (dr->E_kp.len == 0)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"E_kp length == 0 in SKIP_DECRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (dr->E_kp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: E_kp length in "
			"SKIP_DECRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Check A_kp...
		 */
		if (params->mac_alg && (dr->A_kp.len == 0)) {
			SKIP_DEBUG("skip_key_fromkm: "
			"A_kp length == 0 in SKIP_DECRYPTED_PKT_KEY_RSP "
			"from key manager\n");
			break;
		}

		if (dr->A_kp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: A_kp length in "
			"SKIP_DECRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Check the encrypted Kp...
		 */
		if (dr->ekp.len > MAXVARSZ) {
			SKIP_DEBUG("skip_key_fromkm: ekp length in "
			"SKIP_DECRYPTED_PKT_KEY_RSP > MAXVARSZ\n");
			break;
		}

		/*
		 * Protect against alignment problems...
		 */
		if (dr->ekp.len % 4) {
			SKIP_DEBUG("skip_key_fromkm: ekp length in "
			"SKIP_DECRYPTED_PKT_KEY_RSP is not x4\n");
			break;
		}

		/*
		 * update the keystore control block with the response
		 */
		skip_update_decrypt_key(dr);
		break;

	/*
	 * configure a local Master Key Id or nodeid
	 */
	case SKIP_SET_LOCAL_KEYID:

		/*
		 * Check message size from key manager
		 */
		if (size != sizeof (struct Set_local_keyid)) {
			SKIP_DEBUG("skip_key_fromkm: wrong-sized "
				"SKIP_SET_LOCAL_KEYID from key manager\n");
			break;
		}

		/*
		 * Try to set local Master Key Id...
		 */
		skip_set_local_keyid(sm->set_keyid.nsid, &sm->set_keyid.mkeyid);
		break;

	/*
	 * Flush all the local master Key Ids
	 */
	case SKIP_FLUSH_LOCAL_KEYID:

		skip_local_keyid_uninit();
		break;

	/*
	 * Configure supported Kij algorithms
	 */
	case SKIP_SET_SUPPORTED_KIJ:

		if (size != sizeof (struct Set_supported_kij)) {
			SKIP_DEBUG("skip_key_fromkm: wrong-sized "
			"SKIP_SET_SUPPORTED_KIJ from key manager\n");
			break;
		}

		if (ks->version == SKIP_V2) {
			skip_kmgr_kij_alg[ks->kij_alg] = B_TRUE;
		} else {
			skip_kmgr_kij_alg_v1[ks->kij_alg] = B_TRUE;
		}
		break;

	/*
	 * Configure the SKIP CDP Server port
	 */
	case SKIP_SET_CDP_SERVER_PORT:

		if (size != sizeof (struct Set_cdp_server_port)) {
			SKIP_DEBUG("skip_key_fromkm: wrong-sized "
			"SKIP_SET_CDP_SERVER_PORT from key manager\n");
			break;
		}

		/*
		 * Store the CDP server port in NET format
		 */
		skip_server_port = htons(sm->set_cdp_port.port);
		break;

	/*
	 * naughty key manager...
	 */
	default:
		SKIP_DEBUG1("skip_key_fromkm: bad msg (%d) from key manager\n",
								sm->msgtype);
		break;
	}
}
