/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_ah.h	1.6 96/07/08 Sun Microsystems"

#ifndef SKIP_AH_H
#define SKIP_AH_H

#ifdef  __cplusplus
extern "C" {
#endif

#define SKIP_MAX_AH_SZ		24	/* Max Authenticated data length */

/*
 * structure describing an MAC engine
 */
typedef struct {
	/*
	 * Private fields
	 */
	int	mod_id;			/* MAC Module Id	*/
	int	kp_len;			/* Key length		*/
	int	data_len;		/* MAC data length	*/

	/*
	 * Methods
	 */
	int	(*sign)(		/* Signature Alg 	*/
			skip_keycb_t  *,/* Key info		*/
			unsigned char *,/* Start of the packet	*/
			unsigned char *,/* Start of AH data	*/
			unsigned int	/* Packet length	*/
			);

	/*
	 * do not initialize the rest of this structure (statistics ...)
	 */
	unsigned long	in_mac;
	unsigned long	in_mac_errs;
	unsigned long	out_mac;
	unsigned long	out_mac_errs;

} skip_mac_t;

extern skip_mac_t	*skip_macalgs[];

/*
 * Get the MAC module ID from mac alg
 */
#define GETMACMOD(mac) 		skip_macalgs[mac]

/*
 * Functions prototypes
 */
extern void	skip_mac_init(void);
extern void	skip_mac_uninit(void);
extern int	skip_sign(skip_keycb_t *, skip_param_t *,
			unsigned char *, unsigned char *, int);
extern int	skip_auth(skip_keycb_t *, skip_param_t *,
			unsigned char *, unsigned char *, int);

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_AH_H */
