/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
#pragma ident "@(#)skip_certbase.C	1.31 96/05/08"
 
#include "Bigint.h"
#include "Bstream.h"

/*
 * System includes
 */
#include <skip_os.h>

#include "db.h"

#include "my_types.h"
#include "Time.h"
#include "ObjId.h"
#include "Name.h"
#include "SkipCert.h"
#include "CertInfo.h"
#include "CertInfoList.h"
#include "X509Cert.h"
#include "X509skip.h"
#include "HashCert.h"
#include "userfuncs.h"
#include "AuthPolicy.h"

#include "Sig.h"
#include "encrypt.h"

#include "skip_certbase.h"
#include "skip_conf.h"
#include "skip_log.h"

char *certs_base=SKIP_CERTSBASE;

char *lockfile=SKIP_CERTSBASE".lock";

// This doesn't belong here but is included because this file gets linked in
// everywhere.

int nsid_sizes[] = {4,4,4,16,16,16,16,6,16,16,16,16}; 


unsigned int db_hash(const void *q, size_t len)
{
	unsigned char *p;
	unsigned int res = 0;

	p = (unsigned char *) q;
	while (len--)
		res = (res << 1) ^ *p++;

	return res;
}

HASHINFO *db_info() {
	static HASHINFO *info_p = NULL;
	static HASHINFO info;

	if (info_p)
		return info_p;

	info_p = &info;

	bzero(&info, sizeof(info));

	info.bsize = 768;
	info.ffactor = 8;
	info.hash = db_hash;
	info.lorder = 0;

	return info_p;
}

void db_check_certinfo_list(u_char nsid, const Bstream& mkid, CertInfoList& l)
{
	CertInfo *p;

	for (p = l.first(); p; p = l.next()) {
		if (nsid != p->nsid || mkid != p->mkid) {
			skip_log(SKIP_NOTICE,
				"deleting misfiled certificate nsid=%d mkid=%s",
					p->nsid, p->mkid.get_info_str());
			l.delete_current();
			continue;
		}

		char *reason = p->check_valid(auth);
		if (reason) {
			skip_log(SKIP_NOTICE,
			"deleting certificate nsid=%d mkid=%s reason=%s",
				p->nsid, p->mkid.get_info_str(), reason);
			l.delete_current();
		}
	}
}


// Given an (nsid,mkid) pair, obtain a corresponding list of certificates
// from the database.

int db_get_certinfo_list(u_char nsid, const Bstream& mkid, CertInfoList& out)
{
	Bstream key;
	DB *db;
	DBT db_key, db_data;
	int ret;

	out.clear();

	key = Bstream(1, &nsid) + mkid;
	db_key.data = (char *)key.getdatap();
	db_key.size = key.getlength();

	if (skip_db_lock())
		return 1;

	db = dbopen(certs_base, O_RDWR, 0600, DB_HASH, db_info());

	if (db == NULL)  {
		skip_log(SKIP_ERROR, "open of %s failed, error=%s",
					certs_base, strerror(errno));
		skip_db_unlock();
		return 1;
	}

	ret = (db->get)(db, &db_key, &db_data, 0);
	if (ret < 0) {
		(db->close)(db);
		skip_db_unlock();
		return 1;
	}

	if (ret == 1) {			// key not found
		(db->close)(db);
		skip_db_unlock();
		return 1;
	}

	Bstream data_s(db_data.size, db_data.data);

	(db->close)(db);
	skip_db_unlock();

	ret = CertInfoList::decode(data_s, out);
	if (ret)
		return ret;

	db_check_certinfo_list(nsid, mkid, out);

	return 0;
}

//  Return a likely certificate for the given (nsid, mkid)

int db_get_certinfo(u_char nsid, const Bstream& mkid, CertInfo& ret)
{
	CertInfoList l;

	if (db_get_certinfo_list(nsid, mkid, l))
		return 1;

	ret = *(l.find_valid_cert(auth));

	return 0;
}


// Store a list of certificates in the database.   
// All of the certificates in the list must be for the same (nsid,mkid).

int db_put_certinfo_list(u_char nsid, const Bstream& mkid, CertInfoList& l)
{
	Bstream key;
	DB *db;
	DBT db_key, db_data;

	db_check_certinfo_list(nsid, mkid, l);

	if (l.length() == 0)
		return skip_del_dh_cert(mkid, nsid);

	key = Bstream(1, &nsid) + mkid;

	db_key.data = (char *)key.getdatap();
	db_key.size = key.getlength();

	Bstream data = l.encode();

	db_data.data = (char *)data.getdatap();
	db_data.size = data.getlength();

	if (skip_db_lock())
		return 1;

	db = dbopen(certs_base, O_RDWR, 0600, DB_HASH, db_info());
	if (db == NULL)  {
		skip_log(SKIP_ERROR, "open of %s failed, error=%s",
					certs_base, strerror(errno));
		skip_db_unlock();
		return 1;
	}

	int ret = (db->put)(db, &db_key, &db_data, 0);

	(db->close)(db);
	skip_db_unlock();

	if (ret < 0)
		return 1;
	return 0;
}

//  Add one certificate to the database

//  Load the existing certificates which correspond to the (nsid,mkid) pair
//
//  Add the new certificate to the list; replace if the new certificate's
//  validity period exactly matches an exiting certificate's
//  Store the updated list

int db_put_certinfo(CertInfo& cert)
{
	CertInfoList l;

	(void) db_get_certinfo_list(cert.nsid, cert.mkid, l);
	l.add_cert(cert);
	return db_put_certinfo_list(cert.nsid, cert.mkid, l);
}

#if 0
int db_fold_certinfo_list(CertInfoList& cert_l)
{
	CertInfo *p;
	int ret = 0;

	for (p = cert_l.first(); p; p = cert_l.next())
		ret += db_put_certinfo(*p);

	return ret;
}
#endif

// delete all certificates for a (nsid,mkid) from the database.
int
skip_del_dh_cert(const Bstream& boxid, u_char nsid)
{
	DB *db;
	DBT db_key;
	Bstream key;
	int ret;

	key=Bstream(1,&nsid)+boxid;
	db_key.data = (char *)key.getdatap();
	db_key.size = key.getlength();
	if (skip_db_lock())
		return -1;

	db = dbopen(certs_base, O_RDWR, 0600, DB_HASH, db_info());
	if (db == NULL)  {
		skip_log(SKIP_ERROR, "open of %s failed, error=%s",
					certs_base, strerror(errno));
		skip_db_unlock();
		return 1;
	}

	ret = (db->del)(db, &db_key, 0);

	(db->close)(db);
	skip_db_unlock();

	if (ret < 0)
		return 1;
	return 0;
}

// file descriptor used by the locking routines.

static int lf;

// locking routines for the datbase.


int skip_db_unlock()
{
	UNLOCKFILE(lf);
        close(lf);
        return 0;
}

int skip_db_lock()
{
        char *lockfile=SKIP_CERTSBASE".lock";
        lf=open(lockfile, O_RDWR|O_CREAT,0644);
	return LOCKFILE(lf);
}
