/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_crypt.C	1.38 96/10/05"

#include "Bigint.h"
#include "Bstream.h"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include "SkipCert.h"
#include "skip_proto.h"
#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_log.h"
#include "skip_keymgrmsgs.h"
#include "skip_key.h"
#include "skip_crypt.h"
#include "skip_ah.h"
#include "skip_enc_alg.h"

#define MAX_CRYPTORS    	255
#define MAX_CRYPT_VERSIONS	2

// Not a great solution, but fast...
// [two versions] by [kij and kp algs] by [alg numbers]
skip_cryptor_t *cryptors[MAX_CRYPT_VERSIONS][2][MAX_CRYPTORS];

int random_encryptor;

int skip_ver_to_cryptor_ver(int ver)
{
	switch(ver) {
		case SKIP_RAW:
			return 1;
		case SKIP_V2:
			return 1;
		case SKIP_V1:
			return 0;
		default:
			return -1;  // Is this right?
	}
}

int
cryptor_get_Ekeylen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg == 0)
		return 0;

	ver = skip_ver_to_cryptor_ver(ver);
	if (ver < 0 || alg > MAX_CRYPTORS || cryptors[ver][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown Ekeysize for Crypt algorithm %d\n",alg);
		return -1;
	}
	return cryptors[ver][algtype][alg]==NULL? 0 : 
			cryptors[ver][algtype][alg]->ekp_len;
}

int
cryptor_get_ivlen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg == 0)
		return 0;
	ver = skip_ver_to_cryptor_ver(ver);

	if (ver < 0 || alg > MAX_CRYPTORS || cryptors[ver][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown iv size for algorithm %d\n",alg);
		return -1;
	}
	return cryptors[ver][algtype][alg]==NULL? 0 : 
		cryptors[ver][algtype][alg]->mid_len;
}

int
cryptor_get_keylen(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg == 0 )
		return 0;
	ver = skip_ver_to_cryptor_ver(ver);

	if (ver < 0 || alg > MAX_CRYPTORS || cryptors[ver][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown CRYPT keysize for algorithm %d\n",alg);
		return -1;
	}
	return cryptors[ver][algtype][alg]==NULL? 0 : 
			cryptors[ver][algtype][alg]->kp_len;
}

int cryptor_get_flags(int ver, int algtype, ENC_ALG_TYPE alg)
{
	if (alg == 0)
		return 0;
	ver = skip_ver_to_cryptor_ver(ver);

	if ( ver < 0 || alg > MAX_CRYPTORS || cryptors[ver][alg] == NULL) {
		skip_log(SKIP_ERROR,"Unknown iv size for algorithm %d\n",alg);
		return -1;
	}
	return cryptors[ver][algtype][alg]==NULL? 0 : 
			cryptors[ver][algtype][alg]->flags;
}

Bstream keymgr_encrypt(int ver, int algtype, ENC_ALG_TYPE alg, 
			const Bstream& key, const Bstream& input)
{
	Bstream result;
	u_char *p;
	void *cs;
	u_char iv[8];
	unsigned x;
	skip_cryptor_t *t;
	Bstream nullstr;
	unsigned char payload_type; /* XXX - value = ? */

	ver = skip_ver_to_cryptor_ver(ver);

	if (ver < 0 || alg > MAX_CRYPTORS) {
		skip_log(SKIP_ERROR,
			"encrypt: Invalid SKIP version/cryptor number");
		return nullstr;
	}

	bzero(iv,8);

	t=cryptors[ver][algtype][alg];

	if (t == NULL) {
		skip_log(SKIP_ERROR,"Attempt to encrypt with nonexistent cryptor");
		return nullstr;
	}

	if (t->flags & SKIP_KEYED_STREAM_CIPHER) {
		skip_log(SKIP_ERROR,
			 "Error: Attempt to use Stream cipher for Kij Alg");
		return nullstr;
	}

	x=input.getlength();
	p=(u_char *)malloc(x);

	cs=(t->open)((char *)key.getdatap(), key.getlength(), (char *)iv, 8);
	/* XXX */
	(t->encrypt)(cs, (char *)input.getdatap(), &x, (char *)p, 
					(char *)iv, 8, &payload_type);
	(t->close)(cs);

	result=Bstream(x,(byte *)p);
	free((char *)p);

	if (result.getlength() == 0)
		skip_log(SKIP_ERROR,"Unable to Encrypt input");
	return result;
}

Bstream keymgr_decrypt(int ver, int algtype, ENC_ALG_TYPE alg, 
			const Bstream& key, const Bstream& input)
{
	u_char *p;
	void *cs;
	u_char iv[8];
	unsigned int x;
	Bstream result;
	Bstream nullstr;
	skip_cryptor_t *t;
	unsigned char payload_type; /* XXX - value = ? */

	ver = skip_ver_to_cryptor_ver(ver);
	if (ver < 0 || alg > MAX_CRYPTORS)
		return nullstr;

	t=cryptors[ver][algtype][alg];

	if (t == NULL) {
		skip_log(SKIP_ERROR,"Attempt to encrypt with nonexistent cryptor");
		return nullstr;
	}


	if (t->flags & SKIP_STREAM_CIPHER) {
		skip_log(SKIP_ERROR,
		 	 "Error: Attempt to use Stream cipher for Kij Alg");
		return nullstr;
	}

	bzero(iv,8);
	x=input.getlength();
	p=(u_char *)malloc(x);

	cs=(t->open)((char *)key.getdatap(), key.getlength(), (char *)iv, 8);
	/* XXX payload_type ? */
	(t->decrypt)(cs, (char *)input.getdatap(), &x, (char *)p,
					(char *)iv, 8, &payload_type);
	(t->close)(cs);
	
	result=Bstream(x, (byte *)p);
	free((char *)p);
#ifdef DEBUG
	printf("decrypting from:");
	input.print();
	printf("decrypted result:");
	final.print();
	printf("\n");
#endif
	if (result.getlength() == 0)
		skip_log(SKIP_ERROR,"Unable to dencrypt input");
	return result;
}

// Encrypt the random kp with "key".  Uses DES if present, otherwise
// simplecrypt.
Bstream
skip_random_encrypt(Bstream key, Bstream randstr) 
{
        return keymgr_encrypt(SKIP_V1, KIJALG, random_encryptor, key, randstr);
}

#define MAX_MACS	255

skip_mac_t *macs[2][MAX_MACS];

void
skip_init_internal_macs(int keyfd)
{
	int i;
	int ver;

	ver = skip_ver_to_cryptor_ver(SKIP_V1);

	for (i=0; i<MAX_MACS; i++) {
		macs[0][i]=NULL;
		macs[1][i]=NULL;
	}
#ifdef HAVE_KEYED_MD5
	macs[ver][skip_md5_mod.mod_id] = &skip_md5_mod;
#endif
}

int
mac_get_keylen(int ver, MAC_ALG_TYPE alg)
{
	if (alg == 0)
		return 0;
	ver = skip_ver_to_cryptor_ver(SKIP_V1);
	if (ver < 0 || alg > MAX_MACS || macs[ver][alg] == NULL) {
		skip_log(SKIP_ERROR,
			  "Unknown keysize for MAC algorithm %d\n",alg);
		return -1;
	}
	return macs[ver][alg]==NULL? 0 : macs[ver][alg]->kp_len;
}

void
skip_init_internal_cryptors(int keyfd)
{
	int i;
	int ver1, ver2;
	ver1 = skip_ver_to_cryptor_ver(SKIP_V1);
	ver2 = skip_ver_to_cryptor_ver(SKIP_V2);
	
	for (i = 0; i < MAX_CRYPTORS; i++){
		cryptors[ver1][KIJALG][i]=NULL;
		cryptors[ver2][KIJALG][i]=NULL;
		cryptors[ver1][KPALG][i]=NULL;
		cryptors[ver2][KPALG][i]=NULL;
	}

	set_kij_alg(keyfd, SKIP_V2, 0);

#ifdef HAVE_SIMPLECRYPT
	cryptors[ver1][KIJALG][simplecrypt_module_v1.kij_algno]=
		&simplecrypt_module_v1;
	cryptors[ver1][KPALG][simplecrypt_module_v1.kp_algno]=
		&simplecrypt_module_v1;
    /*
     * We use the V1 cryptor for kij instead of the V2 one
     * to avoid bad key length (V2 now add payload type)
     */
    	cryptors[ver2][KIJALG][simplecrypt_module.kij_algno]=
       				&simplecrypt_module_v1;
	cryptors[ver2][KPALG][simplecrypt_module.kp_algno]=
				&simplecrypt_module;
	random_encryptor=simplecrypt_module_v1.kij_algno;

	set_kij_alg(keyfd, SKIP_V1, simplecrypt_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, simplecrypt_module.kij_algno);
#endif
#ifdef HAVE_DES_CBC
	cryptors[ver1][KIJALG][des_cbc_nopad_module_v1.kij_algno]=
		&des_cbc_nopad_module_v1;
	cryptors[ver1][KPALG][des_cbc_module_v1.kp_algno]=
		&des_cbc_module_v1;

	cryptors[ver2][KIJALG][des_cbc_nopad_module.kij_algno]=
		&des_cbc_nopad_module;
	cryptors[ver2][KPALG][des_cbc_module.kp_algno]=
		&des_cbc_module;
	random_encryptor=des_cbc_nopad_module_v1.kij_algno;

	set_kij_alg(keyfd, SKIP_V1, des_cbc_nopad_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, des_cbc_nopad_module.kij_algno);
#endif


#ifdef HAVE_DES_EDE_K3
	cryptors[ver2][KIJALG][des_ede_k3_nopad_module.kij_algno]=
		&des_ede_k3_nopad_module;
	cryptors[ver2][KPALG][des_ede_k3_module.kp_algno]=
		&des_ede_k3_module;

	set_kij_alg(keyfd, SKIP_V2, des_ede_k3_nopad_module.kij_algno);

#endif

#ifdef HAVE_RC2_CBC
	cryptors[ver1][KIJALG][rc2_cbc_nopad_module_v1.kij_algno]=
		&rc2_cbc_nopad_module_v1;
	cryptors[ver1][KPALG][rc2_cbc_module_v1.kp_algno]=
		&rc2_cbc_module_v1;
	cryptors[ver2][KIJALG][rc2_cbc_nopad_module.kij_algno]=
		&rc2_cbc_nopad_module;
	cryptors[ver2][KPALG][rc2_cbc_module.kp_algno]=&rc2_cbc_module;

	set_kij_alg(keyfd, SKIP_V1, rc2_cbc_nopad_module_v1.kij_algno);
	set_kij_alg(keyfd, SKIP_V2, rc2_cbc_nopad_module.kij_algno);
#endif

#ifdef HAVE_RC4
        cryptors[ver1][KPALG][rc4_module_v1.kp_algno]=&rc4_module_v1;
	cryptors[ver2][KPALG][rc4_module.kp_algno]=&rc4_module;
#endif

#ifdef HAVE_SAFER_128SK_CBC
	cryptors[ver2][KIJALG][safer_128sk_cbc_nopad_module.kij_algno] = 
		&safer_128sk_cbc_nopad_module;
	cryptors[ver2][KPALG][safer_128sk_cbc_module.kp_algno] = 
	&safer_128sk_cbc_module;
	set_kij_alg(keyfd, SKIP_V2, safer_128sk_cbc_nopad_module.kij_algno);
#endif

#ifdef HAVE_IDEA_CBC
	cryptors[ver2][KIJALG][idea_cbc_nopad_module.kij_algno] = 
		&idea_cbc_nopad_module;
	cryptors[ver2][KPALG][idea_cbc_module.kp_algno] = &idea_cbc_module;
	set_kij_alg(keyfd, SKIP_V2, idea_cbc_nopad_module.kij_algno);
#endif

}
