/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_lib.h	1.49 96/10/04 Sun Microsystems"

#ifdef  __cplusplus
extern "C" {
#endif

#include <skip_msgs.h>

#define	SKIP_ES			"skip_es"	/* kernel module */

#ifdef	SKIP_HDR_SZ
#undef	SKIP_HDR_SZ
#endif

/*
 * string containing returned error messages
 */
extern char		skip_errmsg[];
#define	ERRSTRSZ	(256)

/*
 * SKIP driver access
 */
extern skip_fd_t	_skip_open(char *);
extern void		_skip_close(skip_fd_t);
extern int		_skip_ioctl(skip_fd_t, int, char *, int);

/*
 * for skip_if_state()
 */


#define	SKIP_ES			"skip_es"	/* kernel module */
#ifdef	SKIP_HDR_SZ
#undef	SKIP_HDR_SZ
#endif

extern char	skip_errmsg[];


/*
 * SKIP driver access
 */
extern skip_fd_t	_skip_open(char *);
extern void		_skip_close(skip_fd_t);
extern int		_skip_ioctl(skip_fd_t, int, char *, int);

/*
 * for skip_if_state()
 */
enum		{ Save, Restore };

#ifndef B_TRUE
#define	B_TRUE	(1)
#endif
#ifndef B_FALSE
#define	B_FALSE	(0)
#endif
#ifndef boolean_t
#define	boolean_t	int
#endif

/*
 * general use
 */
extern int	skip_pre_checks(char *name);
extern char	*skip_default_if();
extern int	skip_hostname();
extern int	skip_host_to_addr(char *, struct in_addr *);
extern int	skip_addr_to_host(struct in_addr *, char *);
extern boolean_t	skip_use_nameservice;

/*
 * interface manipulation routines
 */
extern int	skip_if_state(char *, int);
extern int	skip_if_set_mtu(char *, int);
extern int	skip_if_get_mtu(char *);
extern int	skip_if_get_broadcast(char *, struct in_addr *);
extern int	skip_if_module_present(char *);
extern int	skip_if_plumb(char *, int);
extern int	skip_if_unplumb(char *);

/*
 * access control manipulation routines
 */

extern int	skip_acl_to_name(skip_param_t *, char *, boolean_t);
extern int	skip_set_mode(char *, unsigned char);
extern int	skip_get_mode(char *);
extern int	skip_access_ctrl_on(char *);
extern int	skip_access_ctrl_off(char *);
extern int	skip_acl_add(char *, skip_param_t *);
extern int	skip_acl_del(char *, skip_param_t *);
extern int	skip_acl_get(char *, skip_param_t *);
extern int	skip_acl_list(char *, void (*f)());
extern int	skip_s_to_keyid(char *, unsigned char, skip_key_var_t *);
extern int	skip_keyid_to_s(skip_key_var_t *, unsigned char, char *);
extern void	skip_host_print(skip_param_t *);

/*
 * algorithm manipulation routines
 */
#define	SKIP_DEFAULT_KIJ_ALG	"DES-CBC"
#define	SKIP_DEFAULT_KP_ALG	"DES-CBC"
#define	SKIP_DEFAULT_KIJ_ALG_EX	"RC2-40"
#define	SKIP_DEFAULT_KP_ALG_EX	"RC4-40"
#define	SKIP_DEFAULT_MAC_ALG	"MD5"
#define	SKIP_NO_ALG		"none"

#define	SKIP_DEFAULT		"default"
#define	UNKNOWN			"<unknown>"
#define	SKIP_NOMAD		"*"

/*
 * structure holding NSID information
 */
typedef struct {
	char		*name;
	int		len;
} skip_nsid_inf_t;

extern const int 	skip_max_algs;
extern const int 	skip_max_nsids;
extern skip_nsid_inf_t	skip_nsids[];
extern const boolean_t	skip_supported_nsids[];
extern char		*skip_kij_algs[];
extern char		*skip_kp_algs[];
extern int		skip_get_kp_algs(char *);
extern int		skip_get_kij_algs(char *);
extern int		skip_name_to_kij_alg(char *, unsigned char);
extern int		skip_name_to_kp_alg(char *, unsigned char);
extern int		skip_name_to_mac_alg(char *, unsigned char);
extern char		*skip_kij_alg_to_name(int, unsigned char);
extern char		*skip_kp_alg_to_name(int, unsigned char);
extern char		*skip_mac_alg_to_name(int, unsigned char);
extern boolean_t	skip_supported_kij_alg(int, unsigned char);
extern boolean_t	skip_supported_kp_alg(int, unsigned char);
extern boolean_t	skip_supported_mac_alg(int, unsigned char);


/*
 * skip variable manipulation
 */
extern int	skip_var_init(char *, char *);
extern int	skip_get_encrypt_key_status(int, void *);
extern int	skip_get_decrypt_key_status(int);
extern int	skip_bytes_percent();

/*
 * skip statistics routines
 */
extern int	skip_get_stats_key(char *, ioctl_key_stat_t *);
extern int	skip_get_stats_hdr(char *, ioctl_hdr_stat_t *);
extern int	skip_get_crypt_list(char *, ioctl_alg_list_t *);
extern int	skip_get_kij_list(char *, ioctl_alg_list_t *);
extern int	skip_get_crypt_stats(char *, ioctl_crypt_stat_t *);
extern int	skip_get_mac_stats(char *, ioctl_mac_stat_t *);
extern int	skip_get_list_keyids(char *, ioctl_keyid_t *);

/*
 * kernel variable access routines
 */
extern int	skip_var_get(char *, char  *, int *);
extern int	skip_var_set(char *, char  *, int);
extern int	skip_get_status_keys(char *, ioctl_key_status_t *);

/*
 * key manager support
 */
extern void	skip_time_stamp(char *);
extern int	skip_open_device(char *);
extern int	skip_getmsg(int, void *, int);
extern int	skip_putmsg(int, void *, int);
extern void	skip_fill_random(char *, unsigned int);

/*
 * For command line parsing...
 */
extern char	*optarg;
extern int	optind;

/*
 * Tools main entry points
 */
#ifndef SKIPNOMAIN
#define	SKIPHOST	main
#define	SKIPVAR		main
#define	SKIPSTAT	main
#define	SKIPD		main
#endif

#ifdef  __cplusplus
}
#endif

