/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.test.BaseTest;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.ASCII_CharStream;
import cryptix.util.test.JJMakerCalls;
import cryptix.util.test.MakerConstants;
import cryptix.util.test.MakerTokenManager;
import cryptix.util.test.ParseException;
import cryptix.util.test.Token;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Mode;
import java.security.Parameterized;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Maker
extends BaseTest
implements MakerConstants {
    private MessageDigest md;
    private Cipher algc;
    private Mode algm;
    private String implementation;
    private String mode;
    private String padding;
    private byte[] iv;
    private Hashtable properties = new Hashtable();
    private int gCount;
    private int count;
    private static final String HEADER = "Cryptix security provider algorithm implementation test interpreter\nVersion: $Revision: 1.6 $\nCopyright (c) 1997, Systemics Ltd on behalf of the\nCryptix Development Team. All rights reserved.\n";
    private static final String USAGE = "Usage:\n\tjava cryptix.util.test.Maker inputfile [ > outputfile ]\n\tjava cryptix.util.test.Maker < inputfile [ > outputfile ]\n";
    private static final String SEPARATOR = "\n------------------------------------------------------------\n";
    public MakerTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private final int[] jj_la1_0 = new int[]{65920, 65920, 512, 0x3000000, 1536, 0x200000, 0x3000000, 512, 262144, 1536, 2048, 4096, 8192, 0x200000, 0x200000, 262144, 0x3000000};
    private final JJMakerCalls[] jj_2_rtns = new JJMakerCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    private int trace_indent;
    private boolean trace_enabled = true;

    public static void main(String[] stringArray) {
        Maker maker;
        if (stringArray.length == 0) {
            System.out.println(HEADER);
            System.out.println("Parsing standard input...\n");
            maker = new Maker(System.in);
        } else if (stringArray.length == 1) {
            System.out.println(HEADER);
            System.out.println("Parsing " + stringArray[0] + "...\n");
            try {
                maker = new Maker(new FileInputStream(stringArray[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File '" + stringArray[0] + "' not found.");
                return;
            }
        } else {
            System.out.println(USAGE);
            return;
        }
        maker.commandline(new String[0]);
    }

    protected void engineTest() throws Exception {
        this.Specification();
    }

    public final void Specification() throws ParseException {
        this.trace_call("Specification");
        try {
            this.disable_tracing();
            this.gCount = 0;
            block5: while (true) {
                this.TestModule();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 16: {
                        continue block5;
                    }
                }
                break;
            }
            this.jj_la1[0] = this.jj_gen;
            this.jj_consume_token(0);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.trace_return("Specification");
            throw throwable;
        }
        Object var2_1 = null;
        this.trace_return("Specification");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void TestModule() throws ParseException {
        this.trace_call("TestModule");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: {
                    this.MessageDigestTest();
                    return;
                }
                case 8: {
                    this.CipherTest();
                    return;
                }
                case 16: {
                    this.IncludedTest();
                    return;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            Object var2_1 = null;
            this.trace_return("TestModule");
        }
    }

    public final void MessageDigestTest() throws ParseException {
        this.trace_call("MessageDigestTest");
        try {
            this.jj_consume_token(7);
            this.implementation = this.Identifier();
            this.algc = null;
            this.algm = null;
            this.properties.clear();
            this.count = 0;
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.MessageDigestProperties();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                this.jj_consume_token(10);
                System.out.println("\n" + ++this.gCount + ". " + this.implementation + " test round #" + ++this.count + "...");
                try {
                    this.md = MessageDigest.getInstance(this.implementation);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Error(throwable.getMessage());
                }
                if (this.properties.isEmpty()) {
                    Object var2_5 = null;
                    this.trace_return("MessageDigestTest");
                    return;
                }
                if (this.md instanceof Parameterized) {
                    Enumeration enumeration = this.properties.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Object v = this.properties.get(string);
                        System.out.println("  " + string + ":\t" + v);
                        try {
                            ((Parameterized)this.md).setParameter(string, v);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            throw new Error(throwable.getMessage());
                        }
                    }
                } else {
                    System.out.println("Message digest " + this.implementation + " does not implement java.security.Parameterized.\n" + "Will ignore requested property values...");
                }
                block17: while (true) {
                    this.MessageDigestData();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 24: 
                        case 25: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[3] = this.jj_gen;
                System.out.println(SEPARATOR);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: {
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.trace_return("MessageDigestTest");
            throw throwable;
        }
        Object var2_6 = null;
        this.trace_return("MessageDigestTest");
    }

    public final void MessageDigestProperties() throws ParseException {
        this.trace_call("MessageDigestProperties");
        try {
            this.jj_consume_token(9);
            block5: while (true) {
                this.AlgorithmSpecificProperty();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        continue block5;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.trace_return("MessageDigestProperties");
            throw throwable;
        }
        Object var2_1 = null;
        this.trace_return("MessageDigestProperties");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void MessageDigestData() throws ParseException {
        this.trace_call("MessageDigestData");
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 25: {
                    this.SingleIterationData();
                    return;
                }
                case 24: {
                    this.MultiIterationData();
                    return;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            Object var2_1 = null;
            this.trace_return("MessageDigestData");
        }
    }

    public final void SingleIterationData() throws ParseException {
        this.trace_call("SingleIterationData");
        try {
            Token token = this.jj_consume_token(25);
            byte[] byArray = this.HexadecimalData();
            System.out.println("  input:  " + token.image);
            String string = token.image.substring(1, token.image.length() - 1);
            System.out.println(" digest:  " + Hex.toString(byArray));
            byte[] byArray2 = this.md.digest(string.getBytes());
            boolean bl = ArrayUtil.areEqual(byArray, byArray2);
            this.passIf(bl, "\nDigest operation");
            if (!bl) {
                System.out.println("Computed value is: " + Hex.toString(byArray2));
            }
            System.out.println();
        }
        catch (Throwable throwable) {
            Object var2_7 = null;
            this.trace_return("SingleIterationData");
            throw throwable;
        }
        Object var2_6 = null;
        this.trace_return("SingleIterationData");
    }

    public final void MultiIterationData() throws ParseException {
        this.trace_call("MultiIterationData");
        try {
            Token token = this.jj_consume_token(24);
            this.jj_consume_token(26);
            Token token2 = this.jj_consume_token(25);
            byte[] byArray = this.HexadecimalData();
            long l = new Long(token.image);
            System.out.println("  input:  " + l + " times " + token2.image);
            String string = token2.image.substring(1, token2.image.length() - 1);
            System.out.println(" digest:  " + Hex.toString(byArray));
            byte[] byArray2 = string.getBytes();
            long l2 = 0L;
            while (l2 < l) {
                this.md.update(byArray2);
                ++l2;
            }
            byte[] byArray3 = this.md.digest();
            boolean bl = ArrayUtil.areEqual(byArray, byArray3);
            this.passIf(bl, "\nDigest operation");
            if (!bl) {
                System.out.println("Computed digest is: " + Hex.toString(byArray3));
            }
            System.out.println();
        }
        catch (Throwable throwable) {
            Object var2_11 = null;
            this.trace_return("MultiIterationData");
            throw throwable;
        }
        Object var2_10 = null;
        this.trace_return("MultiIterationData");
    }

    public final void CipherTest() throws ParseException {
        this.trace_call("CipherTest");
        try {
            this.jj_consume_token(8);
            this.implementation = this.Identifier();
            this.mode = "ECB";
            this.padding = "NONE";
            this.iv = null;
            this.md = null;
            this.properties.clear();
            this.count = 0;
            block18: while (true) {
                String string;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.CipherProperties();
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                this.jj_consume_token(10);
                System.out.println("\n" + ++this.gCount + ". " + this.implementation + " test round #" + ++this.count + "...");
                System.out.println("  mode:\t\t" + this.mode);
                if (this.padding != null) {
                    System.out.println("  padding:\t" + this.padding);
                    string = String.valueOf(this.implementation) + "/" + this.mode + "/" + this.padding;
                } else {
                    string = String.valueOf(this.implementation) + "/" + this.mode;
                }
                try {
                    this.algm = (Mode)Cipher.getInstance((String)string);
                }
                catch (ClassCastException classCastException) {
                    this.algm = null;
                    try {
                        this.algc = Cipher.getInstance((String)string);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new Error(throwable.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Error(throwable.getMessage());
                }
                if (this.iv != null) {
                    System.out.println("  iv:\t\t" + Hex.toString(this.iv));
                    ((FeedbackCipher)this.algm).setInitializationVector(this.iv);
                }
                if (this.algm != null) {
                    this.algc = this.algm;
                }
                Enumeration enumeration = this.properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Object v = this.properties.get(string2);
                    System.out.println("  " + string2 + ":\t" + v);
                    try {
                        this.algc.setParameter(string2, v);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        throw new Error(throwable.getMessage());
                    }
                }
                block20: while (true) {
                    this.CipherData();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: {
                            continue block20;
                        }
                    }
                    break;
                }
                this.jj_la1[8] = this.jj_gen;
                System.out.println(SEPARATOR);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: {
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
        }
        catch (Throwable throwable) {
            Object var2_9 = null;
            this.trace_return("CipherTest");
            throw throwable;
        }
        Object var2_8 = null;
        this.trace_return("CipherTest");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void CipherProperties() throws ParseException {
        this.trace_call("CipherProperties");
        try {
            block18: {
                this.jj_consume_token(9);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        this.mode = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        this.padding = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        this.iv = this.HexadecimalData();
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block18;
                    }
                }
                block17: while (true) {
                    this.AlgorithmSpecificProperty();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[13] = this.jj_gen;
            }
            Object var2_1 = null;
            this.trace_return("CipherProperties");
            return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.trace_return("CipherProperties");
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void CipherData() throws ParseException {
        block7: {
            this.trace_call("CipherData");
            try {
                if (this.jj_2_1(3)) {
                    this.TwoWayTestData();
                    break block7;
                }
                if (this.jj_2_2(3)) {
                    this.SymmetricTestData();
                    break block7;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.SpeedTestData();
                        ** break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (Throwable var1_3) {
                var2_2 = null;
                this.trace_return("CipherData");
                throw var1_3;
            }
lbl24:
            // 1 sources

        }
        var2_1 = null;
        this.trace_return("CipherData");
    }

    public final void TwoWayTestData() throws ParseException {
        this.trace_call("TwoWayTestData");
        try {
            byte[] byArray = this.HexadecimalData();
            byte[] byArray2 = this.HexadecimalData();
            byte[] byArray3 = this.HexadecimalData();
            try {
                System.out.print("  key:\t\t");
                System.out.println(Hex.dumpString(byArray));
                System.out.print("  input:\t");
                System.out.println(Hex.dumpString(byArray2));
                System.out.print("  output:\t");
                System.out.println(Hex.dumpString(byArray3));
                RawSecretKey rawSecretKey = new RawSecretKey(this.implementation, byArray);
                this.algc.initEncrypt((Key)rawSecretKey);
                byte[] byArray4 = this.algc.crypt(byArray2);
                boolean bl = ArrayUtil.areEqual(byArray3, byArray4);
                this.passIf(bl, "\nEncryption");
                if (!bl) {
                    System.out.println("Computed output is: " + Hex.dumpString(byArray4));
                }
                this.algc.initDecrypt((Key)rawSecretKey);
                byArray4 = this.algc.crypt(byArray3);
                bl = ArrayUtil.areEqual(byArray2, byArray4);
                this.passIf(bl, "\nDecryption");
                if (!bl) {
                    System.out.print("Computed input is: " + Hex.dumpString(byArray4));
                }
                System.out.println();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Error(throwable.getMessage());
            }
            Object var2_8 = null;
            this.trace_return("TwoWayTestData");
            return;
        }
        catch (Throwable throwable) {
            Object var2_9 = null;
            this.trace_return("TwoWayTestData");
            throw throwable;
        }
    }

    public final void SymmetricTestData() throws ParseException {
        this.trace_call("SymmetricTestData");
        try {
            byte[] byArray = this.HexadecimalData();
            byte[] byArray2 = this.HexadecimalData();
            this.jj_consume_token(14);
            try {
                System.out.print("  key:\t\t");
                System.out.println(Hex.dumpString(byArray));
                System.out.print("  input:\t");
                System.out.println(Hex.dumpString(byArray2));
                RawSecretKey rawSecretKey = new RawSecretKey(this.implementation, byArray);
                this.algc.initEncrypt((Key)rawSecretKey);
                byte[] byArray3 = this.algc.crypt(byArray2);
                this.algc.initDecrypt((Key)rawSecretKey);
                byArray3 = this.algc.crypt(byArray3);
                boolean bl = ArrayUtil.areEqual(byArray2, byArray3);
                this.passIf(bl, "\nSymmetric operation");
                if (!bl) {
                    System.out.println("Computed input is: " + Hex.dumpString(byArray3));
                }
                System.out.println();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Error(throwable.getMessage());
            }
            Object var2_7 = null;
            this.trace_return("SymmetricTestData");
            return;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.trace_return("SymmetricTestData");
            throw throwable;
        }
    }

    public final void SpeedTestData() throws ParseException {
        this.trace_call("SpeedTestData");
        try {
            byte[] byArray = this.HexadecimalData();
            byte[] byArray2 = this.HexadecimalData();
            this.jj_consume_token(15);
            try {
                int n;
                System.out.print("  key:\t\t");
                System.out.println(Hex.dumpString(byArray));
                System.out.print("  input:\t");
                System.out.println(Hex.dumpString(byArray2));
                byte[] byArray3 = (byte[])byArray2.clone();
                int n2 = byArray3.length;
                RawSecretKey rawSecretKey = new RawSecretKey(this.implementation, byArray);
                System.out.println("\nSpeed tests over 100,000 * " + n2 + " bytes...\n");
                this.algc.initEncrypt((Key)rawSecretKey);
                System.out.println("Encryption...");
                System.out.println("  start date/time:  " + new Date().toString());
                int n3 = 0;
                while (n3 < 100) {
                    n = 0;
                    while (n < 1000) {
                        this.algc.update(byArray3, 0, n2, byArray3, 0);
                        ++n;
                    }
                    ++n3;
                }
                System.out.println("  finish date/time: " + new Date().toString());
                this.algc.initDecrypt((Key)rawSecretKey);
                System.out.println("\nDecryption...");
                System.out.println("  start date/time:  " + new Date().toString());
                n3 = 0;
                while (n3 < 100) {
                    n = 0;
                    while (n < 1000) {
                        this.algc.update(byArray3, 0, n2, byArray3, 0);
                        ++n;
                    }
                    ++n3;
                }
                System.out.println("  finish date/time: " + new Date().toString());
                boolean bl = ArrayUtil.areEqual(byArray2, byArray3);
                this.passIf(bl, "\nSymmetric operation");
                if (!bl) {
                    System.out.println("Computed input is: " + Hex.dumpString(byArray3));
                }
                System.out.println();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new Error(throwable.getMessage());
            }
            Object var2_10 = null;
            this.trace_return("SpeedTestData");
            return;
        }
        catch (Throwable throwable) {
            Object var2_11 = null;
            this.trace_return("SpeedTestData");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void AlgorithmSpecificProperty() throws ParseException {
        this.trace_call("AlgorithmSpecificProperty");
        try {
            Token token = this.jj_consume_token(21);
            this.jj_consume_token(27);
            String string = token.image;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: {
                    Token token2 = this.jj_consume_token(24);
                    this.properties.put(string, new Integer(token2.image));
                    return;
                }
                case 25: {
                    Token token3 = this.jj_consume_token(25);
                    this.properties.put(string, token3.image.substring(1, token3.image.length() - 1));
                    return;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        finally {
            Object var2_5 = null;
            this.trace_return("AlgorithmSpecificProperty");
        }
    }

    public final String Identifier() throws ParseException {
        this.trace_call("Identifier");
        try {
            Token token = this.jj_consume_token(20);
            String string = token.image;
            Object var3_3 = null;
            this.trace_return("Identifier");
            return string;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.trace_return("Identifier");
            throw throwable;
        }
    }

    public final byte[] HexadecimalData() throws ParseException {
        this.trace_call("HexadecimalData");
        try {
            Token token = this.jj_consume_token(18);
            String string = token.image;
            String string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = String.valueOf(string2) + stringTokenizer.nextToken();
            }
            byte[] byArray = Hex.fromString(string2);
            Object var3_6 = null;
            this.trace_return("HexadecimalData");
            return byArray;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.trace_return("HexadecimalData");
            throw throwable;
        }
    }

    public final void IncludedTest() throws ParseException {
        this.trace_call("IncludedTest");
        try {
            this.jj_consume_token(16);
            Token token = this.jj_consume_token(25);
            Maker maker = null;
            String string = token.image.substring(1, token.image.length() - 1);
            System.out.println("Begin included file " + string + "...\n");
            try {
                maker = new Maker(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File '" + string + "' not found...\n");
                System.out.println("End included file " + string + "...\n");
                Object var2_4 = null;
                this.trace_return("IncludedTest");
                return;
            }
            try {
                maker.Specification();
                this.pass("Parsing included file " + string);
            }
            catch (ParseException parseException) {
                this.fail("Parsing included file " + string);
                System.out.println(parseException.getMessage());
                parseException.printStackTrace();
            }
            Object var2_5 = null;
            this.trace_return("IncludedTest");
            return;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.trace_return("IncludedTest");
            throw throwable;
        }
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_3R_8() {
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public Maker(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new MakerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 17) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJMakerCalls();
            ++n2;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 17) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJMakerCalls();
            ++n2;
        }
    }

    public Maker(MakerTokenManager makerTokenManager) {
        this.token_source = makerTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 17) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJMakerCalls();
            ++n2;
        }
    }

    public void ReInit(MakerTokenManager makerTokenManager) {
        this.token_source = makerTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 17) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJMakerCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJMakerCalls jJMakerCalls = this.jj_2_rtns[n2];
                    while (jJMakerCalls != null) {
                        if (jJMakerCalls.gen < this.jj_gen) {
                            jJMakerCalls.first = null;
                        }
                        jJMakerCalls = jJMakerCalls.next;
                    }
                    ++n2;
                }
            }
            this.trace_token(this.token, "");
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        this.trace_token(this.token, " (in getNextToken)");
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
            return;
        }
        if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[28];
        int n2 = 0;
        while (n2 < 28) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 17) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 28) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArray, MakerConstants.tokenImage);
    }

    public final void enable_tracing() {
        this.trace_enabled = true;
    }

    public final void disable_tracing() {
        this.trace_enabled = false;
    }

    private final void trace_call(String string) {
        if (this.trace_enabled) {
            int n = 0;
            while (n < this.trace_indent) {
                System.out.print(" ");
                ++n;
            }
            System.out.println("Call:   " + string);
        }
        this.trace_indent += 2;
    }

    private final void trace_return(String string) {
        this.trace_indent -= 2;
        if (this.trace_enabled) {
            int n = 0;
            while (n < this.trace_indent) {
                System.out.print(" ");
                ++n;
            }
            System.out.println("Return: " + string);
        }
    }

    private final void trace_token(Token token, String string) {
        if (this.trace_enabled) {
            int n = 0;
            while (n < this.trace_indent) {
                System.out.print(" ");
                ++n;
            }
            System.out.print("Consumed token: <" + MakerConstants.tokenImage[token.kind]);
            if (token.kind != 0 && !MakerConstants.tokenImage[token.kind].equals("\"" + token.image + "\"")) {
                System.out.print(": \"" + token.image + "\"");
            }
            System.out.println(">" + string);
        }
    }

    private final void trace_scan(Token token, int n) {
        if (this.trace_enabled) {
            int n2 = 0;
            while (n2 < this.trace_indent) {
                System.out.print(" ");
                ++n2;
            }
            System.out.print("Visited token: <" + MakerConstants.tokenImage[token.kind]);
            if (token.kind != 0 && !MakerConstants.tokenImage[token.kind].equals("\"" + token.image + "\"")) {
                System.out.print(": \"" + token.image + "\"");
            }
            System.out.println(">; Expected token: <" + MakerConstants.tokenImage[n] + ">");
        }
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 2) {
            JJMakerCalls jJMakerCalls = this.jj_2_rtns[n];
            do {
                if (jJMakerCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJMakerCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJMakerCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                }
            } while ((jJMakerCalls = jJMakerCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJMakerCalls jJMakerCalls = this.jj_2_rtns[n];
        while (jJMakerCalls.gen > this.jj_gen) {
            if (jJMakerCalls.next == null) {
                jJMakerCalls = jJMakerCalls.next = new JJMakerCalls();
                break;
            }
            jJMakerCalls = jJMakerCalls.next;
        }
        jJMakerCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJMakerCalls.first = this.token;
        jJMakerCalls.arg = n2;
    }
}

