/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.JceSecurity;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private Provider provider;
    private KeyAgreementSpi keyAgreeSpi;
    private String algorithm;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.keyAgreeSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Key doPhase(int n, Key key) throws IllegalStateException, InvalidKeyException {
        return this.keyAgreeSpi.engineDoPhase(n, key);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        return this.keyAgreeSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        return this.keyAgreeSpi.engineGenerateSecret(byArray, n);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = JceSecurity.getImpl(string, "KeyAgreement", null);
            return new KeyAgreement((KeyAgreementSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] objectArray = JceSecurity.getImpl(string, "KeyAgreement", string2);
        return new KeyAgreement((KeyAgreementSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(SecureRandom secureRandom) {
        this.keyAgreeSpi.engineInit(secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.keyAgreeSpi.engineInit(algorithmParameterSpec, secureRandom);
    }
}

