/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;

public final class PBEKeyFactory
extends SecretKeyFactorySpi {
    static /* synthetic */ Class class$javax$crypto$spec$PBEKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        return new PBEKey((PBEKeySpec)keySpec);
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            if (secretKey != null && secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("PBE") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> clazz2 = Class.forName("javax.crypto.spec.PBEKeySpec");
                if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                    return new PBEKeySpec(new String(secretKey.getEncoded()));
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("PBE") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof PBEKey) {
                    return secretKey;
                }
                PBEKeySpec pBEKeySpec = (PBEKeySpec)this.engineGetKeySpec(secretKey, class$javax$crypto$spec$PBEKeySpec != null ? class$javax$crypto$spec$PBEKeySpec : (class$javax$crypto$spec$PBEKeySpec = PBEKeyFactory.class$("javax.crypto.spec.PBEKeySpec")));
                return this.engineGenerateSecret(pBEKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

