#ifndef EC_INCL_EADDR_H
#define EC_INCL_EADDR_H
/* beginning of eaddr.h */

	/* ecashlib public headers */
#include "eaddr.fh"
#include "eerrno.fh"
#include "eecdef.h"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "eaddr.ih"
#endif


	/* EC_Address functions */

/*
 * Create a new EC_Address.
 *
 * parameters:
 *	addr_size: the size of the addr_contents data.
 *	addr_contents: a pointer to a block of a data of size 
 *		addr_size containing the address contents.  EC_addr_new 
 *		will make a copy of addr_contents, so you may free 
 *		addr_contents after calling EC_addr_new().
 */
EC_EXPORT EC_Address *EC_addr_new(UInt32 addr_size, const Byte *addr_contents);


/*
 * Free an EC_Address.
 *
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_addr_free(EC_Address *this_addr_ptr);


/*
 * Duplicate an EC_Address.
 *
 * return values:
 *	pointer to the new EC_Address on success, NULL on failure.
 */
EC_EXPORT EC_Address *EC_addr_dup(const EC_Address *this_addr_lnk);


/*
 * Get the contents of an EC_Address.
 */
EC_EXPORT UInt32 EC_addr_get_size(const EC_Address *this_addr_lnk);

EC_EXPORT Byte *EC_addr_get_contents(const EC_Address *this_addr_lnk);


/* end of eaddr.h */
#endif

