#ifndef EC_INCL_ECOINAGE_H
#define EC_INCL_ECOINAGE_H
/* beginning of ecoinage.h */


	/* ecashlib public headers */
#include "ecoinage.fh"
#include "emintid.fh"
#include "eerrno.fh"


	/* debug info headers */

#ifdef DC_DEBUG_INFO
#include "ecoinage.ih"
#endif


	/* EC_Coinage functions */


/* 
 * Note the absence of a public "EC_coinage_new()" function.  Instead
 * use EC_info_get_coinage().
 */


/*
 * Free an EC_Coinage.
 * return values:
 *	standard EC_Errno
 */
EC_EXPORT EC_Errno EC_coinage_free(EC_Coinage *this_coinage_ptr);

/*
 * Get the mint ID of a coinage.
 * return values:
 *	The mint ID on success, EC_MINTID_INVALID on failure.
 */
EC_EXPORT EC_MintID EC_coinage_get_mintID(const EC_Coinage *this_coinage_lnk);

/*
 * Get the currency ID of a coinage.
 * return values:
 *	The currency ID on success, EC_CURRID_INVALID on failure.
 */
EC_EXPORT EC_CurrencyID EC_coinage_get_currID(const EC_Coinage *this_coinage_lnk);

/*
 * Get the magnitude of the base value of a coinage.
 * return values:
 *	The magnitude of the base value on success, EC_MININT32 on failure.
 */
EC_EXPORT Int32 EC_coinage_get_base_magn(const EC_Coinage *this_coinage_lnk);

/*
 * Get the factor of the base value of a coinage.
 * return values:
 *	The magnitude of the base value on success, EC_MAXUINT32 on failure.
 */
EC_EXPORT UInt32 EC_coinage_get_base_factor(const EC_Coinage *this_coinage_lnk);

/*
 * Get the granularity of a coinage.
 * return values:
 *	The granularity of the coinage on success, EC_MININT32 on failure.
 */
EC_EXPORT Int32 EC_coinage_get_granularity(const EC_Coinage *this_coinage_lnk);



/* end of ecoinage.h */
#endif

