#include <stdio.h>
#include <alloc.h>
#include <mem.h>
#include "x8.h"

#define block_size 8192
#define min_block 3

#define rounds 6
#define passlen 255

#define chain_ECB 0
#define chain_PCBC 1

#define PASS_NC 0
#define PASS_OK 1
#define PASS_NA 2

void main()
{
int i;
int passerr=0;
int len1, len2;
char inputfile[80], outputfile[80];
FILE *infile,*outfile;
unsigned long filesize;
long int blocks,j;
unsigned finalblocksize,splitsize;
char pass1[passlen], pass2[passlen];
BYTE PTR keymem,PTR lastblock,PTR currblock,PTR spareblock,PTR roundkeys;
int chaining=chain_PCBC;
int e_d=ENCRYPT;
int method=m_ROT13;
char inchar;

printf("1 - M8 (A new algorithm) similar to SCOTT8)\n");
printf("2 - IS8 (Improved SCOTT8)\n");
printf("3 - RS8 (Reduced SCOTT8)\n");
printf("4 = ROT13 (NOT SECURE = DOESN'T USE A PASSWORD)\n");
printf("\nChoice (1-4): ");
getkey(inchar);
printf("\n");
switch (inchar)
	{
	case '1': method=m_M8; break;
	case '2': method=m_IS8; break;
	case '3': method=m_RS8; break;
	case '4': method=m_ROT13; break;
	default:
		printf("Invalid choice!!!\n");
		return;
	}

printf("E - Encrypt\n");
printf("D - Decrypt\n");
printf("\nChoice (E/D): ");
getkey(inchar);
printf("\n");
if (inchar=='E' || inchar=='e') e_d=ENCRYPT;
else if (inchar=='D' || inchar=='d') e_d=DECRYPT;
else	{
		printf("Invalid choice!!!\n");
		return;
		}

if (method==m_ROT13)
	printf("Only \"No Chaining\" yields 'Printable Characters'\n");
printf("P - PCBC Chaining\n");
printf("N - No Chaining\n");
printf("\nChoice (P/N): ");
getkey(inchar);
printf("\n");
if (inchar=='P' || inchar=='p') chaining=chain_PCBC;
else if (inchar=='N' || inchar=='n') chaining=chain_ECB;
else	{
		printf("Invalid choice!!!\n");
		return;
		}

/* get the space it needs for a key schedule */
if (NULL==(keymem=getmem(table_size<<1))) return;
if (NULL==(roundkeys=getmem(rounds*roundkeysize))) return;
/* get the space for the blocks it uses in chaining and encryption */
if (NULL==(lastblock=getmem(block_size))) return;
if (NULL==(spareblock=getmem(block_size))) return;
if (NULL==(currblock=getmem(block_size))) return;

/* zero out the new memory for chaining */
clrmem(spareblock,block_size);
clrmem(lastblock,block_size);

/* get the input and output file names */
getfile("Input File : ",inputfile);
infile=fopen(inputfile,"rb");
memset(inputfile,0,80);	/* clear the file name */
if (infile==0)
	{
	printf("Error opening input file\n");
	return;
	}

/* get the file length and reset position to beginning */
fseek(infile,0L,SEEK_END);
filesize=ftell(infile);
rewind(infile);
if (filesize<min_block)
	{
	printf("File smaller than minimum block size\n");
	fclose(infile);
	return;
	}

getfile("Output File : ",outputfile);
outfile=fopen(outputfile,"wb+");
memset(outputfile,0,80);	/* clear the file name */
if (outfile==0)
	{
	printf("Error opening output file\n");
	fclose(infile);
	fclose(outfile);
	return;
	}


if (method==m_ROT13) len2=PASS_NA;
else len2=PASS_NC;
while (passerr<3 && len2==0)
	{
	/* get the password and confirm it */
	len1=passget("Password : ",passlen,pass1);
	len2=passget("Confirm : ",passlen,pass2);

	if (len1!=len2 || memcmp(pass1,pass2,len1)!=0)
		{
		printf("Password not confirmed!!!!\n");
		passerr++;
		len2=PASS_NC;
		}
	else len2=PASS_OK;
	}
/* clear the test password confirmation */
memset(pass2,0,128);
/* set up the key from the password if it is correct*/
if (len2==PASS_NC)
	{
	printf("Error confirming password\n");
	memset(pass1,0,128);
	len1=0;
	fclose(infile);
	fclose(outfile);
	return;
	}

if (len2==PASS_OK) setpassword(method,keymem,roundkeys,pass1,len1,rounds);
/* clear all original password information */
memset(pass1,0,128);
len1=0;

blocks=(filesize/block_size)-1;
/* if more than zero blocks */
if (blocks>0)
	finalblocksize=(unsigned)(filesize-(blocks*block_size));
else
	{
	finalblocksize=(unsigned)filesize;
	blocks=0;
	}

/* if the last block is bigger than a standard block */
if (finalblocksize>block_size)
	{
	splitsize=(finalblocksize>>1)+(finalblocksize&1);
	finalblocksize-=splitsize;
	}
else
	splitsize=0;

if (e_d==ENCRYPT)
	{
	for (j=0;j<blocks;j++)
		{
		fread(currblock,1,block_size,infile);
		if (chaining==chain_PCBC)
			{
			for (i=0;i<block_size;i++)
				{
				lastblock[i]^=currblock[i]^spareblock[i];
				spareblock[i]=currblock[i];
				}
			encrypt(method,keymem,roundkeys,lastblock,block_size,rounds);
			fwrite(lastblock,1,block_size,outfile);
			}
		else
			{
			encrypt(method,keymem,roundkeys,currblock,block_size,rounds);
			fwrite(currblock,1,block_size,outfile);
			}
		}
	if (splitsize>0)
		{
		fread(currblock,1,splitsize,infile);
		if (chaining==chain_PCBC)
			{
			for (i=0;i<splitsize;i++)
				{
				lastblock[i]^=currblock[i]^spareblock[i];
				spareblock[i]=currblock[i];
				}
			encrypt(method,keymem,roundkeys,lastblock,splitsize,rounds);
			fwrite(lastblock,1,splitsize,outfile);
			}
		else
			{
			encrypt(method,keymem,roundkeys,currblock,splitsize,rounds);
			fwrite(currblock,1,splitsize,outfile);
			}
		}
	fread(currblock,1,finalblocksize,infile);
	if (chaining==chain_PCBC)
		{
		for (i=0;i<finalblocksize;i++)
			{
			lastblock[i]^=currblock[i]^spareblock[i];
			spareblock[i]=currblock[i];
			}
		encrypt(method,keymem,roundkeys,lastblock,finalblocksize,rounds);
		fwrite(lastblock,1,finalblocksize,outfile);
		}
	else
		{
		encrypt(method,keymem,roundkeys,currblock,finalblocksize,rounds);
		fwrite(currblock,1,finalblocksize,outfile);
		}
	}
else
	{
	for (j=0;j<blocks;j++)
		{
		fread(currblock,1,block_size,infile);
		if (chaining==chain_PCBC)
			{
			memcpy(spareblock,currblock,block_size);
			decrypt(method,keymem,roundkeys,currblock,block_size,rounds);
			for (i=0;i<block_size;i++)
				{
				currblock[i]^=lastblock[i];
				lastblock[i]=currblock[i]^spareblock[i];
				}
			fwrite(currblock,1,block_size,outfile);
			}
		else
			{
			decrypt(method,keymem,roundkeys,currblock,block_size,rounds);
			fwrite(currblock,1,block_size,outfile);
			}
		}
	if (splitsize>0)
		{
		fread(currblock,1,splitsize,infile);
		if (chaining==chain_PCBC)
			{
			memcpy(spareblock,currblock,splitsize);
			decrypt(method,keymem,roundkeys,currblock,splitsize,rounds);
			for (i=0;i<splitsize;i++)
				{
				currblock[i]^=lastblock[i];
				lastblock[i]=currblock[i]^spareblock[i];
				}
			fwrite(currblock,1,splitsize,outfile);
			}
		else
			{
			decrypt(method,keymem,roundkeys,currblock,splitsize,rounds);
			fwrite(currblock,1,splitsize,outfile);
			}
		}
	fread(currblock,1,finalblocksize,infile);
	if (chaining==chain_PCBC)
		{
		decrypt(method,keymem,roundkeys,currblock,finalblocksize,rounds);
		for (i=0;i<finalblocksize;i++) currblock[i]^=lastblock[i];
		fwrite(currblock,1,finalblocksize,outfile);
		}
	else
		{
		decrypt(method,keymem,roundkeys,currblock,finalblocksize,rounds);
		fwrite(currblock,1,finalblocksize,outfile);
		}
	}
fclose(infile);
fclose(outfile);
clrmem(spareblock,block_size);
clrmem(currblock,block_size);
clrmem(lastblock,block_size);
clrmem(keymem,table_size);
clrmem(roundkeys,rounds*roundkeysize);
}
