#ifndef MD5MAC_H
#define MD5MAC_H

#include "cryptlib.h"
#include "misc.h"

class MD5MAC : public HashModule
{
public:
    MD5MAC(const byte *userKey);
    void Update(const byte *input, unsigned int length);
    void Final(byte *hash);
    int DigestSize() const {return DIGESTSIZE;}

    static void CorrectEndianess(word32 *out, const word32 *in, unsigned int byteCount)
    {
#ifndef LITTLE_ENDIAN
        byteReverse(out, in, byteCount);
#else
        if (in!=out)
            memcpy(out, in, byteCount);
#endif
    }

    static void Transform (word32 *buf, const word32 *in, const word32 *key);

    enum {KEYLENGTH=16, DIGESTSIZE = 16, DATASIZE = 64};

private:
    void Init();
    inline void do_block (const word32 *input);

    SecBlock<word32> buffer;
    word32 *const digest;    // Message digest
    word32 *const data;      // data buffer
	word32 *const key;
    word32 countLo, countHi; // 64-bit bit count

    static const word32 T[12];
};

#endif
