//
//	Workaround for win95/NT show() blocking bug, and non-modal dialogs
//

package  cryptix.gui;

import java.awt.*;

class YesNoDialog extends Dialog
{
	Frame parent;
    Button yes = new Button("Yes");
    Button no = new Button("No");
	boolean status;

	public boolean status() { return status; }

	public YesNoDialog(Frame parent, String question)
	{
		super(parent, "Appname: Question", true);
		this.parent = parent;

		// Doesn't work
		// setResizable(false);

        setLayout(new BorderLayout());

        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(yes);
        buttonPanel.add(no);

        add("Center", new Label(question));
        add("South", buttonPanel);

		pack();
	}

    public boolean action(Event event, Object arg)
    {
		hide();
		status = (event.target == yes);
		parent.postEvent(new Event(this, Event.ACTION_EVENT, null));
		return true;
    }

    public static void main( String argv[] )
    {
	    MainFrame top = new MainFrame("YesNoDialog (mainframe)");
		top.show();
		System.exit(-1);
    }
}

class MainFrame extends Frame
{
	YesNoDialog yn;
	Thread t;

	MainFrame(String title)
	{
		super(title);
	    yn = new YesNoDialog(this, "Yes or No?");
	}

	public void
	show()
	{
		yn.show();
		t = Thread.currentThread();
		t.suspend();
	}

	public boolean
	action(Event event, Object arg)
	{
		t.resume();
		System.out.println(yn.status() ? "Yes" : "No");
		return true;
	}

	public boolean
	handleEvent(Event event)
	{
		if (event.id == Event.WINDOW_DESTROY)
			System.exit(0);

		return super.handleEvent(event);
	}
}
