/*
 * util.h -- Miscellaneous defines
 *
 * Copyright (C) 1997 Pretty Good Privacy, Inc.
 *
 * Written by Mark H. Weaver
 *
 * $Id: util.h,v 1.10 1997/07/09 00:28:00 colin Exp $
 */

#ifndef UTIL_H
#define UTIL_H 1

typedef unsigned long	word32;
typedef unsigned short	word16;
typedef unsigned char	byte;

#define FMT32	"%08lx"
#define FMT16	"%04x"
#define FMT8	"%02x"

#define TAB_CHAR		'\244'	/* Currency symbol, like o in top of x */
#define TAB_STRING		"\244"
#define TAB_PAD_CHAR	' '
#define TAB_PAD_STRING	" "
#define FORMFEED_CHAR	'\245'	/* Yen symbol, like = on top of Y */
#define FORMFEED_STRING	"\245"

#define BYTES_PER_LINE	54		/* When using radix 64 */

#define LINES_PER_PAGE	70		/* Exclusive of header line */
#define LINE_LENGTH		80
#define PREFIX_LENGTH	7		/* Length of prefix, including the space */
#define HDR_HEX_LENGTH	19		/* Length of hex prefix on header */


/* Enough to hold one whole page of munged data */
/* There is no point making this excessively too large */
#define PAGE_BUFFER_SIZE	8192

#if PAGE_BUFFER_SIZE < (LINES_PER_PAGE + 2) * (LINE_LENGTH + PREFIX_LENGTH + 2)
#error PAGE_BUFFER_SIZE is too small
#endif


/* Header flags */
#define HDR_FLAG_LASTPAGE	0x01	/* Indicates last page */


#define elemsof(array) (sizeof(array)/sizeof(*(array)))


extern char const hexDigits[];
extern char const radix64Digits[];

#endif /* !UTIL_H */

/*
 * Local Variables:
 * tab-width: 4
 * End:
 * vi: ts=4 sw=4
 * vim: si
 */

