#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <rsa.h>
#include <md5.h>

#include "libpgp2.h"

/* pubkey to stderr, seckey to stdout */
int main(int argc, char *argv[])
{
  unsigned char passwdhash[16], userid[256] = "Unknown User";
  extern char *optarg;
  int ch, nbits = 1024, passflag = 0;
  RSA *newkey;
  FILE *secout = stdout, *pubout = stderr;

  memset(passwdhash, 0, 16);
  while ((ch = getopt(argc, argv, "n:o:p:s:u:")) != -1) {
    if (ch == 'p')              /* password */
      passflag++,
        MD5(optarg, strlen(optarg), passwdhash);
    else if (ch == 's') {
      secout = fopen(optarg, "wb");
      if (secout == NULL)
        exit(-1);
    } else if (ch == 'o') {
      pubout = fopen(optarg, "wb");
      if (pubout == NULL)
        exit(-1);
    } else if (ch == 'n')
      sscanf(optarg, "%d", &nbits);
    else if (ch == 'u')
      strncpy(userid, optarg, 255);
    else
      exit(-1);
  }
  newkey = RSA_generate_key(nbits, 17, NULL);  /* PGP uses 17 as first E */
  rsatopgp(secout, pubout, passflag ? passwdhash : NULL, userid, newkey);
  return 0;
}
