/* Tie.java --
   Copyright (C) 2002, 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package javax.rmi.CORBA;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InvokeHandler;

/**
 * <p>
 * A Tie serves as a CORBA Servant or implementation base. It is connected to
 * the ORB on a server side, providing the implementation of the required
 * functionality. ORB access this implementation using {@link InvokeHandler}
 * ._invoke(..). All such calls are finally delegated to the object, returned by
 * {@link #getTarget()}.
 * </p>
 * <p>
 * Ties are generated from implementations (name pattern *Impl) and have the
 * name pattern _*Impl_Tie, for instance:<br>
 * <code>rmic -keep -iiop -poa -always gnu.testlet.java.rmi.Remote.CalculatorImpl</code>
 * </p>
 * <p>
 * Ties should normally be derived from the
 * {@link org.omg.PortableServer.Servant}. Such ties are generated by
 * <code>rmic</code> compiler using <code>-poa</code> key. Ties can be also
 * derived from {@link org.omg.CORBA_2_3.portable.ObjectImpl}.
 * </p>
 * 
 * @author Audrius Meskauskas (AudriusA@Bioinformatics.org)
 */
public interface Tie
  extends InvokeHandler
{
  /**
   * Get the invocation target, where all method calls should be delegated.
   * 
   * @return the object, implementing methods, defined in the interface being
   * served by this Tie.
   */
  Remote getTarget();

  /**
   * Set the invocation target, where all method calls should be delegated.
   * 
   * @param target the object, implementing methods, defined in the interface
   * being served by this Tie. The code, produced by a typical rmic compiler
   * usually requires the target to be an instance of the implementation from
   * that the Tie was generated.
   * 
   * @throws ClassCastException if the passed parameter is not an instance of
   * the implementation from that the Tie was generated.
   */
  void setTarget(Remote target);

  /**
   * Get the ORB to that this Tie is connected.
   * 
   * @see org.omg.PortableServer.Servant#_orb
   */
  ORB orb();

  /**
   * Connect this Tie to the given ORB.
   */
  void orb(ORB orb);

  /**
   * Get the object that delegates calls to this tie.
   * 
   * @see org.omg.PortableServer.Servant#_this_object()
   */
  org.omg.CORBA.Object thisObject();

  /**
   * Deactivate this Tie. The tie is normally deactivated using POA mechanisms.
   * Depending on the POA policies, it may be possible to activate the Tie
   * again. The ties that are not derived from
   * {@link org.omg.PortableServer.Servant} deactivate themselves by
   * {@link ORB#disconnect}.
   * 
   * @throws NoSuchObjectException if there are no objects served by this Tie,
   * or if the these objects are already deactivated.
   * 
   * @see org.omg.PortableServer.POAOperations#deactivate_object
   */
  void deactivate()
    throws NoSuchObjectException;

}