(*^

::[paletteColors = 128; 
	fontset = title, "Helvetica-Bold", 24, L2, center, bold, nohscroll;
	fontset = subtitle, "Helvetica-Bold", 18, L2, center, bold, nohscroll;
	fontset = subsubtitle, "Helvetica-Bold", 14, L2, center, bold, nohscroll;
	fontset = section, "Helvetica-Bold", 16, L2, bold, nohscroll, grayBox;
	fontset = subsection, "Helvetica-Bold", 13, L2, bold, nohscroll, blackBox;
	fontset = subsubsection, "Helvetica-Bold", 12, L2, bold, nohscroll, whiteBox;
	fontset = text, "Times-Roman", 12, L2, nohscroll;
	fontset = smalltext, "Times-Roman", 10, L2, nohscroll;
	fontset = input, "Courier-Bold", 12, L2, bold, nowordwrap;
	fontset = output, "Courier", 12, L2, nowordwrap;
	fontset = message, "Courier", 12, L2, R21845, G21845, B21845, nowordwrap;
	fontset = print, "Courier", 12, L2, nowordwrap;
	fontset = info, "Courier", 12, L2, nowordwrap;
	fontset = postscript, "Courier", 12, L2, nowordwrap;
	fontset = name, "Times-Italic", 11, L2, italic, R21845, G21845, B21845, nowordwrap, nohscroll;
	fontset = header, "Times", 10, L2;
	fontset = footer, "Times", 12, L2, center;
	fontset = help, "Times-Roman", 13, L2, nohscroll;
	fontset = clipboard, "New York", 12, L2;
	fontset = completions, "Courier", 16, L2, nowordwrap;
	fontset = network, "Courier", 10, L2, nowordwrap;
	fontset = graphlabel, "Courier", 12, L2, nowordwrap;
	fontset = special1, "New York", 12, L2, nowordwrap;
	fontset = special2, "New York", 12, L2, center, nowordwrap;
	fontset = special3, "New York", 12, L2, right, nowordwrap;
	fontset = special4, "New York", 12, L2, nowordwrap;
	fontset = special5, "New York", 12, L2, nowordwrap;]
:[font = title; inactive; ]
Cover Page Graphics
:[font = text; inactive; ]
This is the code to generate the picture on the book cover.
:[font = subsubsection; inactive; locked; startGroup; Cclosed; ]
Copyright Notice
:[font = smalltext; inactive; locked; endGroup; ]

	Copyright 1989 by Roman Maeder.
	
	Adapted from	Roman E. Maeder: Programming in Mathematica, Addison-Wesley, 1989.
	
	Permission is hereby granted to make copies of	this file for any purpose other than direct profit,	or as part of a commercial product, provided this copyright notice is left intact.	Sale, other than for the cost of media, is prohibited.
	
	Permission is hereby granted to reproduce part or all of this file provided that the source is acknowledged.

:[font = section; inactive; startGroup; Cclosed; ]
Initialization
:[font = input; initialization; ]
*)
Needs["RMPackages`NewParametricPlot3D`"]
(*
:[font = input; initialization; ]
*)
Needs["Utilities`PlotUtilities`"]
(*
:[font = input; initialization; endGroup; ]
*)
part[t0_, phi0_, phi1_] := Block[{theta, phi},
	SphericalPlot3D[{Sin[theta] (2+Cos[phi/2]),
	                 FaceForm[ColorCircle[phi/2, 1], ColorCircle[phi/2, 0.7]]},
	                {theta, t0, t1, dt}, {phi, phi0, phi1, dp},
	                PlotRange -> plotrange, DisplayFunction -> Identity]
	]
(*
:[font = section; inactive; startGroup; Cclosed; ]
Generating the Picture
:[font = text; inactive; ]
The time it takes depends on the number of polygons in each direction.
The values below reproduce the cover exactly, but take a long time!
Feel free to use smaller values first.
:[font = input; ]
thetasteps = 36;
phisteps = 80; (* this should be a multiple of 8 *)
:[font = input; ]
t0 = 0.001; t1 = N[ Pi - t0 ];
dt = (t1 - t0)/thetasteps; dp = N[ 4Pi/phisteps ];
plotrange = {{-2, 3}, {-2.5, 2.5}, {-1.5, 1.5}};
:[font = input; ]
glist = {part[t0, 0, 3Pi/2],
         part[Pi/2, 3Pi/2, 4Pi/2],
	     part[t0, 4Pi/2, 7Pi/2],
	     part[Pi/2, 7Pi/2, 8Pi/2]};
:[font = input; endGroup; ]
Show[ glist,
	Boxed -> False, RenderAll -> True, Lighting -> False,
	DisplayFunction -> $DisplayFunction ];
^*)