/*
 * National Center for SuperComputing Applications, University of Illinois
 *
 * This NCSA software product is public domain software.  Permission
 * is hereby granted to do whatever you like with it. Should you wish
 * to make a contribution towards the production of this software, please
 * send us your comments about your experience with the software,  why
 * you liked or disliked it, how you use it, and most importantly, how it
 * helps your work. We will receive your comments at softdev@ncsa.uiuc.edu.
 *
 * Please send bug reports to bugs@ncsa.uiuc.edu
 *
 * Author: Eng-Whatt Toh, National Center for Supercomputing Applications
 *         ewtoh@ncsa.uiuc.edu
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: gr_toplev.c,v 1.3 1993/12/13 21:27:02 gbourhis Exp $";
#endif

/*
 *	File:		gr_toplev.c
 *	Contents:	Top level window functions for graphics module
 *	$Log: gr_toplev.c,v $
 * Revision 1.3  1993/12/13  21:27:02  gbourhis
 * don't show the dtm toggle if we use -DTMIN command line arg.
 *
 */

#include "gr_com.h"


/*
 * Open the top level window with the logbook and buttons to open the file
 * window.
 */
void
gr_InitTopLevel(shellName,parent,topWin)
char *shellName;
Widget parent;
A_TopWind_t	*topWin;
{
	Widget		boxWind;
#ifdef DTMOK
	extern	char *outPortName;
	extern int IN_PORT_NUMBER;
   extern void DTM_setControlOn(), DTM_setControlOff ();     /* jng 7-jan-91 */
#endif
	DBPRINT("IN gr_InitTopLevel\n"); 

	topWin->shell = 
		gr_MakeWindow("XDS Control",parent,&(topWin->win),
					  (XtCallbackProc)gr_Terminate,CNTRLWIND,
					  td_getToolName(),"Quit",(caddr_t)topWin,0,0,380,240);


	boxWind = gr_MakeBulletin("XDSbulletin",topWin->win,1,1,374, 140);

	topWin->msgWin = gr_MakeText("XDStext",boxWind,
					&topWin->msgVPort,VERTONLY,
					SELECTABLE,FILESOURCE, td_getLogFileName(),
					0, 0, 370, 130);

	topWin->numAniWins = 0;
	topWin->numBossWins = 0;
	topWin->numFileWins = 0;
	topWin->bossWin = NULL;
	topWin->fileWin = NULL;
	topWin->aniWin = NULL;

	if (!USECOMMANDLINEFILE()) { 
	  DBPRINT("MAKING raster, SDS buttons in toplevel window\n");
	  
	  boxWind = gr_MakeBulletin("XDSbulletin",topWin->win,1,136,360,20);
	  gr_MakeButton("XDSbutton",boxWind,"Load 3D SDS",
			(XtCallbackProc)gr_LoadSDS,(caddr_t)topWin,
			2, 2, 102, 16);
	  gr_MakeButton("XDSbutton",boxWind,"Load 8-bit RASTER",
			(XtCallbackProc)gr_LoadRASTER,(caddr_t)topWin,
			110, 2, 102, 16);
	  gr_MakeButton("XDSbutton",boxWind,"Process a SDS",
			(XtCallbackProc)gr_SaveProc,(caddr_t)topWin,
			220, 2, 102, 16);

#ifdef DTMOK
	  if (!outPortName && (IN_PORT_NUMBER < 1))
	    gr_MakeToggle("XDStoggle",boxWind,"DTM",SQUARE,
			  FALSE,(XtCallbackProc) DTM_setControlOn,
			  (XtCallbackProc) DTM_setControlOff ,(caddr_t)topWin,
			  330, 2, 50, 16);
#endif
	}
}
