#ifdef DTMOK

#include "gr_com.h"

#define	MINDSPLXSIZE	300
#define	MINDSPLXSIZE1	100
#define	MINDSPLYSIZE	350
#define	MAXDSPLXSIZE	600
#define	MAXDSPLYSIZE	780
#define	LEEWAY			3

/*
 *	updates a data spreadsheet from dtm incoming SDS data
 * is a patch from gr_InitDsplLevel().
 * jng jan-09-91
 * 
 * NOTE: does not handle MIRIAD data.
 */

DTMupdateDsplWin (odWin, tparent)
A_DsplWind_t	*odWin; /* orig spreadsheet DsplWin to be updated */
A_CubeWind_t	*tparent;


{
	A_BossWind_t	*bossWin=tparent->parent;
	A_Data_t		*hdf=bossWin->data;

	int			numCols,numRows,ncols,nrows;
	int			minxsize,winxsize,winysize,xsize,ysize,xaxis,yaxis;

	A_Axes_t		orient;
	int			scale,width;
	int			i;

	DBPRINTARG("DTMupdateDsplWin for [%s]\n ",bossWin->filename);
	setignoreDTM (1);

	orient = tparent->axesOrient;
	scale = gr_CubegetCurScale(tparent);
	width = atoi(gr_DialogGetValue(tparent->widthDialog));


	gr_WidgetCursor(tparent->shell,XC_man);

	if (hdf->format != HDF) {printf("oops--not an hdf file!!\n"); return; }
	minxsize = MINDSPLXSIZE1;

	ncols = numCols = odWin->xdim;
	nrows = numRows = odWin->ydim;

	if (orient.col < 0) xaxis = -orient.col;
	else xaxis = orient.col;
	if (orient.row < 0) yaxis = -orient.row;
	else yaxis = orient.row;

	if ((tparent->interp == TRUE) && (tparent->cull == FALSE))
	{
		ncols--; nrows--;
	}

/* ***
	if ( (odWin->hScaleData = 
		 td_HdfgetHScale(hdf,orient.col,tparent->cull)) == NULL)
		return;
	
	if ((odWin->vScaleData = 
		 td_HdfgetVScale(hdf,orient.row,tparent->cull)) == NULL)
		return;
*****/


	td_Free2d((char **)odWin->listData);
	if ((odWin->listData = td_HdfgetPlaneData(hdf,tparent->cull,
				orient.row,orient.col,orient.axis,orient.plane)) == NULL)
		return;

	td_Free((char *)odWin->data);
	if ((odWin->data = td_HdfgetPixData(hdf,
					orient.row,orient.col,orient.axis,orient.plane,
					tparent->interp,tparent->cull,
					(unsigned char)gr_color.nColors )) == NULL)
		return;

	if (tparent->cull == FALSE)
	{
		xsize = odWin->imagexsize;
		ysize = odWin->imageysize;
	}
	else
	{
		numCols = numCols/scale; if (numCols*scale<odWin->xdim) numCols++;
		numRows = numRows/scale; if (numRows*scale<odWin->ydim) numRows++;
		xsize = ncols/scale; if (xsize*scale < ncols) xsize++;
		ysize = nrows/scale; if (ysize*scale < nrows) ysize++;

		odWin->xdim = numCols;
		odWin->ydim = numRows;
		odWin->imagexsize = xsize;
		odWin->imageysize = ysize;
	}

	if (xsize > minxsize)
	  if (xsize > MAXDSPLXSIZE) winxsize = MAXDSPLXSIZE;
	  else winxsize = xsize+LEEWAY;
	else
	  winxsize = minxsize;

	if (ysize > MINDSPLYSIZE)
	  if (ysize > MAXDSPLYSIZE) winysize = MAXDSPLYSIZE;
	  else winysize = ysize+LEEWAY;
	else
	  winysize = MINDSPLYSIZE;


/* ********
   odWin->hScaleWin =
      gr_MakeListStatic("XDSstaticlist",odWin->win,&(odWin->hScaleVPort),
               numCols,NULL,odWin->hScaleData,(caddr_t)odWin,
               51,1,319,20);

   odWin->vScaleWin =
      gr_MakeListStatic("XDSstaticlist",odWin->win,&(odWin->vScaleVPort),
               1,NULL,odWin->vScaleData,(caddr_t)odWin,
               1,26,45,245);
******* */


	odWin->listWin =
		gr_MakeList("XDSlist",odWin->win,&(odWin->listVPort),
					VERTHORIZ,numCols,5,
					(XtCallbackProc)gr_DsplListVScroll,
					(XtCallbackProc)gr_DsplListHScroll,
					(XtCallbackProc)gr_DsplListSelect,
					odWin->listData,(caddr_t)odWin,
					51, 26, 345, 272);

	gr_ImageSetCMap(odWin->shell);

/****
   XtDestroyWidget(odWin->imageWin);
	odWin->imageVPort = gr_MakeVPort("XDSvport",odWin->win,NOSCROLL,HP,
						NULL,NULL,5,(caddr_t)odWin,
						400,1,winxsize,winysize);
******/


	odWin->image = gr_ImageCreate(odWin->imageVPort,xsize,ysize,
						odWin->data);

	odWin->imageWin = gr_MakeImageStatic("XDSstaticimage",
							odWin->imageVPort,odWin->image,
							(XtCallbackProc)gr_DsplImageSelect,(caddr_t)odWin,
							0,0,xsize,ysize);

	gr_WidgetCursor(odWin->shell,XC_draped_box);
	gr_WidgetCursor(tparent->shell,XC_draped_box);
	gr_ImageSetCMap(odWin->shell);

	setignoreDTM (0);

	return;
}

/* ------------------------------------------------------------------ */

/*
 * jng jan-09-91
 *	updates all displays for a dtm dataset with boss-window bossWin.
 */

myDTMupdateBoss (bossWin)
A_BossWind_t	*bossWin;
{
	int 				i,ret,num;
	char				tname[200];
	int				match;
	A_CubeWind_t	*cubeWin = bossWin->cubeWin;
	A_DsplWind_t	*dWin;
	A_HistWind_t	*hWin;
	A_AniWind_t		*aWin;



	if (cubeWin==NULL) return;

	/* *********** what follows are code to update all windows  ***** */

		/* (A) --- update for DISPLAY WINDOW */
		dWin = cubeWin->dsplWin;
		while (dWin!=NULL) 
		{
			/* (1) update spreadsheet */
		 	DTMupdateDsplWin (dWin , cubeWin);

			/* (2) update spreadsheet's trace displays  */
		 	hWin = dWin->histWin;
			while (hWin!=NULL) 
			{
				if (hWin->ntraced > 0)
			 		my_SliceExpose(cubeWin,hWin,cubeWin);
				hWin = hWin->next;
			}	
			dWin = dWin->next;
		}	

		/* (B) --- update for ANIMATION WINDOW */
		aWin = cubeWin->aniWin;
		while (aWin!=NULL) 
		{
			myDTMupdateAniWin(aWin, cubeWin);
			aWin = aWin->next;
		}	
	
}  

#endif
