
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>
#include <get.h>

#include "fdefs.h"

#include "fvars_ext.com"

int gx_readscr(xsiz,ysiz,zsiz,icmd,ibuff)
long *xsiz,*ysiz,*zsiz;
int icmd;
unsigned char *ibuff;
{
	Screencoord sx1,sy1,sx2,sy2;
	Coord rx1,ry1,rx2,ry2;
	Colorindex *row_cols;
	int num_bytes;
	register int i,j;
	Icoord ix;
	short lx;
	long jrp;
	unsigned char *buf_ptr;
	RGBvalue *rbuf,*gbuf,*bbuf;
	long dmode;

	getviewport(&sx1,&sx2,&sy1,&sy2);

	*xsiz = (sx2 - sx1) + 1;
	*ysiz = (sy2 - sy1) + 1;
	dmode = getdisplaymode();
	if((dmode == DMRGB) || (dmode == DMRGBDOUBLE))
		*zsiz = 3;
	else
		*zsiz = 1;

	rx1 = (Coord)sx1 - 0.5;
	ry1 = (Coord)sy1 - 0.5;
	rx2 = (Coord)sx2 + 0.5;
	ry2 = (Coord)sy2 + 0.5;

	pushmatrix();
	pushviewport();
	loadmatrix(idmatrix);
	ortho2(rx1,rx2,ry1,ry2);

	lx = (short)(*xsiz);
	ix = sx1;
	buf_ptr = &ibuff[0];
	if (icmd == 0){
		num_bytes = lx * sizeof(Colorindex);
		row_cols = (Colorindex *)malloc(num_bytes);
		if (!row_cols){
			puts("Not enough memory for row_cols");
			exit(1);
		}

		for(j=sy2; j >= sy1; j--){
			cmov2i(ix,j);
			jrp = readpixels(lx,row_cols);
			for(i=0; i<lx; i++)
				*buf_ptr++ = (unsigned char)(row_cols[i] - LUTOFFSET);
		}

		free(row_cols);
	}
	else if (icmd == 1){
		num_bytes = lx * sizeof(RGBvalue);
		rbuf = (RGBvalue *)malloc(num_bytes);
		gbuf = (RGBvalue *)malloc(num_bytes);
		bbuf = (RGBvalue *)malloc(num_bytes);
		if ((!rbuf) || (!gbuf) || (!bbuf)){
			puts("Not enough memory for rbuf gbuf bbuf");
			exit(1);
		}
		for(j=sy2; j >= sy1; j--){
			cmov2i(ix,j);
			jrp = readRGB(lx,rbuf,gbuf,bbuf);
			for(i=0; i<lx; i++){
				*buf_ptr++ = (unsigned char)(rbuf[i]);
				*buf_ptr++ = (unsigned char)(gbuf[i]);
				*buf_ptr++ = (unsigned char)(bbuf[i]);
			}
		}

		free(bbuf);
		free(gbuf);
		free(rbuf);
	}
	else{
	}

	popviewport();
	popmatrix();

	return(0);
}
