/*
** This file is part of the alternative 80386 math library and is
** covered by the GNU General Public license with my modification
** as noted in the README file that accompanied this file.
**
** Copyright 1990 G. Geers
**
*/

	.align 4
.globl _max_normal

_max_normal:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7fefffff, -12(%ebp)
	movl $0xffffffff, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret

	.align 4
.globl _min_normal

_min_normal:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x00100000, -12(%ebp)
	movl $0x00000001, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret

	.align 4
.globl _min_subnormal

_min_subnormal:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x0, -12(%ebp)
	movl $0x00000001, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret

	.align 4
.globl _max_subnormal

_max_subnormal:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x000fffff, -12(%ebp)
	movl $0xffffffff, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret

	.align 4
.globl _quiet_nan

_quiet_nan:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7fffffff, -12(%ebp)
	movl $0xffffffff, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret

	.align 4
.globl _signaling_nan

_signaling_nan:
	pushl %ebp
	movl %esp,%ebp
	subl $8, %esp

	movl $0x7ff00000, -12(%ebp)
	movl $0x00000001, -16(%ebp)

	fldl -16(%ebp)
	
	leave
	ret
