/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1991 Brian Smith
 * All rights reserved.
 *
 * Read the LICENSE file for details on distribution and use.
 *
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

#define NUMBUFS     2
#define SHM_BUFSIZ  (8*4096)
#define SHM_KEY     1796

typedef struct {
    int     not_last_segment[NUMBUFS];
    int     unlocked[NUMBUFS];
    char    buf[NUMBUFS*SHM_BUFSIZ];
}   buf_struct;


main()
{
    int rc;
    int shmid;

    shmid = shmget(SHM_KEY, sizeof(buf_struct), IPC_CREAT | 0644);
    if (shmid == -1)
    {
        perror("creating shared-mem buffer");
        exit(-1);
    }

    rc = shmctl(shmid, IPC_RMID, 0);
    if (rc == -1)
        perror("removing segment");

    exit(0);
}
