/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1991 Brian Smith
 * All rights reserved.
 *
 * Read the LICENSE file for details on distribution and use.
 *
 */

#include <sys/fcntl.h>
#include <sys/sb.h>

int main(argc, argv)
int argc;
char **argv;
{
    int fd;
    int speed;

    if (argc != 2)
    {
        printf("usage: %s <speed>\n", argv[0]);
        exit(-1);
    }
    speed = atoi(argv[1]);
    if ((speed < 4000) || (speed > 24000))
    {
        printf("usage: %s <speed>\n", argv[0]);
        printf("\tspeed must be between 4000 and 24000");
        exit(-1);
    }

    fd = open("/dev/sbdsp", O_RDONLY);
    if (fd == -1)
    {
        perror("opening SoundBlaster");
        exit(-1);
    }

    ioctl(fd, DSP_IOCTL_SPEED, speed);

    exit(0);
}
