/*
 * include file for the ICU for the pc532.
 */

typedef struct {
     unchar icu_hvct;	/* reg 0 */
     unchar icu_svct;	/* reg 1 */
     unchar icu_eltg_lo;	/* reg 2 */
     unchar icu_eltg_hi;	/* reg 3 */
     unchar icu_tpl_lo;	/* reg 4 */
     unchar icu_tpl_hi;	/* reg 5 */
     unchar icu_ipnd_lo;	/* reg 6 */
     unchar icu_ipnd_hi;	/* reg 7 */
     unchar icu_isrv_lo;	/* reg 8 */
     unchar icu_isrv_hi;	/* reg 9 */
     unchar icu_imsk_lo;	/* reg 10 */
     unchar icu_imsk_hi;	/* reg 11 */
     unchar icu_csrc_lo;	/* reg 12 */
     unchar icu_csrc_hi;	/* reg 13 */
     unchar icu_fprt_lo;	/* reg 14 */
     unchar icu_fprt_hi;	/* reg 15 */
     unchar icu_mctl;	/* reg 16 */
     unchar icu_ocasn;	/* reg 17 */
     unchar icu_ciptr;	/* reg 18 */
     unchar icu_pdat;	/* reg 19 */
     unchar icu_ips;	/* reg 20 */
     unchar icu_pdir;	/* reg 21 */
     unchar icu_cctl;	/* reg 22 */
     unchar icu_cictl;	/* reg 23 */
     unchar icu_lcsv_lo;	/* reg 24 */
     unchar icu_lcsv_hi;	/* reg 25 */
     unchar icu_hcsv_lo;	/* reg 26 */
     unchar icu_hcsv_hi;	/* reg 27 */
     unchar icu_lccv_lo;	/* reg 28 */
     unchar icu_lccvhi;	/* reg 29 */
     unchar icu_hccv_lo;	/* reg 30 */
     unchar icu_hccv_hi;	/* reg 31 */
} icu_t;

#define ICU_ADR		0xfffffe00
#define ICU_IO		(ICU->icu_ips)
#define ICU_DIR		(ICU->icu_pdir)
#define ICU_DATA	(ICU->icu_pdat)
#define ICU_SCSI_BIT	0x80
#define ICU ((volatile icu_t *)ICU_ADR)
#define AIC6250		0
#define DP8490		1

#define SELSCSI(ctlr)	ICU_IO &= ~IPS_SCSI; \
     			ICU_DIR &= ~PDIR_SCSI; \
     			if(ctlr == DP8490) \
     				ICU_DATA &= ~ICU_SCSI_BIT; \
     			else \
     				ICU_DATA |= ICU_SCSI_BIT;

/* IPND register */
/* low byte register 6 */
#define IPND_NU1 0x1	/* SWAP */
#define IPND_IR1 0x2
#define IPND_IR2 0x4
#define IPND_IR3 0x8
#define IPND_SC1 0x10	/* 8490 */
#define IPND_SC0 0x20	/* 6150 */
#define IPND_DR3 0x40	/* DUART 3 Rx ready */
#define IPND_DI3 0x80	/* DUART 3 INT */
/* high byte register 7 */
#define IPND_DR2 0x1	/* DUART 2 Rx ready */
#define IPND_DI2 0x2	/* DUART 2 INT */
#define IPND_DR1 0x4	/* DUART 1 Rx ready */
#define IPND_DI1 0x8	/* DUART 1 INT */
#define IPND_DR0 0x10	/* DUART 0 Rx ready */
#define IPND_DI0 0x20	/* DUART 0 INT */
#define IPND_NU2 0x40	/* SCSI SELECT */
#define IPND_IR15 0x80

/* ISRV register */
/* low byte register 8 */
#define ISRV_NU1 0x1	/* SWAP */
#define ISRV_IR1 0x2
#define ISRV_IR2 0x4
#define ISRV_IR3 0x8
#define ISRV_SC1 0x10	/* 8490 */
#define ISRV_SC0 0x20	/* 6150 */
#define ISRV_DR3 0x40	/* DUART 3 Rx ready */
#define ISRV_DI3 0x80	/* DUART 3 INT */
/* high byte register 9 */
#define ISRV_DR2 0x1	/* DUART 2 Rx ready */
#define ISRV_DI2 0x2	/* DUART 2 INT */
#define ISRV_DR1 0x4	/* DUART 1 Rx ready */
#define ISRV_DI1 0x8	/* DUART 1 INT */
#define ISRV_DR0 0x10	/* DUART 0 Rx ready */
#define ISRV_DI0 0x20	/* DUART 0 INT */
#define ISRV_NU2 0x40	/* SCSI SELECT */
#define ISRV_IR15 0x80

/* IMSK register */
/* low byte register 10 */
#define IMSK_NU1 0x1	/* SWAP */
#define IMSK_IR1 0x2
#define IMSK_IR2 0x4
#define IMSK_IR3 0x8
#define IMSK_SC1 0x10	/* 8490 */
#define IMSK_SC0 0x20	/* 6150 */
#define IMSK_DR3 0x40	/* DUART 3 Rx ready */
#define IMSK_DI3 0x80	/* DUART 3 INT */
/* high byte register 11 */
#define IMSK_DR2 0x1	/* DUART 2 Rx ready */
#define IMSK_DI2 0x2	/* DUART 2 INT */
#define IMSK_DR1 0x4	/* DUART 1 Rx ready */
#define IMSK_DI1 0x8	/* DUART 1 INT */
#define IMSK_DR0 0x10	/* DUART 0 Rx ready */
#define IMSK_DI0 0x20	/* DUART 0 INT */
#define IMSK_NU2 0x40	/* SCSI SELECT */
#define IMSK_IR15 0x80

/* MCTL register 16 */
#define MCTL_T16N8 0x1
#define MCTL_NTAR 0x2
#define MCTL_NU1 0x4
#define MCTL_FRZ 0x8
#define MCTL_CLKM 0x10
#define MCTL_COUTM 0x20
#define MCTL_COUTD 0x40
#define MCTL_CFRZ 0x80

/* OCASN register 17, used for HCLK output pin assignment */
#define OCASN_HMSK 0xf
#define OCASN_G0 0x1
#define OCASN_G1 0x2
#define OCASN_G2 0x4
#define OCASN_G3 0x8
#define OCASN_NU 0xf0

/* CIPTR register 18 */
#define CIPTR_LMSK 0x0f	/* can set IR0-IR15 */
#define CIPTR_HMSK 0xf0	/* can set IR0-IR15 */

/* IPS register 20 */
#define IPS_IR0 0x1
#define IPS_IR2 0x2
#define IPS_IR4 0x4
#define IPS_IR6 0x8
#define IPS_IR8 0x10
#define IPS_IR10 0x20
#define IPS_IR12 0x40
#define IPS_IR14 0x80
#define IPS_SCSI 0x80

/* PDIR register 21 */
#define PDIR_G0I 0x1
#define PDIR_G1I 0x2
#define PDIR_G2I 0x4
#define PDIR_G3I 0x8
#define PDIR_G4I 0x10
#define PDIR_G5I 0x20
#define PDIR_G6I 0x40
#define PDIR_G7I 0x80
#define PDIR_SCSI 0x80

/* CCTL register 22 */
#define CCTL_CDCRL 0x1
#define CCTL_CDCRH 0x2
#define CCTL_CRUNL 0x4
#define CCTL_CRUNH 0x8
#define CCTL_ISO   0x0
#define CCTL_ZDL   0x10
#define CCTL_ZDH   0x20
#define CCTL_ZDHL  0x30
#define CCTL_CFNPS 0x40 /* if this is 0 then the clock is prescaled by 4 */
#define CCTL_CCON  0x80 /* if this is one then there is 1 32 bit counter */
#define CCTL_RFR   (CCTL_ZDL|CCTL_CRUNL|CCTL_CDCRL) /* for refresh */

/* CICTL register 23 */
#define CICTL_WENL 0x1
#define CICTL_CIEL 0x2
#define CICTL_CIRL 0x4
#define CICTL_CERL 0x8
#define CICTL_WENH 0x10
#define CICTL_CIEH 0x20
#define CICTL_CIRH 0x40
#define CICTL_CERH 0x80

